package com.example.opteamscreen

import android.os.*
import android.view.View
import android.view.WindowManager
import androidx.appcompat.app.AppCompatActivity
import android.webkit.WebView
import android.webkit.WebViewClient
import android.widget.Toast
import java.util.*
import kotlin.concurrent.schedule

class MyscreenActivite : AppCompatActivity() {

    private lateinit var webView: WebView
    lateinit var mainHandler: Handler
    var delayQueue: Long = 60000

    private val updateUrl = object : Runnable {
        override fun run() {
            webView.reload()
            mainHandler.postDelayed(this, delayQueue)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if (Build.VERSION.SDK_INT < 16) {
            window.setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN)
        }else{
            window.decorView.systemUiVisibility = View.SYSTEM_UI_FLAG_FULLSCREEN
        }

        supportActionBar?.hide()
        setContentView(R.layout.activity_myscreen)

        var myurl = intent.getStringExtra("url")
        supportActionBar?.hide()

        webView = findViewById(R.id.webview)
        webView.settings.javaScriptEnabled = true
        webView.setInitialScale(1)
        webView.settings.loadWithOverviewMode = true
        webView.settings.useWideViewPort = true
        webView.settings.setSupportZoom(true)

        webView.webViewClient = object : WebViewClient() {
            override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
                if (url != null) {
                    view?.loadUrl(url)
                }
                return true
            }
        }

        if(myurl == null || myurl == ""){
            myurl = "https://happydisplay.opteam.net/"
        }

        webView.loadUrl(myurl.toString())
        mainHandler = Handler(Looper.getMainLooper())
    }

    override fun onResume() {
        super.onResume()
        mainHandler.post(updateUrl)
    }
}
