SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- --------------------------------------------------------

--
-- Structure de la table `hd_apexnb_subscriber`
--

CREATE TABLE `hd_apexnb_subscriber` (
  `id` mediumint(9) NOT NULL,
  `email` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active_code` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_commentmeta`
--

CREATE TABLE `hd_commentmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `comment_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_comments`
--

CREATE TABLE `hd_comments` (
  `comment_ID` bigint(20) UNSIGNED NOT NULL,
  `comment_post_ID` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_daln_featured_news`
--

CREATE TABLE `hd_daln_featured_news` (
  `id` int(11) NOT NULL,
  `news_title` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `news_excerpt` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ticker_id` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_daln_sliding_news`
--

CREATE TABLE `hd_daln_sliding_news` (
  `id` int(11) NOT NULL,
  `news_title` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ticker_id` bigint(20) NOT NULL,
  `text_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `text_color_hover` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `background_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `background_color_opacity` float DEFAULT NULL,
  `image_before` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image_after` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_daln_tickers`
--

CREATE TABLE `hd_daln_tickers` (
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `id` bigint(20) NOT NULL,
  `target` int(11) NOT NULL DEFAULT '1',
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` int(11) NOT NULL DEFAULT '1',
  `url_rss` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `category` bigint(20) NOT NULL DEFAULT '0',
  `twitter_username` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `twitter_oauth_access_token` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `twitter_oauth_access_token_secret` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `twitter_consumer_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `twitter_consumer_secret` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `twitter_strip_links` tinyint(1) DEFAULT '0',
  `twitter_strip_hashtags` tinyint(1) DEFAULT '0',
  `twitter_strip_usernames` tinyint(1) DEFAULT '0',
  `open_links_new_tab` tinyint(1) DEFAULT '0',
  `clock_offset` int(11) NOT NULL DEFAULT '0',
  `clock_format` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'HH:mm',
  `clock_source` int(11) NOT NULL DEFAULT '2',
  `clock_autoupdate` tinyint(1) DEFAULT '1',
  `clock_autoupdate_time` int(11) NOT NULL DEFAULT '10',
  `sliding_speed` int(11) NOT NULL DEFAULT '5',
  `sliding_delay` int(11) NOT NULL DEFAULT '0',
  `number_of_sliding_news` int(11) NOT NULL DEFAULT '10',
  `featured_title_maximum_length` int(11) NOT NULL DEFAULT '255',
  `featured_excerpt_maximum_length` int(11) NOT NULL DEFAULT '255',
  `sliding_news_maximum_length` int(11) NOT NULL DEFAULT '255',
  `open_news_as_default` tinyint(1) DEFAULT '1',
  `hide_featured_news` int(11) NOT NULL DEFAULT '1',
  `hide_clock` tinyint(1) DEFAULT '0',
  `enable_rtl_layout` tinyint(1) DEFAULT '0',
  `cached_cycles` int(11) NOT NULL DEFAULT '0',
  `featured_news_background_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sliding_news_background_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sliding_news_background_color_opacity` float DEFAULT NULL,
  `font_family` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `google_font` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `featured_title_font_size` int(11) NOT NULL DEFAULT '38',
  `featured_excerpt_font_size` int(11) NOT NULL DEFAULT '28',
  `sliding_news_font_size` int(11) NOT NULL DEFAULT '28',
  `clock_font_size` int(11) NOT NULL DEFAULT '28',
  `enable_with_mobile_devices` tinyint(1) DEFAULT '0',
  `open_button_image` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `close_button_image` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `clock_background_image` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `featured_news_title_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `featured_news_title_color_hover` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `featured_news_excerpt_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sliding_news_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `sliding_news_color_hover` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `clock_text_color` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `featured_news_background_color_opacity` float DEFAULT NULL,
  `enable_ticker` tinyint(1) DEFAULT '1',
  `enable_links` tinyint(1) DEFAULT '1',
  `transient_expiration` int(11) NOT NULL DEFAULT '0',
  `sliding_news_margin` int(11) NOT NULL DEFAULT '84',
  `sliding_news_padding` int(11) NOT NULL DEFAULT '28',
  `url_mode` tinyint(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_daln_tickers`
--

INSERT INTO `hd_daln_tickers` (`name`, `id`, `target`, `url`, `source`, `url_rss`, `category`, `twitter_username`, `twitter_oauth_access_token`, `twitter_oauth_access_token_secret`, `twitter_consumer_key`, `twitter_consumer_secret`, `twitter_strip_links`, `twitter_strip_hashtags`, `twitter_strip_usernames`, `open_links_new_tab`, `clock_offset`, `clock_format`, `clock_source`, `clock_autoupdate`, `clock_autoupdate_time`, `sliding_speed`, `sliding_delay`, `number_of_sliding_news`, `featured_title_maximum_length`, `featured_excerpt_maximum_length`, `sliding_news_maximum_length`, `open_news_as_default`, `hide_featured_news`, `hide_clock`, `enable_rtl_layout`, `cached_cycles`, `featured_news_background_color`, `sliding_news_background_color`, `sliding_news_background_color_opacity`, `font_family`, `google_font`, `featured_title_font_size`, `featured_excerpt_font_size`, `sliding_news_font_size`, `clock_font_size`, `enable_with_mobile_devices`, `open_button_image`, `close_button_image`, `clock_background_image`, `featured_news_title_color`, `featured_news_title_color_hover`, `featured_news_excerpt_color`, `sliding_news_color`, `sliding_news_color_hover`, `clock_text_color`, `featured_news_background_color_opacity`, `enable_ticker`, `enable_links`, `transient_expiration`, `sliding_news_margin`, `sliding_news_padding`, `url_mode`) VALUES
('Info BFM', 1, 2, 'https://happydisplay.opteam.net/', 3, 'https://www.bfmtv.com/rss/news-24-7/', 0, '', '', '', '', '', 0, 0, 0, 0, 0, 'HH:mm', 2, 1, 10, 5, 0, 10, 280, 280, 280, 0, 2, 0, 0, 5, '#C90016', '#000000', 1, '\\\'Open Sans\\\', sans-serif', 'https://fonts.googleapis.com/css?family=Open+Sans:400,600,700', 38, 28, 28, 28, 1, 'https://happydisplay.opteam.net/wp-content/uploads/2022/10/pixel_transparent.png', 'https://happydisplay.opteam.net/wp-content/uploads/2022/10/pixel_transparent.png', 'https://happydisplay.opteam.net/wp-content/uploads/2022/04/pixel.jpg', '#eee', '#111', '#eee', '#eee', '#aaa', '#111', 1, 1, 0, 60, 84, 28, 0);

-- --------------------------------------------------------

--
-- Structure de la table `hd_links`
--

CREATE TABLE `hd_links` (
  `link_id` bigint(20) UNSIGNED NOT NULL,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_attendees`
--

CREATE TABLE `hd_mec_attendees` (
  `attendee_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `event_id` bigint(20) NOT NULL,
  `occurrence` int(11) NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `first_name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_520_ci,
  `count` int(11) DEFAULT '1',
  `verification` int(1) DEFAULT '0',
  `confirmation` int(1) DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_bookings`
--

CREATE TABLE `hd_mec_bookings` (
  `id` int(10) UNSIGNED NOT NULL,
  `booking_id` int(10) UNSIGNED NOT NULL,
  `user_id` int(10) UNSIGNED DEFAULT NULL,
  `transaction_id` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_id` int(10) UNSIGNED NOT NULL,
  `ticket_ids` varchar(655) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'pending',
  `confirmed` tinyint(4) NOT NULL DEFAULT '0',
  `verified` tinyint(4) NOT NULL DEFAULT '0',
  `all_occurrences` tinyint(4) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  `timestamp` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_dates`
--

CREATE TABLE `hd_mec_dates` (
  `id` int(10) UNSIGNED NOT NULL,
  `post_id` int(10) NOT NULL,
  `dstart` date NOT NULL,
  `dend` date NOT NULL,
  `tstart` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `tend` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `public` int(4) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_events`
--

CREATE TABLE `hd_mec_events` (
  `id` int(10) NOT NULL,
  `post_id` int(10) NOT NULL,
  `start` date NOT NULL,
  `end` date NOT NULL,
  `repeat` tinyint(4) NOT NULL DEFAULT '0',
  `rinterval` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `year` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `month` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `day` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `week` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `weekday` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `weekdays` varchar(80) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `days` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `not_in_days` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time_start` int(10) NOT NULL DEFAULT '0',
  `time_end` int(10) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_occurrences`
--

CREATE TABLE `hd_mec_occurrences` (
  `id` int(10) UNSIGNED NOT NULL,
  `post_id` int(10) UNSIGNED NOT NULL,
  `occurrence` int(10) UNSIGNED NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_mec_users`
--

CREATE TABLE `hd_mec_users` (
  `id` int(11) NOT NULL,
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(127) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `reg` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_image_storage`
--

CREATE TABLE `hd_nextend2_image_storage` (
  `id` int(11) NOT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `image` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_nextend2_image_storage`
--

INSERT INTO `hd_nextend2_image_storage` (`id`, `hash`, `image`, `value`) VALUES
(1, 'bba258296b9380244c3ddec05fdc483e', '$upload$/2022/02/Plan-de-travail-1-80.jpg', 'eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19'),
(2, '21784643660019b6f129487737a84aa6', '$upload$/2022/02/Plan-de-travail-1-copie-80.jpg', 'eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19'),
(3, '1f72ec33e427d4f06b272ec936a639df', '$upload$/2022/02/Plan-de-travail-1-copie-2-80.jpg', 'eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19'),
(4, 'b32af29fadc096a0102d307926dcf228', '$upload$/2022/03/20220322-webinar-icims-language-desktop.jpg', 'eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19'),
(5, '1f78586a73ba7c5c9b08546c968da310', '$upload$/2022/03/Capture-decran-2022-03-24-152537.jpg', 'eyJkZXNrdG9wLXJldGluYSI6eyJpbWFnZSI6IiJ9LCJ0YWJsZXQiOnsiaW1hZ2UiOiIifSwibW9iaWxlIjp7ImltYWdlIjoiIn19');

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_section_storage`
--

CREATE TABLE `hd_nextend2_section_storage` (
  `id` int(11) NOT NULL,
  `application` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `section` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referencekey` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `system` int(11) NOT NULL DEFAULT '0',
  `editable` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_nextend2_section_storage`
--

INSERT INTO `hd_nextend2_section_storage` (`id`, `application`, `section`, `referencekey`, `value`, `system`, `editable`) VALUES
(10000, 'smartslider', 'settings', '', '{\"n2_ss3_version\":\"3.5.1.11\\/b:release-3.5.1.11\\/r:f0b633e7a94052a70133276e2ed8de7715ca6ecb\",\"limit\":\"all\",\"slidersOrder2\":\"ordering\",\"slidersOrder2Direction\":\"ASC\"}', 0, 1),
(10001, 'smartslider', 'tutorial', 'GettingStarted', '1', 0, 1),
(10002, 'smartslider', 'free', 'dismissNewsletterSampleSliders', '1', 0, 1);

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_smartslider3_generators`
--

CREATE TABLE `hd_nextend2_smartslider3_generators` (
  `id` int(11) NOT NULL,
  `group` varchar(254) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(254) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_smartslider3_sliders`
--

CREATE TABLE `hd_nextend2_smartslider3_sliders` (
  `id` int(11) NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'published',
  `time` datetime NOT NULL,
  `thumbnail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_nextend2_smartslider3_sliders`
--

INSERT INTO `hd_nextend2_smartslider3_sliders` (`id`, `alias`, `title`, `type`, `params`, `status`, `time`, `thumbnail`, `ordering`) VALUES
(1, NULL, 'Tutorial Slider', 'simple', '{\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"background\":\"\",\"background-fixed\":\"0\",\"background-size\":\"cover\",\"background-color\":\"FFFFFF00\",\"backgroundVideoMp4\":\"\",\"backgroundVideoMuted\":\"1\",\"backgroundVideoLoop\":\"1\",\"backgroundVideoMode\":\"fill\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"padding\":\"0|*|0|*|0|*|0\",\"perspective\":\"1000\",\"border-width\":\"0\",\"border-color\":\"3E3E3Eff\",\"border-radius\":\"0\",\"slider-preset\":\"\",\"slider-css\":\"\",\"width\":\"1200\",\"height\":\"600\",\"mobileportrait\":\"1\",\"mobilelandscape\":\"1\",\"tabletportrait\":\"1\",\"tabletlandscape\":\"1\",\"desktopportrait\":\"1\",\"desktoplandscape\":\"1\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidthDesktopLandscape\":\"0\",\"responsiveSlideWidthMaxDesktopLandscape\":\"1600\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"3000\",\"responsiveSlideWidthTabletLandscape\":\"0\",\"responsiveSlideWidthMaxTabletLandscape\":\"1200\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"3000\",\"responsiveSlideWidthMobileLandscape\":\"0\",\"responsiveSlideWidthMaxMobileLandscape\":\"740\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-desktop-portrait\":\"1440\",\"responsive-breakpoint-desktop-portrait-landscape\":\"1440\",\"responsive-breakpoint-tablet-landscape\":\"1300\",\"responsive-breakpoint-tablet-landscape-landscape\":\"1300\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-landscape\":\"900\",\"responsive-breakpoint-mobile-landscape-landscape\":\"1050\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-desktop-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-landscape-enabled\":\"0\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-landscape-enabled\":\"0\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"0\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"body\",\"slider-size-override\":\"0\",\"slider-size-override-mobile-portrait\":\"0\",\"mobile-portrait-width\":\"320\",\"mobile-portrait-height\":\"568\",\"slider-size-override-mobile-landscape\":\"0\",\"mobile-landscape-width\":\"568\",\"mobile-landscape-height\":\"320\",\"slider-size-override-tablet-portrait\":\"0\",\"tablet-portrait-width\":\"768\",\"tablet-portrait-height\":\"1024\",\"slider-size-override-tablet-landscape\":\"0\",\"tablet-landscape-width\":\"1024\",\"tablet-landscape-height\":\"768\",\"slider-size-override-desktop-landscape\":\"0\",\"desktop-landscape-width\":\"1440\",\"desktop-landscape-height\":\"900\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-image\":\"\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"1\",\"widget-arrow-previous-hover-color\":\"ffffffff\",\"widget-arrow-mirror\":\"1\",\"widget-arrow-next\":\"thin-horizontal.svg\",\"widget-arrow-next-image\":\"\",\"widget-arrow-next-color\":\"ffffffcc\",\"widget-arrow-next-hover\":\"0\",\"widget-arrow-next-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-mode\":\"simple\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"15\",\"widget-arrow-previous-position-horizontal\":\"left\",\"widget-arrow-previous-position-horizontal-position\":\"0\",\"widget-arrow-previous-position-horizontal-unit\":\"px\",\"widget-arrow-previous-position-vertical\":\"top\",\"widget-arrow-previous-position-vertical-position\":\"0\",\"widget-arrow-previous-position-vertical-unit\":\"px\",\"widget-arrow-next-position-mode\":\"simple\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"15\",\"widget-arrow-next-position-horizontal\":\"left\",\"widget-arrow-next-position-horizontal-position\":\"0\",\"widget-arrow-next-position-horizontal-unit\":\"px\",\"widget-arrow-next-position-vertical\":\"top\",\"widget-arrow-next-position-vertical-position\":\"0\",\"widget-arrow-next-position-vertical-unit\":\"px\",\"widget-arrow-animation\":\"fade\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-mobilelandscape\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-tabletlandscape\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-arrow-display-desktoplandscape\":\"1\",\"widget-arrow-exclude-slides\":\"\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-mode\":\"simple\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-position-horizontal\":\"left\",\"widget-bullet-position-horizontal-position\":\"0\",\"widget-bullet-position-horizontal-unit\":\"px\",\"widget-bullet-position-vertical\":\"top\",\"widget-bullet-position-vertical-position\":\"0\",\"widget-bullet-position-vertical-unit\":\"px\",\"widget-bullet-action\":\"click\",\"widget-bullet-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffcc\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-bar-full-size\":\"0\",\"widget-bullet-align\":\"center\",\"widget-bullet-orientation\":\"auto\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"60\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"1\",\"widget-bullet-display-mobilelandscape\":\"1\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-tabletlandscape\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bullet-display-desktoplandscape\":\"1\",\"widget-bullet-exclude-slides\":\"\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-mode\":\"simple\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-position-horizontal\":\"left\",\"widget-bar-position-horizontal-position\":\"0\",\"widget-bar-position-horizontal-unit\":\"px\",\"widget-bar-position-vertical\":\"top\",\"widget-bar-position-vertical-position\":\"0\",\"widget-bar-position-vertical-unit\":\"px\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"Raleway,Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-width\":\"100%\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-mobilelandscape\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-tabletlandscape\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-bar-display-desktoplandscape\":\"1\",\"widget-bar-exclude-slides\":\"\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-show-image\":\"1\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-position-mode\":\"simple\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-position-horizontal\":\"left\",\"widget-thumbnail-position-horizontal-position\":\"0\",\"widget-thumbnail-position-horizontal-unit\":\"px\",\"widget-thumbnail-position-vertical\":\"top\",\"widget-thumbnail-position-vertical-position\":\"0\",\"widget-thumbnail-position-vertical-unit\":\"px\",\"widget-thumbnail-action\":\"click\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\ntransition: all 0.4s;\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http://fonts.googleapis.com/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-arrow\":\"1\",\"widget-thumbnail-arrow-width\":\"26\",\"widget-thumbnail-arrow-offset\":\"0\",\"widget-thumbnail-arrow-prev-alt\":\"previous arrow\",\"widget-thumbnail-arrow-next-alt\":\"next arrow\",\"widget-thumbnail-arrow-image\":\"\",\"widget-thumbnail-group\":\"1\",\"widget-thumbnail-invert-group-direction\":\"0\",\"widget-thumbnail-orientation\":\"auto\",\"widget-thumbnail-size\":\"100%\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-mobilelandscape\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-tabletlandscape\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-thumbnail-display-desktoplandscape\":\"1\",\"widget-thumbnail-exclude-slides\":\"\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-shadow-image\":\"\",\"widget-shadow-width\":\"100%\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-mobilelandscape\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-tabletlandscape\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"widget-shadow-display-desktoplandscape\":\"1\",\"widget-shadow-exclude-slides\":\"\",\"widget-fullscreen-enabled\":\"0\",\"widgetfullscreen\":\"image\",\"widget-fullscreen-tonormal\":\"full1.svg\",\"widget-fullscreen-tonormal-image\":\"\",\"widget-fullscreen-tonormal-color\":\"ffffffcc\",\"widget-fullscreen-mirror\":\"1\",\"widget-fullscreen-tofull\":\"full1.svg\",\"widget-fullscreen-tofull-image\":\"\",\"widget-fullscreen-tofull-color\":\"ffffffcc\",\"widget-fullscreen-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-fullscreen-position-mode\":\"simple\",\"widget-fullscreen-position-area\":\"4\",\"widget-fullscreen-position-stack\":\"1\",\"widget-fullscreen-position-offset\":\"15\",\"widget-fullscreen-position-horizontal\":\"left\",\"widget-fullscreen-position-horizontal-position\":\"0\",\"widget-fullscreen-position-horizontal-unit\":\"px\",\"widget-fullscreen-position-vertical\":\"top\",\"widget-fullscreen-position-vertical-position\":\"0\",\"widget-fullscreen-position-vertical-unit\":\"px\",\"widget-fullscreen-responsive-desktop\":\"1\",\"widget-fullscreen-responsive-tablet\":\"0.7\",\"widget-fullscreen-responsive-mobile\":\"0.5\",\"widget-fullscreen-display-hover\":\"0\",\"widget-fullscreen-display-mobileportrait\":\"1\",\"widget-fullscreen-display-mobilelandscape\":\"1\",\"widget-fullscreen-display-tabletportrait\":\"1\",\"widget-fullscreen-display-tabletlandscape\":\"1\",\"widget-fullscreen-display-desktopportrait\":\"1\",\"widget-fullscreen-display-desktoplandscape\":\"1\",\"widget-fullscreen-exclude-slides\":\"\",\"widget-html-enabled\":\"0\",\"widgethtml\":\"html\",\"widget-html-position-mode\":\"simple\",\"widget-html-position-area\":\"2\",\"widget-html-position-stack\":\"1\",\"widget-html-position-offset\":\"0\",\"widget-html-position-horizontal\":\"left\",\"widget-html-position-horizontal-position\":\"0\",\"widget-html-position-horizontal-unit\":\"px\",\"widget-html-position-vertical\":\"top\",\"widget-html-position-vertical-position\":\"0\",\"widget-html-position-vertical-unit\":\"px\",\"widget-html-code\":\"\",\"widget-html-display-hover\":\"0\",\"widget-html-display-mobileportrait\":\"1\",\"widget-html-display-mobilelandscape\":\"1\",\"widget-html-display-tabletportrait\":\"1\",\"widget-html-display-tabletlandscape\":\"1\",\"widget-html-display-desktopportrait\":\"1\",\"widget-html-display-desktoplandscape\":\"1\",\"widget-html-exclude-slides\":\"\",\"animation\":\"fade\",\"animation-duration\":\"500\",\"animation-delay\":\"0\",\"animation-easing\":\"easeOutQuad\",\"carousel\":\"1\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"animation-shifted-background-animation\":\"auto\",\"kenburns-animation\":\"50|*|50|*|\",\"kenburns-animation-speed\":\"default\",\"kenburns-animation-strength\":\"default\",\"shape-divider\":\"\",\"particle\":\"\",\"playfirstlayer\":\"1\",\"playonce\":\"0\",\"layer-animation-play-in\":\"end\",\"layer-animation-play-mode\":\"skippable\",\"parallax-enabled\":\"1\",\"parallax-enabled-mobile\":\"0\",\"parallax-3d\":\"0\",\"parallax-animate\":\"1\",\"parallax-horizontal\":\"mouse\",\"parallax-vertical\":\"mouse\",\"parallax-mouse-origin\":\"slider\",\"parallax-scroll-move\":\"both\",\"autoplay\":\"0\",\"autoplayDuration\":\"8000\",\"autoplayStart\":\"1\",\"autoplayAllowReStart\":\"0\",\"autoplayLoop\":\"1\",\"autoplayfinish\":\"1|*|loop|*|current\",\"loop-single-slide\":\"0\",\"autoplayStopClick\":\"1\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"1\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"1\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-image\":\"\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-mirror\":\"1\",\"widget-autoplay-pause\":\"small-light.svg\",\"widget-autoplay-pause-image\":\"\",\"widget-autoplay-pause-color\":\"ffffffcc\",\"widget-autoplay-responsive-desktop\":\"1\",\"widget-autoplay-responsive-tablet\":\"0.7\",\"widget-autoplay-responsive-mobile\":\"0.5\",\"widget-autoplay-position-mode\":\"simple\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-position-horizontal\":\"left\",\"widget-autoplay-position-horizontal-position\":\"0\",\"widget-autoplay-position-horizontal-unit\":\"px\",\"widget-autoplay-position-vertical\":\"top\",\"widget-autoplay-position-vertical-position\":\"0\",\"widget-autoplay-position-vertical-unit\":\"px\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-mobilelandscape\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-tabletlandscape\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"widget-autoplay-display-desktoplandscape\":\"1\",\"widget-autoplay-exclude-slides\":\"\",\"widget-indicator-enabled\":\"0\",\"widgetindicator\":\"pie\",\"widget-indicator-position-mode\":\"simple\",\"widget-indicator-position-area\":\"4\",\"widget-indicator-position-stack\":\"1\",\"widget-indicator-position-offset\":\"15\",\"widget-indicator-position-horizontal\":\"left\",\"widget-indicator-position-horizontal-position\":\"0\",\"widget-indicator-position-horizontal-unit\":\"px\",\"widget-indicator-position-vertical\":\"top\",\"widget-indicator-position-vertical-position\":\"0\",\"widget-indicator-position-vertical-unit\":\"px\",\"widget-indicator-size\":\"25\",\"widget-indicator-thickness\":\"30\",\"widget-indicator-track\":\"000000ab\",\"widget-indicator-bar\":\"ffffffff\",\"widget-indicator-style\":\"\",\"widget-indicator-display-hover\":\"0\",\"widget-indicator-display-mobileportrait\":\"1\",\"widget-indicator-display-mobilelandscape\":\"1\",\"widget-indicator-display-tabletportrait\":\"1\",\"widget-indicator-display-tabletlandscape\":\"1\",\"widget-indicator-display-desktopportrait\":\"1\",\"widget-indicator-display-desktoplandscape\":\"1\",\"widget-indicator-exclude-slides\":\"\",\"imageload\":\"0\",\"imageloadNeighborSlides\":\"0\",\"optimize-scale\":\"0\",\"optimize-quality\":\"70\",\"optimize-thumbnail-scale\":\"0\",\"optimize-thumbnail-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"layer-image-optimize\":\"0\",\"layer-image-width-tablet\":\"800\",\"layer-image-width-mobile\":\"425\",\"layer-image-base64\":\"0\",\"layer-image-base64-size\":\"50\",\"slides-background-video-mobile\":\"1\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"dependency\":\"\",\"delay\":\"0\",\"is-delayed\":\"0\",\"backgroundMode\":\"fill\",\"slide-css\":\"\",\"randomize\":\"0\",\"randomizeFirst\":\"0\",\"randomize-cache\":\"1\",\"variations\":\"5\",\"reverse-slides\":\"0\",\"maximumslidecount\":\"1000\",\"maintain-session\":\"0\",\"global-lightbox\":\"0\",\"global-lightbox-label\":\"0\",\"slide-background-parallax\":\"0\",\"slide-background-parallax-strength\":\"50\",\"bg-parallax-tablet\":\"0\",\"bg-parallax-mobile\":\"0\",\"blockrightclick\":\"0\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"related-posts\":\"\"}', 'trash', '2020-02-25 13:53:41', 'https://smartslider3.com/wp-content/uploads/slider404/tutorialsliderthumbnail-1.png', 3),
(2, NULL, 'Slider Opteam', 'simple', '{\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1920\",\"height\":\"1080\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"1300\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"980\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"1080\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"5\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"5\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"100\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;background-size:cover;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"0\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"600\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"1\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"0\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"0\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"0\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"1\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"1\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.3\"}', 'published', '2022-02-23 11:37:45', '$upload$/slider2/fullwidhtgradient.png', 0),
(3, NULL, 'Présentation Olvea', 'simple', '{\"thumbnail\":\"\",\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1920\",\"height\":\"1080\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"1300\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"980\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"1080\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"5\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"5\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"100\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;background-size:cover;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"0\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"600\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"1\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"0\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"0\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"0\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"1\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"1\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.3\"}', 'published', '2022-02-23 15:08:14', '', 1);
INSERT INTO `hd_nextend2_smartslider3_sliders` (`id`, `alias`, `title`, `type`, `params`, `status`, `time`, `thumbnail`, `ordering`) VALUES
(4, NULL, 'Présentation Olvea - TEAM', 'simple', '{\"thumbnail\":\"\",\"aria-label\":\"Slider\",\"alias-id\":\"\",\"alias-smoothscroll\":\"\",\"alias-slideswitch\":\"\",\"alias-slideswitch-scroll\":\"1\",\"align\":\"normal\",\"margin\":\"0|*|0|*|0|*|0\",\"width\":\"1920\",\"height\":\"1080\",\"responsiveLimitSlideWidth\":\"1\",\"responsiveSlideWidth\":\"0\",\"responsiveSlideWidthMax\":\"1300\",\"responsiveSlideWidthTablet\":\"0\",\"responsiveSlideWidthMaxTablet\":\"980\",\"responsiveSlideWidthMobile\":\"0\",\"responsiveSlideWidthMaxMobile\":\"480\",\"responsive-breakpoint-tablet-portrait\":\"1199\",\"responsive-breakpoint-tablet-portrait-landscape\":\"1199\",\"responsive-breakpoint-mobile-portrait\":\"700\",\"responsive-breakpoint-mobile-portrait-landscape\":\"900\",\"responsive-breakpoint-tablet-portrait-enabled\":\"1\",\"responsive-breakpoint-mobile-portrait-enabled\":\"1\",\"responsive-breakpoint-global\":\"0\",\"breakpoints-orientation\":\"portrait\",\"responsive-mode\":\"fullwidth\",\"responsiveSliderHeightMin\":\"1080\",\"responsiveForceFull\":\"1\",\"responsiveForceFullOverflowX\":\"body\",\"responsiveForceFullHorizontalSelector\":\"\",\"controlsTouch\":\"horizontal\",\"controlsScroll\":\"0\",\"controlsKeyboard\":\"1\",\"widget-arrow-enabled\":\"0\",\"widgetarrow\":\"imageEmpty\",\"widget-arrow-previous\":\"thin-horizontal.svg\",\"widget-arrow-previous-color\":\"ffffffcc\",\"widget-arrow-previous-hover\":\"0\",\"widget-arrow-previous-hover-color\":\"ffffffcc\",\"widget-arrow-style\":\"\",\"widget-arrow-previous-position-area\":\"6\",\"widget-arrow-previous-position-stack\":\"1\",\"widget-arrow-previous-position-offset\":\"5\",\"widget-arrow-next-position-area\":\"7\",\"widget-arrow-next-position-stack\":\"1\",\"widget-arrow-next-position-offset\":\"5\",\"widget-arrow-previous-alt\":\"previous arrow\",\"widget-arrow-next-alt\":\"next arrow\",\"widget-arrow-base64\":\"1\",\"widget-arrow-display-hover\":\"0\",\"widget-arrow-display-mobileportrait\":\"0\",\"widget-arrow-display-tabletportrait\":\"1\",\"widget-arrow-display-desktopportrait\":\"1\",\"widget-bullet-enabled\":\"1\",\"widgetbullet\":\"transition\",\"widget-bullet-position-area\":\"10\",\"widget-bullet-position-stack\":\"1\",\"widget-bullet-position-offset\":\"5\",\"widget-bullet-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"ffffff00\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"5|*|5|*|5|*|5|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffcc\\\",\\\"borderradius\\\":\\\"50\\\",\\\"extra\\\":\\\"margin: 4px;\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\",\\\"border\\\":\\\"2|*|solid|*|ffffffff\\\"}]}\",\"widget-bullet-bar\":\"\",\"widget-bullet-thumbnail-show-image\":\"0\",\"widget-bullet-thumbnail-width\":\"100\",\"widget-bullet-thumbnail-height\":\"60\",\"widget-bullet-thumbnail-style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000080\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"margin: 5px;background-size:cover;\\\"}]}\",\"widget-bullet-thumbnail-side\":\"before\",\"widget-bullet-display-hover\":\"0\",\"widget-bullet-display-mobileportrait\":\"0\",\"widget-bullet-display-tabletportrait\":\"1\",\"widget-bullet-display-desktopportrait\":\"1\",\"widget-bar-enabled\":\"0\",\"widgetbar\":\"horizontal\",\"widget-bar-position-area\":\"10\",\"widget-bar-position-stack\":\"1\",\"widget-bar-position-offset\":\"30\",\"widget-bar-animate\":\"0\",\"widget-bar-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"5|*|20|*|5|*|20|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"40\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-bar-show-title\":\"1\",\"widget-bar-font-title\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-show-description\":\"1\",\"widget-bar-font-description\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000c7\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":1,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\",\\\"extra\\\":\\\"vertical-align: middle;\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-bar-slide-count\":\"0\",\"widget-bar-full-width\":\"0\",\"widget-bar-separator\":\" - \",\"widget-bar-align\":\"center\",\"widget-bar-display-hover\":\"0\",\"widget-bar-display-mobileportrait\":\"1\",\"widget-bar-display-tabletportrait\":\"1\",\"widget-bar-display-desktopportrait\":\"1\",\"widget-thumbnail-enabled\":\"0\",\"widgetthumbnail\":\"default\",\"widget-thumbnail-width\":\"100\",\"widget-thumbnail-height\":\"60\",\"widget-thumbnail-tablet-width\":\"100\",\"widget-thumbnail-tablet-height\":\"60\",\"widget-thumbnail-mobile-width\":\"100\",\"widget-thumbnail-mobile-height\":\"60\",\"widget-thumbnail-position-area\":\"12\",\"widget-thumbnail-position-stack\":\"1\",\"widget-thumbnail-position-offset\":\"0\",\"widget-thumbnail-align-content\":\"start\",\"widget-thumbnail-style-bar\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"242424ff\\\",\\\"padding\\\":\\\"3|*|3|*|3|*|3|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-style-slides\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"00000000\\\",\\\"padding\\\":\\\"0|*|0|*|0|*|0|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|ffffff00\\\",\\\"borderradius\\\":\\\"0\\\",\\\"opacity\\\":\\\"40\\\",\\\"extra\\\":\\\"margin: 3px;\\\\ntransition: all 0.4s;\\\\nbackground-size: cover;\\\"},{\\\"border\\\":\\\"0|*|solid|*|ffffffcc\\\",\\\"opacity\\\":\\\"100\\\",\\\"extra\\\":\\\"\\\"}]}\",\"widget-thumbnail-title-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"3|*|10|*|3|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"0\\\",\\\"extra\\\":\\\"bottom: 0;\\\\nleft: 0;\\\"}]}\",\"widget-thumbnail-title\":\"0\",\"widget-thumbnail-title-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-description\":\"0\",\"widget-thumbnail-description-font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ab\\\",\\\"afont\\\":\\\"Montserrat\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"left\\\"},{\\\"color\\\":\\\"fc2828ff\\\",\\\"afont\\\":\\\"google(@import url(http:\\/\\/fonts.googleapis.com\\/css?family=Raleway);),Arial\\\",\\\"size\\\":\\\"25||px\\\"},{}]}\",\"widget-thumbnail-caption-placement\":\"overlay\",\"widget-thumbnail-caption-size\":\"100\",\"widget-thumbnail-display-hover\":\"0\",\"widget-thumbnail-display-mobileportrait\":\"1\",\"widget-thumbnail-display-tabletportrait\":\"1\",\"widget-thumbnail-display-desktopportrait\":\"1\",\"widget-shadow-enabled\":\"0\",\"widgetshadow\":\"shadow\",\"widget-shadow-shadow\":\"dark.png\",\"widget-shadow-display-mobileportrait\":\"1\",\"widget-shadow-display-tabletportrait\":\"1\",\"widget-shadow-display-desktopportrait\":\"1\",\"animation\":\"horizontal\",\"animation-duration\":\"600\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"normal\",\"autoplay\":\"1\",\"autoplayDuration\":\"8000\",\"autoplayStopClick\":\"0\",\"autoplayStopMouse\":\"0\",\"autoplayStopMedia\":\"0\",\"autoplayResumeClick\":\"0\",\"autoplayResumeMouse\":\"0\",\"autoplayResumeMedia\":\"0\",\"widget-autoplay-enabled\":\"0\",\"widgetautoplay\":\"image\",\"widget-autoplay-play\":\"small-light.svg\",\"widget-autoplay-play-color\":\"ffffffcc\",\"widget-autoplay-style\":\"{\\\"data\\\":[{\\\"backgroundcolor\\\":\\\"000000ab\\\",\\\"padding\\\":\\\"10|*|10|*|10|*|10|*|px\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"3\\\",\\\"extra\\\":\\\"\\\"},{\\\"backgroundcolor\\\":\\\"000000ab\\\"}]}\",\"widget-autoplay-position-area\":\"4\",\"widget-autoplay-position-stack\":\"1\",\"widget-autoplay-position-offset\":\"15\",\"widget-autoplay-display-hover\":\"0\",\"widget-autoplay-display-mobileportrait\":\"1\",\"widget-autoplay-display-tabletportrait\":\"1\",\"widget-autoplay-display-desktopportrait\":\"1\",\"loading-type\":\"\",\"delay\":\"0\",\"playWhenVisible\":\"1\",\"playWhenVisibleAt\":\"50\",\"optimize-scale\":\"1\",\"optimize-quality\":\"70\",\"optimize-slide-width-normal\":\"1920\",\"optimize-thumbnail-scale\":\"1\",\"optimize-thumbnail-quality\":\"70\",\"optimizeThumbnailWidth\":\"100\",\"optimizeThumbnailHeight\":\"60\",\"backgroundMode\":\"fill\",\"backgroundBlurFit\":\"7\",\"controlsBlockCarouselInteraction\":\"1\",\"clear-both\":\"1\",\"clear-both-after\":\"1\",\"overflow-hidden-page\":\"0\",\"responsiveFocusUser\":\"1\",\"responsiveFocusEdge\":\"auto\",\"is-delayed\":\"0\",\"legacy-font-scale\":\"0\",\"classes\":\"\",\"custom-css-codes\":\"\",\"callbacks\":\"\",\"loading-time\":\"2000\",\"related-posts\":\"\",\"version\":\"3.5.1.3\"}', 'published', '2022-02-25 16:45:51', '', 2);

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_smartslider3_sliders_xref`
--

CREATE TABLE `hd_nextend2_smartslider3_sliders_xref` (
  `group_id` int(11) NOT NULL,
  `slider_id` int(11) NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_nextend2_smartslider3_sliders_xref`
--

INSERT INTO `hd_nextend2_smartslider3_sliders_xref` (`group_id`, `slider_id`, `ordering`) VALUES
(0, 2, 0),
(0, 3, 1),
(0, 4, 2);

-- --------------------------------------------------------

--
-- Structure de la table `hd_nextend2_smartslider3_slides`
--

CREATE TABLE `hd_nextend2_smartslider3_slides` (
  `id` int(11) NOT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slider` int(11) NOT NULL,
  `publish_up` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '1970-01-01 00:00:00',
  `published` tinyint(1) NOT NULL,
  `first` int(11) NOT NULL,
  `slide` longtext COLLATE utf8mb4_unicode_520_ci,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thumbnail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ordering` int(11) NOT NULL,
  `generator_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_nextend2_smartslider3_slides`
--

INSERT INTO `hd_nextend2_smartslider3_slides` (`id`, `title`, `slider`, `publish_up`, `publish_down`, `published`, `first`, `slide`, `description`, `thumbnail`, `params`, `ordering`, `generator_id`) VALUES
(1, 'Slide Background', 1, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-IbNOabpfT5aE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-dtwtw9DVCwgQ\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Fjvyu081qJeK\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"01. Slide Background\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Every slide includes a background, which can be a picture or solid color.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To change the background click on the label bar and in the layer window select the style tab.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Choose a source from the background top tab then upload an image or pick a background color.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-LnImbm1HgUAv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/background.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', 'https://smartslider3.com/wp-content/uploads/slider424/slidebackground.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide1.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}', 1, 0),
(2, 'Build & Design', 1, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":1120,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitselfalign\":\"center\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-TPnUuKlAWVoC\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"tabletportraitgutter\":20,\"mobileportraitinneralign\":\"inherit\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"mobileportraitgutter\":20,\"mobileportraitwrapafter\":1,\"mobileportraitmaxwidth\":400,\"mobileportraitselfalign\":\"inherit\",\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-NmnNQvKK01kO\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"ffffff00\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitorder\":0,\"tabletportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitmaxwidth\":0,\"mobileportraitinneralign\":\"left\",\"mobileportraitpadding\":\"10|*|0|*|10|*|0|*|px\",\"mobileportraitorder\":2,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-R5Jkk06Nmzr4\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"2/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Jeans Store Interior\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.2\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"02. Build & Design\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Lorem ipsum dolor sit amet, consect\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"24||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.3\\\",\\\"weight\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Build any layout with layers and customize your designs limitlessly.\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 1\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"To add a layer, click the green plus button in the left sidebar and select the type of layer.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":100,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Latest Project\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffdb\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"uppercase\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"heading\":\"Step 2\",\"title\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"split-text-transform-origin\":\"50|*|50|*|0\",\"split-text-backface-visibility\":\"1\",\"split-text-animation-in\":\"\",\"split-text-delay-in\":\"0\",\"split-text-animation-out\":\"\",\"split-text-delay-out\":\"0\",\"class\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":90,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Text\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffb0\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"weight\\\":400,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Select any layer and you can edit its content and style properties in the layer window.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"20|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":80,\"mobileportraitmargin\":\"10|*|0|*|0|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Read More\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"14||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"weight\\\":1,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"1px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"0568f6ff\\\"}]}\",\"style\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"0568f6ff\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"1|*|2|*|1|*|2|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"5\\\"},{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffffff\\\"}]}\",\"content\":\"Next Slide\",\"nowrap\":\"1\",\"fullwidth\":\"0\",\"href\":\"NextSlide[]\",\"href-target\":\"_self\",\"href-rel\":\"\",\"class\":\"\",\"icon\":\"\",\"iconsize\":\"100\",\"iconspacing\":\"30\",\"iconplacement\":\"left\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitinneralign\":\"center\",\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-iYi6ZKk8yeVp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"verticalalign\":\"center\",\"colwidth\":\"3/5\",\"href\":\"\",\"href-target\":\"_self\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Column\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":300,\"id\":\"\",\"uniqueclass\":\"\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', 'https://smartslider3.com/wp-content/uploads/slider424/buildanddesign.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"10|*|60|*|10|*|60\",\"tabletportraitpadding\":\"10|*|50|*|10|*|50\",\"mobileportraitpadding\":\"10|*|10|*|35|*|10\",\"record-slides\":0,\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"ffffff00\",\"backgroundGradient\":\"off\",\"backgroundColorEnd\":\"ffffff00\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"https://smartslider3.com/wp-content/uploads/slider424/slide2.png\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.4.0\"}', 2, 0),
(3, 'Slide 1', 2, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-19001ef738de1\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-180f0b0bfd71d\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1ee0db941a48b\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"9/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|5|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":80,\"id\":\"\",\"uniqueclass\":\"n-uc-KIXhBvPSBS1J\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"LATEST PROJECT\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"Semaine des services de l\'automobile et de la mobilit\\u00e9\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"2px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffff33\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0.5|*|1.5|*|0.5|*|1.5|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"n-uc-AjkxiCjWgkZp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Free Full Width Slider\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Site \\u00e9v\\u00e9nementiel\",\"priority\":\"2\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-037bB6LoFg48\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Smart Slider 3 is the best rated fr\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Concevoir un site web \\u00e9v\\u00e8nementiel, responsive, g\\u00e9olocalis\\u00e9 et multi-administrateurs \\u00e0 l\\u2019occasion de la semaine de sensibilisation aux m\\u00e9tiers de l\\u2019automobile et de la mobilit\\u00e9.\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-13116e89e3503\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"11/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitmaxwidth\":270,\"id\":\"\",\"uniqueclass\":\"n-uc-x9MKS9OIcHrz\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"gradientslider1.png\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/02/iPhone_X_-_ssam-2022-v2.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"80%|*|80%\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', '$upload$/slider2/gradient1.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|50|*|40|*|50\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"0072d2ff\",\"backgroundGradient\":\"horizontal\",\"backgroundColorEnd\":\"00b6c3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 0, 0);
INSERT INTO `hd_nextend2_smartslider3_slides` (`id`, `title`, `slider`, `publish_up`, `publish_down`, `published`, `first`, `slide`, `description`, `thumbnail`, `params`, `ordering`, `generator_id`) VALUES
(4, 'Slide 2', 2, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|20|*|10|*|20|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1bcf86987cbe4\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-141aa931f436e\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1c73b8f8a3847\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"9/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|5|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":80,\"id\":\"\",\"uniqueclass\":\"n-uc-ST3zovKuXSDj\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"LATEST PROJECT\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"Gagneraud\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"2px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffff33\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0.5|*|1.5|*|0.5|*|1.5|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"n-uc-apfDOUBstlw7\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Beautiful Visual Interface\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Intranet Groupe et R\\u00e9gions\",\"priority\":\"2\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-CiLD0XYurxcD\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"The interface is clear and simple, \",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Outre une dynamisation de l\\u2019identit\\u00e9 et de l\\u2019image du groupe, les dirigeants souhaitaient renouveler les messages et des argumentaires, afin notamment de s\\u00e9duire les jeunes dipl\\u00f4m\\u00e9s ainsi que les futurs collaborateurs potentiels.\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-10930cce5e62e\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"11/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitmaxwidth\":320,\"mobileportraitmaxwidth\":160,\"id\":\"\",\"uniqueclass\":\"n-uc-8vZoqCmDt8Eg\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"gradientslider2.png\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/02/WEB-APP-GAGNU.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', '$upload$/slider2/slide2thumbnail.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|50|*|40|*|50\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"f79b65ff\",\"backgroundGradient\":\"horizontal\",\"backgroundColorEnd\":\"fdf355ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 1, 0),
(5, 'Slide 3', 2, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"left\",\"desktopportraitpadding\":\"10|*|20|*|10|*|20|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-119f66eb31e42\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-12b77186b1328\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-15555616c1ac0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"9/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|5|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitfontsize\":80,\"id\":\"\",\"uniqueclass\":\"n-uc-EaqRUpgyisDA\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"LATEST PROJECT\",\"namesynced\":1,\"item\":{\"type\":\"button\",\"values\":{\"content\":\"Parcours m\\u00e9tier\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"12||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":700,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"center\\\",\\\"letterspacing\\\":\\\"2px\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"backgroundcolor\\\":\\\"ffffff33\\\",\\\"opacity\\\":100,\\\"padding\\\":\\\"0.5|*|1.5|*|0.5|*|1.5|*|em\\\",\\\"boxshadow\\\":\\\"0|*|0|*|0|*|0|*|000000ff\\\",\\\"border\\\":\\\"0|*|solid|*|000000ff\\\",\\\"borderradius\\\":\\\"99\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"fullwidth\":\"0\",\"nowrap\":\"1\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":70,\"id\":\"\",\"uniqueclass\":\"n-uc-CZanzvj92wWk\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Fully Responsive Slider\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Pop up M\\u00e9tier\",\"priority\":\"2\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.5\\\",\\\"bold\\\":300,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|30|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitfontsize\":80,\"mobileportraitfontsize\":60,\"mobileportraitmargin\":\"0|*|0|*|10|*|0|*|px\",\"id\":\"\",\"uniqueclass\":\"n-uc-xUP8ZpvLUYtK\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"You can adjust the layers on tablet\",\"namesynced\":1,\"item\":{\"type\":\"text\",\"values\":{\"content\":\"Optez pour la facilit\\u00e9 avec nos modules d\\u2019expositions en bois naturel ou dibond (aluminium + pvc) permettant de diffuser informations, jeux ludo-p\\u00e9dagogiques et outils num\\u00e9riques.\",\"font\":\"{\\\"name\\\":\\\"Static\\\",\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"ffffffcc\\\",\\\"size\\\":\\\"18||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Roboto\\\",\\\"lineheight\\\":\\\"1.6\\\",\\\"bold\\\":0,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"mobileportraitorder\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-14babe20e1197\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"11/20\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"tabletportraitmaxwidth\":320,\"mobileportraitmaxwidth\":160,\"id\":\"\",\"uniqueclass\":\"n-uc-PaeRZRqgsrZZ\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"gradientslider3.png\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/02/learning-v2-72dpi.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|auto\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', '$upload$/slider2/slide3thumbnail.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|50|*|40|*|50\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"color\",\"backgroundColor\":\"4ac23fff\",\"backgroundGradient\":\"horizontal\",\"backgroundColorEnd\":\"0072d2ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 2, 0),
(6, 'Slide 2 Arrivées', 3, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 1, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-hNW1wHtKgQD6\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-R3dnETvVagfs\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":0,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1tfL56IOVoMP\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitgutter\":110,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1ceb05270f64b\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|40|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1aa4936d29e8d\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-15c823a24fc8a\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[]}]}]}]}]}]', '', '$upload$/2022/03/PHOTO-PROFILE.png', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|45|*|40|*|100\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/03/Capture-decran-2022-03-24-152537.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 2, 0),
(9, 'Slide 1 Valeur', 3, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-GzNF2ihFwo9n\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-CONjeFnE2vLx\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Row\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-mSFdM3cHzlxY\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-f3QAhQ08PocI\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/02/teste-valeur-3.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"|*|850\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]}]}]', '', '$upload$/2022/02/TESTE-VALEUR.png', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|50|*|40|*|50\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/02/Plan-de-travail-1-80.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 1, 0),
(10, 'Slide 3 Emploie', 3, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-fIJYyfxoKIcq\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-JuLMvoU4gvZN\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":0,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-c3PJzZ7Kh0d0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[]}]},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":null,\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"size\":\"auto|*|auto\",\"href\":\"#\",\"style\":\"\",\"image\":\"$upload$/2022/03/EM-Logo-2018-default.png\",\"alt\":\"\",\"title\":\"\",\"href-target\":\"_self\",\"href-rel\":\"\",\"href-class\":\"\",\"cssclass\":\"\",\"image-optimize\":1}}},{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"35|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":null,\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Titre d\'en-t\\u00eate\",\"namesynced\":1,\"item\":{\"type\":\"heading\",\"values\":{\"heading\":\"Bonjour !\",\"priority\":\"div\",\"fullwidth\":\"1\",\"nowrap\":\"0\",\"font\":\"{\\\"data\\\":[{\\\"color\\\":\\\"ffffffff\\\",\\\"size\\\":\\\"36||px\\\",\\\"align\\\":\\\"inherit\\\"},{\\\"extra\\\":\\\"\\\"}]}\",\"style\":\"\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\"}}}]}]', '', '$upload$/2022/02/Image2.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|45|*|40|*|100\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/03/20220322-webinar-icims-language-desktop.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 2, 0),
(11, 'Slide 4 YT', 3, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-3Ms8l5pdePex\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":\"auto\",\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-eo8Ndo0dgECE\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"YouTube\",\"namesynced\":1,\"item\":{\"type\":\"youtube\",\"values\":{\"youtubeurl\":\"https://www.youtube.com/watch?v=RtzVsoYkgwo&ab_channel=EMNormandieBusinessSchool\",\"image\":\"https://i.ytimg.com/vi/RtzVsoYkgwo/hqdefault.jpg\",\"aspect-ratio\":\"16:9\",\"aspect-ratio-width\":\"16\",\"aspect-ratio-height\":\"9\",\"autoplay\":\"1\",\"ended\":\"next\",\"start\":\"0\",\"end\":\"0\",\"volume\":\"1\",\"scroll-pause\":\"\",\"loop\":\"0\",\"reset\":\"1\",\"controls\":\"1\",\"center\":\"1\",\"related\":\"0\"}}},{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-hiLVZgQTag4Y\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":0,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-MdZju4OJwwu7\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[]}]}]}]', '', '$upload$/2022/03/20220322-webinar-icims-language-desktop.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|40|*|0\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":244800,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/03/20220322-webinar-icims-language-desktop.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 2, 0);
INSERT INTO `hd_nextend2_smartslider3_slides` (`id`, `title`, `slider`, `publish_up`, `publish_down`, `published`, `first`, `slide`, `description`, `thumbnail`, `params`, `ordering`, `generator_id`) VALUES
(13, 'Slide 2 Arrivées', 4, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 1, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-Nwhgg7ZnijGA\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-1UXJHL9RqgBB\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":0,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-w8SSYnKCbJuP\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitgutter\":110,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-OcjVPxRtRgq0\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|40|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8uaIZCUJLUlr\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-D5mYhX1U266s\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/03/EM-Logo-2018-default.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|400\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-syl8UfSVrT7d\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|40|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-f35c8Wmly9Sp\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Image\",\"namesynced\":1,\"item\":{\"type\":\"image\",\"values\":{\"image\":\"$upload$/2022/03/EM-Logo-2018-default.png\",\"href\":\"#\",\"href-target\":\"_self\",\"href-rel\":\"\",\"size\":\"auto|*|400\",\"alt\":\"\",\"title\":\"\",\"href-class\":\"\"}}}]}]},{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10\",\"desktopportraitgutter\":110,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-4EA2zlGL2Qgc\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":1,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"25|*|25|*|25|*|25\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-IupYyaEei8jQ\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"E7EFF0ff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-PunuzyMRJciH\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":0,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"77AEB1ff\\\",\\\"size\\\":\\\"27||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.8\\\",\\\"weight\\\":200,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"<b>Pierre Malard </b>a int\\u00e9gr\\u00e9 l\\u2019\\u00e9quipe de Ludovic Maillard en tant qu\\u2019Agent de Quai le 3 janvier 2022. Il a plusieurs ann\\u00e9es d\\u2019exp\\u00e9rience comme manutentionnaire cariste, op\\u00e9rateur de production sur automate et op\\u00e9rateur en dilution de peinture.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]},{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"25|*|25|*|25|*|25\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-mjess47fgH3d\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"E7EFF0ff\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/2\",\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"0|*|0|*|0|*|0\",\"borderstyle\":\"solid\",\"bordercolor\":\"ffffffff\",\"name\":\"Colonne\",\"namesynced\":1,\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-RIgmD2s5XTqv\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"Texte\",\"namesynced\":0,\"item\":{\"type\":\"text\",\"values\":{\"font\":\"{\\\"data\\\":[{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"77AEB1ff\\\",\\\"size\\\":\\\"27||px\\\",\\\"tshadow\\\":\\\"0|*|0|*|0|*|000000ff\\\",\\\"afont\\\":\\\"Arial\\\",\\\"lineheight\\\":\\\"1.8\\\",\\\"weight\\\":200,\\\"italic\\\":0,\\\"underline\\\":0,\\\"align\\\":\\\"inherit\\\",\\\"letterspacing\\\":\\\"normal\\\",\\\"wordspacing\\\":\\\"normal\\\",\\\"texttransform\\\":\\\"none\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"},{\\\"extra\\\":\\\"\\\",\\\"color\\\":\\\"1890d7ff\\\"}]}\",\"style\":\"\",\"content\":\"Titulaire d\\u2019un bac technologique en g\\u00e9nie m\\u00e9canique, <b>Xavier Dumont</b> \\u00e9tait Op\\u00e9rateur de Quart chez V\\u00e9olia depuis 2012 apr\\u00e8s un parcours polyvalent alternant des postes de m\\u00e9canicien, de cariste, et une exp\\u00e9rience de conducteur de four chez Citron. <b>Xavier rejoint</b> OLVEA en tant qu\\u2019Op\\u00e9rateur de quart le 5 janvier 2022.\",\"content-tablet-enabled\":\"0\",\"contenttablet\":\"\",\"content-mobile-enabled\":\"0\",\"contentmobile\":\"\"}}}]}]}]}]}]}]', '', '$upload$/2022/03/PHOTO-PROFILE.png', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"40|*|45|*|40|*|100\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"default\",\"static-slide\":0,\"slide-duration\":0,\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/03/20220322-webinar-icims-language-desktop.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 1, 0),
(15, 'Slide 1 YT team', 4, '1970-01-01 00:00:00', '1970-01-01 00:00:00', 0, 0, '[{\"type\":\"content\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"center\",\"desktopportraitpadding\":\"10|*|10|*|10|*|10|*|px\",\"desktopportraitselfalign\":\"inherit\",\"mobileportraitinneralign\":\"center\",\"mobileportraitpadding\":\"20|*|20|*|20|*|20|*|px\",\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-eD2ZptBfnrMj\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"layers\":[{\"type\":\"layer\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitmargin\":\"0|*|0|*|0|*|0\",\"desktopportraitheight\":\"auto\",\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"id\":\"\",\"uniqueclass\":\"n-uc-7PbkOeC4OBZl\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"name\":\"YouTube\",\"namesynced\":1,\"item\":{\"type\":\"youtube\",\"values\":{\"youtubeurl\":\"https://www.youtube.com/watch?v=B3gCR5RpAOk&ab_channel=GroupeOLVEA\",\"image\":\"https://i.ytimg.com/vi/B3gCR5RpAOk/hqdefault.jpg\",\"aspect-ratio\":\"16:9\",\"aspect-ratio-width\":\"16\",\"aspect-ratio-height\":\"9\",\"autoplay\":\"1\",\"ended\":\"next\",\"start\":\"0\",\"end\":\"0\",\"volume\":\"1\",\"scroll-pause\":\"\",\"loop\":\"0\",\"reset\":\"1\",\"controls\":\"1\",\"center\":\"1\",\"related\":\"0\"}}},{\"type\":\"row\",\"pm\":\"normal\",\"desktopportraitfontsize\":100,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitgutter\":0,\"desktopportraitwrapafter\":0,\"desktopportraitmargin\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitheight\":0,\"desktopportraitmaxwidth\":0,\"desktopportraitselfalign\":\"inherit\",\"mobileportraitgutter\":10,\"mobileportraitwrapafter\":1,\"mobilelandscapewrapafter\":1,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-8Mhict6prqE7\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"FFFFFFFF\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"fullwidth\":1,\"stretch\":0,\"name\":\"Rang\\u00e9e\",\"namesynced\":0,\"cols\":[{\"type\":\"col\",\"pm\":\"default\",\"desktopportraitfontsize\":100,\"desktopportraitverticalalign\":\"center\",\"desktopportraitmaxwidth\":0,\"desktopportraitinneralign\":\"inherit\",\"desktopportraitpadding\":\"0|*|0|*|0|*|0|*|px\",\"desktopportraitorder\":0,\"opened\":1,\"id\":\"\",\"uniqueclass\":\"n-uc-DpE5EPd8xgCI\",\"generatorvisible\":\"\",\"zindex\":2,\"class\":\"\",\"crop\":\"visible\",\"rotation\":0,\"parallax\":0,\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"bgimage\":\"\",\"bgimagex\":50,\"bgimagey\":50,\"bgcolor\":\"00000000\",\"bgcolorgradient\":\"off\",\"bgcolorgradientend\":\"00000000\",\"colwidth\":\"1/1\",\"href\":\"#\",\"href-target\":\"_self\",\"aria-label\":\"\",\"borderradius\":0,\"boxshadow\":\"0|*|0|*|0|*|0|*|00000080\",\"borderwidth\":\"1|*|1|*|1|*|1\",\"borderstyle\":\"none\",\"bordercolor\":\"ffffffff\",\"name\":\"Col\",\"namesynced\":1,\"layers\":[]}]}]}]', '', '$upload$/2022/02/Plan-de-travail-1-80.jpg', '{\"type\":\"slide\",\"desktopportraitfontsize\":100,\"desktopportraitpadding\":\"0|*|0|*|40|*|0\",\"mobileportraitpadding\":\"0|*|0|*|0|*|0\",\"record-slides\":0,\"thumbnailAlt\":\"\",\"thumbnailType\":\"videoDark\",\"static-slide\":0,\"slide-duration\":\"118000\",\"ligthboxImage\":\"\",\"background-animation\":\"\",\"background-animation-color\":\"333333ff\",\"background-animation-speed\":\"default\",\"desktopportrait\":1,\"desktoplandscape\":1,\"tabletportrait\":1,\"tabletlandscape\":1,\"mobileportrait\":1,\"mobilelandscape\":1,\"href\":\"\",\"href-target\":\"_self\",\"aria-label\":\"\",\"background-type\":\"image\",\"backgroundColor\":\"98D2D2ff\",\"backgroundGradient\":\"diagonal1\",\"backgroundColorEnd\":\"01add3ff\",\"backgroundColorOverlay\":0,\"backgroundImage\":\"$upload$/2022/02/Plan-de-travail-1-80.jpg\",\"backgroundFocusX\":50,\"backgroundFocusY\":50,\"backgroundImageOpacity\":100,\"backgroundImageBlur\":0,\"backgroundAlt\":\"\",\"backgroundTitle\":\"\",\"backgroundMode\":\"default\",\"backgroundBlurFit\":7,\"guides\":\"eyJob3Jpem9udGFsIjpbXSwidmVydGljYWwiOltdfQ==\",\"version\":\"3.5.1.3\"}', 2, 0);

-- --------------------------------------------------------

--
-- Structure de la table `hd_options`
--

CREATE TABLE `hd_options` (
  `option_id` bigint(20) UNSIGNED NOT NULL,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_options`
--

INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', 'https://happydisplay.opteam.net', 'yes'),
(2, 'home', 'https://happydisplay.opteam.net', 'yes'),
(3, 'blogname', 'Happy Display', 'yes'),
(4, 'blogdescription', 'Connect yours screens', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'web@opteam.net', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '0', 'yes'),
(22, 'posts_per_page', '10', 'yes'),
(23, 'date_format', 'j F Y', 'yes'),
(24, 'time_format', 'G\\hi', 'yes'),
(25, 'links_updated_date_format', 'd F Y G\\hi', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%postname%/', 'yes');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(29, 'rewrite_rules', 'a:518:{s:13:\"(?:events)/?$\";s:49:\"index.php?post_type=mec-events&MecDisplay=default\";s:38:\"(?:events)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=mec-events&feed=$matches[1]\";s:10:\"project/?$\";s:27:\"index.php?post_type=project\";s:40:\"project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:35:\"project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:27:\"project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:9:\"events/?$\";s:30:\"index.php?post_type=mec-events\";s:39:\"events/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=mec-events&feed=$matches[1]\";s:34:\"events/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=mec-events&feed=$matches[1]\";s:26:\"events/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=mec-events&paged=$matches[1]\";s:15:\"publications/?$\";s:27:\"index.php?post_type=project\";s:45:\"publications/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:40:\"publications/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:32:\"publications/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:6:\"amm/?$\";s:23:\"index.php?post_type=amm\";s:36:\"amm/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=amm&feed=$matches[1]\";s:31:\"amm/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=amm&feed=$matches[1]\";s:23:\"amm/page/([0-9]{1,})/?$\";s:41:\"index.php?post_type=amm&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/verify(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&verify=$matches[3]\";s:32:\"category/(.+?)/cancel(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&cancel=$matches[3]\";s:40:\"category/(.+?)/gateway-cancel(/(.*))?/?$\";s:62:\"index.php?category_name=$matches[1]&gateway-cancel=$matches[3]\";s:40:\"category/(.+?)/gateway-return(/(.*))?/?$\";s:62:\"index.php?category_name=$matches[1]&gateway-return=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:56:\"layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:51:\"layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=layout_category&term=$matches[1]&feed=$matches[2]\";s:32:\"layout_category/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=layout_category&term=$matches[1]&embed=true\";s:44:\"layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=layout_category&term=$matches[1]&paged=$matches[2]\";s:26:\"layout_category/([^/]+)/?$\";s:51:\"index.php?taxonomy=layout_category&term=$matches[1]\";s:51:\"layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:46:\"layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?taxonomy=layout_tag&term=$matches[1]&feed=$matches[2]\";s:27:\"layout_tag/([^/]+)/embed/?$\";s:57:\"index.php?taxonomy=layout_tag&term=$matches[1]&embed=true\";s:39:\"layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?taxonomy=layout_tag&term=$matches[1]&paged=$matches[2]\";s:21:\"layout_tag/([^/]+)/?$\";s:46:\"index.php?taxonomy=layout_tag&term=$matches[1]\";s:52:\"layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_pack&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_pack/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_pack&term=$matches[1]&embed=true\";s:40:\"layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_pack&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_pack/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_pack&term=$matches[1]\";s:52:\"layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:47:\"layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=layout_type&term=$matches[1]&feed=$matches[2]\";s:28:\"layout_type/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=layout_type&term=$matches[1]&embed=true\";s:40:\"layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=layout_type&term=$matches[1]&paged=$matches[2]\";s:22:\"layout_type/([^/]+)/?$\";s:47:\"index.php?taxonomy=layout_type&term=$matches[1]\";s:53:\"module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:48:\"module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=module_width&term=$matches[1]&feed=$matches[2]\";s:29:\"module_width/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=module_width&term=$matches[1]&embed=true\";s:41:\"module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=module_width&term=$matches[1]&paged=$matches[2]\";s:23:\"module_width/([^/]+)/?$\";s:48:\"index.php?taxonomy=module_width&term=$matches[1]\";s:46:\"scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:41:\"scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?taxonomy=scope&term=$matches[1]&feed=$matches[2]\";s:22:\"scope/([^/]+)/embed/?$\";s:52:\"index.php?taxonomy=scope&term=$matches[1]&embed=true\";s:34:\"scope/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?taxonomy=scope&term=$matches[1]&paged=$matches[2]\";s:16:\"scope/([^/]+)/?$\";s:41:\"index.php?taxonomy=scope&term=$matches[1]\";s:40:\"et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:33:\"et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:41:\"et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:48:\"et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:38:\"et_pb_layout/([^/]+)/verify(/(.*))?/?$\";s:68:\"index.php?post_type=et_pb_layout&name=$matches[1]&verify=$matches[3]\";s:38:\"et_pb_layout/([^/]+)/cancel(/(.*))?/?$\";s:68:\"index.php?post_type=et_pb_layout&name=$matches[1]&cancel=$matches[3]\";s:46:\"et_pb_layout/([^/]+)/gateway-cancel(/(.*))?/?$\";s:76:\"index.php?post_type=et_pb_layout&name=$matches[1]&gateway-cancel=$matches[3]\";s:46:\"et_pb_layout/([^/]+)/gateway-return(/(.*))?/?$\";s:76:\"index.php?post_type=et_pb_layout&name=$matches[1]&gateway-return=$matches[3]\";s:44:\"et_pb_layout/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:55:\"et_pb_layout/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:44:\"et_pb_layout/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:55:\"et_pb_layout/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:52:\"et_pb_layout/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:63:\"et_pb_layout/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:52:\"et_pb_layout/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:63:\"et_pb_layout/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:37:\"et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:29:\"et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:51:\"et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&feed=$matches[2]\";s:32:\"et_tb_item_type/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&embed=true\";s:44:\"et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]&paged=$matches[2]\";s:26:\"et_tb_item_type/([^/]+)/?$\";s:51:\"index.php?taxonomy=et_tb_item_type&term=$matches[1]\";s:38:\"et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:31:\"et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:39:\"et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:46:\"et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:36:\"et_tb_item/([^/]+)/verify(/(.*))?/?$\";s:66:\"index.php?post_type=et_tb_item&name=$matches[1]&verify=$matches[3]\";s:36:\"et_tb_item/([^/]+)/cancel(/(.*))?/?$\";s:66:\"index.php?post_type=et_tb_item&name=$matches[1]&cancel=$matches[3]\";s:44:\"et_tb_item/([^/]+)/gateway-cancel(/(.*))?/?$\";s:74:\"index.php?post_type=et_tb_item&name=$matches[1]&gateway-cancel=$matches[3]\";s:44:\"et_tb_item/([^/]+)/gateway-return(/(.*))?/?$\";s:74:\"index.php?post_type=et_tb_item&name=$matches[1]&gateway-return=$matches[3]\";s:42:\"et_tb_item/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:53:\"et_tb_item/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:42:\"et_tb_item/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:53:\"et_tb_item/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:50:\"et_tb_item/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:61:\"et_tb_item/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"et_tb_item/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:61:\"et_tb_item/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:35:\"et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:27:\"et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"publications/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"publications/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"publications/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"publications/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"publications/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"publications/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"publications/(.+?)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:31:\"publications/(.+?)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:51:\"publications/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:46:\"publications/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:39:\"publications/(.+?)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:46:\"publications/(.+?)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:36:\"publications/(.+?)/verify(/(.*))?/?$\";s:48:\"index.php?project=$matches[1]&verify=$matches[3]\";s:36:\"publications/(.+?)/cancel(/(.*))?/?$\";s:48:\"index.php?project=$matches[1]&cancel=$matches[3]\";s:44:\"publications/(.+?)/gateway-cancel(/(.*))?/?$\";s:56:\"index.php?project=$matches[1]&gateway-cancel=$matches[3]\";s:44:\"publications/(.+?)/gateway-return(/(.*))?/?$\";s:56:\"index.php?project=$matches[1]&gateway-return=$matches[3]\";s:42:\"publications/.+?/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:53:\"publications/.+?/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:42:\"publications/.+?/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:53:\"publications/.+?/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:50:\"publications/.+?/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:61:\"publications/.+?/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"publications/.+?/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:61:\"publications/.+?/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:35:\"publications/(.+?)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:34:\"events/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"events/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"events/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"events/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"events/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"events/([^/]+)/embed/?$\";s:43:\"index.php?mec-events=$matches[1]&embed=true\";s:27:\"events/([^/]+)/trackback/?$\";s:37:\"index.php?mec-events=$matches[1]&tb=1\";s:47:\"events/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?mec-events=$matches[1]&feed=$matches[2]\";s:42:\"events/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?mec-events=$matches[1]&feed=$matches[2]\";s:35:\"events/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mec-events=$matches[1]&paged=$matches[2]\";s:42:\"events/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mec-events=$matches[1]&cpage=$matches[2]\";s:32:\"events/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?mec-events=$matches[1]&verify=$matches[3]\";s:32:\"events/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?mec-events=$matches[1]&cancel=$matches[3]\";s:40:\"events/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?mec-events=$matches[1]&gateway-cancel=$matches[3]\";s:40:\"events/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?mec-events=$matches[1]&gateway-return=$matches[3]\";s:38:\"events/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:49:\"events/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:38:\"events/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:49:\"events/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:46:\"events/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:57:\"events/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:46:\"events/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:57:\"events/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:31:\"events/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mec-events=$matches[1]&page=$matches[2]\";s:23:\"events/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"events/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"events/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"events/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"events/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"mec-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?mec_category=$matches[1]&feed=$matches[2]\";s:48:\"mec-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?mec_category=$matches[1]&feed=$matches[2]\";s:29:\"mec-category/([^/]+)/embed/?$\";s:45:\"index.php?mec_category=$matches[1]&embed=true\";s:41:\"mec-category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?mec_category=$matches[1]&paged=$matches[2]\";s:23:\"mec-category/([^/]+)/?$\";s:34:\"index.php?mec_category=$matches[1]\";s:41:\"mec_calendars/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"mec_calendars/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"mec_calendars/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"mec_calendars/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"mec_calendars/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"mec_calendars/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"mec_calendars/([^/]+)/embed/?$\";s:46:\"index.php?mec_calendars=$matches[1]&embed=true\";s:34:\"mec_calendars/([^/]+)/trackback/?$\";s:40:\"index.php?mec_calendars=$matches[1]&tb=1\";s:42:\"mec_calendars/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?mec_calendars=$matches[1]&paged=$matches[2]\";s:49:\"mec_calendars/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?mec_calendars=$matches[1]&cpage=$matches[2]\";s:39:\"mec_calendars/([^/]+)/verify(/(.*))?/?$\";s:54:\"index.php?mec_calendars=$matches[1]&verify=$matches[3]\";s:39:\"mec_calendars/([^/]+)/cancel(/(.*))?/?$\";s:54:\"index.php?mec_calendars=$matches[1]&cancel=$matches[3]\";s:47:\"mec_calendars/([^/]+)/gateway-cancel(/(.*))?/?$\";s:62:\"index.php?mec_calendars=$matches[1]&gateway-cancel=$matches[3]\";s:47:\"mec_calendars/([^/]+)/gateway-return(/(.*))?/?$\";s:62:\"index.php?mec_calendars=$matches[1]&gateway-return=$matches[3]\";s:45:\"mec_calendars/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:56:\"mec_calendars/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:45:\"mec_calendars/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:56:\"mec_calendars/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:53:\"mec_calendars/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:64:\"mec_calendars/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:53:\"mec_calendars/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:64:\"mec_calendars/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:38:\"mec_calendars/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?mec_calendars=$matches[1]&page=$matches[2]\";s:30:\"mec_calendars/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"mec_calendars/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"mec_calendars/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"mec_calendars/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"mec_calendars/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"mec_calendars/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"amm/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"amm/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"amm/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"amm/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"amm/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"amm/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"amm/([^/]+)/embed/?$\";s:36:\"index.php?amm=$matches[1]&embed=true\";s:24:\"amm/([^/]+)/trackback/?$\";s:30:\"index.php?amm=$matches[1]&tb=1\";s:44:\"amm/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?amm=$matches[1]&feed=$matches[2]\";s:39:\"amm/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?amm=$matches[1]&feed=$matches[2]\";s:32:\"amm/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?amm=$matches[1]&paged=$matches[2]\";s:39:\"amm/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?amm=$matches[1]&cpage=$matches[2]\";s:29:\"amm/([^/]+)/verify(/(.*))?/?$\";s:44:\"index.php?amm=$matches[1]&verify=$matches[3]\";s:29:\"amm/([^/]+)/cancel(/(.*))?/?$\";s:44:\"index.php?amm=$matches[1]&cancel=$matches[3]\";s:37:\"amm/([^/]+)/gateway-cancel(/(.*))?/?$\";s:52:\"index.php?amm=$matches[1]&gateway-cancel=$matches[3]\";s:37:\"amm/([^/]+)/gateway-return(/(.*))?/?$\";s:52:\"index.php?amm=$matches[1]&gateway-return=$matches[3]\";s:35:\"amm/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:46:\"amm/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:35:\"amm/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:46:\"amm/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:43:\"amm/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:54:\"amm/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:43:\"amm/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:54:\"amm/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:28:\"amm/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?amm=$matches[1]&page=$matches[2]\";s:20:\"amm/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\"amm/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\"amm/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"amm/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\"amm/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"amm/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:37:\"et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:45:\"et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:52:\"et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:42:\"et_theme_builder/([^/]+)/verify(/(.*))?/?$\";s:72:\"index.php?post_type=et_theme_builder&name=$matches[1]&verify=$matches[3]\";s:42:\"et_theme_builder/([^/]+)/cancel(/(.*))?/?$\";s:72:\"index.php?post_type=et_theme_builder&name=$matches[1]&cancel=$matches[3]\";s:50:\"et_theme_builder/([^/]+)/gateway-cancel(/(.*))?/?$\";s:80:\"index.php?post_type=et_theme_builder&name=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"et_theme_builder/([^/]+)/gateway-return(/(.*))?/?$\";s:80:\"index.php?post_type=et_theme_builder&name=$matches[1]&gateway-return=$matches[3]\";s:48:\"et_theme_builder/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:59:\"et_theme_builder/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:48:\"et_theme_builder/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:59:\"et_theme_builder/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:56:\"et_theme_builder/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:67:\"et_theme_builder/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:56:\"et_theme_builder/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:67:\"et_theme_builder/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:41:\"et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:33:\"et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:32:\"et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:40:\"et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:47:\"et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:37:\"et_template/([^/]+)/verify(/(.*))?/?$\";s:67:\"index.php?post_type=et_template&name=$matches[1]&verify=$matches[3]\";s:37:\"et_template/([^/]+)/cancel(/(.*))?/?$\";s:67:\"index.php?post_type=et_template&name=$matches[1]&cancel=$matches[3]\";s:45:\"et_template/([^/]+)/gateway-cancel(/(.*))?/?$\";s:75:\"index.php?post_type=et_template&name=$matches[1]&gateway-cancel=$matches[3]\";s:45:\"et_template/([^/]+)/gateway-return(/(.*))?/?$\";s:75:\"index.php?post_type=et_template&name=$matches[1]&gateway-return=$matches[3]\";s:43:\"et_template/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:54:\"et_template/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:43:\"et_template/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:54:\"et_template/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:51:\"et_template/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:62:\"et_template/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:51:\"et_template/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:62:\"et_template/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:36:\"et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:28:\"et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:37:\"et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:45:\"et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:42:\"et_header_layout/([^/]+)/verify(/(.*))?/?$\";s:72:\"index.php?post_type=et_header_layout&name=$matches[1]&verify=$matches[3]\";s:42:\"et_header_layout/([^/]+)/cancel(/(.*))?/?$\";s:72:\"index.php?post_type=et_header_layout&name=$matches[1]&cancel=$matches[3]\";s:50:\"et_header_layout/([^/]+)/gateway-cancel(/(.*))?/?$\";s:80:\"index.php?post_type=et_header_layout&name=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"et_header_layout/([^/]+)/gateway-return(/(.*))?/?$\";s:80:\"index.php?post_type=et_header_layout&name=$matches[1]&gateway-return=$matches[3]\";s:48:\"et_header_layout/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:59:\"et_header_layout/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:48:\"et_header_layout/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:59:\"et_header_layout/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:56:\"et_header_layout/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:67:\"et_header_layout/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:56:\"et_header_layout/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:67:\"et_header_layout/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:41:\"et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:35:\"et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:43:\"et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:50:\"et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:40:\"et_body_layout/([^/]+)/verify(/(.*))?/?$\";s:70:\"index.php?post_type=et_body_layout&name=$matches[1]&verify=$matches[3]\";s:40:\"et_body_layout/([^/]+)/cancel(/(.*))?/?$\";s:70:\"index.php?post_type=et_body_layout&name=$matches[1]&cancel=$matches[3]\";s:48:\"et_body_layout/([^/]+)/gateway-cancel(/(.*))?/?$\";s:78:\"index.php?post_type=et_body_layout&name=$matches[1]&gateway-cancel=$matches[3]\";s:48:\"et_body_layout/([^/]+)/gateway-return(/(.*))?/?$\";s:78:\"index.php?post_type=et_body_layout&name=$matches[1]&gateway-return=$matches[3]\";s:46:\"et_body_layout/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:57:\"et_body_layout/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:46:\"et_body_layout/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:57:\"et_body_layout/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:54:\"et_body_layout/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:65:\"et_body_layout/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:54:\"et_body_layout/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:65:\"et_body_layout/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:39:\"et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:31:\"et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:37:\"et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:45:\"et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:52:\"et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:42:\"et_footer_layout/([^/]+)/verify(/(.*))?/?$\";s:72:\"index.php?post_type=et_footer_layout&name=$matches[1]&verify=$matches[3]\";s:42:\"et_footer_layout/([^/]+)/cancel(/(.*))?/?$\";s:72:\"index.php?post_type=et_footer_layout&name=$matches[1]&cancel=$matches[3]\";s:50:\"et_footer_layout/([^/]+)/gateway-cancel(/(.*))?/?$\";s:80:\"index.php?post_type=et_footer_layout&name=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"et_footer_layout/([^/]+)/gateway-return(/(.*))?/?$\";s:80:\"index.php?post_type=et_footer_layout&name=$matches[1]&gateway-return=$matches[3]\";s:48:\"et_footer_layout/[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:59:\"et_footer_layout/[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:48:\"et_footer_layout/[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:59:\"et_footer_layout/[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:56:\"et_footer_layout/[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:67:\"et_footer_layout/[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:56:\"et_footer_layout/[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:67:\"et_footer_layout/[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:41:\"et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:33:\"et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"events-label/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?taxonomy=mec_label&term=$matches[1]&feed=$matches[2]\";s:48:\"events-label/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?taxonomy=mec_label&term=$matches[1]&feed=$matches[2]\";s:29:\"events-label/([^/]+)/embed/?$\";s:56:\"index.php?taxonomy=mec_label&term=$matches[1]&embed=true\";s:41:\"events-label/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?taxonomy=mec_label&term=$matches[1]&paged=$matches[2]\";s:23:\"events-label/([^/]+)/?$\";s:45:\"index.php?taxonomy=mec_label&term=$matches[1]\";s:56:\"events-location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=mec_location&term=$matches[1]&feed=$matches[2]\";s:51:\"events-location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?taxonomy=mec_location&term=$matches[1]&feed=$matches[2]\";s:32:\"events-location/([^/]+)/embed/?$\";s:59:\"index.php?taxonomy=mec_location&term=$matches[1]&embed=true\";s:44:\"events-location/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?taxonomy=mec_location&term=$matches[1]&paged=$matches[2]\";s:26:\"events-location/([^/]+)/?$\";s:48:\"index.php?taxonomy=mec_location&term=$matches[1]\";s:57:\"events-organizer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=mec_organizer&term=$matches[1]&feed=$matches[2]\";s:52:\"events-organizer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?taxonomy=mec_organizer&term=$matches[1]&feed=$matches[2]\";s:33:\"events-organizer/([^/]+)/embed/?$\";s:60:\"index.php?taxonomy=mec_organizer&term=$matches[1]&embed=true\";s:45:\"events-organizer/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?taxonomy=mec_organizer&term=$matches[1]&paged=$matches[2]\";s:27:\"events-organizer/([^/]+)/?$\";s:49:\"index.php?taxonomy=mec_organizer&term=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=100&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/verify(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&verify=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/cancel(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cancel=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/gateway-cancel(/(.*))?/?$\";s:90:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&gateway-cancel=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/gateway-return(/(.*))?/?$\";s:90:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&gateway-return=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/verify(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&verify=$matches[3]\";s:28:\"([0-9]{4})/cancel(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&cancel=$matches[3]\";s:36:\"([0-9]{4})/gateway-cancel(/(.*))?/?$\";s:53:\"index.php?year=$matches[1]&gateway-cancel=$matches[3]\";s:36:\"([0-9]{4})/gateway-return(/(.*))?/?$\";s:53:\"index.php?year=$matches[1]&gateway-return=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:31:\".?.+?/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:31:\".?.+?/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:39:\".?.+?/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:50:\".?.+?/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:39:\".?.+?/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:50:\".?.+?/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/verify(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&verify=$matches[3]\";s:25:\"([^/]+)/cancel(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&cancel=$matches[3]\";s:33:\"([^/]+)/gateway-cancel(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&gateway-cancel=$matches[3]\";s:33:\"([^/]+)/gateway-return(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&gateway-return=$matches[3]\";s:31:\"[^/]+/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/verify(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&verify=$matches[3]\";s:31:\"[^/]+/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/cancel(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&cancel=$matches[3]\";s:39:\"[^/]+/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:50:\"[^/]+/attachment/([^/]+)/gateway-cancel(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-cancel=$matches[3]\";s:39:\"[^/]+/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:50:\"[^/]+/attachment/([^/]+)/gateway-return(/(.*))?/?$\";s:59:\"index.php?attachment=$matches[1]&gateway-return=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}', 'yes');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:8:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:18:\"live-news/init.php\";i:2;s:59:\"modern-events-calendar-lite/modern-events-calendar-lite.php\";i:3;s:32:\"opteam-monitoring/monitoring.php\";i:4;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:5;s:21:\"safe-svg/safe-svg.php\";i:6;s:33:\"smart-slider-3/smart-slider-3.php\";i:7;s:47:\"wp-admin-menu-manager/wp-admin-menu-manager.php\";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', '', 'no'),
(40, 'template', 'Divi', 'yes'),
(41, 'stylesheet', 'Divi-child', 'yes'),
(42, 'comment_registration', '0', 'yes'),
(43, 'html_type', 'text/html', 'yes'),
(44, 'use_trackback', '0', 'yes'),
(45, 'default_role', 'subscriber', 'yes'),
(46, 'db_version', '53496', 'yes'),
(47, 'uploads_use_yearmonth_folders', '1', 'yes'),
(48, 'upload_path', '', 'yes'),
(49, 'blog_public', '0', 'yes'),
(50, 'default_link_category', '2', 'yes'),
(51, 'show_on_front', 'page', 'yes'),
(52, 'tag_base', '', 'yes'),
(53, 'show_avatars', '1', 'yes'),
(54, 'avatar_rating', 'G', 'yes'),
(55, 'upload_url_path', '', 'yes'),
(56, 'thumbnail_size_w', '150', 'yes'),
(57, 'thumbnail_size_h', '150', 'yes'),
(58, 'thumbnail_crop', '1', 'yes'),
(59, 'medium_size_w', '300', 'yes'),
(60, 'medium_size_h', '300', 'yes'),
(61, 'avatar_default', 'mystery', 'yes'),
(62, 'large_size_w', '1024', 'yes'),
(63, 'large_size_h', '1024', 'yes'),
(64, 'image_default_link_type', 'none', 'yes'),
(65, 'image_default_size', '', 'yes'),
(66, 'image_default_align', '', 'yes'),
(67, 'close_comments_for_old_posts', '0', 'yes'),
(68, 'close_comments_days_old', '14', 'yes'),
(69, 'thread_comments', '1', 'yes'),
(70, 'thread_comments_depth', '5', 'yes'),
(71, 'page_comments', '0', 'yes'),
(72, 'comments_per_page', '50', 'yes'),
(73, 'default_comments_page', 'newest', 'yes'),
(74, 'comment_order', 'asc', 'yes'),
(75, 'sticky_posts', 'a:0:{}', 'yes'),
(76, 'widget_categories', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(77, 'widget_text', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(78, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(79, 'uninstall_plugins', 'a:1:{s:59:\"modern-events-calendar-lite/modern-events-calendar-lite.php\";a:2:{i:0;s:11:\"MEC_factory\";i:1;s:9:\"uninstall\";}}', 'no'),
(80, 'timezone_string', 'Europe/Paris', 'yes'),
(81, 'page_for_posts', '0', 'yes'),
(82, 'page_on_front', '100', 'yes'),
(83, 'default_post_format', '0', 'yes'),
(84, 'link_manager_enabled', '0', 'yes'),
(85, 'finished_splitting_shared_terms', '1', 'yes'),
(86, 'site_icon', '557', 'yes'),
(87, 'medium_large_size_w', '768', 'yes'),
(88, 'medium_large_size_h', '0', 'yes'),
(89, 'wp_page_for_privacy_policy', '3', 'yes'),
(90, 'show_comments_cookies_opt_in', '1', 'yes'),
(91, 'admin_email_lifespan', '1680012114', 'yes'),
(92, 'disallowed_keys', '', 'no'),
(93, 'comment_previously_approved', '1', 'yes'),
(94, 'auto_plugin_theme_update_emails', 'a:0:{}', 'no'),
(95, 'auto_update_core_dev', 'enabled', 'yes'),
(96, 'auto_update_core_minor', 'enabled', 'yes'),
(97, 'auto_update_core_major', 'enabled', 'yes'),
(98, 'wp_force_deactivated_plugins', 'a:0:{}', 'yes'),
(99, 'initial_db_version', '51917', 'yes'),
(100, 'hd_user_roles', 'a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:79:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:11:\"smartslider\";b:1;s:18:\"smartslider_config\";b:1;s:16:\"smartslider_edit\";b:1;s:18:\"smartslider_delete\";b:1;s:12:\"mec_bookings\";b:1;s:15:\"mec_add_booking\";b:1;s:11:\"mec_coupons\";b:1;s:10:\"mec_report\";b:1;s:17:\"mec_import_export\";b:1;s:12:\"mec_settings\";b:1;s:14:\"mec_shortcodes\";b:1;s:15:\"manage_security\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}', 'yes'),
(101, 'fresh_site', '0', 'yes'),
(102, 'WPLANG', 'fr_FR', 'yes'),
(103, 'widget_block', 'a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(104, 'sidebars_widgets', 'a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:18:\"smartslider_area_1\";a:0:{}s:13:\"array_version\";i:3;}', 'yes'),
(105, 'cron', 'a:10:{i:1666879063;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1666880753;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1666881247;a:1:{s:13:\"mec_scheduler\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1666906482;a:4:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1666949682;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666949700;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666964047;a:1:{s:17:\"mec_syncScheduler\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1667468082;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1668937290;a:1:{s:32:\"et_core_page_resource_auto_clear\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}', 'yes'),
(106, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(107, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(108, 'widget_archives', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(109, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(110, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(111, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(112, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(113, 'widget_meta', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(114, 'widget_search', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(115, 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(116, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(117, 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(119, 'recovery_keys', 'a:0:{}', 'yes'),
(122, 'theme_mods_twentytwentytwo', 'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1645609290;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}', 'yes'),
(125, 'https_detection_errors', 'a:0:{}', 'yes'),
(160, 'finished_updating_comment_type', '1', 'yes'),
(163, 'current_theme', 'Theme Opteam', 'yes'),
(164, 'theme_mods_Divi-child', 'a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:5;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:0:{}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}', 'yes'),
(165, 'theme_switched', '', 'yes'),
(166, 'et_pb_cache_notice', 'a:1:{s:5:\"4.7.5\";s:6:\"ignore\";}', 'yes'),
(171, 'et_core_version', '4.18.0', 'yes'),
(173, 'et_divi', 'a:177:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:30:\"et_flush_rewrite_rules_library\";s:6:\"4.18.0\";s:31:\"divi_previous_installed_version\";s:6:\"4.17.4\";s:29:\"divi_latest_installed_version\";s:6:\"4.18.0\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:40:\"divi_email_provider_credentials_migrated\";b:1;s:22:\"builder_global_presets\";O:8:\"stdClass\":0:{}s:29:\"custom_defaults_migrated_flag\";b:1;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:9:\"divi_logo\";s:0:\"\";s:14:\"divi_fixed_nav\";s:5:\"false\";s:26:\"divi_gallery_layout_enable\";s:5:\"false\";s:18:\"divi_color_palette\";s:63:\"#000000|#ffffff|#e02b20|#e09900|#edf000|#7cda24|#0c71c3|#8300e9\";s:15:\"divi_grab_image\";s:5:\"false\";s:15:\"divi_blog_style\";s:5:\"false\";s:12:\"divi_sidebar\";s:16:\"et_right_sidebar\";s:22:\"divi_shop_page_sidebar\";s:16:\"et_right_sidebar\";s:23:\"divi_show_facebook_icon\";s:5:\"false\";s:22:\"divi_show_twitter_icon\";s:5:\"false\";s:21:\"divi_show_google_icon\";s:5:\"false\";s:24:\"divi_show_instagram_icon\";s:5:\"false\";s:18:\"divi_show_rss_icon\";s:5:\"false\";s:17:\"divi_facebook_url\";s:1:\"#\";s:16:\"divi_twitter_url\";s:1:\"#\";s:15:\"divi_google_url\";s:1:\"#\";s:18:\"divi_instagram_url\";s:1:\"#\";s:12:\"divi_rss_url\";s:0:\"\";s:34:\"divi_woocommerce_archive_num_posts\";i:9;s:17:\"divi_catnum_posts\";i:6;s:21:\"divi_archivenum_posts\";i:5;s:20:\"divi_searchnum_posts\";i:5;s:17:\"divi_tagnum_posts\";i:5;s:16:\"divi_date_format\";s:6:\"M j, Y\";s:16:\"divi_use_excerpt\";s:5:\"false\";s:26:\"divi_responsive_shortcodes\";s:2:\"on\";s:33:\"divi_gf_enable_all_character_sets\";s:5:\"false\";s:16:\"divi_back_to_top\";s:5:\"false\";s:18:\"divi_smooth_scroll\";s:5:\"false\";s:25:\"divi_disable_translations\";s:5:\"false\";s:29:\"divi_enable_responsive_images\";s:2:\"on\";s:27:\"divi_minify_combine_scripts\";s:2:\"on\";s:26:\"divi_minify_combine_styles\";s:2:\"on\";s:15:\"divi_custom_css\";s:0:\"\";s:21:\"divi_enable_dropdowns\";s:2:\"on\";s:14:\"divi_home_link\";s:2:\"on\";s:15:\"divi_sort_pages\";s:10:\"post_title\";s:15:\"divi_order_page\";s:3:\"asc\";s:22:\"divi_tiers_shown_pages\";i:3;s:32:\"divi_enable_dropdowns_categories\";s:2:\"on\";s:21:\"divi_categories_empty\";s:2:\"on\";s:27:\"divi_tiers_shown_categories\";i:3;s:13:\"divi_sort_cat\";s:4:\"name\";s:14:\"divi_order_cat\";s:3:\"asc\";s:20:\"divi_disable_toptier\";s:5:\"false\";s:27:\"et_pb_post_type_integration\";a:4:{s:4:\"post\";s:2:\"on\";s:4:\"page\";s:2:\"on\";s:7:\"project\";s:2:\"on\";s:10:\"mec-events\";s:3:\"off\";}s:21:\"et_pb_static_css_file\";s:3:\"off\";s:19:\"et_pb_css_in_footer\";s:3:\"off\";s:25:\"et_pb_product_tour_global\";s:2:\"on\";s:24:\"et_enable_classic_editor\";s:2:\"on\";s:14:\"divi_postinfo2\";a:4:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";}s:22:\"divi_show_postcomments\";s:2:\"on\";s:15:\"divi_thumbnails\";s:2:\"on\";s:20:\"divi_page_thumbnails\";s:5:\"false\";s:23:\"divi_show_pagescomments\";s:5:\"false\";s:14:\"divi_postinfo1\";a:3:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";}s:21:\"divi_thumbnails_index\";s:2:\"on\";s:19:\"divi_seo_home_title\";s:5:\"false\";s:25:\"divi_seo_home_description\";s:5:\"false\";s:22:\"divi_seo_home_keywords\";s:5:\"false\";s:23:\"divi_seo_home_canonical\";s:5:\"false\";s:23:\"divi_seo_home_titletext\";s:0:\"\";s:29:\"divi_seo_home_descriptiontext\";s:0:\"\";s:26:\"divi_seo_home_keywordstext\";s:0:\"\";s:18:\"divi_seo_home_type\";s:27:\"BlogName | Blog description\";s:22:\"divi_seo_home_separate\";s:3:\" | \";s:21:\"divi_seo_single_title\";s:5:\"false\";s:27:\"divi_seo_single_description\";s:5:\"false\";s:24:\"divi_seo_single_keywords\";s:5:\"false\";s:25:\"divi_seo_single_canonical\";s:5:\"false\";s:27:\"divi_seo_single_field_title\";s:9:\"seo_title\";s:33:\"divi_seo_single_field_description\";s:15:\"seo_description\";s:30:\"divi_seo_single_field_keywords\";s:12:\"seo_keywords\";s:20:\"divi_seo_single_type\";s:21:\"Post title | BlogName\";s:24:\"divi_seo_single_separate\";s:3:\" | \";s:24:\"divi_seo_index_canonical\";s:5:\"false\";s:26:\"divi_seo_index_description\";s:5:\"false\";s:19:\"divi_seo_index_type\";s:24:\"Category name | BlogName\";s:23:\"divi_seo_index_separate\";s:3:\" | \";s:28:\"divi_integrate_header_enable\";s:2:\"on\";s:26:\"divi_integrate_body_enable\";s:2:\"on\";s:31:\"divi_integrate_singletop_enable\";s:2:\"on\";s:34:\"divi_integrate_singlebottom_enable\";s:2:\"on\";s:21:\"divi_integration_head\";s:0:\"\";s:21:\"divi_integration_body\";s:0:\"\";s:27:\"divi_integration_single_top\";s:0:\"\";s:30:\"divi_integration_single_bottom\";s:0:\"\";s:15:\"divi_468_enable\";s:5:\"false\";s:14:\"divi_468_image\";s:0:\"\";s:12:\"divi_468_url\";s:0:\"\";s:16:\"divi_468_adsense\";s:0:\"\";s:24:\"footer_widget_text_color\";s:7:\"#ffffff\";s:24:\"footer_widget_link_color\";s:7:\"#ffffff\";s:13:\"content_width\";i:1400;s:12:\"divi_favicon\";s:0:\"\";s:19:\"product_tour_status\";a:3:{i:1;s:3:\"off\";i:2;s:3:\"off\";i:3;s:3:\"off\";}s:32:\"et_fb_pref_settings_bar_location\";s:6:\"bottom\";s:28:\"et_fb_pref_builder_animation\";s:4:\"true\";s:41:\"et_fb_pref_builder_display_modal_settings\";s:5:\"false\";s:39:\"et_fb_pref_builder_enable_dummy_content\";s:4:\"true\";s:46:\"et_fb_pref_builder_enable_visual_theme_builder\";s:4:\"true\";s:21:\"et_fb_pref_event_mode\";s:5:\"hover\";s:28:\"et_fb_pref_limited_view_mode\";s:9:\"wireframe\";s:32:\"et_fb_pref_hide_disabled_modules\";s:5:\"false\";s:28:\"et_fb_pref_history_intervals\";i:1;s:29:\"et_fb_pref_page_creation_flow\";s:7:\"default\";s:42:\"et_fb_pref_quick_actions_always_start_with\";s:7:\"nothing\";s:44:\"et_fb_pref_quick_actions_show_recent_queries\";s:3:\"off\";s:39:\"et_fb_pref_quick_actions_recent_queries\";s:0:\"\";s:40:\"et_fb_pref_quick_actions_recent_category\";s:0:\"\";s:35:\"et_fb_pref_limited_modal_preference\";s:7:\"default\";s:30:\"et_fb_pref_modal_snap_location\";s:0:\"\";s:21:\"et_fb_pref_modal_snap\";s:5:\"false\";s:27:\"et_fb_pref_modal_fullscreen\";s:5:\"false\";s:32:\"et_fb_pref_modal_dimension_width\";i:730;s:33:\"et_fb_pref_modal_dimension_height\";i:361;s:27:\"et_fb_pref_modal_position_x\";i:525;s:27:\"et_fb_pref_modal_position_y\";i:0;s:32:\"et_fb_pref_limited_toolbar_click\";s:5:\"false\";s:34:\"et_fb_pref_limited_toolbar_desktop\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_grid\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_hover\";s:5:\"false\";s:32:\"et_fb_pref_limited_toolbar_phone\";s:4:\"true\";s:33:\"et_fb_pref_limited_toolbar_tablet\";s:4:\"true\";s:36:\"et_fb_pref_limited_toolbar_wireframe\";s:4:\"true\";s:31:\"et_fb_pref_limited_toolbar_zoom\";s:4:\"true\";s:36:\"et_fb_pref_lv_modal_dimension_height\";i:0;s:35:\"et_fb_pref_lv_modal_dimension_width\";i:0;s:30:\"et_fb_pref_lv_modal_position_x\";i:0;s:30:\"et_fb_pref_lv_modal_position_y\";i:0;s:34:\"et_fb_pref_responsive_tablet_width\";i:768;s:35:\"et_fb_pref_responsive_tablet_height\";i:0;s:33:\"et_fb_pref_responsive_phone_width\";i:400;s:34:\"et_fb_pref_responsive_phone_height\";i:0;s:35:\"et_fb_pref_responsive_minimum_width\";i:320;s:35:\"et_fb_pref_responsive_maximum_width\";i:980;s:20:\"et_fb_pref_view_mode\";s:7:\"desktop\";s:27:\"et_fb_pref_modal_preference\";s:7:\"default\";s:24:\"et_fb_pref_toolbar_click\";s:5:\"false\";s:26:\"et_fb_pref_toolbar_desktop\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_grid\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_hover\";s:5:\"false\";s:24:\"et_fb_pref_toolbar_phone\";s:4:\"true\";s:25:\"et_fb_pref_toolbar_tablet\";s:4:\"true\";s:28:\"et_fb_pref_toolbar_wireframe\";s:4:\"true\";s:23:\"et_fb_pref_toolbar_zoom\";s:4:\"true\";s:29:\"divi_dynamic_module_framework\";s:2:\"on\";s:16:\"divi_dynamic_css\";s:5:\"false\";s:30:\"divi_dynamic_icons_child_theme\";s:5:\"false\";s:22:\"divi_inline_stylesheet\";s:2:\"on\";s:17:\"divi_critical_css\";s:5:\"false\";s:30:\"divi_critical_threshold_height\";s:6:\"Medium\";s:25:\"divi_dynamic_js_libraries\";s:5:\"false\";s:19:\"divi_disable_emojis\";s:2:\"on\";s:20:\"divi_defer_block_css\";s:2:\"on\";s:24:\"divi_google_fonts_inline\";s:5:\"false\";s:51:\"divi_limit_google_fonts_support_for_legacy_browsers\";s:2:\"on\";s:23:\"divi_enable_jquery_body\";s:2:\"on\";s:32:\"divi_enable_jquery_compatibility\";s:2:\"on\";s:29:\"divi_enable_jquery_body_super\";s:5:\"false\";}', 'yes'),
(174, 'widget_aboutmewidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(175, 'widget_adsensewidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(176, 'widget_advwidget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(177, 'shop_catalog_image_size', 'a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}', 'yes'),
(178, 'shop_single_image_size', 'a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}', 'yes'),
(179, 'shop_thumbnail_image_size', 'a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}', 'yes'),
(180, 'et_support_site_id', 'nmTH2!(7@hd#GpzS5CuJ', 'yes'),
(181, 'et_safe_mode_plugins_allowlist', 'a:8:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:27:\"ari-adminer/ari-adminer.php\";i:5;s:31:\"query-monitor/query-monitor.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}', 'yes'),
(182, 'et_support_center_installed', 'true', 'yes'),
(183, 'et_images_temp_folder', '/home/bloxjwu/www/happydisplay/wp-content/uploads/et_temp', 'yes'),
(184, 'et_schedule_clean_images_last_time', '1666825752', 'yes'),
(185, 'et_bfb_settings', 'a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}', 'yes'),
(187, 'et_pb_builder_options', 'a:2:{i:0;b:0;s:35:\"email_provider_credentials_migrated\";b:1;}', 'yes'),
(188, 'et_support_center_setup_done', 'processed', 'yes'),
(190, 'et_account_status', 'active', 'no'),
(192, 'et_google_api_settings', 'a:3:{s:7:\"api_key\";s:0:\"\";s:26:\"enqueue_google_maps_script\";s:5:\"false\";s:16:\"use_google_fonts\";s:2:\"on\";}', 'yes'),
(193, 'et_automatic_updates_options', 'a:2:{s:8:\"username\";s:6:\"Opteam\";s:7:\"api_key\";s:40:\"a6333bc0033c64fc91c1ac37d66f312552d95f08\";}', 'no'),
(198, 'recently_activated', 'a:0:{}', 'yes'),
(199, 'rsssl_activated_plugin', '1', 'yes'),
(200, 'rlrsssl_options', 'a:16:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:1;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.3.5\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:1;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}', 'yes'),
(201, 'rsssl_remaining_tasks', '1', 'yes'),
(218, 'rsssl_current_version', '5.3.5', 'yes'),
(221, 'rsssl_activation_timestamp', '1645609406', 'yes'),
(232, 'rsssl_port_check_2082', 'fail', 'yes'),
(233, 'rsssl_port_check_8443', 'fail', 'yes'),
(234, 'rsssl_port_check_2222', 'fail', 'yes'),
(249, 'rsssl_mixed_content_scan_dismissed', '1', 'yes'),
(256, 'rsssl_google_analytics_dismissed', '1', 'yes'),
(263, 'rsssl_divi_dismissed', '1', 'yes'),
(284, 'revslider_server_refresh', '1645609592', 'yes'),
(285, 'revslider-update-check-short', '1645610884', 'yes'),
(286, 'revslider_servers', 'a:1:{i:0;s:16:\"themepunch.tools\";}', 'yes'),
(287, 'revslider-library-check', '1645609642', 'yes'),
(288, 'revslider-templates-check', '1645609692', 'yes'),
(291, 'rs-templates-counter', '0', 'no'),
(295, 'revslider_update_version', '6.4.10', 'yes'),
(301, 'widget_rev-slider-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(302, 'rs_cache_overlay', '6.5.17', 'yes'),
(303, 'revslider-update-check', '1645436951', 'yes'),
(304, 'revslider_update_info', 'O:8:\"stdClass\":0:{}', 'yes'),
(305, 'revslider_update_revision_current', '6.4.10', 'yes'),
(347, 'widget_recent-posts', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(349, 'widget_recent-comments', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(352, 'category_children', 'a:0:{}', 'yes'),
(370, 'n2_ss3_version', '3.5.1.11/b:release-3.5.1.11/r:f0b633e7a94052a70133276e2ed8de7715ca6ecb', 'yes'),
(375, 'widget_smartslider3', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(834, '_transient_health-check-site-status-result', '{\"good\":17,\"recommended\":3,\"critical\":0}', 'yes'),
(5383, 'auto_core_update_notified', 'a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:14:\"web@opteam.net\";s:7:\"version\";s:5:\"6.0.3\";s:9:\"timestamp\";i:1666253510;}', 'no'),
(6587, 'acf_version', '6.0.3', 'yes'),
(6645, 'et_pb_contact_form_32b626810e66e2b15bbce2c3c2e9c1d6', 'off', 'yes'),
(9511, '_transient_et_updated_plugins_data', 'O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1666876915;}', 'yes'),
(9524, 'recovery_mode_email_last_sent', '1653382931', 'yes'),
(9672, 'new_admin_email', 'web@opteam.net', 'yes'),
(11375, 'apexnb_lite_settings', 'a:53:{s:21:\"apexnblite_enable_bar\";s:1:\"1\";s:24:\"apexnblite_enable_mobile\";s:1:\"1\";s:12:\"edn_position\";s:6:\"bottom\";s:19:\"edn_notify_on_pages\";s:9:\"all_pages\";s:21:\"edn_notification_font\";s:6:\"Roboto\";s:11:\"edn_bgcolor\";s:0:\"\";s:14:\"edn_font_color\";s:0:\"\";s:12:\"edn_bar_type\";i:2;s:16:\"edn_bar_template\";s:1:\"4\";s:17:\"edn_social_optons\";i:0;s:23:\"edn_social_heading_text\";s:0:\"\";s:24:\"edn_social_heading_color\";s:0:\"\";s:13:\"icons_details\";a:0:{}s:16:\"edn_right_optons\";i:1;s:11:\"edn_cp_type\";s:4:\"text\";s:21:\"edn_text_display_mode\";s:8:\"multiple\";s:10:\"edn_static\";a:19:{s:4:\"text\";s:0:\"\";s:18:\"call_action_button\";s:6:\"custom\";s:8:\"but_text\";s:0:\"\";s:7:\"but_url\";s:0:\"\";s:11:\"link_target\";s:6:\"_blank\";s:14:\"contact_choose\";s:6:\"c-form\";s:16:\"contact_btn_text\";s:0:\"\";s:10:\"name_label\";s:0:\"\";s:16:\"name_placeholder\";s:0:\"\";s:14:\"name_error_msg\";s:0:\"\";s:11:\"email_label\";s:0:\"\";s:17:\"email_placeholder\";s:0:\"\";s:15:\"email_error_msg\";s:0:\"\";s:9:\"msg_label\";s:0:\"\";s:15:\"msg_placeholder\";s:0:\"\";s:9:\"msg_error\";s:0:\"\";s:12:\"send_to_mail\";s:0:\"\";s:15:\"success_message\";s:0:\"\";s:12:\"sendfail_msg\";s:0:\"\";}s:9:\"edn_multi\";a:0:{}s:15:\"edn_subs_choose\";s:11:\"subs-c-form\";s:15:\"edn_subs_custom\";a:13:{s:9:\"head_text\";s:0:\"\";s:8:\"but_text\";s:0:\"\";s:11:\"description\";s:0:\"\";s:21:\"but_email_placeholder\";s:0:\"\";s:23:\"but_email_error_message\";s:0:\"\";s:16:\"but_already_subs\";s:0:\"\";s:20:\"but_check_to_conform\";s:0:\"\";s:16:\"but_sending_fail\";s:0:\"\";s:13:\"email_subject\";s:0:\"\";s:7:\"confirm\";i:0;s:10:\"thank_text\";s:0:\"\";s:9:\"from_name\";s:13:\"Happy Display\";s:10:\"from_email\";s:0:\"\";}s:15:\"edn_recentposts\";a:7:{s:23:\"edn_choose_filter_posts\";s:12:\"recent-posts\";s:14:\"posts_per_page\";s:1:\"5\";s:18:\"edn_posttype_value\";s:4:\"post\";s:23:\"edn_recentposts_orderby\";s:4:\"date\";s:21:\"edn_recentposts_order\";s:4:\"desc\";s:15:\"read_more_label\";s:9:\"Read More\";s:16:\"read_more_target\";s:6:\"_blank\";}s:15:\"edn_search_form\";a:3:{s:11:\"description\";s:0:\"\";s:17:\"input_placeholder\";s:0:\"\";s:11:\"button_name\";s:0:\"\";}s:21:\"edn_bar_effect_option\";s:1:\"1\";s:10:\"edn_ticker\";a:3:{s:10:\"title_text\";s:0:\"\";s:5:\"speed\";s:0:\"\";s:9:\"direction\";s:8:\"vertical\";}s:10:\"edn_slider\";a:5:{s:8:\"duration\";s:0:\"\";s:5:\"speed\";s:0:\"\";s:4:\"auto\";s:4:\"true\";s:9:\"animation\";s:10:\"horizontal\";s:15:\"adaptive_height\";s:4:\"true\";}s:10:\"edn_scroll\";a:4:{s:10:\"title_text\";s:0:\"\";s:5:\"speed\";s:0:\"\";s:9:\"direction\";s:3:\"ltr\";s:9:\"animation\";s:6:\"reveal\";}s:14:\"edn_visibility\";s:6:\"sticky\";s:28:\"edn_visibility_show_duration\";s:2:\"10\";s:28:\"edn_visibility_hide_duration\";s:2:\"10\";s:16:\"edn_close_button\";s:7:\"disable\";s:9:\"show_once\";s:0:\"\";s:14:\"edn_bar_design\";s:12:\"preavailable\";s:12:\"edn_multiple\";a:25:{s:12:\"text_content\";a:1:{s:5:\"od6UA\";s:11:\"<p>Test</p>\";}s:14:\"call_to_action\";a:1:{s:5:\"od6UA\";s:1:\"0\";}s:20:\"call_to_acction_type\";a:1:{s:5:\"od6UA\";s:6:\"custom\";}s:17:\"contact_form_type\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:16:\"contact_btn_text\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:13:\"link_but_text\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:8:\"link_url\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:11:\"link_target\";a:1:{s:5:\"od6UA\";s:6:\"_blank\";}s:10:\"name_label\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:11:\"email_label\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:13:\"name_required\";a:1:{s:5:\"od6UA\";s:1:\"1\";}s:14:\"email_required\";a:1:{s:5:\"od6UA\";s:1:\"1\";}s:12:\"msg_required\";a:1:{s:5:\"od6UA\";s:1:\"1\";}s:9:\"msg_label\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:13:\"send_to_email\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:16:\"name_placeholder\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:17:\"email_placeholder\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:18:\"name_error_message\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:9:\"msg_error\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:19:\"email_error_message\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:25:\"email_valid_error_message\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:19:\"message_placeholder\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:15:\"success_message\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:12:\"sendfail_msg\";a:1:{s:5:\"od6UA\";s:0:\"\";}s:14:\"form_shortcode\";a:1:{s:5:\"od6UA\";s:9:\"undefined\";}}s:12:\"icon_details\";a:0:{}s:17:\"edn_show_duration\";s:0:\"\";s:17:\"edn_hide_duration\";s:0:\"\";s:18:\"duration_show_once\";s:0:\"\";s:18:\"show_once_hideshow\";s:0:\"\";s:12:\"edn_bg_color\";s:0:\"\";s:9:\"edn_fonts\";s:7:\"default\";s:13:\"edn_font_size\";s:0:\"\";s:11:\"cf_bg_color\";s:0:\"\";s:13:\"cf_font_color\";s:0:\"\";s:17:\"cf_hover_bg_color\";s:0:\"\";s:19:\"cf_hover_font_color\";s:0:\"\";s:12:\"button_fsize\";s:0:\"\";s:14:\"button_fweight\";s:6:\"normal\";s:13:\"atag_bg_color\";s:0:\"\";s:15:\"atag_font_color\";s:0:\"\";s:19:\"atag_hover_bg_color\";s:0:\"\";s:21:\"atag_hover_font_color\";s:0:\"\";s:14:\"close_bg_color\";s:0:\"\";s:16:\"close_font_color\";s:0:\"\";}', 'yes'),
(11376, 'apexnb_fonts', 'a:725:{i:0;s:7:\"ABeeZee\";i:1;s:4:\"Abel\";i:2;s:13:\"Abril Fatface\";i:3;s:8:\"Aclonica\";i:4;s:4:\"Acme\";i:5;s:5:\"Actor\";i:6;s:7:\"Adamina\";i:7;s:10:\"Advent Pro\";i:8;s:15:\"Aguafina Script\";i:9;s:7:\"Akronim\";i:10;s:6:\"Aladin\";i:11;s:7:\"Aldrich\";i:12;s:4:\"Alef\";i:13;s:8:\"Alegreya\";i:14;s:11:\"Alegreya SC\";i:15;s:13:\"Alegreya Sans\";i:16;s:16:\"Alegreya Sans SC\";i:17;s:10:\"Alex Brush\";i:18;s:13:\"Alfa Slab One\";i:19;s:5:\"Alice\";i:20;s:5:\"Alike\";i:21;s:13:\"Alike Angular\";i:22;s:5:\"Allan\";i:23;s:7:\"Allerta\";i:24;s:15:\"Allerta Stencil\";i:25;s:6:\"Allura\";i:26;s:8:\"Almendra\";i:27;s:16:\"Almendra Display\";i:28;s:11:\"Almendra SC\";i:29;s:8:\"Amarante\";i:30;s:8:\"Amaranth\";i:31;s:9:\"Amatic SC\";i:32;s:9:\"Amethysta\";i:33;s:5:\"Amiri\";i:34;s:5:\"Amita\";i:35;s:7:\"Anaheim\";i:36;s:6:\"Andada\";i:37;s:6:\"Andika\";i:38;s:6:\"Angkor\";i:39;s:24:\"Annie Use Your Telescope\";i:40;s:13:\"Anonymous Pro\";i:41;s:5:\"Antic\";i:42;s:12:\"Antic Didone\";i:43;s:10:\"Antic Slab\";i:44;s:5:\"Anton\";i:45;s:6:\"Arapey\";i:46;s:7:\"Arbutus\";i:47;s:12:\"Arbutus Slab\";i:48;s:19:\"Architects Daughter\";i:49;s:13:\"Archivo Black\";i:50;s:14:\"Archivo Narrow\";i:51;s:5:\"Arimo\";i:52;s:8:\"Arizonia\";i:53;s:6:\"Armata\";i:54;s:8:\"Artifika\";i:55;s:4:\"Arvo\";i:56;s:4:\"Arya\";i:57;s:4:\"Asap\";i:58;s:4:\"Asar\";i:59;s:5:\"Asset\";i:60;s:7:\"Astloch\";i:61;s:4:\"Asul\";i:62;s:10:\"Atomic Age\";i:63;s:6:\"Aubrey\";i:64;s:9:\"Audiowide\";i:65;s:10:\"Autour One\";i:66;s:7:\"Average\";i:67;s:12:\"Average Sans\";i:68;s:19:\"Averia Gruesa Libre\";i:69;s:12:\"Averia Libre\";i:70;s:17:\"Averia Sans Libre\";i:71;s:18:\"Averia Serif Libre\";i:72;s:10:\"Bad Script\";i:73;s:9:\"Balthazar\";i:74;s:7:\"Bangers\";i:75;s:5:\"Basic\";i:76;s:10:\"Battambang\";i:77;s:7:\"Baumans\";i:78;s:5:\"Bayon\";i:79;s:8:\"Belgrano\";i:80;s:7:\"Belleza\";i:81;s:9:\"BenchNine\";i:82;s:7:\"Bentham\";i:83;s:15:\"Berkshire Swash\";i:84;s:5:\"Bevan\";i:85;s:13:\"Bigelow Rules\";i:86;s:11:\"Bigshot One\";i:87;s:5:\"Bilbo\";i:88;s:16:\"Bilbo Swash Caps\";i:89;s:7:\"Biryani\";i:90;s:6:\"Bitter\";i:91;s:13:\"Black Ops One\";i:92;s:5:\"Bokor\";i:93;s:6:\"Bonbon\";i:94;s:8:\"Boogaloo\";i:95;s:10:\"Bowlby One\";i:96;s:13:\"Bowlby One SC\";i:97;s:7:\"Brawler\";i:98;s:10:\"Bree Serif\";i:99;s:14:\"Bubblegum Sans\";i:100;s:11:\"Bubbler One\";i:101;s:4:\"Buda\";i:102;s:7:\"Buenard\";i:103;s:10:\"Butcherman\";i:104;s:14:\"Butterfly Kids\";i:105;s:5:\"Cabin\";i:106;s:15:\"Cabin Condensed\";i:107;s:12:\"Cabin Sketch\";i:108;s:15:\"Caesar Dressing\";i:109;s:10:\"Cagliostro\";i:110;s:14:\"Calligraffitti\";i:111;s:6:\"Cambay\";i:112;s:5:\"Cambo\";i:113;s:6:\"Candal\";i:114;s:9:\"Cantarell\";i:115;s:11:\"Cantata One\";i:116;s:11:\"Cantora One\";i:117;s:8:\"Capriola\";i:118;s:5:\"Cardo\";i:119;s:5:\"Carme\";i:120;s:14:\"Carrois Gothic\";i:121;s:17:\"Carrois Gothic SC\";i:122;s:10:\"Carter One\";i:123;s:6:\"Caudex\";i:124;s:18:\"Cedarville Cursive\";i:125;s:11:\"Ceviche One\";i:126;s:10:\"Changa One\";i:127;s:6:\"Chango\";i:128;s:18:\"Chau Philomene One\";i:129;s:9:\"Chela One\";i:130;s:14:\"Chelsea Market\";i:131;s:6:\"Chenla\";i:132;s:17:\"Cherry Cream Soda\";i:133;s:12:\"Cherry Swash\";i:134;s:5:\"Chewy\";i:135;s:6:\"Chicle\";i:136;s:5:\"Chivo\";i:137;s:6:\"Cinzel\";i:138;s:17:\"Cinzel Decorative\";i:139;s:14:\"Clicker Script\";i:140;s:4:\"Coda\";i:141;s:12:\"Coda Caption\";i:142;s:8:\"Codystar\";i:143;s:5:\"Combo\";i:144;s:9:\"Comfortaa\";i:145;s:11:\"Coming Soon\";i:146;s:11:\"Concert One\";i:147;s:9:\"Condiment\";i:148;s:7:\"Content\";i:149;s:12:\"Contrail One\";i:150;s:11:\"Convergence\";i:151;s:6:\"Cookie\";i:152;s:5:\"Copse\";i:153;s:6:\"Corben\";i:154;s:9:\"Courgette\";i:155;s:7:\"Cousine\";i:156;s:8:\"Coustard\";i:157;s:21:\"Covered By Your Grace\";i:158;s:12:\"Crafty Girls\";i:159;s:9:\"Creepster\";i:160;s:11:\"Crete Round\";i:161;s:12:\"Crimson Text\";i:162;s:13:\"Croissant One\";i:163;s:7:\"Crushed\";i:164;s:6:\"Cuprum\";i:165;s:6:\"Cutive\";i:166;s:11:\"Cutive Mono\";i:167;s:6:\"Damion\";i:168;s:14:\"Dancing Script\";i:169;s:7:\"Dangrek\";i:170;s:20:\"Dawning of a New Day\";i:171;s:8:\"Days One\";i:172;s:5:\"Dekko\";i:173;s:6:\"Delius\";i:174;s:17:\"Delius Swash Caps\";i:175;s:14:\"Delius Unicase\";i:176;s:13:\"Della Respira\";i:177;s:8:\"Denk One\";i:178;s:10:\"Devonshire\";i:179;s:8:\"Dhurjati\";i:180;s:13:\"Didact Gothic\";i:181;s:9:\"Diplomata\";i:182;s:12:\"Diplomata SC\";i:183;s:6:\"Domine\";i:184;s:11:\"Donegal One\";i:185;s:10:\"Doppio One\";i:186;s:5:\"Dorsa\";i:187;s:5:\"Dosis\";i:188;s:11:\"Dr Sugiyama\";i:189;s:10:\"Droid Sans\";i:190;s:15:\"Droid Sans Mono\";i:191;s:11:\"Droid Serif\";i:192;s:9:\"Duru Sans\";i:193;s:9:\"Dynalight\";i:194;s:11:\"EB Garamond\";i:195;s:10:\"Eagle Lake\";i:196;s:5:\"Eater\";i:197;s:9:\"Economica\";i:198;s:5:\"Eczar\";i:199;s:8:\"Ek Mukta\";i:200;s:11:\"Electrolize\";i:201;s:5:\"Elsie\";i:202;s:16:\"Elsie Swash Caps\";i:203;s:11:\"Emblema One\";i:204;s:12:\"Emilys Candy\";i:205;s:10:\"Engagement\";i:206;s:9:\"Englebert\";i:207;s:9:\"Enriqueta\";i:208;s:9:\"Erica One\";i:209;s:7:\"Esteban\";i:210;s:15:\"Euphoria Script\";i:211;s:5:\"Ewert\";i:212;s:3:\"Exo\";i:213;s:5:\"Exo 2\";i:214;s:13:\"Expletus Sans\";i:215;s:12:\"Fanwood Text\";i:216;s:9:\"Fascinate\";i:217;s:16:\"Fascinate Inline\";i:218;s:10:\"Faster One\";i:219;s:8:\"Fasthand\";i:220;s:9:\"Fauna One\";i:221;s:8:\"Federant\";i:222;s:6:\"Federo\";i:223;s:6:\"Felipa\";i:224;s:5:\"Fenix\";i:225;s:12:\"Finger Paint\";i:226;s:9:\"Fira Mono\";i:227;s:9:\"Fira Sans\";i:228;s:10:\"Fjalla One\";i:229;s:9:\"Fjord One\";i:230;s:8:\"Flamenco\";i:231;s:7:\"Flavors\";i:232;s:10:\"Fondamento\";i:233;s:16:\"Fontdiner Swanky\";i:234;s:5:\"Forum\";i:235;s:12:\"Francois One\";i:236;s:12:\"Freckle Face\";i:237;s:20:\"Fredericka the Great\";i:238;s:11:\"Fredoka One\";i:239;s:8:\"Freehand\";i:240;s:6:\"Fresca\";i:241;s:7:\"Frijole\";i:242;s:7:\"Fruktur\";i:243;s:9:\"Fugaz One\";i:244;s:9:\"GFS Didot\";i:245;s:15:\"GFS Neohellenic\";i:246;s:8:\"Gabriela\";i:247;s:6:\"Gafata\";i:248;s:8:\"Galdeano\";i:249;s:7:\"Galindo\";i:250;s:13:\"Gentium Basic\";i:251;s:18:\"Gentium Book Basic\";i:252;s:3:\"Geo\";i:253;s:7:\"Geostar\";i:254;s:12:\"Geostar Fill\";i:255;s:12:\"Germania One\";i:256;s:6:\"Gidugu\";i:257;s:13:\"Gilda Display\";i:258;s:14:\"Give You Glory\";i:259;s:13:\"Glass Antiqua\";i:260;s:6:\"Glegoo\";i:261;s:17:\"Gloria Hallelujah\";i:262;s:10:\"Goblin One\";i:263;s:10:\"Gochi Hand\";i:264;s:8:\"Gorditas\";i:265;s:21:\"Goudy Bookletter 1911\";i:266;s:8:\"Graduate\";i:267;s:11:\"Grand Hotel\";i:268;s:12:\"Gravitas One\";i:269;s:11:\"Great Vibes\";i:270;s:6:\"Griffy\";i:271;s:6:\"Gruppo\";i:272;s:5:\"Gudea\";i:273;s:8:\"Gurajada\";i:274;s:6:\"Habibi\";i:275;s:6:\"Halant\";i:276;s:15:\"Hammersmith One\";i:277;s:7:\"Hanalei\";i:278;s:12:\"Hanalei Fill\";i:279;s:7:\"Handlee\";i:280;s:7:\"Hanuman\";i:281;s:12:\"Happy Monkey\";i:282;s:12:\"Headland One\";i:283;s:11:\"Henny Penny\";i:284;s:20:\"Herr Von Muellerhoff\";i:285;s:4:\"Hind\";i:286;s:15:\"Holtwood One SC\";i:287;s:14:\"Homemade Apple\";i:288;s:8:\"Homenaje\";i:289;s:15:\"IM Fell DW Pica\";i:290;s:18:\"IM Fell DW Pica SC\";i:291;s:19:\"IM Fell Double Pica\";i:292;s:22:\"IM Fell Double Pica SC\";i:293;s:15:\"IM Fell English\";i:294;s:18:\"IM Fell English SC\";i:295;s:20:\"IM Fell French Canon\";i:296;s:23:\"IM Fell French Canon SC\";i:297;s:20:\"IM Fell Great Primer\";i:298;s:23:\"IM Fell Great Primer SC\";i:299;s:7:\"Iceberg\";i:300;s:7:\"Iceland\";i:301;s:7:\"Imprima\";i:302;s:11:\"Inconsolata\";i:303;s:5:\"Inder\";i:304;s:12:\"Indie Flower\";i:305;s:5:\"Inika\";i:306;s:14:\"Inknut Antiqua\";i:307;s:12:\"Irish Grover\";i:308;s:9:\"Istok Web\";i:309;s:8:\"Italiana\";i:310;s:9:\"Italianno\";i:311;s:16:\"Jacques Francois\";i:312;s:23:\"Jacques Francois Shadow\";i:313;s:5:\"Jaldi\";i:314;s:14:\"Jim Nightshade\";i:315;s:10:\"Jockey One\";i:316;s:12:\"Jolly Lodger\";i:317;s:12:\"Josefin Sans\";i:318;s:12:\"Josefin Slab\";i:319;s:8:\"Joti One\";i:320;s:6:\"Judson\";i:321;s:5:\"Julee\";i:322;s:15:\"Julius Sans One\";i:323;s:5:\"Junge\";i:324;s:4:\"Jura\";i:325;s:17:\"Just Another Hand\";i:326;s:23:\"Just Me Again Down Here\";i:327;s:5:\"Kadwa\";i:328;s:5:\"Kalam\";i:329;s:7:\"Kameron\";i:330;s:9:\"Kantumruy\";i:331;s:5:\"Karla\";i:332;s:5:\"Karma\";i:333;s:14:\"Kaushan Script\";i:334;s:6:\"Kavoon\";i:335;s:10:\"Kdam Thmor\";i:336;s:10:\"Keania One\";i:337;s:10:\"Kelly Slab\";i:338;s:5:\"Kenia\";i:339;s:5:\"Khand\";i:340;s:5:\"Khmer\";i:341;s:5:\"Khula\";i:342;s:8:\"Kite One\";i:343;s:7:\"Knewave\";i:344;s:9:\"Kotta One\";i:345;s:6:\"Koulen\";i:346;s:6:\"Kranky\";i:347;s:5:\"Kreon\";i:348;s:6:\"Kristi\";i:349;s:9:\"Krona One\";i:350;s:6:\"Kurale\";i:351;s:15:\"La Belle Aurore\";i:352;s:5:\"Laila\";i:353;s:11:\"Lakki Reddy\";i:354;s:8:\"Lancelot\";i:355;s:6:\"Lateef\";i:356;s:4:\"Lato\";i:357;s:13:\"League Script\";i:358;s:12:\"Leckerli One\";i:359;s:6:\"Ledger\";i:360;s:6:\"Lekton\";i:361;s:5:\"Lemon\";i:362;s:17:\"Libre Baskerville\";i:363;s:11:\"Life Savers\";i:364;s:10:\"Lilita One\";i:365;s:15:\"Lily Script One\";i:366;s:9:\"Limelight\";i:367;s:11:\"Linden Hill\";i:368;s:7:\"Lobster\";i:369;s:11:\"Lobster Two\";i:370;s:16:\"Londrina Outline\";i:371;s:15:\"Londrina Shadow\";i:372;s:15:\"Londrina Sketch\";i:373;s:14:\"Londrina Solid\";i:374;s:4:\"Lora\";i:375;s:21:\"Love Ya Like A Sister\";i:376;s:17:\"Loved by the King\";i:377;s:14:\"Lovers Quarrel\";i:378;s:12:\"Luckiest Guy\";i:379;s:8:\"Lusitana\";i:380;s:7:\"Lustria\";i:381;s:7:\"Macondo\";i:382;s:18:\"Macondo Swash Caps\";i:383;s:5:\"Magra\";i:384;s:13:\"Maiden Orange\";i:385;s:4:\"Mako\";i:386;s:8:\"Mallanna\";i:387;s:7:\"Mandali\";i:388;s:9:\"Marcellus\";i:389;s:12:\"Marcellus SC\";i:390;s:12:\"Marck Script\";i:391;s:9:\"Margarine\";i:392;s:9:\"Marko One\";i:393;s:8:\"Marmelad\";i:394;s:6:\"Martel\";i:395;s:11:\"Martel Sans\";i:396;s:6:\"Marvel\";i:397;s:4:\"Mate\";i:398;s:7:\"Mate SC\";i:399;s:9:\"Maven Pro\";i:400;s:7:\"McLaren\";i:401;s:6:\"Meddon\";i:402;s:13:\"MedievalSharp\";i:403;s:10:\"Medula One\";i:404;s:6:\"Megrim\";i:405;s:11:\"Meie Script\";i:406;s:8:\"Merienda\";i:407;s:12:\"Merienda One\";i:408;s:12:\"Merriweather\";i:409;s:17:\"Merriweather Sans\";i:410;s:5:\"Metal\";i:411;s:11:\"Metal Mania\";i:412;s:12:\"Metamorphous\";i:413;s:11:\"Metrophobic\";i:414;s:8:\"Michroma\";i:415;s:7:\"Milonga\";i:416;s:9:\"Miltonian\";i:417;s:16:\"Miltonian Tattoo\";i:418;s:7:\"Miniver\";i:419;s:14:\"Miss Fajardose\";i:420;s:5:\"Modak\";i:421;s:14:\"Modern Antiqua\";i:422;s:7:\"Molengo\";i:423;s:5:\"Molle\";i:424;s:5:\"Monda\";i:425;s:8:\"Monofett\";i:426;s:7:\"Monoton\";i:427;s:20:\"Monsieur La Doulaise\";i:428;s:7:\"Montaga\";i:429;s:6:\"Montez\";i:430;s:10:\"Montserrat\";i:431;s:21:\"Montserrat Alternates\";i:432;s:20:\"Montserrat Subrayada\";i:433;s:4:\"Moul\";i:434;s:8:\"Moulpali\";i:435;s:22:\"Mountains of Christmas\";i:436;s:13:\"Mouse Memoirs\";i:437;s:10:\"Mr Bedfort\";i:438;s:8:\"Mr Dafoe\";i:439;s:14:\"Mr De Haviland\";i:440;s:19:\"Mrs Saint Delafield\";i:441;s:13:\"Mrs Sheppards\";i:442;s:4:\"Muli\";i:443;s:13:\"Mystery Quest\";i:444;s:3:\"NTR\";i:445;s:6:\"Neucha\";i:446;s:6:\"Neuton\";i:447;s:10:\"New Rocker\";i:448;s:10:\"News Cycle\";i:449;s:7:\"Niconne\";i:450;s:9:\"Nixie One\";i:451;s:6:\"Nobile\";i:452;s:6:\"Nokora\";i:453;s:7:\"Norican\";i:454;s:7:\"Nosifer\";i:455;s:20:\"Nothing You Could Do\";i:456;s:12:\"Noticia Text\";i:457;s:9:\"Noto Sans\";i:458;s:10:\"Noto Serif\";i:459;s:8:\"Nova Cut\";i:460;s:9:\"Nova Flat\";i:461;s:9:\"Nova Mono\";i:462;s:9:\"Nova Oval\";i:463;s:10:\"Nova Round\";i:464;s:11:\"Nova Script\";i:465;s:9:\"Nova Slim\";i:466;s:11:\"Nova Square\";i:467;s:6:\"Numans\";i:468;s:6:\"Nunito\";i:469;s:14:\"Odor Mean Chey\";i:470;s:7:\"Offside\";i:471;s:15:\"Old Standard TT\";i:472;s:9:\"Oldenburg\";i:473;s:11:\"Oleo Script\";i:474;s:22:\"Oleo Script Swash Caps\";i:475;s:9:\"Open Sans\";i:476;s:19:\"Open Sans Condensed\";i:477;s:11:\"Oranienbaum\";i:478;s:8:\"Orbitron\";i:479;s:7:\"Oregano\";i:480;s:7:\"Orienta\";i:481;s:15:\"Original Surfer\";i:482;s:6:\"Oswald\";i:483;s:16:\"Over the Rainbow\";i:484;s:8:\"Overlock\";i:485;s:11:\"Overlock SC\";i:486;s:3:\"Ovo\";i:487;s:6:\"Oxygen\";i:488;s:11:\"Oxygen Mono\";i:489;s:7:\"PT Mono\";i:490;s:7:\"PT Sans\";i:491;s:15:\"PT Sans Caption\";i:492;s:14:\"PT Sans Narrow\";i:493;s:8:\"PT Serif\";i:494;s:16:\"PT Serif Caption\";i:495;s:8:\"Pacifico\";i:496;s:9:\"Palanquin\";i:497;s:14:\"Palanquin Dark\";i:498;s:7:\"Paprika\";i:499;s:10:\"Parisienne\";i:500;s:11:\"Passero One\";i:501;s:11:\"Passion One\";i:502;s:18:\"Pathway Gothic One\";i:503;s:12:\"Patrick Hand\";i:504;s:15:\"Patrick Hand SC\";i:505;s:9:\"Patua One\";i:506;s:11:\"Paytone One\";i:507;s:7:\"Peddana\";i:508;s:7:\"Peralta\";i:509;s:16:\"Permanent Marker\";i:510;s:19:\"Petit Formal Script\";i:511;s:7:\"Petrona\";i:512;s:11:\"Philosopher\";i:513;s:6:\"Piedra\";i:514;s:13:\"Pinyon Script\";i:515;s:10:\"Pirata One\";i:516;s:7:\"Plaster\";i:517;s:4:\"Play\";i:518;s:8:\"Playball\";i:519;s:16:\"Playfair Display\";i:520;s:19:\"Playfair Display SC\";i:521;s:7:\"Podkova\";i:522;s:10:\"Poiret One\";i:523;s:10:\"Poller One\";i:524;s:4:\"Poly\";i:525;s:8:\"Pompiere\";i:526;s:12:\"Pontano Sans\";i:527;s:7:\"Poppins\";i:528;s:16:\"Port Lligat Sans\";i:529;s:16:\"Port Lligat Slab\";i:530;s:14:\"Pragati Narrow\";i:531;s:5:\"Prata\";i:532;s:11:\"Preahvihear\";i:533;s:14:\"Press Start 2P\";i:534;s:14:\"Princess Sofia\";i:535;s:8:\"Prociono\";i:536;s:10:\"Prosto One\";i:537;s:7:\"Puritan\";i:538;s:12:\"Purple Purse\";i:539;s:6:\"Quando\";i:540;s:8:\"Quantico\";i:541;s:12:\"Quattrocento\";i:542;s:17:\"Quattrocento Sans\";i:543;s:9:\"Questrial\";i:544;s:9:\"Quicksand\";i:545;s:14:\"Quintessential\";i:546;s:7:\"Qwigley\";i:547;s:15:\"Racing Sans One\";i:548;s:6:\"Radley\";i:549;s:8:\"Rajdhani\";i:550;s:7:\"Raleway\";i:551;s:12:\"Raleway Dots\";i:552;s:10:\"Ramabhadra\";i:553;s:8:\"Ramaraja\";i:554;s:6:\"Rambla\";i:555;s:12:\"Rammetto One\";i:556;s:8:\"Ranchers\";i:557;s:6:\"Rancho\";i:558;s:5:\"Ranga\";i:559;s:9:\"Rationale\";i:560;s:12:\"Ravi Prakash\";i:561;s:9:\"Redressed\";i:562;s:13:\"Reenie Beanie\";i:563;s:7:\"Revalia\";i:564;s:13:\"Rhodium Libre\";i:565;s:6:\"Ribeye\";i:566;s:13:\"Ribeye Marrow\";i:567;s:9:\"Righteous\";i:568;s:6:\"Risque\";i:569;s:6:\"Roboto\";i:570;s:16:\"Roboto Condensed\";i:571;s:11:\"Roboto Mono\";i:572;s:11:\"Roboto Slab\";i:573;s:9:\"Rochester\";i:574;s:9:\"Rock Salt\";i:575;s:7:\"Rokkitt\";i:576;s:9:\"Romanesco\";i:577;s:9:\"Ropa Sans\";i:578;s:7:\"Rosario\";i:579;s:8:\"Rosarivo\";i:580;s:12:\"Rouge Script\";i:581;s:9:\"Rozha One\";i:582;s:5:\"Rubik\";i:583;s:14:\"Rubik Mono One\";i:584;s:9:\"Rubik One\";i:585;s:4:\"Ruda\";i:586;s:6:\"Rufina\";i:587;s:11:\"Ruge Boogie\";i:588;s:6:\"Ruluko\";i:589;s:10:\"Rum Raisin\";i:590;s:14:\"Ruslan Display\";i:591;s:9:\"Russo One\";i:592;s:6:\"Ruthie\";i:593;s:3:\"Rye\";i:594;s:10:\"Sacramento\";i:595;s:7:\"Sahitya\";i:596;s:4:\"Sail\";i:597;s:5:\"Salsa\";i:598;s:7:\"Sanchez\";i:599;s:8:\"Sancreek\";i:600;s:11:\"Sansita One\";i:601;s:6:\"Sarala\";i:602;s:6:\"Sarina\";i:603;s:8:\"Sarpanch\";i:604;s:7:\"Satisfy\";i:605;s:5:\"Scada\";i:606;s:12:\"Scheherazade\";i:607;s:10:\"Schoolbell\";i:608;s:14:\"Seaweed Script\";i:609;s:9:\"Sevillana\";i:610;s:11:\"Seymour One\";i:611;s:18:\"Shadows Into Light\";i:612;s:22:\"Shadows Into Light Two\";i:613;s:6:\"Shanti\";i:614;s:5:\"Share\";i:615;s:10:\"Share Tech\";i:616;s:15:\"Share Tech Mono\";i:617;s:9:\"Shojumaru\";i:618;s:11:\"Short Stack\";i:619;s:8:\"Siemreap\";i:620;s:10:\"Sigmar One\";i:621;s:7:\"Signika\";i:622;s:16:\"Signika Negative\";i:623;s:9:\"Simonetta\";i:624;s:7:\"Sintony\";i:625;s:13:\"Sirin Stencil\";i:626;s:8:\"Six Caps\";i:627;s:7:\"Skranji\";i:628;s:10:\"Slabo 13px\";i:629;s:10:\"Slabo 27px\";i:630;s:7:\"Slackey\";i:631;s:6:\"Smokum\";i:632;s:6:\"Smythe\";i:633;s:7:\"Sniglet\";i:634;s:7:\"Snippet\";i:635;s:13:\"Snowburst One\";i:636;s:10:\"Sofadi One\";i:637;s:5:\"Sofia\";i:638;s:10:\"Sonsie One\";i:639;s:16:\"Sorts Mill Goudy\";i:640;s:15:\"Source Code Pro\";i:641;s:15:\"Source Sans Pro\";i:642;s:16:\"Source Serif Pro\";i:643;s:13:\"Special Elite\";i:644;s:10:\"Spicy Rice\";i:645;s:9:\"Spinnaker\";i:646;s:6:\"Spirax\";i:647;s:10:\"Squada One\";i:648;s:20:\"Sree Krushnadevaraya\";i:649;s:9:\"Stalemate\";i:650;s:13:\"Stalinist One\";i:651;s:15:\"Stardos Stencil\";i:652;s:21:\"Stint Ultra Condensed\";i:653;s:20:\"Stint Ultra Expanded\";i:654;s:5:\"Stoke\";i:655;s:6:\"Strait\";i:656;s:19:\"Sue Ellen Francisco\";i:657;s:6:\"Sumana\";i:658;s:9:\"Sunshiney\";i:659;s:16:\"Supermercado One\";i:660;s:4:\"Sura\";i:661;s:7:\"Suranna\";i:662;s:9:\"Suravaram\";i:663;s:11:\"Suwannaphum\";i:664;s:18:\"Swanky and Moo Moo\";i:665;s:9:\"Syncopate\";i:666;s:9:\"Tangerine\";i:667;s:6:\"Taprom\";i:668;s:5:\"Tauri\";i:669;s:4:\"Teko\";i:670;s:5:\"Telex\";i:671;s:18:\"Tenali Ramakrishna\";i:672;s:10:\"Tenor Sans\";i:673;s:11:\"Text Me One\";i:674;s:18:\"The Girl Next Door\";i:675;s:6:\"Tienne\";i:676;s:7:\"Tillana\";i:677;s:7:\"Timmana\";i:678;s:5:\"Tinos\";i:679;s:9:\"Titan One\";i:680;s:13:\"Titillium Web\";i:681;s:11:\"Trade Winds\";i:682;s:7:\"Trocchi\";i:683;s:7:\"Trochut\";i:684;s:7:\"Trykker\";i:685;s:10:\"Tulpen One\";i:686;s:6:\"Ubuntu\";i:687;s:16:\"Ubuntu Condensed\";i:688;s:11:\"Ubuntu Mono\";i:689;s:5:\"Ultra\";i:690;s:14:\"Uncial Antiqua\";i:691;s:8:\"Underdog\";i:692;s:9:\"Unica One\";i:693;s:14:\"UnifrakturCook\";i:694;s:18:\"UnifrakturMaguntia\";i:695;s:7:\"Unkempt\";i:696;s:6:\"Unlock\";i:697;s:4:\"Unna\";i:698;s:5:\"VT323\";i:699;s:11:\"Vampiro One\";i:700;s:6:\"Varela\";i:701;s:12:\"Varela Round\";i:702;s:11:\"Vast Shadow\";i:703;s:12:\"Vesper Libre\";i:704;s:5:\"Vibur\";i:705;s:8:\"Vidaloka\";i:706;s:4:\"Viga\";i:707;s:5:\"Voces\";i:708;s:7:\"Volkhov\";i:709;s:8:\"Vollkorn\";i:710;s:8:\"Voltaire\";i:711;s:23:\"Waiting for the Sunrise\";i:712;s:8:\"Wallpoet\";i:713;s:15:\"Walter Turncoat\";i:714;s:6:\"Warnes\";i:715;s:9:\"Wellfleet\";i:716;s:9:\"Wendy One\";i:717;s:8:\"Wire One\";i:718;s:9:\"Work Sans\";i:719;s:17:\"Yanone Kaffeesatz\";i:720;s:11:\"Yantramanav\";i:721;s:10:\"Yellowtail\";i:722;s:10:\"Yeseva One\";i:723;s:10:\"Yesteryear\";i:724;s:6:\"Zeyada\";}', 'yes'),
(11481, 'widget_hmnewsfeedwidgetactivater', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(11522, 'wpos_anylc_redirect', '', 'yes'),
(11527, 'wpos_anylc_site_uid', 'af2325ec344380aaa1b49f37bfd6fc7d', 'yes'),
(11528, 'wpos_anylc_pdt_5', 'a:1:{s:6:\"status\";i:2;}', 'yes');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(11572, 'fs_active_plugins', 'O:8:\"stdClass\":0:{}', 'yes'),
(11573, 'fs_debug_mode', '', 'yes'),
(11574, 'fs_accounts', 'a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:9048;a:3:{s:4:\"slug\";s:11:\"wp-top-news\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:27:\"wp-top-news/wp-top-news.php\";}}s:11:\"plugin_data\";a:1:{s:11:\"wp-top-news\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:27:\"wp-top-news/wp-top-news.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1651054918;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:5:\"2.4.3\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:3:\"2.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:16:\"happydisplay.opteam.net\";s:9:\"server_ip\";s:14:\"185.83.236.175\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1651054918;s:7:\"version\";s:3:\"2.1\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1651054925;s:7:\"version\";s:3:\"2.1\";}}}s:13:\"file_slug_map\";a:1:{s:27:\"wp-top-news/wp-top-news.php\";s:11:\"wp-top-news\";}s:7:\"plugins\";a:1:{s:11:\"wp-top-news\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:11:\"WP Top News\";s:4:\"slug\";s:11:\"wp-top-news\";s:12:\"premium_slug\";s:19:\"wp-top-news-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:27:\"wp-top-news/wp-top-news.php\";s:7:\"version\";s:3:\"2.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:12:\"Professional\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_cda42efe6097938ed803a6a4ef6d2\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"9048\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"c64b87c4902ac64156803711e4b25436\";s:13:\"admin_notices\";a:1:{s:11:\"wp-top-news\";a:0:{}}}', 'yes'),
(11575, 'fs_gdpr', 'a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}', 'yes'),
(11576, 'fs_api_cache', 'a:0:{}', 'no'),
(11592, '_transient_wtn_api_cached_data_cnn', 'a:3:{s:6:\"status\";s:2:\"ok\";s:12:\"totalResults\";i:10;s:8:\"articles\";a:10:{i:0;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:46:\"Sugam Pokharel and Mark Thompson, CNN Business\";s:5:\"title\";s:52:\"Russia shuts off gas supplies to Poland and Bulgaria\";s:11:\"description\";s:164:\"Russia has cut off natural gas supplies to Poland and Bulgaria, dramatically escalating its response to Western sanctions imposed on Moscow over the war in Ukraine.\";s:3:\"url\";s:64:\"http://us.cnn.com/2022/04/26/energy/poland-russia-gas/index.html\";s:10:\"urlToImage\";s:98:\"https://cdn.cnn.com/cnnnext/dam/assets/220426145143-yamal-gas-pipeline-poland-0219-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-27T08:51:45Z\";s:7:\"content\";N;}i:1;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:127:\"By <a href=\"/profiles/jessie-yeung\">Jessie Yeung</a>, Seán Federico-O\'Murchú, Ben Morse, Jeevan Ravindran and Ed Upright, CNN\";s:5:\"title\";s:37:\"Live updates: Russia\'s war in Ukraine\";s:11:\"description\";s:211:\"Civilians are fleeing the southern Ukrainian city of Kherson, which has fallen to Russian control and is expected to stage what Ukrainian leaders have called a sham referendum. Follow here for live news updates.\";s:3:\"url\";s:80:\"https://www.cnn.com/europe/live-news/russia-ukraine-war-news-04-27-22/index.html\";s:10:\"urlToImage\";s:87:\"https://cdn.cnn.com/cnnnext/dam/assets/220426111149-mariupol-mass-grave-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-27T03:59:50Z\";s:7:\"content\";s:216:\"The Ukrainian armed forces have acknowledged the loss of several towns and villages in eastern regions as Russia steps up its ground offensive.\r\nHeavy fighting is ongoing on three fronts, with Russia… [+2001 chars]\";}i:2;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:86:\"By <a href=\"/profiles/jessie-yeung\">Jessie Yeung</a> and Seán Federico-O\'Murchú, CNN\";s:5:\"title\";s:37:\"Live updates: Russia\'s war in Ukraine\";s:11:\"description\";s:211:\"Civilians are fleeing the southern Ukrainian city of Kherson, which has fallen to Russian control and is expected to stage what Ukrainian leaders have called a sham referendum. Follow here for live news updates.\";s:3:\"url\";s:104:\"https://www.cnn.com/europe/live-news/russia-ukraine-war-news-04-27-22/h_a737a86115cc6fcd1c74f63e35b8f0b5\";s:10:\"urlToImage\";s:87:\"https://cdn.cnn.com/cnnnext/dam/assets/220426111149-mariupol-mass-grave-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-27T03:59:50Z\";s:7:\"content\";s:216:\"Despite Russia\'s repeated denials they were responsible for any carnage in Bucha, located outside Kyiv, Russian military vehicles and forces were seen on a Bucha street near civilian bodies, new dron… [+1728 chars]\";}i:3;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:86:\"By <a href=\"/profiles/jessie-yeung\">Jessie Yeung</a> and Seán Federico-O\'Murchú, CNN\";s:5:\"title\";s:37:\"Live updates: Russia\'s war in Ukraine\";s:11:\"description\";s:211:\"Civilians are fleeing the southern Ukrainian city of Kherson, which has fallen to Russian control and is expected to stage what Ukrainian leaders have called a sham referendum. Follow here for live news updates.\";s:3:\"url\";s:104:\"https://www.cnn.com/europe/live-news/russia-ukraine-war-news-04-27-22/h_22beeb77e5f9abb8b79420982273143c\";s:10:\"urlToImage\";s:93:\"https://dynaimage.cdn.cnn.com/cnn/digital-images/org/4a80eea9-a654-4177-b119-79ae12c0f5ca.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-27T03:59:50Z\";s:7:\"content\";s:216:\"The Ukrainian armed forces have acknowledged the loss of several towns and villages in eastern regions as Russia steps up its ground offensive.\r\nHeavy fighting is ongoing on three fronts, with Russia… [+2001 chars]\";}i:4;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";N;s:5:\"title\";s:76:\"See the steel plant in Mariupol meant to withstand nuclear blast - CNN Video\";s:11:\"description\";s:229:\"The fight for the Azovstal steel plant in Mariupol, Ukraine, which is meant to withstand nuclear blasts, continues as Russian forces close in on the only thing stopping them from conquering the city. CNN\'s Alex Marquardt reports.\";s:3:\"url\";s:98:\"http://us.cnn.com/videos/world/2022/04/26/azovstal-steel-plant-mariupol-marqaurdt-dnt-ebof-vpx.cnn\";s:10:\"urlToImage\";s:88:\"https://cdn.cnn.com/cnnnext/dam/assets/220426201945-azovstal-steel-plant-super-tease.jpg\";s:11:\"publishedAt\";s:27:\"2022-04-27T01:22:20.355676Z\";s:7:\"content\";N;}i:5;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:47:\"Amir Vera, Elizabeth Wolfe and Amanda Musa, CNN\";s:5:\"title\";s:92:\"Juvenile suspect arrested in connection with the homicide of a 10-year-old girl in Wisconsin\";s:11:\"description\";s:145:\"After the body of Illiana \"Lily\" Peters, 10, was found in the woods Monday morning, police are investigating her death as a homicide, police say.\";s:3:\"url\";s:88:\"http://www.cnn.com/2022/04/25/us/lily-peters-wisconsin-homicide-investigation/index.html\";s:10:\"urlToImage\";s:79:\"https://cdn.cnn.com/cnnnext/dam/assets/220425173737-lily-peters-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-26T23:58:34Z\";s:7:\"content\";s:216:\"(CNN)Police in Chippewa Falls, Wisconsin, arrested a juvenile suspect in connection with the death of 10-year-old Illiana \"Lily\" Peters, police Chief Matthew Kelm said Tuesday night.\r\n\"The suspect wa… [+3739 chars]\";}i:6;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:23:\"Matt Egan, CNN Business\";s:5:\"title\";s:48:\"A major recession is coming, Deutsche Bank warns\";s:11:\"description\";s:130:\"Deutsche Bank raised eyebrows earlier this month by becoming the first major bank to forecast a US recession, albeit a \"mild\" one.\";s:3:\"url\";s:89:\"http://us.cnn.com/2022/04/26/economy/inflation-recession-economy-deutsche-bank/index.html\";s:10:\"urlToImage\";s:109:\"https://cdn.cnn.com/cnnnext/dam/assets/220426085009-restricted-us-economy-inflation-recession-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-26T15:51:20Z\";s:7:\"content\";N;}i:7;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:51:\"Ellie Kaufman, Zachary Cohen and Michael Conte, CNN\";s:5:\"title\";s:124:\"Exclusive: Top US general tells CNN \'global international security order\' is at stake following Russia\'s invasion of Ukraine\";s:11:\"description\";s:253:\"Chairman of the Joint Chiefs of Staff Gen. Mark Milley told CNN\'s Jim Sciutto on Tuesday that the entire \"global international security order\" put in place after World War II is at stake if Russia gets away \"cost-free\" following its invasion of Ukraine.\";s:3:\"url\";s:76:\"http://us.cnn.com/2022/04/26/politics/mark-milley-interview-cnntv/index.html\";s:10:\"urlToImage\";s:97:\"https://cdn.cnn.com/cnnnext/dam/assets/220426104345-01-mark-milley-interview-0426-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-26T15:25:13Z\";s:7:\"content\";N;}i:8;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:10:\"Devan Cole\";s:5:\"title\";s:95:\"Garland says funds from assets US seizes from Russian oligarchs should go \'directly to Ukraine\'\";s:11:\"description\";s:194:\"Attorney General Merrick Garland said Tuesday that he supports efforts to allow some of the proceeds from assets the Justice Department seizes from Russian oligarchs to go \"directly to Ukraine.\"\";s:3:\"url\";s:86:\"http://us.cnn.com/2022/04/26/politics/merrick-garland-senate-budget-hearing/index.html\";s:10:\"urlToImage\";s:111:\"https://media.cnn.com/api/v1/images/stellar/prod/220426102311-02-merrick-garland-0426.jpg?c=16x9&q=w_800,c_fill\";s:11:\"publishedAt\";s:20:\"2022-04-26T15:08:31Z\";s:7:\"content\";s:216:\"Attorney General Merrick Garland said Tuesday that he supports efforts to allow some of the proceeds from assets the Justice Department seizes from Russian oligarchs to go directly to Ukraine. \r\nThe … [+1294 chars]\";}i:9;O:8:\"stdClass\":8:{s:6:\"source\";O:8:\"stdClass\":2:{s:2:\"id\";s:3:\"cnn\";s:4:\"name\";s:3:\"CNN\";}s:6:\"author\";s:55:\"Ivana Kottasová, Stephanie Halasz and Ulrike Heil, CNN\";s:5:\"title\";s:73:\"Germany agrees to send heavy weapons to Ukraine after major policy U-turn\";s:11:\"description\";s:204:\"Germany has agreed to deliver anti-aircraft tanks to Ukraine, the German Defense Ministry announced on Tuesday, a move that underscores a major shift in its approach to providing military help to Ukraine.\";s:3:\"url\";s:77:\"https://www.cnn.com/2022/04/26/europe/germany-weapons-ukraine-intl/index.html\";s:10:\"urlToImage\";s:84:\"https://cdn.cnn.com/cnnnext/dam/assets/220426141806-gepard-tank-file-super-tease.jpg\";s:11:\"publishedAt\";s:20:\"2022-04-26T13:43:38Z\";s:7:\"content\";N;}}}', 'yes'),
(11623, 'daln_database_version', '2', 'yes'),
(11624, 'daln_detect_url_mode', 'wp_request', 'yes'),
(11625, 'daln_load_momentjs', '1', 'yes'),
(11626, 'daln_tickers_menu_capability', 'manage_options', 'yes'),
(11627, 'daln_featured_menu_capability', 'manage_options', 'yes'),
(11628, 'daln_sliding_menu_capability', 'manage_options', 'yes'),
(12180, 'mec_table_version_hd_mec_attendees', '1.1.0', 'yes'),
(12181, 'mec_core_db', '6.5.5', 'yes'),
(12183, 'mec_options', 'a:4:{s:8:\"settings\";a:105:{s:24:\"multiple_day_show_method\";s:18:\"first_day_listgrid\";s:18:\"google_maps_status\";i:1;s:20:\"export_module_status\";i:1;s:2:\"sn\";a:7:{s:9:\"googlecal\";i:1;s:4:\"ical\";i:1;s:8:\"facebook\";i:1;s:5:\"gplus\";i:1;s:7:\"twitter\";i:1;s:8:\"linkedin\";i:1;s:5:\"email\";i:1;}s:16:\"countdown_status\";i:1;s:21:\"social_network_status\";i:1;s:20:\"default_skin_archive\";s:13:\"full_calendar\";s:16:\"hide_time_method\";s:5:\"start\";s:24:\"remove_data_on_uninstall\";s:1:\"1\";s:11:\"date_suffix\";s:1:\"0\";s:6:\"schema\";s:1:\"1\";s:8:\"weekdays\";a:5:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";}s:8:\"weekends\";a:2:{i:0;s:1:\"6\";i:1;s:1:\"7\";}s:17:\"datepicker_format\";s:14:\"dd-mm-yy&d-m-Y\";s:13:\"midnight_hour\";s:1:\"0\";s:14:\"event_as_popup\";s:1:\"0\";s:11:\"sh_as_popup\";s:1:\"0\";s:21:\"include_image_in_feed\";s:1:\"0\";s:30:\"fallback_featured_image_status\";s:1:\"0\";s:10:\"tag_method\";s:8:\"post_tag\";s:9:\"ical_feed\";s:1:\"0\";s:19:\"booking_sender_name\";s:0:\"\";s:20:\"booking_sender_email\";s:0:\"\";s:25:\"booking_recipients_method\";s:3:\"BCC\";s:13:\"archive_title\";s:6:\"Events\";s:17:\"archive_title_tag\";s:2:\"h1\";s:14:\"custom_archive\";s:0:\"\";s:25:\"monthly_view_archive_skin\";s:7:\"classic\";s:22:\"timetable_archive_skin\";s:6:\"modern\";s:17:\"list_archive_skin\";s:7:\"classic\";s:17:\"grid_archive_skin\";s:7:\"classic\";s:21:\"default_skin_category\";s:4:\"list\";s:23:\"custom_archive_category\";s:0:\"\";s:26:\"monthly_view_category_skin\";s:7:\"classic\";s:23:\"timetable_category_skin\";s:6:\"modern\";s:18:\"list_category_skin\";s:7:\"classic\";s:18:\"grid_category_skin\";s:7:\"classic\";s:22:\"category_events_method\";s:1:\"1\";s:14:\"archive_status\";s:1:\"1\";s:4:\"slug\";s:6:\"events\";s:13:\"category_slug\";s:12:\"mec-category\";s:8:\"currency\";s:1:\"$\";s:16:\"currency_symptom\";s:0:\"\";s:13:\"currency_sign\";s:6:\"before\";s:18:\"thousand_separator\";s:1:\",\";s:17:\"decimal_separator\";s:1:\".\";s:17:\"currency_decimals\";s:1:\"2\";s:24:\"decimal_separator_status\";s:1:\"1\";s:24:\"assets_disable_stripe_js\";s:1:\"0\";s:22:\"assets_per_page_status\";s:1:\"0\";s:23:\"assets_in_footer_status\";s:1:\"0\";s:23:\"google_recaptcha_status\";s:1:\"0\";s:20:\"google_recaptcha_fes\";s:1:\"0\";s:24:\"google_recaptcha_sitekey\";s:0:\"\";s:26:\"google_recaptcha_secretkey\";s:0:\"\";s:11:\"time_format\";s:2:\"12\";s:13:\"fes_list_page\";s:0:\"\";s:13:\"fes_form_page\";s:0:\"\";s:20:\"fes_new_event_status\";s:0:\"\";s:24:\"fes_display_date_in_list\";s:1:\"0\";s:17:\"fes_thankyou_page\";s:0:\"\";s:21:\"fes_thankyou_page_url\";s:0:\"\";s:22:\"fes_thankyou_page_time\";s:4:\"2000\";s:17:\"fes_max_file_size\";s:4:\"5000\";s:16:\"fes_guest_status\";s:1:\"0\";s:20:\"fes_guest_name_email\";s:1:\"1\";s:23:\"fes_guest_user_creation\";s:1:\"0\";s:23:\"fes_section_data_fields\";s:1:\"1\";s:28:\"fes_section_countdown_method\";s:1:\"1\";s:23:\"fes_section_event_links\";s:1:\"1\";s:16:\"fes_section_cost\";s:1:\"1\";s:26:\"fes_section_featured_image\";s:1:\"1\";s:22:\"fes_section_categories\";s:1:\"1\";s:18:\"fes_section_labels\";s:1:\"1\";s:32:\"fes_section_shortcode_visibility\";s:1:\"1\";s:23:\"fes_section_event_color\";s:1:\"1\";s:16:\"fes_section_tags\";s:1:\"1\";s:20:\"fes_section_location\";s:1:\"1\";s:21:\"fes_section_organizer\";s:1:\"1\";s:22:\"fes_use_all_organizers\";s:1:\"1\";s:19:\"fes_section_speaker\";s:1:\"0\";s:27:\"fes_section_hourly_schedule\";s:1:\"1\";s:18:\"fes_section_schema\";s:1:\"1\";s:19:\"fes_section_excerpt\";s:1:\"0\";s:8:\"fes_note\";s:1:\"0\";s:19:\"fes_note_visibility\";s:6:\"always\";s:13:\"fes_agreement\";s:1:\"0\";s:21:\"fes_agreement_checked\";s:1:\"0\";s:18:\"fes_agreement_page\";s:0:\"\";s:17:\"fes_required_body\";s:1:\"0\";s:20:\"fes_required_excerpt\";s:1:\"0\";s:17:\"fes_required_cost\";s:1:\"0\";s:23:\"fes_required_event_link\";s:1:\"0\";s:27:\"fes_required_more_info_link\";s:1:\"0\";s:21:\"fes_required_category\";s:1:\"0\";s:18:\"fes_required_label\";s:1:\"0\";s:20:\"userevents_shortcode\";s:3:\"224\";s:20:\"search_bar_ajax_mode\";s:1:\"0\";s:22:\"search_bar_modern_type\";s:1:\"0\";s:19:\"search_bar_category\";s:1:\"0\";s:19:\"search_bar_location\";s:1:\"0\";s:20:\"search_bar_organizer\";s:1:\"0\";s:14:\"search_bar_tag\";s:1:\"0\";s:16:\"search_bar_label\";s:1:\"0\";s:21:\"search_bar_text_field\";s:1:\"0\";}s:6:\"styles\";a:1:{s:3:\"CSS\";s:0:\"\";}s:8:\"gateways\";a:1:{i:1;a:1:{s:6:\"status\";i:1;}}s:13:\"notifications\";a:9:{s:20:\"booking_notification\";a:3:{s:7:\"subject\";s:25:\"Your booking is received.\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:238:\"Hello %%name%%,\r\n\r\n                    Your booking is received. We will check and confirm your booking as soon as possible.\r\n                    Thanks for your patience.\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:18:\"email_verification\";a:3:{s:7:\"subject\";s:27:\"Please verify your booking.\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:205:\"Hi %%name%%,\r\n\r\n                    Please verify your booking by clicking on following link:\r\n\r\n                    %%verification_link%%\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:20:\"booking_confirmation\";a:3:{s:7:\"subject\";s:26:\"Your booking is confirmed.\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:295:\"Hi %%name%%,\r\n\r\n                    Your booking is confirmed. You should be available at %%book_date%% in %%event_location_address%%.\r\n\r\n                    You can contact to event organizer by calling %%event_organizer_tel%%.\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:25:\"cancellation_notification\";a:7:{s:6:\"status\";s:1:\"0\";s:7:\"subject\";s:25:\"Your booking is canceled.\";s:10:\"recipients\";s:0:\"\";s:13:\"send_to_admin\";s:1:\"1\";s:17:\"send_to_organizer\";s:1:\"0\";s:12:\"send_to_user\";s:1:\"0\";s:7:\"content\";s:187:\"Hi %%name%%,\r\n\r\n                    For your information, your booking for %%event_title%% at %%book_date%% is canceled.\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:18:\"admin_notification\";a:3:{s:7:\"subject\";s:26:\"A new booking is received.\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:282:\"Dear Admin,\r\n\r\n                    A new booking is received. Please check and confirm it as soon as possible.\r\n\r\n                    %%admin_link%%\r\n                    \r\n                    %%attendees_full_info%%\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:9:\"new_event\";a:4:{s:6:\"status\";s:1:\"1\";s:7:\"subject\";s:21:\"A new event is added.\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:322:\"Hello,\r\n\r\n                    A new event just added. The event title is %%event_title%% and its status is %%event_status%%.\r\n                    The new event may need to be published. Please use this link for managing your website events: %%admin_link%%\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:21:\"user_event_publishing\";a:4:{s:6:\"status\";s:1:\"1\";s:7:\"subject\";s:25:\"Your event gets published\";s:10:\"recipients\";s:0:\"\";s:7:\"content\";s:224:\"Hello %%name%%,\r\n\r\n                    Your event gets published. You can check it below:\r\n\r\n                    <a href=\"%%event_link%%\">%%event_title%%</a>\r\n\r\n                    Regards,\r\n                    %%blog_name%%\";}s:13:\"event_soldout\";a:6:{s:6:\"status\";s:1:\"0\";s:7:\"subject\";s:22:\"Your event is soldout!\";s:10:\"recipients\";s:0:\"\";s:13:\"send_to_admin\";s:1:\"1\";s:17:\"send_to_organizer\";s:1:\"1\";s:7:\"content\";s:188:\"Hi %%name%%,\r\n\r\n                    For your information, your %%event_title%% event at %%book_date%% is soldout.\r\n        \r\n                    Regards,\r\n                    %%blog_name%%\";}s:17:\"booking_rejection\";a:7:{s:6:\"status\";s:1:\"0\";s:7:\"subject\";s:26:\"Your booking got rejected!\";s:10:\"recipients\";s:0:\"\";s:13:\"send_to_admin\";s:1:\"0\";s:17:\"send_to_organizer\";s:1:\"1\";s:12:\"send_to_user\";s:1:\"1\";s:7:\"content\";s:195:\"Hi %%name%%,\r\n\r\n                    For your information, your booking for %%event_title%% at %%book_date%% is rejected.\r\n        \r\n                    Regards,\r\n                    %%blog_name%%\";}}}', 'yes'),
(12184, 'mec_installed', '1', 'yes'),
(12185, 'mec_version', '6.5.5', 'yes'),
(12190, 'widget_mec_mec_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(12191, 'widget_mec_single_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(12192, 'mec_gfont', '', 'yes'),
(12193, 'mec_dyncss', '', 'yes'),
(12207, 'mec_latest_event_datetime', '20220722105613', 'no'),
(12208, 'mec_saved_message_2_time', '2022-10-27', 'yes'),
(12209, 'mec_custom_msg_2_html', '<link rel = \"stylesheet\" type = \"text/css\" href = \"https://webnus.net/modern-events-calendar/addons-api/mec-extra-content/style2.css\" /><div class=\"mec-custom-msg-2-notification-set-box extra\"><div style=\"margin: 0\" class=\"w-row mec-custom-msg-notification-wrap\"><div class=\"w-col-sm-12\"><div class=\"w-clearfix w-box mec-cmsg-2-notification-box-wrap mec-new-addons-wrap\" style=\"margin-top:0;\"><div class=\"w-box-head\">Announcement<span><i class=\"mec-sl-close\"></i></span></div><div class=\"w-box-content\"><div class=\"mec-addons-notification-box-image\" style=\"width: 240px; margin-right: 10px;\"><img style=\"border-radius: 8px;\" src=\"https://webnus.net/modern-events-calendar/addons-api/mec-extra-content/7x7-campaign-special-min.png\" /></div><div class=\"mec-addons-notification-box-content mec-new-addons\" style=\"width: calc(100% - 270px);\"><div class=\"w-box-content\"><div class=\"csm-message-notice\" style=\"text-align: center; background: #BAF0FC57; border-radius: 6px;letter-spacing: 4.4px; color: #00CAE6; text-transform: uppercase; padding: 10px 5px; font-weight: bold; margin-bottom: 40px;\">Special Offer!</div><p>We are celebrating the last week of a wonderful campaign with you. For this occasion, we are offering a FREE license for MEC Pro and Deep Pro to anyone that buys this bundle, currently at 49% off.The special offer ends on October 31. So hurry up and get yours!<br/><div class=\"mec-addons-key-features\"><ul><li style=\"display: inline-block;width: 40%;\">Webex Integration</li><li style=\"display: inline-block;width: 40%;\">Social Auto Poster</li><li style=\"display: inline-block;width: 40%;\">Elementor FES Builder</li><li style=\"display: inline-block;width: 40%;\">Seat</li><li style=\"display: inline-block;width: 40%;\">Gutenberg Single Builder</li><li style=\"display: inline-block;width: 40%;\">Square Payment</li><li style=\"display: inline-block;width: 40%;\">Liquid-view Layouts</li><li style=\"display: inline-block;width: 40%;\"><strong style=\"color: #FC5649\">MEC & Deep Pro</strong></li></ul></div></p><div style=\"clear:both\"></div><a href=\"https://webnus.net/7x7/?ref=17\" target=\"_blank\">Get the deal</a></div></div></div></div></div></div></div>', 'yes'),
(12210, 'mec_custom_msg_2_display', '2', 'yes'),
(12211, 'mec_custom_msg_2_display_option', '2', 'yes'),
(12212, 'mec_custom_msg_2_close_option', 'close', 'yes'),
(12213, 'mec_saved_message_time', '2022-10-27', 'yes'),
(12214, 'mec_custom_msg_html', '<link rel = \"stylesheet\" type = \"text/css\" href = \"https://webnus.net/modern-events-calendar/addons-api/mec-extra-content/style2.css\" /><div class=\"mec-custom-msg-2-notification-set-box extra\"><div style=\"margin: 0\" class=\"w-row mec-custom-msg-notification-wrap\"><div class=\"w-col-sm-12\"><div class=\"w-clearfix w-box mec-cmsg-2-notification-box-wrap mec-new-addons-wrap\" style=\"margin-top:0;\"><div class=\"w-box-head\">Announcement<span><i class=\"mec-sl-close\"></i></span></div><div class=\"w-box-content\"><div class=\"mec-addons-notification-box-image\" style=\"width: 240px; margin-right: 10px;\"><img src=\"https://webnus.net/modern-events-calendar/addons-api/mec-extra-content/liquid-view-layouts.svg\" /></div><div class=\"mec-addons-notification-box-content mec-new-addons\" style=\"width: calc(100% - 270px);\"><div class=\"w-box-content\"><div class=\"csm-message-notice\" style=\"text-align: center; background: #BAF0FC57; border-radius: 6px;letter-spacing: 4.4px; color: #00CAE6; text-transform: uppercase; padding: 10px 5px; font-weight: bold; margin-bottom: 40px;\">Liquid View Layouts</div><p>As promised, another one of the most-requested addons by you, Liquid View Layouts, is released this week. The all addons are out already. Webex Integration and Social Auto Poster and Elementor FES Builder and Seat and Gutenberg Single Builder and Square Payment and Liquid View Layouts are now available on our website for purchase.<br/></p><div style=\"clear:both\"></div><a href=\"https://webnus.net/modern-events-calendar/addons/liquid-view-layout/?ref=17\" target=\"_blank\">Read More</a></div></div></div></div></div></div></div>', 'yes'),
(12215, 'mec_custom_msg_display', '1', 'yes'),
(12216, 'mec_custom_msg_display_option', '1', 'yes'),
(12217, 'mec_custom_msg_close_option', 'close', 'yes'),
(12375, 'mec_category_children', 'a:0:{}', 'yes'),
(12895, 'mec_get_webnus_news_time', '2022-10-27', 'yes'),
(12896, 'mec_get_webnus_news_html', '', 'yes'),
(16896, 'layout_category_children', 'a:0:{}', 'yes'),
(19779, 'mec_colors', 'a:5:{i:0;s:6:\"fdd700\";i:1;s:6:\"00a0d2\";i:2;s:6:\"e14d43\";i:3;s:6:\"dd823b\";i:4;s:6:\"a3b745\";}', 'yes'),
(20529, 'user_count', '1', 'no'),
(20530, 'db_upgraded', '', 'yes'),
(20664, 'can_compress_scripts', '0', 'no'),
(21833, '_transient_timeout__et_builder_gf_feature_cache', '1666912155', 'no'),
(21834, '_transient__et_builder_gf_feature_cache', '1', 'no'),
(21874, '_transient_timeout_rsssl_certinfo', '1666947209', 'no'),
(21875, '_transient_rsssl_certinfo', 'a:16:{s:4:\"name\";s:22:\"/CN=anfa-ao.opteam.net\";s:7:\"subject\";a:1:{s:2:\"CN\";s:18:\"anfa-ao.opteam.net\";}s:4:\"hash\";s:8:\"47874688\";s:6:\"issuer\";a:3:{s:1:\"C\";s:2:\"US\";s:1:\"O\";s:13:\"Let\'s Encrypt\";s:2:\"CN\";s:2:\"R3\";}s:7:\"version\";i:2;s:12:\"serialNumber\";s:38:\"0x03D21DB5E508C4ED11E4F537183FCCB4665A\";s:15:\"serialNumberHex\";s:36:\"03D21DB5E508C4ED11E4F537183FCCB4665A\";s:9:\"validFrom\";s:13:\"221027083727Z\";s:7:\"validTo\";s:13:\"230125083726Z\";s:16:\"validFrom_time_t\";i:1666859847;s:14:\"validTo_time_t\";i:1674635846;s:15:\"signatureTypeSN\";s:10:\"RSA-SHA256\";s:15:\"signatureTypeLN\";s:23:\"sha256WithRSAEncryption\";s:16:\"signatureTypeNID\";i:668;s:8:\"purposes\";a:9:{i:1;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslclient\";}i:2;a:3:{i:0;b:1;i:1;b:0;i:2;s:9:\"sslserver\";}i:3;a:3:{i:0;b:1;i:1;b:0;i:2;s:11:\"nssslserver\";}i:4;a:3:{i:0;b:0;i:1;b:0;i:2;s:9:\"smimesign\";}i:5;a:3:{i:0;b:0;i:1;b:0;i:2;s:12:\"smimeencrypt\";}i:6;a:3:{i:0;b:0;i:1;b:0;i:2;s:7:\"crlsign\";}i:7;a:3:{i:0;b:1;i:1;b:1;i:2;s:3:\"any\";}i:8;a:3:{i:0;b:1;i:1;b:0;i:2;s:10:\"ocsphelper\";}i:9;a:3:{i:0;b:0;i:1;b:0;i:2;s:13:\"timestampsign\";}}s:10:\"extensions\";a:9:{s:8:\"keyUsage\";s:35:\"Digital Signature, Key Encipherment\";s:16:\"extendedKeyUsage\";s:60:\"TLS Web Server Authentication, TLS Web Client Authentication\";s:16:\"basicConstraints\";s:8:\"CA:FALSE\";s:20:\"subjectKeyIdentifier\";s:59:\"D7:1F:89:58:E2:25:2C:0E:4B:86:AD:F7:01:F9:EA:CD:DA:A1:C6:D2\";s:22:\"authorityKeyIdentifier\";s:66:\"keyid:14:2E:B3:17:B7:58:56:CB:AE:50:09:40:E6:1F:AF:9D:8B:14:C2:C6\n\";s:19:\"authorityInfoAccess\";s:73:\"OCSP - URI:http://r3.o.lencr.org\nCA Issuers - URI:http://r3.i.lencr.org/\n\";s:14:\"subjectAltName\";s:600:\"DNS:acte5.opteam.net, DNS:adherents.lesamisdefrenchlines.fr, DNS:anfa-ao.opteam.net, DNS:anfa.opteam.net, DNS:api.opteam.net, DNS:bouvard.opteam.net, DNS:ccmo.opteam.net, DNS:face.opteam.net, DNS:gastronome.opteam.net, DNS:gestion.opteam.net, DNS:happydisplay.opteam.net, DNS:kadopub.opteam.net, DNS:marcsa.opteam.net, DNS:metiers-logistique.fr, DNS:morgere.opteam.net, DNS:novatice-solutions.opteam.net, DNS:novatice.opteam.net, DNS:olvea.opteam.net, DNS:saintromain.acte5.opteam.net, DNS:sidoresto.opteam.net, DNS:workspace.opteam.net, DNS:www.happydisplay.opteam.net, DNS:www.metiers-logistique.fr\";s:19:\"certificatePolicies\";s:89:\"Policy: 2.23.140.1.2.1\nPolicy: 1.3.6.1.4.1.44947.1.1.1\n  CPS: http://cps.letsencrypt.org\n\";s:15:\"ct_precert_scts\";s:1161:\"Signed Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : B7:3E:FB:24:DF:9C:4D:BA:75:F2:39:C5:BA:58:F4:6C:\n                5D:FC:42:CF:7A:9F:35:C4:9E:1D:09:81:25:ED:B4:99\n    Timestamp : Oct 27 09:37:28.065 2022 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:45:02:21:00:CA:49:49:88:DF:23:81:B0:6A:A8:9B:\n                0B:F9:B2:30:20:7C:54:E0:30:AF:1C:A5:32:E9:34:01:\n                52:D3:DF:9B:52:02:20:39:CF:69:5E:68:D5:C5:41:DC:\n                16:96:FB:54:67:ED:32:94:61:66:27:26:3A:63:17:70:\n                79:0D:1B:87:8E:61:11\nSigned Certificate Timestamp:\n    Version   : v1 (0x0)\n    Log ID    : 7A:32:8C:54:D8:B7:2D:B6:20:EA:38:E0:52:1E:E9:84:\n                16:70:32:13:85:4D:3B:D2:2B:C1:3A:57:A3:52:EB:52\n    Timestamp : Oct 27 09:37:28.589 2022 GMT\n    Extensions: none\n    Signature : ecdsa-with-SHA256\n                30:45:02:20:73:3F:8A:DC:B9:B8:39:93:25:F2:58:5F:\n                ED:60:77:08:95:00:39:23:53:0C:D4:52:F7:53:A6:D2:\n                BE:17:0D:D5:02:21:00:B3:EB:BB:D9:9C:ED:BB:B2:C7:\n                D3:6A:F5:4C:3E:10:2E:6E:11:5B:2A:CC:C3:1F:C1:9D:\n                5F:E4:21:77:95:BE:AC\";}}', 'no'),
(21942, '_site_transient_update_core', 'O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.0.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1666863304;s:15:\"version_checked\";s:5:\"6.0.3\";s:12:\"translations\";a:0:{}}', 'no'),
(21951, '_site_transient_update_plugins', 'O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1666876915;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:5:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"6.0.3\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.0.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-256x256.png?rev=1082746\";s:2:\"1x\";s:75:\"https://ps.w.org/advanced-custom-fields/assets/icon-128x128.png?rev=1082746\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=1729099\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=1729102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:18:\"live-news/init.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/live-news-lite\";s:4:\"slug\";s:14:\"live-news-lite\";s:6:\"plugin\";s:18:\"live-news/init.php\";s:11:\"new_version\";s:4:\"1.05\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/live-news-lite/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/live-news-lite.1.05.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/live-news-lite/assets/icon-256x256.png?rev=2527149\";s:2:\"1x\";s:59:\"https://ps.w.org/live-news-lite/assets/icon.svg?rev=2527149\";s:3:\"svg\";s:59:\"https://ps.w.org/live-news-lite/assets/icon.svg?rev=2527149\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/live-news-lite/assets/banner-1544x500.png?rev=2527149\";s:2:\"1x\";s:69:\"https://ps.w.org/live-news-lite/assets/banner-772x250.png?rev=2527149\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"5.3.5\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.5.3.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=1782452\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=2594863\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=2594863\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:21:\"safe-svg/safe-svg.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/safe-svg\";s:4:\"slug\";s:8:\"safe-svg\";s:6:\"plugin\";s:21:\"safe-svg/safe-svg.php\";s:11:\"new_version\";s:5:\"2.0.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/safe-svg/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/safe-svg.2.0.3.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:61:\"https://ps.w.org/safe-svg/assets/icon-256x256.png?rev=2683939\";s:2:\"1x\";s:53:\"https://ps.w.org/safe-svg/assets/icon.svg?rev=2779013\";s:3:\"svg\";s:53:\"https://ps.w.org/safe-svg/assets/icon.svg?rev=2779013\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/safe-svg/assets/banner-1544x500.png?rev=2683939\";s:2:\"1x\";s:63:\"https://ps.w.org/safe-svg/assets/banner-772x250.png?rev=2683939\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:33:\"smart-slider-3/smart-slider-3.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/smart-slider-3\";s:4:\"slug\";s:14:\"smart-slider-3\";s:6:\"plugin\";s:33:\"smart-slider-3/smart-slider-3.php\";s:11:\"new_version\";s:8:\"3.5.1.11\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/smart-slider-3/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/smart-slider-3.3.5.1.11.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:67:\"https://ps.w.org/smart-slider-3/assets/icon-256x256.png?rev=2307688\";s:2:\"1x\";s:59:\"https://ps.w.org/smart-slider-3/assets/icon.svg?rev=2307688\";s:3:\"svg\";s:59:\"https://ps.w.org/smart-slider-3/assets/icon.svg?rev=2307688\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/smart-slider-3/assets/banner-1544x500.png?rev=2632650\";s:2:\"1x\";s:69:\"https://ps.w.org/smart-slider-3/assets/banner-772x250.png?rev=2632650\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}}}', 'no'),
(21952, '_site_transient_et_update_all_plugins', 'O:8:\"stdClass\":3:{s:7:\"checked\";a:8:{s:30:\"advanced-custom-fields/acf.php\";s:5:\"6.0.3\";s:18:\"live-news/init.php\";s:4:\"2.14\";s:59:\"modern-events-calendar-lite/modern-events-calendar-lite.php\";s:5:\"6.5.5\";s:32:\"opteam-monitoring/monitoring.php\";s:3:\"1.0\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:5:\"5.3.5\";s:21:\"safe-svg/safe-svg.php\";s:5:\"2.0.3\";s:33:\"smart-slider-3/smart-slider-3.php\";s:8:\"3.5.1.11\";s:47:\"wp-admin-menu-manager/wp-admin-menu-manager.php\";s:6:\"3.0.12\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1666876915;}', 'no'),
(21959, '_site_transient_update_themes', 'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1666860784;s:7:\"checked\";a:2:{s:10:\"Divi-child\";s:3:\"1.1\";s:4:\"Divi\";s:6:\"4.18.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:4:\"Divi\";a:6:{s:5:\"theme\";s:4:\"Divi\";s:11:\"new_version\";s:4:\"4.18\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:140:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=a6333bc0033c64fc91c1ac37d66f312552d95f08&username=Opteam\";s:8:\"requires\";s:0:\"\";s:12:\"requires_php\";s:0:\"\";}}s:12:\"translations\";a:0:{}}', 'no'),
(21960, '_site_transient_et_update_themes', 'O:8:\"stdClass\":4:{s:7:\"checked\";a:2:{s:10:\"Divi-child\";s:3:\"1.1\";s:4:\"Divi\";s:6:\"4.18.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:4:\"Divi\";a:6:{s:5:\"theme\";s:4:\"Divi\";s:11:\"new_version\";s:4:\"4.18\";s:3:\"url\";s:52:\"https://www.elegantthemes.com/api/changelog/divi.txt\";s:7:\"package\";s:140:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi&api_key=a6333bc0033c64fc91c1ac37d66f312552d95f08&username=Opteam\";s:8:\"requires\";s:0:\"\";s:12:\"requires_php\";s:0:\"\";}}s:12:\"last_checked\";i:1666860784;}', 'no'),
(21963, '_transient_timeout_et_core_path', '1666949926', 'no'),
(21964, '_transient_et_core_path', '/home/bloxjwu/www/happydisplay/wp-content/themes/Divi/core', 'no'),
(21965, '_transient_timeout_et_core_version', '1666949926', 'no'),
(21966, '_transient_et_core_version', '4.18.0', 'no'),
(21972, 'rsssl_meet_6_dismissed', '1', 'yes'),
(21973, '_transient_timeout_rsssl_can_use_curl_headers_check', '1667465615', 'no'),
(21974, '_transient_rsssl_can_use_curl_headers_check', 'no', 'no'),
(21979, '_transient_timeout_rsssl_remaining_task_count', '1666947220', 'no'),
(21980, '_transient_rsssl_remaining_task_count', '3', 'no'),
(21985, '_transient_timeout_rsssl_plusone_count', '1667465622', 'no'),
(21986, '_transient_rsssl_plusone_count', '0', 'no'),
(22008, '_transient_timeout_rsssl_admin_notices', '1666963316', 'no'),
(22009, '_transient_rsssl_admin_notices', 'a:0:{}', 'no'),
(22021, '_site_transient_timeout_theme_roots', '1666865096', 'no'),
(22022, '_site_transient_theme_roots', 'a:2:{s:10:\"Divi-child\";s:7:\"/themes\";s:4:\"Divi\";s:7:\"/themes\";}', 'no'),
(22023, '_site_transient_timeout_php_check_96314025ffed7f9d1b2dac177cea1337', '1667468096', 'no'),
(22024, '_site_transient_php_check_96314025ffed7f9d1b2dac177cea1337', 'a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}', 'no'),
(22041, '_et_builder_da_feature_cache', 'a:2:{i:0;s:39:\"{\"gph\":-1,\"divi\":\"4.18.0\",\"wp\":\"6.0.3\"}\";i:1;a:1:{s:0:\"\";a:1:{s:29:\"_et_dynamic_cached_attributes\";a:0:{}}}}', 'yes'),
(22064, '_site_transient_timeout_available_translations', '1666886688', 'no');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(22065, '_site_transient_available_translations', 'a:129:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.3/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-05-30 20:47:16\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-09-08 17:57:56\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.22/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 19:41:58\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-10-31 08:48:37\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-09 10:47:25\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 05:39:59\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 07:14:25\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 08:45:13\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-12 09:36:03\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-03-17 12:58:14\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-05-24 08:57:04\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.0.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-05-24 09:00:33\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 16:35:32\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 11:06:04\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.0.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.3/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 16:52:15\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-20 10:54:36\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-12 12:01:12\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-25 06:38:18\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-04-01 22:35:34\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2021-12-24 12:36:39\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 20:39:44\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 12:41:12\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-11 00:03:12\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-06 15:13:59\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-01 00:22:12\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-05-17 18:49:06\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-04 20:53:18\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-06-14 16:02:22\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.17/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-22 14:08:10\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-07 20:37:41\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-08-12 08:38:59\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-02 17:59:27\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-13 06:47:49\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-07 13:34:46\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 17:34:38\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-19 14:38:47\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-13 18:56:33\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-22 13:54:46\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2018-01-29 17:32:35\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 11:51:59\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-09-14 12:33:48\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.29\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.29/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-10 09:13:56\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-11-06 12:34:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.12/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-21 08:38:14\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-18 19:40:10\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.3/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-11 07:57:56\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-09 01:29:51\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-27 10:17:55\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-23 01:52:51\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-24 08:01:09\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-29 14:49:24\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.3/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2018-07-10 11:35:44\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.17\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.17/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-30 17:57:15\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-25 12:03:54\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-12-07 16:32:30\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.6/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-23 12:35:40\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-20 19:18:29\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2019-11-22 15:32:08\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.9.22/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.11\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.11/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 11:20:18\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 16:02:27\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-06-02 21:03:02\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.0.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 20:37:33\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-27 11:42:24\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.21/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-13 09:46:04\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.30\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.30/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-01 12:16:29\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-09 12:26:21\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.0.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 14:11:50\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 14:41:40\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 15:14:15\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 14:03:37\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.12/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-25 11:10:49\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-10 16:01:09\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-05 12:27:18\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-16 11:26:37\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2021-08-01 21:21:06\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8.6/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-17 21:05:38\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:6:\"5.3.14\";s:7:\"updated\";s:19:\"2019-10-13 15:35:35\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.3.14/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.34\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.34/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"5.8.6\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/5.8.6/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.21\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.21/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-20 11:51:03\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.9.22\";s:7:\"updated\";s:19:\"2021-07-03 18:41:33\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.22/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-09-11 15:51:48\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.12\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.12/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-24 07:53:05\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-10-18 06:25:45\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-08-15 08:22:28\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.0.3\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.3/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}', 'no');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(22075, '_site_transient_timeout_browser_acff52a1652901ae7e446fb41b9189b7', '1667480760', 'no'),
(22076, '_site_transient_browser_acff52a1652901ae7e446fb41b9189b7', 'a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"106.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}', 'no'),
(22077, '_site_transient_timeout_community-events-0cfd79ddf15a617dd9c639fb97208614', '1666919165', 'no'),
(22078, '_site_transient_community-events-0cfd79ddf15a617dd9c639fb97208614', 'a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:18:\"2a01:e0a:e6:6f40::\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:13:\"WordCamp Lyon\";s:3:\"url\";s:31:\"https://lyon.wordcamp.org/2022/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2022-10-28 08:00:00\";s:8:\"end_date\";s:19:\"2022-10-28 08:00:00\";s:20:\"start_unix_timestamp\";i:1666936800;s:18:\"end_unix_timestamp\";i:1666936800;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Lyon, France\";s:7:\"country\";s:2:\"FR\";s:8:\"latitude\";d:45.7499567;s:9:\"longitude\";d:4.8221146;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:15:\"WordCamp Italia\";s:3:\"url\";s:33:\"https://italia.wordcamp.org/2022/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2022-11-11 09:00:00\";s:8:\"end_date\";s:19:\"2022-11-12 00:00:00\";s:20:\"start_unix_timestamp\";i:1668153600;s:18:\"end_unix_timestamp\";i:1668207600;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Milan, Italy\";s:7:\"country\";s:2:\"IT\";s:8:\"latitude\";d:45.460342;s:9:\"longitude\";d:9.1941298;}}}}', 'no'),
(22079, '_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198', '1666919166', 'no');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(22080, '_transient_feed_0d2db5fea5a8633b56992c916819b198', 'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Oct 2022 22:02:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.2-alpha-54699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Blog | WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:77:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Oct 2022 16:20:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2509\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"Tour d\'horizon des changements techniques apportés par WordPress 6.1, la prochaine version majeure du CMS.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:66:\"https://make.wordpress.org/design/files/2022/09/tt3_variations.mp4\";s:6:\"length\";s:6:\"996018\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:45434:\"\n<p>La version&nbsp;<em>Release Candidate</em>&nbsp;de&nbsp;<strong>WordPress&nbsp;6.1</strong>&nbsp;est sortie mardi 11 octobre. Il est donc temps de parcourir les différents changements techniques qu’apportera cette prochaine version majeure de notre CMS.</p>\n\n\n\n<p><strong>La sortie finale de cette nouvelle version est planifiée pour le 1<sup>er</sup>&nbsp;novembre 2022.</strong></p>\n\n\n\n<figure class=\"wp-block-image\"><img decoding=\"async\" width=\"2328\" height=\"1158\" src=\"https://fr.wordpress.org/files/2022/10/wp61-guide.png\" alt=\"WordPress 6.1 : Guide des changements techniques\" class=\"wp-image-2472\" srcset=\"https://fr.wordpress.org/files/2022/10/wp61-guide.png 2328w, https://fr.wordpress.org/files/2022/10/wp61-guide-300x149.png 300w, https://fr.wordpress.org/files/2022/10/wp61-guide-1024x509.png 1024w, https://fr.wordpress.org/files/2022/10/wp61-guide-768x382.png 768w, https://fr.wordpress.org/files/2022/10/wp61-guide-1536x764.png 1536w, https://fr.wordpress.org/files/2022/10/wp61-guide-2048x1019.png 2048w\" sizes=\"(max-width: 2328px) 100vw, 2328px\" /></figure>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-1/\">L’équipe de direction de WP 6.1</a>&nbsp;et plusieurs centaines de contributeurs et contributrices ont travaillé sur plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">120 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">241 correctifs</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.1&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">42 autres tâches variées</a>, ce qui représente plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">400 tickets sur Trac</a>.</p>\n\n\n\n<p>À cela, il faut ajouter plus de&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56467\">50 pull requests</a>&nbsp;ayant permis de fusionner les différentes versions de Gutenberg dans le cœur du CMS. Du côté du projet Gutenberg il y a eu en tout 1684 pull requests apportant 425 nouvelles fonctionnalités et améliorations et 428&nbsp;correctifs de bugs, le reste concernant des tâches courantes de revue de qualité du code, de documentation ou d&rsquo;amélioration des outils de déploiement.</p>\n\n\n\n<p class=\"is-style-serif has-text-color\" style=\"color:#d95e43;font-size:18px\">En route pour un petit tour d’horizon des<br>nouveautés techniques de WordPress&nbsp;6.1&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f680.png\" alt=\"🚀\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais.</p>\n\n\n\n<p>L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-text-color has-background\" style=\"color:#ac270c;background-color:#f4e3da\">À noter&nbsp;: certaines modifications listées ici vont nécessiter des actions de la part des auteurs et autrices de thèmes et d’extensions, qui devront adapter ou modifier leur code. Si vous êtes concerné·e, veuillez lire les notes de développement listées dans cet article consciencieusement afin de vous assurer que votre code fonctionnera avec WordPress&nbsp;6.1 lorsque cette version sortira le 1<sup>er</sup>&nbsp;novembre 2022.</p>\n\n\n\n<h2>Performances</h2>\n\n\n\n<p>Avec&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=version&amp;col=focuses&amp;col=keywords&amp;order=priority\">45 tickets sur Trac</a>&nbsp;pour WP&nbsp;6.1, l’amélioration des performances et des temps de chargement de WordPress a été l’un des enjeux principaux de cette version. Les changements les plus significatifs portent sur les requêtes&nbsp;<code>WP_Query</code>&nbsp;et sur l’API REST, deux points qui impactent grandement les temps de chargement de votre site. L’un des changements les plus attendus concernait notamment la mise en cache des requêtes&nbsp;<code>WP_Query</code>, et c’est maintenant une réalité avec WP&nbsp;6.1.</p>\n\n\n\n<p>De nouveaux points de contrôle ont aussi été ajoutés dans l’écran de&nbsp;<em>Santé du site</em>, qui vous indiquera maintenant si la mise en cache des pages et le cache persistant fonctionnent correctement sur votre site.</p>\n\n\n\n<p>Plusieurs améliorations conséquentes sur l’API de mise en cache de WordPress ont également été mises en œuvre, et l’ordre d’exécution général des crochets d’action a été optimisé pour retarder le moins possible l’affichage des pages.</p>\n\n\n\n<p>L’enregistrement de blocs personnalisés pour l’éditeur à l’aide de fichiers&nbsp;<code>block.json</code>&nbsp;a aussi été rendu bien plus performant.</p>\n\n\n\n<p>Et ce n’est qu’une petite partie des améliorations de performances de WP 6.1. Pour en découvrir plus, voici un guide spécifique sur les performances dans cette nouvelle version de WP&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qnD9kaPwLM\"><a href=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/\">Performance Field Guide for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Performance Field Guide for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/performance-field-guide-for-wordpress-6-1/embed/#?secret=S9AxfZHdKy#?secret=qnD9kaPwLM\" data-secret=\"qnD9kaPwLM\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Accessibilité</h2>\n\n\n\n<p>Il s’agit du second focus principal de WordPress 6.1, avec&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.1&amp;group=component&amp;col=id&amp;col=summary&amp;col=focuses&amp;col=version&amp;col=keywords&amp;order=priority\">28 tickets sur Trac</a>, concernant 13 des principaux composants du CMS. De nombreuses améliorations ont été faites sur l’éditeur de blocs et sur la fonctionnalité d’édition complète du site, quelques éléments encore non conformes sur les différents écrans d’administration ont été corrigés, et beaucoup d’autres améliorations ont été faites pour faciliter l’utilisation de WordPress par toutes et tous.</p>\n\n\n\n<p>Une attention particulière a également été portée sur la gestion des champs requis sur les différents formulaires de l’interface d’administration&nbsp;: pour faciliter leur maintenance, une petite API a été créée afin de gérer de façon centralisée leur affichage. Celle-ci est publique et peut donc être utilisée par les personnes réalisant des développements sur mesure.</p>\n\n\n\n<p>Notons également qu’avec WordPress 6.1, les deux thèmes natifs&nbsp;<a href=\"https://core.trac.wordpress.org/changeset/54467\">Twenty Twenty-Three</a>&nbsp;(nous reparlerons de celui-là dans un article dédié&nbsp;!) et&nbsp;<a href=\"https://github.com/WordPress/wordpress-develop/pull/2324/files\">Twenty Twenty-Two</a>&nbsp;font leur entrée parmi les premiers&nbsp;<em>Block Themes</em>&nbsp;(ces thèmes entièrement modifiables avec l’éditeur de blocs) ayant obtenu le libellé&nbsp;<code>accessibility-ready</code>&nbsp;sur le répertoire de thèmes WordPress.org.</p>\n\n\n\n<p>Pour en savoir plus sur toutes ces améliorations concernant l’accessibilité de WordPress, consultez le guide spécifique proposé par l’équipe&nbsp;<em>Accessibility</em>&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"gOxSBctZIG\"><a href=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/\">WordPress 6.1 Accessibility Improvements</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 6.1 Accessibility Improvements&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/wordpress-6-1-accessibility-improvements/embed/#?secret=Rp2Ep8E3XI#?secret=gOxSBctZIG\" data-secret=\"gOxSBctZIG\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>L’éditeur de blocs</h2>\n\n\n\n<p>C’est évidemment encore et toujours un des axes concentrant le plus d’évolutions d’une version à une autre&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>WordPress 6.1 embarque les versions&nbsp;<a href=\"https://make.wordpress.org/core/2022/04/28/whats-new-in-gutenberg-13-1-27-april/\">13.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/12/whats-new-in-gutenberg-13-2-may-11/\">13.2</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/26/whats-new-in-gutenberg-13-3-0-may-25/\">13.3</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/06/10/whats-new-in-gutenberg-13-4-8-june/\">13.4</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/06/22/whats-new-in-gutenberg-13-5-22-june/\">13.5</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/07/whats-new-in-gutenberg-13-6-6-july/\">13.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/07/20/whats-new-in-gutenberg-13-7-20-july/\">13.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/04/whats-new-in-gutenberg-13-8-3-august/\">13.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/08/17/whats-new-in-gutenberg-13-9-17-august/\">13.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/01/whats-new-in-gutenberg-14-0-31-august/\">14.0</a>, et&nbsp;<a href=\"https://make.wordpress.org/core/2022/09/16/whats-new-in-gutenberg-14-1-15-september/\">14.1</a>&nbsp;du projet Gutenberg.</p>\n\n\n\n<p>Parmi les nombreux changements de ces 10 versions de l’extension Gutenberg, un gros effort a été fait pour rendre les blocs et autres fonctionnalités de l’éditeur de plus en plus disponibles pour les thèmes «&nbsp;classiques&nbsp;», c’est à dire les thèmes qui ne prennent pas encore en charge l’édition complète du site à l’aide de blocs, une fonctionnalité introduite dans le CMS en 2022 avec WordPress&nbsp;5.9.</p>\n\n\n\n<p>L’objectif est de faciliter le travail des développeuses et des développeurs pour effectuer une transition de leurs thèmes «&nbsp;classiques&nbsp;» vers le principe du thème basé sur des blocs, que celui-ci soit entièrement ou partiellement modifiable dans l’éditeur. Nous espérons que cela poussera encore plus les personnes développant des thèmes WordPress à exploiter au maximum les fonctionnalités de l’éditeur.</p>\n\n\n\n<p>Par ailleurs, de nombreuses fonctionnalités utiles au quotidien ont été ajoutées dans cette version&nbsp;: filtrage des données du&nbsp;<code>theme.json</code>, nouveau système de gestion des préférences dans l’éditeur, possibilité de modifier et étendre le bloc «&nbsp;Boucle de requête&nbsp;», et bien plus encore.</p>\n\n\n\n<p>Vous trouverez ci-dessous les différentes notes de développement concernant l’éditeur de WordPress&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dBrmxcR9rG\"><a href=\"https://make.wordpress.org/core/2022/10/12/block-api-changes-in-wordpress-6-1/\">Block API changes in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block API changes in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/12/block-api-changes-in-wordpress-6-1/embed/#?secret=yffoVF22CZ#?secret=dBrmxcR9rG\" data-secret=\"dBrmxcR9rG\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Fjn1oGyqWW\"><a href=\"https://make.wordpress.org/core/2022/10/07/create-block-scaffolding-tool-updates/\">Create-block scaffolding tool updates</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Create-block scaffolding tool updates&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/07/create-block-scaffolding-tool-updates/embed/#?secret=VtlSw1eM1t#?secret=Fjn1oGyqWW\" data-secret=\"Fjn1oGyqWW\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zyyLlU97ov\"><a href=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/\">Extending the Query Loop block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Extending the Query Loop block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/extending-the-query-loop-block/embed/#?secret=LIiTYZPDuG#?secret=zyyLlU97ov\" data-secret=\"zyyLlU97ov\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zexxXNky1n\"><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Block-based &#8220;template parts&#8221; in traditional themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block-based &#8220;template parts&#8221; in traditional themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/embed/#?secret=jGN0kLdfpO#?secret=zexxXNky1n\" data-secret=\"zexxXNky1n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TQjPI7jtgJ\"><a href=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/\">Block styles generation (Style Engine)</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block styles generation (Style Engine)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/block-styles-generation-style-engine/embed/#?secret=hpcPvjxOC0#?secret=TQjPI7jtgJ\" data-secret=\"TQjPI7jtgJ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3JmOVCNc5n\"><a href=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/\">Changes to block editor preferences in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Changes to block editor preferences in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/changes-to-block-editor-preferences-in-wordpress-6-1/embed/#?secret=71OVXmY0eo#?secret=3JmOVCNc5n\" data-secret=\"3JmOVCNc5n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vifHRi3Twr\"><a href=\"https://make.wordpress.org/core/2022/10/10/editor-components-updates-for-wordpress-6-1/\">Editor Components updates in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Editor Components updates in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/editor-components-updates-for-wordpress-6-1/embed/#?secret=qPmCZKf0U8#?secret=vifHRi3Twr\" data-secret=\"vifHRi3Twr\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h3aDnp2W04\"><a href=\"https://make.wordpress.org/core/2022/10/11/simplified-data-access-with-new-react-hooks-in-wordpress-6-1/\">Simplified data access with new React hooks in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Simplified data access with new React hooks in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/simplified-data-access-with-new-react-hooks-in-wordpress-6-1/embed/#?secret=0IPHFMNGSf#?secret=h3aDnp2W04\" data-secret=\"h3aDnp2W04\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"bRnyzICqAu\"><a href=\"https://make.wordpress.org/core/2022/10/10/miscellaneous-editor-changes-for-wordpress-6-1/\">Miscellaneous editor changes for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous editor changes for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/miscellaneous-editor-changes-for-wordpress-6-1/embed/#?secret=5zY0ol61lV#?secret=bRnyzICqAu\" data-secret=\"bRnyzICqAu\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Par ailleurs, la note de développement suivante fournit un état des lieux très pratique des blocs natifs et de leurs différentes possibilités de formatage&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wq78upcC0e\"><a href=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/\">Roster of design tools per block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Roster of design tools per block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/roster-of-design-tools-per-block/embed/#?secret=0coW6ckdnA#?secret=wq78upcC0e\" data-secret=\"wq78upcC0e\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Développement de thèmes WordPress</h2>\n\n\n\n<p>Les notes de développement suivantes présentent des changements qui concernent tout particulièrement les développeuses et développeurs de thèmes.</p>\n\n\n\n<p>Tout d’abord, l’entête&nbsp;<code>Update URI</code>&nbsp;qui doit être utilisé si vous développez des thèmes sur mesure n’ayant pas vocation à être déployés sur le répertoire WordPress.org. Cela évitera que votre site propose une mise à jour et écrase votre thème dans le cas où un thème du répertoire officiel porterait le même identifiant (slug) que le vôtre&nbsp;!</p>\n\n\n\n<p>Ensuite nous avons plusieurs notes de développement concernant les interactions entre les thèmes et l’éditeur de site. Et notamment la possibilité de créer des éléments de modèles basés sur des blocs au sein d’un thème classique, c’est à dire d’un thème ne proposant au départ pas de compatibilité avec l’édition complète de site (<em>full site editing</em>).</p>\n\n\n\n<p>Enfin, on notera l&rsquo;arrivée de la gestion fluide des polices typographiques, qui permettent de définir la taille de typo de façon à ce qu&rsquo;elle s&rsquo;adapte dynamiquement à la largeur de l&rsquo;écran.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kTK0wJfy87\"><a href=\"https://make.wordpress.org/core/2022/10/06/introducing-update-uri-theme-header-in-wordpress-6-1/\">Introducing “Update URI” theme header in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing “Update URI” theme header in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/06/introducing-update-uri-theme-header-in-wordpress-6-1/embed/#?secret=qitshxDkLe#?secret=kTK0wJfy87\" data-secret=\"kTK0wJfy87\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zexxXNky1n\"><a href=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/\">Block-based &#8220;template parts&#8221; in traditional themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block-based &#8220;template parts&#8221; in traditional themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/04/block-based-template-parts-in-traditional-themes/embed/#?secret=jGN0kLdfpO#?secret=zexxXNky1n\" data-secret=\"zexxXNky1n\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WzczIz4yg6\"><a href=\"https://make.wordpress.org/core/2022/10/03/fluid-font-sizes-in-wordpress-6-1/\">Fluid font sizes in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Fluid font sizes in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/03/fluid-font-sizes-in-wordpress-6-1/embed/#?secret=SLMWQp7RNK#?secret=WzczIz4yg6\" data-secret=\"WzczIz4yg6\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"z0vYQmLM5z\"><a href=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/\">Navigation Block Fallback Behavior in WP 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Navigation Block Fallback Behavior in WP 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/09/27/navigation-block-fallback-behavior-in-wp-6-1-dev-note/embed/#?secret=tx4090NC9A#?secret=z0vYQmLM5z\" data-secret=\"z0vYQmLM5z\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"GWWtPp4NS7\"><a href=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/\">Styling elements in block themes</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Styling elements in block themes&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/styling-elements-in-block-themes/embed/#?secret=DNb1wiOY5K#?secret=GWWtPp4NS7\" data-secret=\"GWWtPp4NS7\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"iGV1yvHNkk\"><a href=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/\">Updated editor layout support in 6.1 after refactor</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Updated editor layout support in 6.1 after refactor&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/updated-editor-layout-support-in-6-1-after-refactor/embed/#?secret=ldKH3CQjOT#?secret=iGV1yvHNkk\" data-secret=\"iGV1yvHNkk\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"90Yib2AXch\"><a href=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/\">Filters for theme.json data</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Filters for theme.json data&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/10/filters-for-theme-json-data/embed/#?secret=5Qfg0Q38Dk#?secret=90Yib2AXch\" data-secret=\"90Yib2AXch\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"PrZ6RePCEE\"><a href=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/\">Introduction of presets across padding, margin and block gap</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introduction of presets across padding, margin and block gap&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/07/introduction-of-presets-across-padding-margin-and-block-gap/embed/#?secret=9fmr75XcT7#?secret=PrZ6RePCEE\" data-secret=\"PrZ6RePCEE\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Twenty Twenty-Three, le nouveau thème natif</h2>\n\n\n\n<p><em>Twenty Twenty-Three</em>&nbsp;est le nouveau thème par défaut de WordPress.</p>\n\n\n\n<p>Comme son prédécesseur, il exploite à 100&nbsp;% les fonctionnalités de l’éditeur de site. Il va même beaucoup plus loin en intégrant nativement 10 variations de styles permettant de modifier complètement l’interface depuis l’administration.</p>\n\n\n\n<p>Ces 10 variations de styles ont été sélectionnées à l’aide d’un appel à contribution. L’objectif est de montrer par l’exemple comment se comportent les nouvelles fonctionnalités de l’éditeur de site, et notamment comment exploiter le fichier <code>theme.json</code>.</p>\n\n\n\n<p>Vous trouverez ci-dessous une vidéo balayant les 10 variations de styles de ce thème.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/design/files/2022/09/tt3_variations.mp4\"></video></figure>\n\n\n\n<p>Comme d’habitude, ce thème natif a été développé sur GitHub (où vous retrouverez l’historique du projet) puis intégré au cœur de WordPress pendant la phase de développement de la version 6.1.</p>\n\n\n\n<h2>Autres améliorations</h2>\n\n\n\n<h3>API REST</h3>\n\n\n\n<p>L’API REST a vu l’arrivée d’améliorations concernant le point de terminaison&nbsp;<code>/search</code>&nbsp;ainsi que de l’affichage des réponses JSON pouvant être controlées via le filtre&nbsp;<code>rest_json_encode_options</code>. Toutes les améliorations de l’API sont décrites dans la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wqhN6S07e4\"><a href=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-rest-api-improvements-in-wordpress-6-1/\">Miscellaneous REST API improvements in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous REST API improvements in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-rest-api-improvements-in-wordpress-6-1/embed/#?secret=99O3BHkhq9#?secret=wqhN6S07e4\" data-secret=\"wqhN6S07e4\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3>Page de connexion</h3>\n\n\n\n<p>Une nouvelle fonction attendue depuis plus de 10 ans a fait son entrée dans la boîte à outils des développeuses et développeurs&nbsp;:&nbsp;<code>is_login()</code>&nbsp;permet de déterminer si l’on se trouve sur la page de connexion ou non.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"T8g55XKRps\"><a href=\"https://make.wordpress.org/core/2022/09/11/new-is_login-function-for-determining-if-a-page-is-the-login-screen/\">New is_login() function for determining if a page is the login screen</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New is_login() function for determining if a page is the login screen&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/09/11/new-is_login-function-for-determining-if-a-page-is-the-login-screen/embed/#?secret=JQ3aBVlXl1#?secret=T8g55XKRps\" data-secret=\"T8g55XKRps\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3>Tableaux de listes de l’admin</h3>\n\n\n\n<p>Une nouvelle méthode fait son apparition, afin de pouvoir interagir et filtrer plus facilement les liens de visualisation présents dans ces tableaux.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"at2b0OL7mT\"><a href=\"https://make.wordpress.org/core/2022/10/09/introducing-wp_list_tableget_views_links-in-wordpress-6-1/\">Introducing WP_List_Table::get_views_links() in WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing WP_List_Table::get_views_links() in WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/09/introducing-wp_list_tableget_views_links-in-wordpress-6-1/embed/#?secret=iitc3BtHzA#?secret=at2b0OL7mT\" data-secret=\"at2b0OL7mT\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3>Médias</h3>\n\n\n\n<p>Avec la version 5.8, nous avons accueilli <a href=\"https://make.wordpress.org/core/2021/06/07/wordpress-5-8-adds-webp-support/\">la prise en charge du format WebP</a> et nous prévoyions initialement d’intégrer la génération automatique et par défaut d’images dans ce format dans WordPress 6.1, mais le <em>commit</em> associé a finalement été <a href=\"https://core.trac.wordpress.org/ticket/54226\">annulé</a> avec la <a href=\"https://make.wordpress.org/core/2022/09/11/webp-in-core-for-6-1/\">recommandation</a> de plutôt intégrer cette fonctionnalité dans une <a href=\"https://make.wordpress.org/core/2022/09/11/canonical-plugins-revisited/\">extension canonique</a>.</p>\n\n\n\n<p>En revanche, la propriété&nbsp;<code>muted</code>&nbsp;est maintenant disponible pour les vidéos insérées dans l’éditeur, ce qui permet de rendre silencieuse les vidéos ayant vocation à être lancées automatiquement (propriété&nbsp;<code>autoplay</code>). Ceci est obligatoire pour les vidéos automatiques.</p>\n\n\n\n<h3>Autres changements techniques</h3>\n\n\n\n<p>WordPress 6.1 introduit de nombreuses nouvelles fonctions et crochets d’action ou filtres. Ces changements sont détaillés dans la note de développement suivante&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eKrGcN1LRi\"><a href=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-core-changes-for-wordpress-6-1/\">Miscellaneous Core changes for WordPress 6.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Core changes for WordPress 6.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/10/11/miscellaneous-core-changes-for-wordpress-6-1/embed/#?secret=wygMCG7gVe#?secret=eKrGcN1LRi\" data-secret=\"eKrGcN1LRi\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>En plus de tous ces changements, on notera les évolutions suivantes, triées par composant du cœur WP&nbsp;:</p>\n\n\n\n<ul>\n<li><strong>Mots de passe d’applications :</strong>&nbsp;les super&nbsp;admins peuvent mettre en place un mot de passe d’application sur un site auquel ils n’ont pas été rattachés (<a href=\"https://core.trac.wordpress.org/ticket/53224\">#53224</a>)</li>\n\n\n\n<li><strong>Sauvegardes automatiques :</strong>&nbsp;les utilisateur·ices ayant un blocage via la fonctionnalité&nbsp;<code>post lock</code>&nbsp;pouvaient auparavant tricher en surchargeant les modifications via les sauvegardes automatiques&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/55659\">#55659</a>)</li>\n\n\n\n<li><strong>API de gestion du cache&nbsp;:&nbsp;</strong>ajout des fonctions&nbsp;<code>wp_cache_flush_group</code>&nbsp;et&nbsp;<code>wp_cache_supports</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/4476\">#4476</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56605\">#56605</a>)</li>\n\n\n\n<li><strong>Charset&nbsp;:</strong>&nbsp;ajout de l’échappement des caractères unicode NFD dans&nbsp;<code>remove_accents()</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/35951\">#35951</a>)</li>\n\n\n\n<li><strong>API Cron :</strong>&nbsp;ajout de la journalisation des erreurs et de crochets associés dans&nbsp;<code>wp-cron.php</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56048\">#56048</a>)</li>\n\n\n\n<li><strong>Éditeur&nbsp;:</strong>&nbsp;clarification du fait que&nbsp;<code>get_page_template()</code>&nbsp;ne fonctionne pas sur les thèmes basés sur des blocs&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56394\">#56394</a>)</li>\n\n\n\n<li><strong>Compositions de blocs :</strong>&nbsp;ajout d’une catégorie «&nbsp;Pieds de page&nbsp;»&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/56416\">#56416</a>)</li>\n\n\n\n<li><strong>Bibliothèque tierces :</strong>\n<ul>\n<li>Correction sur Thickbox pour la prise en charge des images WebP&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55786\">#55786</a></li>\n\n\n\n<li>Mise à jour de PHPMailer à la version 6.6.4&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55976\">#55976</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56016\">#56016</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56413\">#56413</a></li>\n\n\n\n<li>Mise à jour de Underscore à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56030\">#56030</a></li>\n\n\n\n<li>Mise à jour de Moment à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56031\">#56031</a></li>\n\n\n\n<li>Mise à jour de jQuery&nbsp;UI à la version 6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56239\">#56239</a></li>\n\n\n\n<li>Mise à jour de mediaelement.js à la version 4.2.17&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56319\">#56319</a></li>\n\n\n\n<li>Mise à jour de jQuery à la version 3.6.1&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56451\">#56451</a></li>\n\n\n\n<li>Mise à jour de Sodium Compat à la version 1.19.0&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56564\">#56564</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56653\">#56653</a></li>\n\n\n\n<li>Mise à jour de GetID3 à la version 1.9.22&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56692\">#56692</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Formatage :</strong>\n<ul>\n<li>Suppression des accents combinés dans&nbsp;<code>remove_accents()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/24661\">#24661</a></li>\n\n\n\n<li>Inversement de l’encapsulation de&nbsp;<code>sanitize_url()</code>&nbsp;et&nbsp;<code>esc_url_raw()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55852\">#55852</a></li>\n\n\n\n<li>Correction de la valeur retournée par&nbsp;<code>safecss_filter_attr()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55966\">#55966</a></li>\n\n\n\n<li>Autorisation de l’utilisation de propriétés CSS spécifiques à la mise en page dans le filtre&nbsp;<code>safe_style_css</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56122\">#56122</a></li>\n\n\n\n<li>Autorisation de l’utilisation de variables CSS dans&nbsp;<code>safecss_filter_attr</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56353\">#56353</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Général :</strong>\n<ul>\n<li>Mise à jour de&nbsp;<code>is_serialized</code>&nbsp;pour accepter les Enums&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/53299\">#53299</a></li>\n\n\n\n<li>Remplacement des appels à&nbsp;<code>phpversion()</code>&nbsp;par la constante PHP_VERSION&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55680\">#55680</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>realpath()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56636\">#56636</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>file_get_contents</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56637\">#56637</a></li>\n\n\n\n<li>Suppression des appels à&nbsp;<code>file_exists()</code>&nbsp;sur les variables utilisant&nbsp;<code>realpath()</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56654\">#56654</a></li>\n\n\n\n<li>Suppression des doublons d’utilisation de&nbsp;<code>get_theme_file_path</code>&nbsp;dans&nbsp;<code>register_block_style_handle</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/56666\">#56666</a></li>\n\n\n\n<li>Correction du retour obtenu en utilisant&nbsp;<code>wp_rand( 0, 0)</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55194\">#55194</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Internationalisation :</strong>&nbsp;correction d’un bug conduisant&nbsp;<code>switch_to_locale()</code>&nbsp;à annuler le chargement des traductions des thèmes et des extensions&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/39210\">#39210</a></li>\n\n\n\n<li><strong>Page de connexion/inscription :</strong>\n<ul>\n<li>Les champs obligatoires de la page d’inscription sur les multisites n’avaient pas d’attribut&nbsp;<code>required</code>&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54344\">#54344</a></li>\n\n\n\n<li>Ajout de description ARIA sur les champs d’erreur de connexion&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54483\">#54483</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Médias :</strong>&nbsp;correction d’un bug sur l’interprétation de l’orientation des images via leurs données EXIF&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54937\">#54937</a></li>\n\n\n\n<li><strong>Multisite :</strong>\n<ul>\n<li>Suppression complète des termes globaux <a href=\"https://core.trac.wordpress.org/ticket/21734\">#21734</a></li>\n\n\n\n<li>Utilisation de l’API&nbsp;des métadonnées pour les options du réseau <a href=\"https://core.trac.wordpress.org/ticket/37181\">#37181</a></li>\n\n\n\n<li>Stockage de l&rsquo;ID du site principal dans les options du réseau multisite <a href=\"https://core.trac.wordpress.org/ticket/55802\">#55802</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Chargement des scripts :</strong> mise en place des scripts en front-end via&nbsp;<code>viewScript</code> pour les blocs dynamiques <a href=\"https://core.trac.wordpress.org/ticket/56470\">#56470</a></li>\n\n\n\n<li><strong>Publications :</strong> correction de la vérification des publications non existantes dans&nbsp;<code>get_post_permalink()</code> <a href=\"https://core.trac.wordpress.org/ticket/45329\">#45329</a></li>\n\n\n\n<li><strong>Taxonomies :</strong>\n<ul>\n<li>Dans <code>wp_insert_term</code>, passage de <code>$args</code> en tant que paramètre additionnel pour les actions d’après-insertion (<code>create_term</code>, <code>created_term</code>, etc.)&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55441\">#55441</a></li>\n\n\n\n<li>Les liens d&rsquo;archives de catégories n&rsquo;incluent plus par défaut la description dans l&rsquo;attribut  <code>title</code> du lien&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55530\">#55530</a></li>\n\n\n\n<li>Les champs des termes sont maintenant associés avec leurs description dans l&rsquo;admin&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/55651\">#55651</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Mises à jour :</strong>\n<ul>\n<li>Ajout d&rsquo;un suivi de l&rsquo;usage des modules PHP installés sur les sites WP&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/48116\">#48116</a></li>\n</ul>\n</li>\n\n\n\n<li><strong>Widgets :</strong>\n<ul>\n<li>Suppression de requêtes inutiles vers la base de données&nbsp;<a href=\"https://core.trac.wordpress.org/ticket/54677\">#54677</a></li>\n</ul>\n</li>\n</ul>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">l’extension Beta Tester</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec WordPress 6.1&nbsp;RC&nbsp;1.&nbsp;Nous comptons sur vous pour vous assurer que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p style=\"font-size:13px\">Ce guide en français a été rédigé par <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> avec l’aide de <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a> et <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Arrêt définitif des mises à jour de sécurité pour les versions de WordPress 3.7 à 4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Sep 2022 13:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2445\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"À partir du 1er décembre 2022, l\'équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 3.7 à 4.0.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4346:\"\n<p>Jusqu&rsquo;à présent, l&rsquo;équipe de sécurité de WordPress proposait des correctifs de sécurité pour toutes les versions de WordPress reposant sur les versions 3.7 à la version actuelle (6.0, sachant que WordPress 6.1 sortira cet automne). Cela faisait donc un grand nombre de versions à maintenir, alors qu&rsquo;elles ne représentent qu&rsquo;un nombre très minoritaire de sites (les statistiques sont disponibles publiquement <a href=\"https://fr.wordpress.org/about/stats/\">sur cette page</a>).</p>\n\n\n\n<p>À partir du 1<sup>er</sup> décembre 2022, l&rsquo;équipe dédiée à la sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 3.7 à 4.0.</p>\n\n\n\n<p>Ces versions datant maintenant de 8 ans ou plus, il y a peu de chances que votre site soit concerné, mais vous pouvez vous en assurer en vous connectant à votre tableau de bord et en vérifiant la version de WordPress indiquée dans l’encart « D&rsquo;un coup d&rsquo;œil » (sur les versions les plus anciennes, cet encart est intitulé « Aujourd’hui »).</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"300\" src=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-1024x300.png\" alt=\"\" class=\"wp-image-2448\" srcset=\"https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-1024x300.png 1024w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-300x88.png 300w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil-768x225.png 768w, https://fr.wordpress.org/files/2022/09/widget-wordpress-duncoupdoeil.png 1132w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Dans le cas où vous disposeriez d&rsquo;une installation tournant sur WordPress 4.0 ou inférieur, vous devrez faire une mise à jour vers une version plus récente (nous recommandons la dernière version disponible) afin de garder votre site sécurisé. Consultez notre <a href=\"https://fr.wordpress.org/support/article/updating-wordpress/\">documentation sur la mise à niveau de votre site WordPress</a> pour plus d&rsquo;informations.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"564\" src=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1024x564.png\" alt=\"\" class=\"wp-image-2452\" srcset=\"https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1024x564.png 1024w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-300x165.png 300w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-768x423.png 768w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-1536x846.png 1536w, https://fr.wordpress.org/files/2022/09/maj-wordpress-tableau-de-bord-2048x1128.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Dans tous les cas, il est important de noter que <strong>la seule version de WordPress activement maintenue est la version courante</strong> (à ce jour, la version 6.0). Les versions plus anciennes ne font que bénéficier de correctifs de sécurité et ne reçoivent généralement aucun correctif de bug.</p>\n\n\n\n<p>Dans les prochains mois, l&rsquo;arrêt du support d&rsquo;un nouveau groupe d’anciennes versions de WordPress sera annoncé, selon un calendrier qui est en cours d&rsquo;élaboration au sein de l&rsquo;équipe de sécurité de WP.</p>\n\n\n\n<p>Pour plus d&rsquo;informations sur le processus d&rsquo;arrêt du support des anciennes versions de WordPress, vous pouvez consulter <a href=\"https://make.wordpress.org/security/?p=73\">cet article de l&rsquo;équipe de sécurité de WordPress (en anglais)</a>.</p>\n\n\n\n<p class=\"has-small-font-size\"><em>Article publié par <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a> de l&rsquo;équipe de sécurité de WP. Merci aux co-responsables du site fr.wordpress.org <a href=\"https://profiles.wordpress.org/wolforg/\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> et <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a> pour la relecture.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.0 « Arturo »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 May 2022 06:16:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2400\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"Bienvenue sur WordPress 6.0 «&#160;Arturo&#160;» Nous vous souhaitons la bienvenue sur WordPress 6.0, version inspirée par le musicien de jazz Arturo O’Farrill. Célèbre pour son influence sur le jazz latino contemporain, Arturo a publié plus de 15 albums sur 50 ans de carrière. Prenez le temps d’explorer WordPress 6.0. Cette version a été conçue afin [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:54322:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"694\" src=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post-1024x694.png\" alt=\"\" class=\"wp-image-2401\" srcset=\"https://fr.wordpress.org/files/2022/05/Main-image-News-post-1024x694.png 1024w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-300x203.png 300w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-768x521.png 768w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-1536x1042.png 1536w, https://fr.wordpress.org/files/2022/05/Main-image-News-post-2048x1389.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<h2>Bienvenue sur WordPress 6.0 «&nbsp;Arturo&nbsp;»</h2>\n\n\n\n<p>Nous vous souhaitons la bienvenue sur WordPress 6.0, version inspirée par le musicien de jazz <a href=\"https://en.wikipedia.org/wiki/Arturo_O\'Farrill\">Arturo O’Farrill</a>. Célèbre pour son influence sur le jazz latino contemporain, Arturo a publié plus de 15 albums sur 50 ans de carrière.</p>\n\n\n\n<p>Prenez le temps d’explorer WordPress 6.0. Cette version a été conçue afin de vous aider à développer votre inspiration créative et pour rendre l’expérience éditoriale encore plus intuitive. Pendant que vous découvrez les nouveautés de cette version, n’hésitez pas à lancer une liste de lecture comprenant les meilleures chansons d’Arturo&nbsp;!</p>\n\n\n\n<p>Avec presque 1&nbsp;000 améliorations et corrections, la deuxième version majeure de l’année 2022 est là. <a href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Cliquez ici pour télécharger WordPress 6.0&nbsp;!</a></p>\n\n\n\n<p>Les propriétaires de sites devraient mettre à jour leurs installations WordPress afin de profiter des avantages de sa stabilité, de ses améliorations de performances, et de ses améliorations en terme d&rsquo;ergonomie. Les personnes créant du contenu avec WordPress apprécieront toutes les nouvelles fonctionnalités améliorant l&rsquo;expérience éditoriale et de mise en page.</p>\n\n\n\n<div class=\"is-layout-flex wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.0 en français – ZIP 22,5 Mo </a></div>\n</div>\n\n\n\n<h3>Le contenu de WordPress 6.0</h3>\n\n\n\n<p>Pour en savoir plus sur le contenu technique de la version, lisez <a href=\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/\" data-type=\"post\" data-id=\"2369\">le guide que nous avons publié il y a quelques semaines</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Writing-Improvements-1.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple lines of text from two blocks\" class=\"wp-image-12887\" /></figure>\n\n\n\n<h4>Une expérience d’édition améliorée</h4>\n\n\n\n<p>Les améliorations éditoriales ne manquent pas, que vous écriviez un tout nouvel article ou que vous ajoutiez des éléments à une page existante. Explorez les façons d’améliorer votre processus de création de contenu avec&nbsp;:</p>\n\n\n\n<ul><li>Sélectionnez du texte à cheval sur plusieurs blocs pour le modifier en une seule fois.</li><li>Saisissez deux crochets ouvrants&nbsp;<code>[[</code>&nbsp;pour accéder rapidement au gestionnaire de liens.</li><li>Conservez les styles existants lorsque vous transformez des blocs d’un certain type en un autre type de bloc, par exemple lorsque vous transformez un bloc paragraphe en un bloc code.</li><li>Créez des boutons personnalisés et tous les nouveaux boutons que vous créerez par la suite conserveront automatiquement ces styles personnalisés.</li><li>Rendez les nuages d’étiquettes et les icônes de réseaux sociaux encore plus attrayants avec leurs nouveaux réglages. Un nouveau style de contour est aussi disponible pour le nuage d’étiquettes.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/Style-switcher-big.gif?fit=1204%2C700&amp;ssl=1\" alt=\"Style variations of Twenty Twenty Two theme\" class=\"wp-image-12893\" /></figure>\n\n\n\n<h4>Changements de styles</h4>\n\n\n\n<p>Les thèmes basés sur des blocs permettent désormais de multiples variations de style. Cela étend le nouveau système de gestion des styles et ajoute des raccourcis permettant de changer l’affichage de votre site avec un seul et même thème. Vous pouvez modifier les réglages disponibles, tels que la graisse de la police et autres options de mise en forme comme la palette de couleurs disponible par défaut. Vous pouvez modifier le rendu de votre site en quelques clics seulement.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i2.wp.com/wordpress.org/news/files/2022/05/Expanded-templates.png?fit=1204%2C700&amp;ssl=1\" alt=\"Popover listing available templates\" class=\"wp-image-12889\" /></figure>\n\n\n\n<h4>Plus de choix de modèles</h4>\n\n\n\n<p>WordPress 6.0 inclut cinq nouveaux modèles pour les thèmes basés sur des blocs&nbsp;: auteur/autrice, date, catégorie, étiquette et taxonomie. Ces modèles additionnels offrent encore plus de flexibilité pour créer du contenu. Adaptez-les avec les outils que vous connaissez déjà ou bien en utilisant les nouvelles fonctionnalités de cette version&nbsp;:</p>\n\n\n\n<ul><li>Les images mises en avant peuvent être utilisées dans le bloc bannière.</li><li>Les nouveaux contrôles de la taille des images mises en avant vous permettent d’obtenir exactement ce que vous souhaitez.</li><li>Lorsque vous modifiez un modèle, l’outil d’insertion rapide vous affiche les compositions et les éléments de modèles qui vous aideront à travailler plus rapidement et à découvrir de nouvelles options de mise en page.</li><li>Le bloc Boucle de requête prend en charge le filtrage en fonction de multiples auteurs ou autrices, en fonction de taxonomies personnalisées, ainsi que la personnalisation de ce qui est affiché lorsqu’aucune publication n’est trouvée.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Integrated-Patterns.png?fit=1204%2C700&amp;ssl=1\" alt=\"Browsing footer patterns in the quick inserter\" class=\"wp-image-12890\" /></figure>\n\n\n\n<h4>Compositions intégrées</h4>\n\n\n\n<p>Les compositions s’affichent désormais là où vous en avez besoin, comme dans l’outil d’insertion rapide ou lors de la création d’un nouvel en-tête ou pied de page. Si vous créez des thèmes basés sur des blocs, vous pouvez même&nbsp;<a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">déclarer des compositions provenant du répertoire de compositions via le fichier&nbsp;<code>theme.json</code></a>, ce qui vous permet de prioriser les compositions qui vous semblent les plus utiles pour les personnes utilisant votre thème.</p>\n\n\n\n<h4>Une vue en liste améliorée</h4>\n\n\n\n<p>De nouveaux raccourcis clavier vous permettent de sélectionner plusieurs blocs dans la vue en liste, de les modifier en une fois et de les glisser-déposer dans la liste. La vue en liste peut maintenant être ouverte et fermée plus facilement. Au départ, elle est en affichage réduit puis elle s’étend automatiquement à la sélection actuelle lorsque que vous sélectionnez un bloc.</p>\n\n\n\n<h4>Verrouillage des blocs</h4>\n\n\n\n<p>Vous pouvez dorénavant verrouiller vos blocs, ce qui permet de désactiver la possibilité de les déplacer ou de les retirer. Cela facilite la gestion de projet pour les pros, en permettant à leurs clientèle d’exprimer leur créativité au sein d’un cadre limitant les risques de casser leur site.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i1.wp.com/wordpress.org/news/files/2022/05/Block-Locking-Controls.png?fit=1204%2C700&amp;ssl=1\" alt=\"Unlocking the block in the block toolbar\" class=\"wp-image-12892\" /></figure>\n\n\n\n<h3>De nouveaux outils de design</h3>\n\n\n\n<p>Les outils de design deviennent plus puissants et intuitifs à chaque nouvelle version.<br>Parmi les principaux changements de la version 6.0, on trouvera&nbsp;:</p>\n\n\n\n<ul><li>Un nouveau panneau de gestion des couleurs qui économise de la place sur l’éditeur, tout en montrant toutes les options en un coup d’œil.</li><li>Les nouveaux contrôles des bordures offrent une façon plus simple de définir les bordures de vos conteneurs.</li><li>Les niveaux de transparence vous permettent des choix colorimétriques encore plus créatifs.</li><li>Contrôlez les espacements, les marges ou la typographie de vos blocs en une fois via le bloc groupe.</li><li>Basculez entre les variations «&nbsp;empilé&nbsp;», «&nbsp;en ligne&nbsp;» ou «&nbsp;groupé&nbsp;» pour positionner des groupes de blocs avec une plus grande flexibilité de mise en page.</li><li>Utilisez la fonctionnalité de gestion des espacements du bloc galerie pour créer toute une variété de mises en page en faisant varier l’espacement entre les images, ou tout simplement en le supprimant.</li></ul>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2022/05/List-view.png?fit=1204%2C700&amp;ssl=1\" alt=\"Selecting multiple blocks in the list view\" class=\"wp-image-12891\" /></figure>\n\n\n\n<h3>De meilleures performances</h3>\n\n\n\n<p>Cette version comprend plusieurs améliorations des performances de WordPress. Elles portent sur le chargement des publications, la réduction du temps d’exécution des requêtes, la mise en cache, le chargement des menus de navigation et bien plus encore. Notre équipe dédiée aux performances travaille au quotidien pour améliorer l&rsquo;expérience d&rsquo;utilisation de votre site WordPress.</p>\n\n\n\n<h3>Une meilleure accessibilité</h3>\n\n\n\n<p>Rendre le web plus accessible fait partie des missions du CMS WordPress. Cette nouvelle version comprend plus de 50 améliorations de l’accessibilité de WP.</p>\n\n\n\n<h2>En savoir plus sur WordPress 6.0</h2>\n\n\n\n<p>Découvrez WordPress 6.0 en action&nbsp;! Notre&nbsp;<a href=\"https://www.youtube.com/watch?v=oe452WcY7fA\">vidéo de présentation</a>&nbsp;propose une vue d’ensemble des principales fonctionnalités qui sont arrivées avec WordPress 6.0.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"612\" height=\"345\" src=\"https://www.youtube.com/embed/oe452WcY7fA?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=fr-FR&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>Nous invitons les développeurs et développeuses à explorer <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">le guide de changements techniques de WordPress&nbsp;6.0</a>.</p>\n\n\n\n<p>N’hésitez aussi pas à lire le <a href=\"https://wordpress.org/support/wordpress-version/version-6-0/\">journal de version de WordPress 6.0</a> pour plus d&rsquo;informations sur les fichiers créés, modifiés et supprimés dans cette version.</p>\n\n\n\n<h2>L’équipe de direction de WP 6.0</h2>\n\n\n\n<ul><li>Directeur de la version&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>&nbsp;</li><li>Coordinateur·ice·s de la version&nbsp;: <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> et <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li><li>Directeur technique Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a></li><li>Directeurs techniques Éditeur&nbsp;: <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> et <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a></li><li>Responsables de projet Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> et <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a></li><li>Responsable de projet Éditeur&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a></li><li>Directeur·ice·s de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> et <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li><li>Responsable de la communication&nbsp;: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a></li><li>Responsable des tests&nbsp;: <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> et <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a></li><li>Responsable du design&nbsp;: <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a></li></ul>\n\n\n\n<h2>Merci aux plus de 500 contributeurs et contributrices&nbsp;!</h2>\n\n\n\n<p>La livraison de WordPress 6.0 n’aurait jamais été possible sans la participation de ces personnes provenant de plus de 58 pays différents&nbsp;!</p>\n\n\n\n<p><small><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a> · <a href=\"https://profiles.wordpress.org/adi64bit/\">adi64bit</a> · <a href=\"https://profiles.wordpress.org/aadilali/\">Adil Ali</a> · <a href=\"https://profiles.wordpress.org/agepcom/\">agepcom</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a> · <a href=\"https://profiles.wordpress.org/alansyue/\">alansyue</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/albertomake/\">albertomake</a> · <a href=\"https://profiles.wordpress.org/alefesouza/\">Alefe Souza</a> · <a href=\"https://profiles.wordpress.org/alex897/\">Aleksandar Kostov</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/aliakseyenkaihar/\">aliakseyenkaihar</a> · <a href=\"https://profiles.wordpress.org/alkesh7/\">Alkesh Miyani</a> · <a href=\"https://profiles.wordpress.org/alokstha1/\">Alok Shrestha</a> · <a href=\"https://profiles.wordpress.org/shedonist/\">Amanda Giles</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/_smartik_/\">Andrei Surdu</a> · <a href=\"https://profiles.wordpress.org/aandrewdixon/\">Andrew Dixon</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/anoopranawat/\">Anoop Ranawat</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/paranoia1906/\">Anthony Ledesma</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antonrinas/\">antonrinas</a> · <a href=\"https://profiles.wordpress.org/arcangelini/\">arcangelini</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arnee/\">Arne</a> · <a href=\"https://profiles.wordpress.org/arpitgshah/\">Arpit G Shah</a> · <a href=\"https://profiles.wordpress.org/artdecotech/\">artdecotech</a> · <a href=\"https://profiles.wordpress.org/madeinua/\">ArteMa</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/asaquzzaman/\">Asaquzzaman mishu</a> · <a href=\"https://profiles.wordpress.org/atomicjack/\">atomicjack</a> · <a href=\"https://profiles.wordpress.org/ajoah/\">Aurélien Joahny</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/barryhughes/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartoszgadomski/\">Bartosz Gadomski</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bettyjj/\">BettyJJ</a> · <a href=\"https://profiles.wordpress.org/bhrugesh12/\">Bhrugesh Bavishi</a> · <a href=\"https://profiles.wordpress.org/binarymoon/\">binarymoon</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/supercleanse/\">Blair Williams</a> · <a href=\"https://profiles.wordpress.org/blogaid/\">BlogAid</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/wpe_bdurette/\">Brandon DuRette</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/brookedot/\">Brooke.</a> · <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a> · <a href=\"https://profiles.wordpress.org/caraya/\">caraya</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos Garcia</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbigler/\">cbigler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/critterverse/\">Channing Ritter</a> · <a href=\"https://profiles.wordpress.org/charleyparkerdesign/\">charleyparkerdesign</a> · <a href=\"https://profiles.wordpress.org/charlyox/\">charlyox</a> · <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a> · <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/clubkert/\">Chris Lubkert</a> · <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/clonemykey/\">clonemykey</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/conner_bw/\">conner_bw</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/htdat/\">Dat Hoang</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">Dave Smith</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/devutpol/\">Deb Nath Utpol</a> · <a href=\"https://profiles.wordpress.org/delowardev/\">Delowar Hossain</a> · <a href=\"https://profiles.wordpress.org/denishua/\">denishua</a> · <a href=\"https://profiles.wordpress.org/dennisatyoast/\">Dennis Claassen</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a> · <a href=\"https://profiles.wordpress.org/drago239/\">drago239</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/dromero20/\">dromero20</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/eric3d/\">eric3d</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik Betshammar</a> · <a href=\"https://profiles.wordpress.org/espiat/\">espiat</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/etaproducto/\">etaproducto</a> · <a href=\"https://profiles.wordpress.org/everpress/\">EverPress</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/iogui/\">Fabio Blanco</a> · <a href=\"https://profiles.wordpress.org/faison/\">Faison</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/femkreations/\">Femy Praseeth</a> · <a href=\"https://profiles.wordpress.org/florianbrinkmann/\">Florian Brinkmann</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/foliovision/\">FolioVision</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frankei/\">frankei</a> · <a href=\"https://profiles.wordpress.org/furi3r/\">furi3r</a> · <a href=\"https://profiles.wordpress.org/gadhiyaravi/\">gadhiyaravi</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/voldemortensen/\">Garth Mortensen</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/genosseeinhorn/\">genosseeinhorn</a> · <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/geriux/\">geriux</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/greglone/\">Grégory Viguier</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregoiresailland/\">gregoiresailland</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gumacahin/\">gumacahin</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a> · <a href=\"https://profiles.wordpress.org/hasnainashfaq/\">Hasnain Ashfaq</a> · <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hristok/\">HristoK</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ianatkins/\">ianatkins</a> · <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a> · <a href=\"https://profiles.wordpress.org/credo61/\">ImanGM</a> · <a href=\"https://profiles.wordpress.org/imokol/\">imokol</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishitaka/\">ishitaka</a> · <a href=\"https://profiles.wordpress.org/itsamoreh/\">itsamoreh</a> · <a href=\"https://profiles.wordpress.org/iulia-cazan/\">Iulia Cazan</a> · <a href=\"https://profiles.wordpress.org/ivanlutrov/\">Ivan Lutrov</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/rumpel2116/\">Jan Weiss</a> · <a href=\"https://profiles.wordpress.org/janh2/\">janh2</a> · <a href=\"https://profiles.wordpress.org/jarretc/\">Jarret</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jprieton/\">Javier Prieto</a> · <a href=\"https://profiles.wordpress.org/grandeljay/\">Jay Trees</a> · <a href=\"https://profiles.wordpress.org/jazbek/\">jazbek</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/miss_jwo/\">Jenny Wong</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a> · <a href=\"https://profiles.wordpress.org/sausajez/\">Jez Emery</a> · <a href=\"https://profiles.wordpress.org/jhned/\">jhned</a> · <a href=\"https://profiles.wordpress.org/jhnstn/\">jhnstn</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">jigar bhanushali</a> · <a href=\"https://profiles.wordpress.org/jiteshdhamaniya/\">jiteshdhamaniya</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/goaroundagain/\">Johannes Kinast</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnwatkins0/\">John Watkins</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jorgecontreras/\">Jorge</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josearcos/\">José Arcos</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/jostnes/\">Josepha Dambul</a> · <a href=\"https://profiles.wordpress.org/joshf/\">Joshua Fredrickson</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrivett/\">jrivett</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a> · <a href=\"https://profiles.wordpress.org/juanlopez4691/\">juanlopez4691</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junaidkbr/\">Junaid Ahmed</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/justinbusa/\">Justin Busa</a> · <a href=\"https://profiles.wordpress.org/certainstrings/\">Justin Tucker</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/kapacity/\">kapacity</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">kbatdorf</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/w33zy/\">Kemory Grubb</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kprovance/\">Kev Provance</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirtan95/\">Kirtan Gajjar</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kmix39/\">KMix</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/konradyoast/\">Konrad.K</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/kpegoraro/\">kpegoraro</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/sainthkh/\">Kukhyeon Heo</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/uzumymw/\">leskam</a> · <a href=\"https://profiles.wordpress.org/layotte/\">Lew Ayotte</a> · <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a> · <a href=\"https://profiles.wordpress.org/lschuyler/\">Lisa Schuyler</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/karpstrucking/\">Lucas Karpiuk</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/pyrobd/\">Lukman Nakib</a> · <a href=\"https://profiles.wordpress.org/michelangelovandam/\">M. van Dam</a> · <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a> · <a href=\"https://profiles.wordpress.org/mashikag/\">Maciej</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maguijo/\">maguijo</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/mkox/\">Markus Kosmal</a> · <a href=\"https://profiles.wordpress.org/marv2/\">marv2</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">matiasbenedetto</a> · <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a> · <a href=\"https://profiles.wordpress.org/sivel/\">Matt Martz</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/themattroyal/\">Matt Royal</a> · <a href=\"https://profiles.wordpress.org/mjstoney/\">Matt Stoney</a> · <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a> · <a href=\"https://profiles.wordpress.org/mauriac/\">maur</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maxkellermann/\">Max Kellermann</a> · <a href=\"https://profiles.wordpress.org/mehedi890/\">Mehedi Foysal</a> · <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mauteri/\">Mike Auteri</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/miken32/\">miken32</a> · <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/mirkolofio/\">Mirco Babini</a> · <a href=\"https://profiles.wordpress.org/mmdeveloper/\">MMDeveloper</a> · <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\">Mohadese Ghasemi</a> · <a href=\"https://profiles.wordpress.org/ahsan03/\">Mohammad Ahsan Habib</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mjkhajeh/\">MohammadJafar Khajeh</a> · <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a> · <a href=\"https://profiles.wordpress.org/moushik/\">moushik</a> · <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a> · <a href=\"https://profiles.wordpress.org/muhammadfaizanhaidar/\">Muhammad Faizan Haidar</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a> · <a href=\"https://profiles.wordpress.org/nabil_kadimi/\">Nabil</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai – a11n</a> · <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a> · <a href=\"https://profiles.wordpress.org/nhadsall/\">Nathan</a> · <a href=\"https://profiles.wordpress.org/nayana123/\">Nayana Maradia</a> · <a href=\"https://profiles.wordpress.org/nextend_ramona/\">Nextend Support – Ramona</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickciske/\">Nick Ciske</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/rahe/\">Nicolas Juen</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/knilkantha/\">Nil</a> · <a href=\"https://profiles.wordpress.org/nmschaller/\">nmschaller</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/oakesjosh/\">oakesjosh</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a> · <a href=\"https://profiles.wordpress.org/otshelnik-fm/\">Otshelnik-Fm</a> · <a href=\"https://profiles.wordpress.org/overclokk/\">overclokk</a> · <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/figureone/\">Paul Ryan</a> · <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">paulkevan</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/malinevskiy/\">Pavlo</a> · <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/petaryoast/\">Petar Ratković</a> · <a href=\"https://profiles.wordpress.org/psmits1567/\">Peter Smits</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petrosparaskevopoulos/\">petrosparaskevopoulos</a> · <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a> · <a href=\"https://profiles.wordpress.org/pgpagely/\">pgpagely</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/pikamander2/\">pikamander2</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pravinparmar2404/\">Pravin Parmar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pypwalters/\">pypwalters</a> · <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiahmedd/\">Rafi Ahmed</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/jontyravi/\">Ravi Vaghela</a> · <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a> · <a href=\"https://profiles.wordpress.org/razvanonofrei/\">Razvan Onofrei</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/richybkreckel/\">Richard B. Kreckel</a> · <a href=\"https://profiles.wordpress.org/ricomoorman/\">ricomoorman</a> · <a href=\"https://profiles.wordpress.org/r0bsc0tt/\">Rob Scott</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/rolfsiebers/\">Rolf Siebers</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/rufus87/\">Rufus87</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/samiff/\">Sami Falah</a> · <a href=\"https://profiles.wordpress.org/sanzeeb3/\">Sanjeev Aryal</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">santosguillamot</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/arasae/\">Sarah Snow</a> · <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbossarte/\">sbossarte</a> · <a href=\"https://profiles.wordpress.org/sclayf1/\">sclayf1</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">Segayuu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sheepysheep60/\">sheepysheep60</a> · <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a> · <a href=\"https://profiles.wordpress.org/shreyasikhar26/\">Shreyas Ikhar</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/silb3r/\">silb3r</a> · <a href=\"https://profiles.wordpress.org/lumpysimon/\">Simon Blackbourn</a> · <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a> · <a href=\"https://profiles.wordpress.org/simonhammes/\">simonhammes</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a> · <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a> · <a href=\"https://profiles.wordpress.org/socalchristina/\">socalchristina</a> · <a href=\"https://profiles.wordpress.org/spencercameron/\">Spencer Cameron-Morin</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/stefanfisk/\">stefanfisk</a> · <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevegrunwell/\">Steve Grunwell</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/5um17/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva</a> · <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/legendusmaximus/\">Theo H</a> · <a href=\"https://profiles.wordpress.org/thimalw/\">Thimal Wickremage</a> · <a href=\"https://profiles.wordpress.org/twistermc/\">Thomas McMahon</a> · <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a> · <a href=\"https://profiles.wordpress.org/xiven/\">Thomas Pike</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/waterfire/\">Tim Blankenship</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjdevisser/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomasztunik/\">tomasztunik</a> · <a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/ttahmouch/\">Tony Tahmouch</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/sierratr/\">Tracy</a> · <a href=\"https://profiles.wordpress.org/trex005/\">trex005</a> · <a href=\"https://profiles.wordpress.org/tszming/\">tszming</a> · <a href=\"https://profiles.wordpress.org/tumas2/\">tumas2</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/junsuijin/\">Tynan Beatty</a> · <a href=\"https://profiles.wordpress.org/tzipporahwitty/\">tzipporahwitty</a> · <a href=\"https://profiles.wordpress.org/uday17035/\">Uday Kokitkar</a> · <a href=\"https://profiles.wordpress.org/ugljanin/\">ugljanin</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/grapplerulrich/\">Ulrich</a> · <a href=\"https://profiles.wordpress.org/utkarshpatel/\">Utkarsh</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/versusbassz/\">versusbassz</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/elifvish/\">Vishal Kumar</a> · <a href=\"https://profiles.wordpress.org/vladolaru/\">vlad.olaru</a> · <a href=\"https://profiles.wordpress.org/volodymyrkolesnykov/\">Volodymyr Kolesnykov</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/wendyjchen/\">Wendy Chen</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whoisnegrello/\">whoisnegrello</a> · <a href=\"https://profiles.wordpress.org/antonynz/\">wpcharged</a> · <a href=\"https://profiles.wordpress.org/wpmakenorg/\">wpmakenorg</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wraithkenny/\">WraithKenny</a> · <a href=\"https://profiles.wordpress.org/wslyhbb/\">wslyhbb</a> · <a href=\"https://profiles.wordpress.org/upsuper/\">Xidorn Quan</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/dolphingg/\">Yunus Ertuğrul</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/znuff/\">znuff</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></small></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p>Merci également aux personnes qui ont traduit WordPress 6.0 en français&nbsp;: <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a style=\"font-size: revert;, sans-serif\" href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/ajoah\">Aurélien Joahny</a>,&nbsp;<a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>,&nbsp;<a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/fred5550\">Frederic Nuyts</a>,&nbsp;<a href=\"https://profiles.wordpress.org/guillaumeturpin\">Guillaume TURPIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/ioanamuresan\">Ioana M</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jaz_on\">Jason Rouet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lulucmy\">lulucmy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nandow\">Nandor Wiener</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/virginienacci\">Virginie Nacci</a>,&nbsp;<a href=\"https://profiles.wordpress.org/whodunitagency\">Whodunit</a>,&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a> et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><small>Merci à <a href=\'https://profiles.wordpress.org/fxbenard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>fxbenard</a> <a href=\'https://profiles.wordpress.org/wolforg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>wolforg</a> et <a href=\'https://profiles.wordpress.org/em-m/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>em-m</a> pour la relecture de communiqué</small></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://fr.wordpress.org/2022/05/25/wordpress-6-0-arturo/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 04 May 2022 12:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2369\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"Maintenant que la première version Release Candidate de WordPress 6.0 est sortie, il est grand temps d&#8217;explorer les modifications apportées par cette future version, dont la sortie est prévue pour le 24 mai 2022. WordPress 6.0 est une version majeure de même niveau que WP 5.8 ou WP 5.9. Elle apportera le principe des variations [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:37523:\"\n<p>Maintenant que la première version <em>Release Candidate</em> de WordPress 6.0 est sortie, il est grand temps d&rsquo;explorer les modifications apportées par cette future version, dont la sortie est prévue pour le 24 mai 2022. WordPress 6.0 est une version majeure de même niveau que WP 5.8 ou WP 5.9. Elle apportera le principe des variations de styles, l’interface de verrouillage des blocs, plusieurs améliorations de l&rsquo;éditeur, encore plus d’outils de design, de nouveaux crochets et filtres, des mises à jour des différentes bibliothèques utilisées par WP, et bien plus encore&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"702\" src=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-1024x702.png\" alt=\"\" class=\"wp-image-2376\" srcset=\"https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-1024x702.png 1024w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-300x206.png 300w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire-768x527.png 768w, https://fr.wordpress.org/files/2022/05/wordpress-60-provisoire.png 1446w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Au bas mot, ce seront au moins <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">97 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">131 corrections de bogues</a>, <a href=\"https://core.trac.wordpress.org/ticket/55567\">13 correctifs sur l’éditeur de bloc</a>, ainsi que&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 autres changements divers</a>, ce qui représente au total <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">231 tickets Trac</a>.</p>\n\n\n\n<p>La nouvelle équipe chargée des performances de WordPress a aussi travaillé dur pour améliorer diverses parties du CMS. De nombreuses requêtes ont été optimisées et certaines d&rsquo;entre elles ont été retirées, la gestion du cache a été perfectionnée, et de nombreux doublons de traductions ont été enlevés afin d&rsquo;améliorer la vitesse de chargement de WP sur les installations non anglophones.</p>\n\n\n\n<p class=\"is-style-plain has-medium-font-size\">C&rsquo;est parti pour un petit tour d’horizon des nouveautés de WordPress 6.0&nbsp;!</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L&rsquo;objectif est de fournir un panorama général des changements techniques apportés par cette version, en français.</p>\n\n\n\n<p class=\"has-text-color has-background\" style=\"background-color:#cceaff;color:#03517f\">À noter&nbsp;: certaines modifications listées ici vont nécessiter des actions des auteurs et autrices de thèmes et d’extensions, qui devront adapter ou modifier leur code. Si vous êtes concerné·e, veuillez lire les notes de développement listées dans cet article consciencieusement afin de vous assurer que votre code fonctionnera avec WordPress 6.0 lorsque cette version sortira le 24 mai 2022.</p>\n\n\n\n<h2>Accessibilité</h2>\n\n\n\n<p>De même que pour les performances, l’accessibilité de WordPress a été grandement améliorée. La note de développement suivante détaille les différentes améliorations effectuées.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"aylbLUKVvp\"><a href=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/\">WordPress 6.0 Accessibility Improvements</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 6.0 Accessibility Improvements&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/20/wordpress-6-0-accessibility-improvements/embed/#?secret=1ZIEsiLvDE#?secret=aylbLUKVvp\" data-secret=\"aylbLUKVvp\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>L’éditeur de blocs</h2>\n\n\n\n<p>L’éditeur a bien entendu reçu de nombreuses améliorations&nbsp;:</p>\n\n\n\n<ul><li>Possibilité de construire de multiples variations de styles pour les thèmes basés sur des blocs&nbsp;;</li><li>Possibilité de créer des compositions de contenu de pages que les rédacteurs et rédactrices pourront utiliser ou non pour construire leurs pages de contenu&nbsp;;</li><li>Nouvelle propriété <code>ancestor</code> dans le fichier <code>block.json</code> afin de permettre la restriction des endroits où les rédacteurs et rédactrices peuvent placer leurs blocs&nbsp;;</li><li>Une nouvelle interface de verrouillage des blocs à l&rsquo;aide de l&rsquo;attribut <code>lock</code>&nbsp;;</li><li>Déclaration et enregistrement de blocs au sein des thèmes&nbsp;;</li><li>Amélioration de la préservation des contenus non reconnus comme des blocs dans l’éditeur&nbsp;;</li><li>Une fonctionnalité d&rsquo;exportation des blocs des thèmes plus robuste au sein de l’éditeur&nbsp;;</li><li>Des mises à jour du balisage des blocs image, citation, liste et groupe&nbsp;;</li><li>De nouveaux blocs tels que le bloc de commentaires de la publication, le bloc «&nbsp;Aucun résultat&nbsp;», et bien plus encore…</li></ul>\n\n\n\n<p>À noter que si vous utilisez la version <em>extension</em> de Gutenberg (ce qui ne devrait être le cas que sur un site destiné à des expérimentations), vous devrez impérativement la mettre à jour vers sa toute dernière version <em>avant</em> de mettre à jour votre site avec la version 6.0 de WordPress.</p>\n\n\n\n<p>Sans plus attendre, voici les notes de développement liées à l’éditeur&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"O4MaN7Al9W\"><a href=\"https://make.wordpress.org/core/2022/05/03/page-creation-patterns-in-wordpress-6-0/\">Page creation patterns in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Page creation patterns in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/page-creation-patterns-in-wordpress-6-0/embed/#?secret=Vva1kiTUdO#?secret=O4MaN7Al9W\" data-secret=\"O4MaN7Al9W\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yNgdvwFZyq\"><a href=\"https://make.wordpress.org/core/2022/05/03/global-styles-variations-in-wordpress-6-0/\">Global Styles variations in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Global Styles variations in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/global-styles-variations-in-wordpress-6-0/embed/#?secret=LouvK1NNRH#?secret=yNgdvwFZyq\" data-secret=\"yNgdvwFZyq\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"gEKvxlYKbw\"><a href=\"https://make.wordpress.org/core/2022/05/03/support-for-handling-resolution-errors-for-editor-data-module/\">Support for handling resolution errors for Editor data module</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Support for handling resolution errors for Editor data module&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/support-for-handling-resolution-errors-for-editor-data-module/embed/#?secret=ok7NQ4NnkH#?secret=gEKvxlYKbw\" data-secret=\"gEKvxlYKbw\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yzhtIAVRNf\"><a href=\"https://make.wordpress.org/core/2022/05/03/block-markup-updates-for-image-quote-list-and-group-blocks/\">Block markup updates for image, quote, list and group blocks</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block markup updates for image, quote, list and group blocks&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/block-markup-updates-for-image-quote-list-and-group-blocks/embed/#?secret=udFFQ8yHBA#?secret=yzhtIAVRNf\" data-secret=\"yzhtIAVRNf\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kC6j5E5zKf\"><a href=\"https://make.wordpress.org/core/2022/05/03/separator-block-updated-to-use-block-supports-color-settings/\">Separator block: Updated to use block supports color settings</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Separator block: Updated to use block supports color settings&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/separator-block-updated-to-use-block-supports-color-settings/embed/#?secret=EVWwVqSsK8#?secret=kC6j5E5zKf\" data-secret=\"kC6j5E5zKf\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e8Tty8IzRp\"><a href=\"https://make.wordpress.org/core/2022/05/03/block-editor-miscellaneous-dev-notes-for-wordpress-6-0/\">Block Editor miscellaneous Dev Notes for WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block Editor miscellaneous Dev Notes for WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/block-editor-miscellaneous-dev-notes-for-wordpress-6-0/embed/#?secret=5wJqoOGfuk#?secret=e8Tty8IzRp\" data-secret=\"e8Tty8IzRp\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Processus de chargement de WordPress</h2>\n\n\n\n<p>Entre autres améliorations concernant les performances du logiciel, le processus de chargement de WordPress (le «&nbsp;bootstrap&nbsp;») a été amélioré afin de permettre aux développeurs et développeuses d’ignorer les requêtes non nécessaires avec le filtre <code>do_parse_request</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"QGN6nyDZZx\"><a href=\"https://make.wordpress.org/core/2022/04/27/changes-to-do_parse_request-filter-in-wordpress-6-0/\">Changes to do_parse_request filter in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Changes to do_parse_request filter in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/27/changes-to-do_parse_request-filter-in-wordpress-6-0/embed/#?secret=JGyFNpM8Vw#?secret=QGN6nyDZZx\" data-secret=\"QGN6nyDZZx\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>API de gestion du cache</h2>\n\n\n\n<p>Avec WordPress 6.0, l’API <code>wp_cache_*_multiple</code> devient une API complètement CRUD (voir le <a href=\"https://fr.wikipedia.org/wiki/CRUD\">terme «&nbsp;CRUD&nbsp;» sur Wikipédia</a>). Par ailleurs, une option permettant de réinitialiser le temps d’exécution du cache sans réinitialiser l&rsquo;entièreté du cache persistant a été ajoutée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HixiB7GUbB\"><a href=\"https://make.wordpress.org/core/2022/04/29/caching-improvements-in-wordpress-6-0/\">Caching improvements in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Caching improvements in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/29/caching-improvements-in-wordpress-6-0/embed/#?secret=eSHwD0gV8N#?secret=HixiB7GUbB\" data-secret=\"HixiB7GUbB\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Médias</h2>\n\n\n\n<p>La gestion des médias a elle aussi reçu de nouveaux filtres et plusieurs améliorations d’interface&nbsp;:</p>\n\n\n\n<ul><li>Activation de la modification des tailles d’images personnalisées à l’aide du filtre&nbsp;<code>edit_custom_thumbnail_sizes</code>&nbsp;qui permet aux développeuses et développeurs de modifier les tailles d’images personnalisées individuelles (<a href=\"https://core.trac.wordpress.org/ticket/28277\">Voir le ticket #28277</a>)&nbsp;;</li><li>&nbsp;Ajout d’une fonction «&nbsp;copier l’URL dans le presse-papier&nbsp;» sur la vue en liste des médias (<a href=\"https://core.trac.wordpress.org/ticket/54426\">Voir le ticket #54426</a>).</li></ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"yxx2tJKflU\"><a href=\"https://make.wordpress.org/core/2022/04/27/new-filter-to-modify-content-images-in-wordpress-6-0/\">New filter to modify content images in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New filter to modify content images in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/27/new-filter-to-modify-content-images-in-wordpress-6-0/embed/#?secret=8kaC2NHwuW#?secret=yxx2tJKflU\" data-secret=\"yxx2tJKflU\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Le composant Médias a par ailleurs lui aussi reçu des améliorations de performances&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"rzdrAmmrI6\"><a href=\"https://make.wordpress.org/core/2022/05/02/media-storing-file-size-as-part-of-metadata/\">Media: storing file size as part of metadata</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Media: storing file size as part of metadata&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/media-storing-file-size-as-part-of-metadata/embed/#?secret=7VfVtwQN76#?secret=rzdrAmmrI6\" data-secret=\"rzdrAmmrI6\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Types de publications</h2>\n\n\n\n<p>WordPress 6.0 introduit encore davantage de crochets et filtres dynamiques pour les types de publications et les taxonomies.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WJDM87k4sz\"><a href=\"https://make.wordpress.org/core/2022/05/02/object-type-specific-registration-hooks-in-6-0/\">Object type specific registration hooks in 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Object type specific registration hooks in 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/object-type-specific-registration-hooks-in-6-0/embed/#?secret=wYXFAV3b98#?secret=WJDM87k4sz\" data-secret=\"WJDM87k4sz\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Taxonomies</h2>\n\n\n\n<p>Les taxonomies ont reçues des améliorations de performances, notamment à travers la mise en cache des requêtes sur les termes de taxonomies, et via l’ajout de limites aux requêtes concernant les taxonomies, mais aussi au niveau des éléments de menus de navigation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"VtwOOxjJuQ\"><a href=\"https://make.wordpress.org/core/2022/04/28/taxonomy-performance-improvements-in-wordpress-6-0/\">Taxonomy performance improvements in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Taxonomy performance improvements in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/28/taxonomy-performance-improvements-in-wordpress-6-0/embed/#?secret=90lFxU7Wbk#?secret=VtwOOxjJuQ\" data-secret=\"VtwOOxjJuQ\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Thèmes</h2>\n\n\n\n<p>Cette nouvelle version offre aux auteurs et autrices de thèmes une façon encore plus efficace de travailler avec les compositions de blocs, la prise en charge de multiples fichiers <code>theme.json</code> avec l’éditeur de site, et bien plus encore.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"pTkwNLfniL\"><a href=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/\">New features for working with patterns and themes in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New features for working with patterns and themes in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/new-features-for-working-with-patterns-and-themes-in-wordpress-6-0/embed/#?secret=z1ichmCsB3#?secret=pTkwNLfniL\" data-secret=\"pTkwNLfniL\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZTyMFeyCFv\"><a href=\"https://make.wordpress.org/core/2022/05/02/theme-export-in-wordpress-6-0/\">Theme export in WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Theme export in WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/theme-export-in-wordpress-6-0/embed/#?secret=AIOHcWsoD9#?secret=ZTyMFeyCFv\" data-secret=\"ZTyMFeyCFv\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3>Les thèmes basés sur des blocs peuvent maintenant se passer du fichier index.php</h3>\n\n\n\n<p>Avec cette modification, il n&rsquo;est maintenant plus nécessaire d&rsquo;avoir un fichier modèle&nbsp;<code>index.php</code>. Jusqu&rsquo;à présent, il était nécessaire d&rsquo;en avoir un même s&rsquo;il n&rsquo;était pas utilisé. Dorénavant, ce fichier est remplacé par le fichier&nbsp;<code>templates/index.html</code>. <a href=\"https://core.trac.wordpress.org/ticket/54272\">Voir le ticket #54272</a>.</p>\n\n\n\n<h3>Correction de la logique d’affichage des avertissements&nbsp;_doing_it_wrong()&nbsp;pour&nbsp;add_theme_support( &lsquo;html5&rsquo; )</h3>\n\n\n\n<ul><li>Le fait d’appeler&nbsp;<code>add_theme_support( \'html5\' )</code>&nbsp;sans passer un tableau de types pris en charges affiche maintenant un avertissement&nbsp;<code>_doing_it_wrong()</code>&nbsp;: «&nbsp;Vous devez passer un tableau de types&nbsp;» ;</li><li>Si le second paramètre n’est pas spécifié, un tableau contenant&nbsp;<code>comment-list</code>,&nbsp;<code>comment-form</code>, et&nbsp;<code>search-form</code>&nbsp;sera automatiquement passé en tant que solution de repli, pour assurer la rétrocompatibilité de la fonction&nbsp;;</li><li>Si le second paramètre n’est pas un tableau, la fonction retournera&nbsp;<code>false</code>.</li></ul>\n\n\n\n<p>Pour plus d&rsquo;informations, <a href=\"https://core.trac.wordpress.org/ticket/51657\">voir le ticket #51657</a>.</p>\n\n\n\n<h2>Comptes</h2>\n\n\n\n<p>Avec WP 6.0, les installations comprenant plus de 10&nbsp;000 comptes ont reçu des améliorations de performances sur les requêtes concernant les comptes.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BHtC3yStBd\"><a href=\"https://make.wordpress.org/core/2022/04/29/wp_user_query-now-accepts-fields-options-in-wordpress-6-0/\">WP_User_Query now accepts fields options in WordPress 6.0 </a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WP_User_Query now accepts fields options in WordPress 6.0 &#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/04/29/wp_user_query-now-accepts-fields-options-in-wordpress-6-0/embed/#?secret=YDNq2zqbDE#?secret=BHtC3yStBd\" data-secret=\"BHtC3yStBd\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WrP1XxUcf7\"><a href=\"https://make.wordpress.org/core/2022/05/02/performance-increase-for-sites-with-large-user-counts-now-also-available-on-single-site/\">Performance increase for sites with large user counts (now also available on single site)</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Performance increase for sites with large user counts (now also available on single site)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/02/performance-increase-for-sites-with-large-user-counts-now-also-available-on-single-site/embed/#?secret=xdlkVPVFnI#?secret=WrP1XxUcf7\" data-secret=\"WrP1XxUcf7\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Autres changements techniques</h2>\n\n\n\n<p>WordPress 6.0 apporte également&nbsp;: </p>\n\n\n\n<ul><li>Un filtre destiné aux auteurs et autrices d’extensions qui leur permet de modifier la description de leur extension telle qu’elle est affichée sur l&rsquo;écran <strong>Extensions &gt; Ajouter</strong> et/ou sur l&rsquo;écran&nbsp;<strong>Administration du réseau&nbsp;&gt; Extensions &gt; Ajouter</strong>&nbsp;;</li><li>La possibilité de filtrer l’ensemble de la notification e-mail envoyée par <code>retrieve_password</code>&nbsp;;</li><li>La possibilité de retirer les icônes de sites sur les réseaux multisites.</li></ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ET2xV9XcVa\"><a href=\"https://make.wordpress.org/core/2022/05/03/miscellaneous-dev-notes-for-wordpress-6-0/\">Miscellaneous Dev Notes for WordPress 6.0</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Dev Notes for WordPress 6.0&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/05/03/miscellaneous-dev-notes-for-wordpress-6-0/embed/#?secret=Z0RAvcrbpa#?secret=ET2xV9XcVa\" data-secret=\"ET2xV9XcVa\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2>Et bien plus encore…</h2>\n\n\n\n<p>Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">131 corrections de bugs</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.0&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">97 améliorations et nouvelles fonctionnalité</a>, ainsi que&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">23 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.0&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">ajoutés dans WordPress 6.0</a>.</p>\n\n\n\n<p>Voici quelques modifications qui méritent d’être soulignées&nbsp;:</p>\n\n\n\n<ul><li><strong>Administration&nbsp;:</strong> ajout d’un filtre&nbsp;<code>media_date_column_time</code>&nbsp;à la colonne de date de l&rsquo;écran de liste des médias. De façon similaire au filtre existant <code>post_date_column_time</code>&nbsp;pour les publications, ce filtre permet de modifier l’affichage du contenu de la colonne «&nbsp;Date&nbsp;» (<a href=\"https://core.trac.wordpress.org/ticket/42942\">voir le ticket #42942</a>)&nbsp;;</li><li><strong>Outils de <em>build</em> et de tests&nbsp;:</strong><ul><li>Mise à jour de webpack vers la version v5.x. Cela rapproche WordPress de la façon dont l’extension Gutenberg gère ses paquets&nbsp;;</li><li>WordPress 6.0 active également la prise en charge de <em>«&nbsp;React Fast Refresh&nbsp;»</em> pour le développement de blocs avec <code>@wordpress/scripts</code>&nbsp;;</li><li>Cette nouvelle version ajoute aussi la dernière version de&nbsp;<code>caniuse-lite</code>&nbsp;qui permet de s’assurer que les outils de <em>build</em> de WP ciblent la dernière version des navigateurs pris en charge par WordPress (voir les tickets <a href=\"https://core.trac.wordpress.org/ticket/51750\">#51750</a> et <a href=\"https://core.trac.wordpress.org/ticket/55505\">#55505</a>)&nbsp;;</li><li>Un fichier <code>.git-blame-ignore-revs</code> a été ajouté au répertoire de développement de WP afin de rendre la fonctionnalité <code>git blame</code> plus efficace sur GitHub (<a href=\"https://core.trac.wordpress.org/ticket/55422\">voir le ticket #55422</a>)&nbsp;;</li><li>La commande <code>npm install</code> a été corrigée pour les contributeurs et contributrices utilisant des appareils <em>«&nbsp;Apple M series silicone&nbsp;»</em> en mettant à jour la dépendance technique <code>grunt-contrib-qunit</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/52690\">voir le ticket #52690</a>)&nbsp;;</li></ul></li><li><strong>Thèmes natifs&nbsp;:</strong> si vous rencontriez des soucis avec l’ordre des éléments dans le formulaire de commentaires du thème Twenty Nineteen, nous avons une bonne nouvelle&nbsp;: ceci a été corrigé dans le ticket <a href=\"https://core.trac.wordpress.org/ticket/46600\">#46600</a>&nbsp;; </li><li><strong>URL canoniques&nbsp;:</strong> la fonction <code>redirect_guess_404_permalink()</code> inclue maintenant tous les états publics des publications, et pas uniquement l’état «&nbsp;publié&nbsp;» / <code>publish</code>, dans les redirections 404 de recherche (<a href=\"https://core.trac.wordpress.org/ticket/47911\">voir le ticket #47911</a>)&nbsp;;</li><li><strong>Commentaires&nbsp;:</strong>&nbsp;accélération du chargement SQL du tableau de bord et de la modération des commentaires (<a href=\"https://core.trac.wordpress.org/ticket/19901\">voir le ticket #19901</a>)&nbsp;;</li><li><strong>Emojis :</strong> mise à jour de la bibliothèque Twemoji vers la version 14.0.2. Cette version introduit la prise en charge des derniers Emojis ajoutés dans la version 14 (<a href=\"https://core.trac.wordpress.org/ticket/55395\">voir le ticket #55395</a>)&nbsp;;</li><li><strong>Bibliothèques externes&nbsp;:</strong> <ul><li>Mise à jour de Jcrop à la version 0.9.15 (<a href=\"https://core.trac.wordpress.org/ticket/54035\">ticket #54035</a>)&nbsp;;</li><li>Mise à jour de jQuery Color à la version 2.2.0. Suppression de la version embarquée (qui existait toujours dans le cœur WP) en faveur de l&rsquo;amélioration du processus Grunt pour plutôt inclure le paquet depuis NPM (<a href=\"https://core.trac.wordpress.org/ticket/55016\">ticket #55016</a>)&nbsp;;</li><li>Mise à jour de <code>random_compat</code> à la version 2.0.21. Cela améliore la compatibilité avec PHP 8.1 et corrige des bogues avec les plateformes Windows (<a href=\"https://core.trac.wordpress.org/ticket/55181\">ticket #55181</a>) ;</li><li>Mise à niveau de PHPMailer à la version 6.5.4. Amélioration de compatibilité PHP et sécurisation contre les hébergeurs désactivant certaines fonctions de sécurité. <strong>Note aux hébergeurs&nbsp;: ne désactivez pas les fonctions&nbsp;<code>escapeshellarg()</code>&nbsp;et&nbsp;<code>escapeshellcmd()</code>, cela présente un risque de sécurité&nbsp;!</strong> (<a href=\"https://core.trac.wordpress.org/ticket/55187\">ticket #55187</a>)&nbsp;;</li><li>Mise à niveau de PHPMailer à la version 6.6.0 (<a href=\"https://core.trac.wordpress.org/ticket/55277\">ticket #55277</a>)&nbsp;;</li><li>Mise à jour de sodium_compat à la version 1.17.1. Amélioration de la compatibilité PHP 8.1 (<a href=\"https://core.trac.wordpress.org/ticket/55453\">ticket #55453</a>)</li><li>Mise à jour de <code>backbone</code>&nbsp;de la version&nbsp;<code>1.4.0</code>&nbsp;à la version&nbsp;<code>1.4.1</code>&nbsp;;</li><li>Mise à jour de <code>underscore</code>&nbsp;de la version&nbsp;<code>1.13.1</code>&nbsp;à la version&nbsp;<code>1.13.2</code>&nbsp;;</li><li>Mise à jour de <code>clipboard</code>&nbsp;de la version&nbsp;<code>2.0.8</code>&nbsp;à la version&nbsp;<code>2.0.10</code> (<a href=\"https://core.trac.wordpress.org/ticket/55547\">ticket #55547</a>)&nbsp;;</li></ul></li><li><strong>Formatage :</strong> <ul><li>Ajout de la prise en charge des formatage de tailles PB, EB, ZB, and YB (<a href=\"https://core.trac.wordpress.org/ticket/40875\">ticket #40875</a>)</li></ul></li><li><strong>KSES&nbsp;:</strong> <ul><li>Prise en charge de l&rsquo;élément&nbsp;<code>&lt;ruby&gt;</code>&nbsp;et des autres éléments liés. Cela est particulièrement utile pour le contenu écrit en japonais ou chinois, via les éléments HTML&nbsp;<code>&lt;ruby&gt;</code>,&nbsp;<code>&lt;rt&gt;</code> et&nbsp;<code>&lt;rp&gt;</code>&nbsp;dans le&nbsp;<a href=\"https://html.spec.whatwg.org/multipage/text-level-semantics.html#the-ruby-element\">standard HTML</a>, ainsi que&nbsp;<code>&lt;rb&gt;</code>&nbsp;et&nbsp;<code>&lt;rtc&gt;</code>&nbsp;pour des options de formatage avancées (<a href=\"https://core.trac.wordpress.org/ticket/54698\">ticket #54698</a>)&nbsp;;</li><li>Ajout global de la prise en charge des attributs&nbsp;<code>lang</code>,&nbsp;<code>xml:lang</code>,&nbsp;<code>dir</code>&nbsp;en tant qu’attributs utilisables sur n&rsquo;importe quel élément HTML, ce qui améliore considérablement les possibilités de produire du contenu accessible (<a href=\"https://core.trac.wordpress.org/ticket/54699\">ticket #54699</a>)&nbsp;;</li><li>La fonction <code>get_the_author_link()</code> devient filtrable sur WordPress 6.0, via le filtre <code>get_the_author_link</code>, afin de permettre l&rsquo;altération de l’affichage du lien vers l’auteur/autrice de chaque publication (<a href=\"https://core.trac.wordpress.org/ticket/51859\">ticket #51859</a>)&nbsp;;</li></ul></li><li><strong>Internationnalisation&nbsp;:</strong><ul><li>Le séparateur des éléments de liste est maintenant une propriété de <code>WP_Locale</code> (<a href=\"https://core.trac.wordpress.org/ticket/39733\">voir le ticket #39733</a>)&nbsp;;</li><li>Les chemins de langues sont maintenant définissables dans la fonction  <code>register_block_type</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/54797\">ticket #54797</a>)&nbsp;;</li></ul></li><li><strong>Médias&nbsp;:</strong> suppression du filtre&nbsp;<code>attachment_fields_to_save</code>&nbsp;filter et dépréciation de la fonction&nbsp;<code>image_attachment_fields_to_save()</code>. Cette fonction n’était plus utilisée par le cœur WP&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/39108\">ticket #39108</a>)&nbsp;;</li><li><strong>Réseaux multisites&nbsp;:</strong> amélioration de la génération du cache des clés sur <code>WP_Site_Query</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/55462\">ticket #55462</a>)&nbsp;;</li><li><strong>Extensions&nbsp;:</strong> <ul><li>Ajout du filtre&nbsp;<code>plugin_install_description</code> (<a href=\"https://core.trac.wordpress.org/ticket/55480\">ticket #55480</a>)</li><li>Conversion de&nbsp;<code>apply_filters()</code>&nbsp;en une vraie fonction variadique. Une fonction variadique est une fonction d&rsquo;arité indéfinie, c&rsquo;est-à-dire qu&rsquo;elle accepte un nombre variable de paramètres (<a href=\"https://core.trac.wordpress.org/ticket/53218\">voir le ticket #53218</a>)&nbsp;;</li></ul></li><li><strong>Publications et types de publications&nbsp;:</strong> passage du paramètre <code>$update</code>&nbsp;aux filtres <code>wp_insert_post_data</code>&nbsp;et&nbsp;<code>wp_insert_attachment_data</code>. Cela facilite la détermination de l&rsquo;existence d&rsquo;une publication lors de sa mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/46228\">ticket #46228</a>)&nbsp;;</li><li><strong>Taxonomies :</strong> mutualisation de la traduction des libellés de taxonomies afin d&rsquo;améliorer les performances générales de l&rsquo;administration WordPress&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/26746\">ticket #26746</a>).</li></ul>\n\n\n\n<p>Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a rel=\"noreferrer noopener\" href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">l’extension Beta Tester</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec WordPress 6.0 RC1.&nbsp;Nous comptons sur vous pour vous assurer que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"has-small-font-size\"><em>Rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> d&rsquo;après le <a href=\"https://make.wordpress.org/core/2022/05/03/wordpress-6-0-field-guide/\">Field Guide en anglais</a>. Merci à <a href=\"https://profiles.wordpress.org/valer1e/\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a> et <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour la relecture.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://fr.wordpress.org/2022/05/04/guide-des-changements-techniques-de-wordpress-6-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordPress 5.9 « Joséphine »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Jan 2022 21:05:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2330\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:450:\"Bienvenue sur WordPress 5.9 «&#160;Joséphine&#160;»&#160;! Nous vous présentons WordPress 5.9, nommée «&#160;Joséphine&#160;» en l’honneur de la chanteuse internationale de jazz Joséphine Baker. Vous pouvez&#160;télécharger cette version ici&#160;ou effectuer la mise à jour directement depuis votre tableau de bord. En tant que militante des droits civiques depuis toujours, Joséphine Baker pensait que tout le monde pouvait [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:61885:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"682\" src=\"https://fr.wordpress.org/files/2022/01/5-9-josephine-1024x682.png\" alt=\"\" class=\"wp-image-2341\" srcset=\"https://fr.wordpress.org/files/2022/01/5-9-josephine-1024x682.png 1024w, https://fr.wordpress.org/files/2022/01/5-9-josephine-300x200.png 300w, https://fr.wordpress.org/files/2022/01/5-9-josephine-768x512.png 768w, https://fr.wordpress.org/files/2022/01/5-9-josephine.png 1264w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<h2 id=\"bienvenue-sur-wordpress-5-9-josephine\">Bienvenue sur WordPress 5.9 «&nbsp;Joséphine&nbsp;»&nbsp;!</h2>\n\n\n\n<p>Nous vous présentons WordPress 5.9, nommée «&nbsp;Joséphine&nbsp;» en l’honneur de la chanteuse internationale de jazz Joséphine Baker. Vous pouvez&nbsp;<a href=\"https://wordpress.org/download/\">télécharger cette version ici</a>&nbsp;ou effectuer la mise à jour directement depuis votre tableau de bord.</p>\n\n\n\n<p>En tant que militante des droits civiques depuis toujours, Joséphine Baker pensait que tout le monde pouvait vivre en harmonie ensemble, tout comme les différents instruments d&rsquo;un groupe de jazz se mélangent pour former un morceau complet. Mentionnons également que Joséphine Baker était naturalisée française et est d&rsquo;ailleurs entrée au Panthéon l’année dernière, en 2021.</p>\n\n\n\n<p>Activez donc une liste de lecture de votre service de musique préféré et profitez de ses célèbres interprétations de <em>« You are the greatest love »</em>, <em>« Sans Amour »</em> et <em>« Love is a dreamer »</em> tout en découvrant les fonctionnalités de cette toute nouvelle version de WordPress.</p>\n\n\n\n<span id=\"more-2330\"></span>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 id=\"l-edition-complete-de-votre-site-est-la\">L’édition complète de votre site est là.</h2>\n\n\n\n<p>Cela vous donne le contrôle sur l’ensemble de votre site, directement depuis votre administration WordPress.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-1.png\" alt=\"\" class=\"wp-image-12101\" /></figure>\n\n\n\n<h3 id=\"decouvrez-twenty-twenty-two\">Découvrez Twenty Twenty-Two</h3>\n\n\n\n<p>Et saluez l’arrivée du premier thème natif basé sur des blocs dans l’histoire de WordPress. Cela représente bien plus qu’un thème natif&nbsp;: c’est une toute nouvelle façon de travailler avec les thèmes WordPress.</p>\n\n\n\n<p>Les <a href=\"https://fr.wordpress.org/support/article/block-themes/\">thèmes basés sur des blocs</a> placent un large choix de conception dans vos mains, des jeux de couleurs aux combinaisons typographiques, en passant par les modèles de pages et les filtres d’images. Tout cela est compris sur <a href=\"https://fr.wordpress.org/support/article/site-editor/\">la nouvelle interface d’édition de site</a>. En un seul et même endroit, vous trouverez tout ce qu’il faut pour donner votre touche graphique à <em>Twenty Twenty‑Two</em>, et vous pourrez donner un nouveau départ à votre site.</p>\n\n\n\n<p>Le thème Twenty Twenty‑Two est déjà sans doute disponible sur votre site si vous l’avez mis à jour vers WP 5.9. Il a été installé en même temps que WordPress 5.9. Vous le trouverez avec&nbsp;les autres thèmes que vous avez installés.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-2.png\" alt=\"\" class=\"wp-image-12102\" /></figure>\n\n\n\n<h3 id=\"votre-palette-de-peinture-vous-attend\">Votre palette de peinture vous attend</h3>\n\n\n\n<p>D’autres thèmes basés sur des blocs et implémentant des fonctionnalités d’édition de site sont disponibles dans le répertoire officiel des thèmes, aux côtés de Twenty Twenty‑Two. Ils attendent simplement d’être essayés. Et bien d’autres viendront avec le temps&nbsp;!</p>\n\n\n\n<p>Lorsque vous utiliserez l’un de ces nouveaux thèmes, vous n’aurez plus besoin de l’outil de personnalisation. À la place, vous découvrirez la puissance de l’interface de gestion des styles globaux comprise dans l’éditeur de site. Tout comme avec Twenty Twenty‑Two, vous pourrez y bâtir l’apparence de votre site avec des outils prêts à l’emploi et une interface fluide et dynamique.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-3.png\" alt=\"\" class=\"wp-image-12103\" /></figure>\n\n\n\n<h3 id=\"le-bloc-navigation\">Le bloc navigation</h3>\n\n\n\n<p>Les blocs font leur entrée dans les menus de navigation, le cœur de l’expérience de visite de votre site.</p>\n\n\n\n<p>Le nouveau bloc Navigation vous donne la possibilité de choisir&nbsp;: un menu fluide ou plutôt un menu adapté à la taille d’écran de l’internaute. Qu’importe le menu que vous créez, vous pourrez le réutiliser partout où vous le souhaitez, que ce soit dans un nouveau modèle de page ou même après avoir changé de thème.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 id=\"encore-plus-d-ameliorations-et-de-mises-a-jour\">Encore plus d’améliorations et de mises à jour</h2>\n\n\n\n<p>Vous aimez bloguer ou produire de contenu&nbsp;? De nouveaux ajustements aideront votre expérience éditoriale et la rendront plus efficace.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-4.png\" alt=\"\" class=\"wp-image-12104\" /></figure>\n\n\n\n<h3 id=\"de-meilleurs-outils-de-controle-pour-les-blocs\">De meilleurs outils de contrôle pour les blocs</h3>\n\n\n\n<p>WordPress 5.9 contient de nouveaux outils typographiques et vous permet de contrôler votre mise en page, comme par exemple sur des détails tels que les espacements, les bordures, et bien plus encore. Cela vous aidera à apporter autant de soin à l’apparence générale de votre site qu’aux détails des contenus de vos pages.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-5.png\" alt=\"\" class=\"wp-image-12105\" /></figure>\n\n\n\n<h3 id=\"le-pouvoir-des-compositions\">Le pouvoir des compositions</h3>\n\n\n\n<p>Le répertoire de compositions de WordPress contient un grand nombre de compositions de blocs construites pour vous faire gagner du temps. Vous pouvez les utiliser et les modifier autant que vous le souhaitez. Vous voulez un en-tête ou un pied de page différent pour votre site&nbsp;? Vous pourrez en installer de nouveaux en quelques clics.</p>\n\n\n\n<p>Avec sa vue en grande largeur qui vous montre tous les détails de chaque élément, l’outil d’exploration de compositions vous permet de comparer les compositions entre elles et de choisir la plus adaptée pour votre site.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-6.png\" alt=\"\" class=\"wp-image-12106\" /></figure>\n\n\n\n<h3 id=\"une-refonte-de-la-vue-en-liste\">Une refonte de la vue en liste</h3>\n\n\n\n<p>Dans WP 5.9, la vue en liste vous permet de glisser-déposer votre contenu exactement où vous le souhaitez. Gérer des documents complexes est encore plus simple&nbsp;: des boutons vous permettent de déplier-replier les sections pendant que vous bâtissez votre site, et d’ajouter des ancres à vos blocs pour aider les internautes à naviguer dans la page.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2022/01/5-9-release-7.png\" alt=\"\" class=\"wp-image-12107\" /></figure>\n\n\n\n<h3 id=\"un-meilleur-bloc-galerie\">Un meilleur bloc galerie</h3>\n\n\n\n<p>Manipulez chaque image de vos blocs galeries de la même façon que vous manipuleriez un bloc image indépendant.</p>\n\n\n\n<p>Mettez en forme chaque image de votre galerie de façon indépendante des autres (par exemple avec un recadrage différent ou un filtre duotone), ou faites-les toutes se ressembler. Vous pourrez ensuite modifier la mise en page de la galerie avec un simple glisser-déposer.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 id=\"wordpress-5-9-pour-les-developpeurs-et-les-developpeuses\">WordPress 5.9 pour les développeurs et les développeuses</h2>\n\n\n\n<h3 id=\"le-fichier-theme-json-pour-les-themes-enfants\">Le fichier theme.json pour les thèmes enfants</h3>\n\n\n\n<p>Avec WP 5.9, le fichier <code>theme.json</code> prendra maintenant en charge les thèmes enfants. Cela signifie que vous pourrez construire un thème enfant directement depuis l’interface d’administration de WordPress, sans écrire la moindre ligne de code.&nbsp;</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">Voir la note de développement sur la fonctionnalité theme.json pour les thèmes enfants (en anglais)</a></p>\n\n\n\n<h3 id=\"verrouillage-des-blocs\">Verrouillage des blocs</h3>\n\n\n\n<p>Vous pouvez maintenant verrouiller tout ou partie des blocs au sein d’une composition, juste en ajoutant un attribut de verrouillage dans ses réglages au sein du fichier block.json. Laissez les rédacteur·ice·s libres de modifier le reste de la composition pour adapter son contenu.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">Voir la note de développement sur la fonctionnalité de verrouillage des blocs (en anglais)</a></p>\n\n\n\n<h3 id=\"plusieurs-feuilles-de-styles-pour-chaque-bloc\">Plusieurs feuilles de styles pour chaque bloc</h3>\n\n\n\n<p>Vous pouvez maintenant déclarer plus qu’une seule feuille de style par bloc. Cela vous permet de partager des styles entre différents blocs que vous avez créés, ou pour charger des styles pour des blocs individuels, ce qui fait que vos styles ne sont chargés que lorsque le bloc est utilisé. Pour en savoir plus, apprenez à&nbsp;<a href=\"https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/\">charger plusieurs feuilles de styles sur un bloc (en anglais)</a>.</p>\n\n\n\n<h3 id=\"un-bloc-galerie-remodele-de-a-a-z\">Un bloc galerie remodelé de A à Z</h3>\n\n\n\n<p>Les modifications du bloc galerie listées ci-dessus sont le résultat d’un remodelage complet. Si vous avez construit un thème ou une extension qui l’utilise, assurez-vous de lire la&nbsp;<a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">note technique de compatibilité du bloc galerie (en anglais)</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 id=\"en-savoir-plus-sur-les-fonctionnalites-de-wp-5-9\">En savoir plus sur les fonctionnalités de WP&nbsp;5.9</h3>\n\n\n\n<p>Vous voulez plonger dans 5.9 mais ne savez pas par où commencer&nbsp;? Rendez-vous sur&nbsp;<a href=\"https://learn.wordpress.org/\">learn.wordpress.org</a>&nbsp;pour consulter des ressources sur les nouvelles fonctionnalités de WordPress 5.9.</p>\n\n\n\n<p>Si vous cherchez des ressources en français, nous vous conseillons aussi de <a href=\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/\" data-type=\"post\" data-id=\"2304\">consulter la documentation produite par l&rsquo;équipe de traduction de WordPress en français tout spécialement pour WordPress&nbsp;5.9</a>.</p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3 id=\"consultez-le-guide-de-la-version-pour-en-savoir-plus\">Consultez le guide de la version pour en savoir plus&nbsp;!</h3>\n\n\n\n<p>Consultez le guide des changements techniques de WordPress&nbsp;5.9. Il met en avant les notes de développement pour chaque modification que vous souhaiteriez approfondir&nbsp;:&nbsp;<a href=\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/\" data-type=\"post\" data-id=\"2264\">guide des changements techniques de WordPress 5.9 en français</a></p>\n\n\n\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 id=\"l-equipe-de-direction-de-wordpress-5-9\"><strong>L’équipe de direction de WordPress&nbsp;5.9</strong></h2>\n\n\n\n<p>La version 5.9 de WordPress 5.9 a été dirigée par <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, avec l’assistance de l’équipe de direction suivante&nbsp;:</p>\n\n\n\n<ul><li>Directeur de la version&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li><li>Directrice technique et coordinatrice de la version&nbsp;: <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a></li><li>Responsables projet&nbsp;: <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> et <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a></li><li>Responsables techniques côté éditeur/Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> et <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li><li>Responsables du nouveau thème&nbsp;: <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> et <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a></li><li>Rédacteur technique&nbsp;: <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a></li><li>Responsables de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> et <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a></li><li>Responsables marketing &amp; communications&nbsp;: <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> et <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a></li><li>Responsables des tests&nbsp;: <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> et <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a></li></ul>\n\n\n\n<p>WordPress 5.9 reflète l’impressionnant travail accompli par of 624 contributrices et contributeurs bénévoles. Cela a abouti à <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=5.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">370 tickets sur Trac</a> et plus de <a href=\"https://github.com/WordPress/gutenberg/compare/v10.8.0...v11.9.0\">1900 <em>pull requests</em> sur GitHub</a>. Merci à toutes et à tous&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/2linctools/\">2linctools</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a>, <a href=\"https://profiles.wordpress.org/abesell132/\">abesell132</a>, <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a>, <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a>, <a href=\"https://profiles.wordpress.org/wpmudev-support8/\">Adam &#8211; WPMU DEV Support</a>, <a href=\"https://profiles.wordpress.org/bosconiandynamics/\">Adam Bosco</a>, <a href=\"https://profiles.wordpress.org/adam3128/\">Adam Morgan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zielinski</a>, <a href=\"https://profiles.wordpress.org/addiestavlo/\">Addie</a>, <a href=\"https://profiles.wordpress.org/aadilali/\">Adil Ali</a>, <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a>, <a href=\"https://profiles.wordpress.org/aezazshekh/\">Aezaz Shekh</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a>, <a href=\"https://profiles.wordpress.org/ajotka/\">ajotka</a>, <a href=\"https://profiles.wordpress.org/soniakash/\">Akash Soni</a>, <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/alanjacobmathew/\">Alan Jacob Mathew</a>, <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexvorn2/\">Alexandru Vornicescu</a>, <a href=\"https://profiles.wordpress.org/alexeydemidov/\">alexeydemidov</a>, <a href=\"https://profiles.wordpress.org/alexislloyd/\">Alexis Lloyd</a>, <a href=\"https://profiles.wordpress.org/alexstine/\">alexstine</a>, <a href=\"https://profiles.wordpress.org/algala/\">AlGala</a>, <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a>, <a href=\"https://profiles.wordpress.org/almendron/\">almendron</a>, <a href=\"https://profiles.wordpress.org/amandariu/\">Amanda Riu</a>, <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a>, <a href=\"https://profiles.wordpress.org/nosolosw/\">André</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a>, <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/anevins/\">Andrew Nevins</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a>, <a href=\"https://profiles.wordpress.org/oandregal/\">André</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a>, <a href=\"https://profiles.wordpress.org/andy-schmidt/\">Andy Schmidt</a>, <a href=\"https://profiles.wordpress.org/andynick/\">andynick</a>, <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a>, <a href=\"https://profiles.wordpress.org/anjanavasan/\">Anjana Vasan</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a>, <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a>, <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a>, <a href=\"https://profiles.wordpress.org/anthonyeden/\">Anthony Eden</a>, <a href=\"https://profiles.wordpress.org/paranoia1906/\">Anthony Ledesma</a>, <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a>, <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a>, <a href=\"https://profiles.wordpress.org/arena/\">arena</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a>, <a href=\"https://profiles.wordpress.org/ashfame/\">Ashfame</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/baelx/\">baelx</a>, <a href=\"https://profiles.wordpress.org/allerune/\">Bartlomiej</a>, <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a>, <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a>, <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a>, <a href=\"https://profiles.wordpress.org/utz119/\">Benachi</a>, <a href=\"https://profiles.wordpress.org/benitolopez/\">benitolopez</a>, <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a>, <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a>, <a href=\"https://profiles.wordpress.org/benjaminanakena/\">benjamin.anakena</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">Bernhard Reiter</a>, <a href=\"https://profiles.wordpress.org/bgardner/\">bgardner</a>, <a href=\"https://profiles.wordpress.org/bijayyadav/\">bijayyadav</a>, <a href=\"https://profiles.wordpress.org/binarykitten/\">BinaryKitten</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a>, <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a>, <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/bravokeyl/\">bravokeyl</a>, <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a>, <a href=\"https://profiles.wordpress.org/rzen/\">Brian Richards</a>, <a href=\"https://profiles.wordpress.org/bronsonquick/\">bronsonquick</a>, <a href=\"https://profiles.wordpress.org/ribaricplusplus/\">Bruno Ribaric</a>, <a href=\"https://profiles.wordpress.org/brylie/\">Brylie Christopher Oxley</a>, <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a>, <a href=\"https://profiles.wordpress.org/calebwoodbridge/\">calebwoodbridge</a>, <a href=\"https://profiles.wordpress.org/carepsules/\">carepsules</a>, <a href=\"https://profiles.wordpress.org/carike/\">Carike</a>, <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/vefusion/\">Carlos Garcia</a>, <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/cdyerkes/\">cdyerkes</a>, <a href=\"https://profiles.wordpress.org/ceyhun0/\">Ceyhun Ozugur</a>, <a href=\"https://profiles.wordpress.org/shireling/\">Chad</a>, <a href=\"https://profiles.wordpress.org/chiaki/\">Chiaki</a>, <a href=\"https://profiles.wordpress.org/chintan1896/\">Chintan hingrajiya</a>, <a href=\"https://profiles.wordpress.org/chipsnyder/\">Chip Snyder</a>, <a href=\"https://profiles.wordpress.org/cbringmann/\">Chloe Bringmann</a>, <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>, <a href=\"https://profiles.wordpress.org/cklosows/\">Chris Klosowski</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/christianztamayo/\">Christian Tamayo</a>, <a href=\"https://profiles.wordpress.org/amethystanswers/\">Christina Workman</a>, <a href=\"https://profiles.wordpress.org/vimes1984/\">Christopher Churchill</a>, <a href=\"https://profiles.wordpress.org/clucasrowlands/\">clucasrowlands</a>, <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a>, <a href=\"https://profiles.wordpress.org/callye/\">Collieth Clarke</a>, <a href=\"https://profiles.wordpress.org/collizo4sky/\">Collins Agbonghama</a>, <a href=\"https://profiles.wordpress.org/copons/\">Copons</a>, <a href=\"https://profiles.wordpress.org/coreyw/\">Corey</a>, <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a>, <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a>, <a href=\"https://profiles.wordpress.org/craigfrancis/\">craigfrancis</a>, <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a>, <a href=\"https://profiles.wordpress.org/critterverse/\">critterverse</a>, <a href=\"https://profiles.wordpress.org/littlebigthing/\">Csaba (LittleBigThings)</a>, <a href=\"https://profiles.wordpress.org/davidszabo/\">Dávid Szabó</a>, <a href=\"https://profiles.wordpress.org/daisyo/\">Daisy Olsen</a>, <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/danfarrow/\">Dan Farrow</a>, <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/chthnc/\">Daniel Shaw</a>, <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a>, <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a>, <a href=\"https://profiles.wordpress.org/dariak/\">Daria</a>, <a href=\"https://profiles.wordpress.org/daschmi/\">Daschmi</a>, <a href=\"https://profiles.wordpress.org/datagutten/\">datagutten</a>, <a href=\"https://profiles.wordpress.org/datainterlock/\">datainterlock</a>, <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a>, <a href=\"https://profiles.wordpress.org/davidanderson/\">David Anderson</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a>, <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a>, <a href=\"https://profiles.wordpress.org/dgwyer/\">David Gwyer</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/davidkryzaniak/\">David Kryzaniak</a>, <a href=\"https://profiles.wordpress.org/davidmosterd/\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a>, <a href=\"https://profiles.wordpress.org/dryanpress/\">David Ryan</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/davidwebca/\">davidwebca</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/deepaklalwani/\">Deepak Lalwani</a>, <a href=\"https://profiles.wordpress.org/denisco/\">Denis Yanchevskiy</a>, <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhanendran/\">Dhanendran</a>, <a href=\"https://profiles.wordpress.org/dhusakovic/\">dhusakovic</a>, <a href=\"https://profiles.wordpress.org/diedeexterkate/\">DiedeExterkate</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/dingo_d/\">dingo-d</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dlt101/\">dlt101</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/donmhico/\">donmhico</a>, <a href=\"https://profiles.wordpress.org/codezen8/\">Donna Botti</a>, <a href=\"https://profiles.wordpress.org/dontgo2sleep/\">dontgo2sleep</a>, <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/dpegasusm/\">dpegasusm</a>, <a href=\"https://profiles.wordpress.org/raubvogel/\">Dr. Ronny Harbich</a>, <a href=\"https://profiles.wordpress.org/dratwas/\">dratwas</a>, <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/drosmog/\">drosmog</a>, <a href=\"https://profiles.wordpress.org/dustinrue/\">dustinrue</a>, <a href=\"https://profiles.wordpress.org/seedsca/\">ecotechie</a>, <a href=\"https://profiles.wordpress.org/ehtis/\">ehtis</a>, <a href=\"https://profiles.wordpress.org/ekojr/\">EkoJR</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a>, <a href=\"https://profiles.wordpress.org/empatogen/\">empatogen</a>, <a href=\"https://profiles.wordpress.org/enchiridion/\">Enchiridion</a>, <a href=\"https://profiles.wordpress.org/enej/\">Enej Bajgorić</a>, <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a>, <a href=\"https://profiles.wordpress.org/erayalakese/\">erayalakese</a>, <a href=\"https://profiles.wordpress.org/teachlynx/\">Eric Malalel</a>, <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a>, <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a>, <a href=\"https://profiles.wordpress.org/etoledo/\">etoledo</a>, <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a>, <a href=\"https://profiles.wordpress.org/fedepia/\">fedepia</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/felipeloureirosantos/\">Felipe Santos</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/fpcsjames/\">FPCSJames</a>, <a href=\"https://profiles.wordpress.org/piewp/\">fperdaan</a>, <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a>, <a href=\"https://profiles.wordpress.org/fcolombo/\">Francesco</a>, <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">fullofcaffeine</a>, <a href=\"https://profiles.wordpress.org/galbaras/\">Gal Baras</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gazchap/\">gazchap</a>, <a href=\"https://profiles.wordpress.org/generosus/\">generosus</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/revgeorge/\">George Hotelling</a>, <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a>, <a href=\"https://profiles.wordpress.org/gilbitron/\">Gilbert Pellegrom</a>, <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a>, <a href=\"https://profiles.wordpress.org/goldsounds/\">goldsounds</a>, <a href=\"https://profiles.wordpress.org/gkloveweb/\">Govind</a>, <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a>, <a href=\"https://profiles.wordpress.org/gregrickaby/\">Greg Rickaby</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a>, <a href=\"https://profiles.wordpress.org/hansjovisyoast/\">Hans-Christiaan Braun</a>, <a href=\"https://profiles.wordpress.org/haosun/\">haosun</a>, <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a>, <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman</a>, <a href=\"https://profiles.wordpress.org/azhiyadev/\">Hauwa Abashiya</a>, <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a>, <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/herbmiller/\">herbmiller</a>, <a href=\"https://profiles.wordpress.org/hermpheus/\">Herm Martini</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">Herre Groen</a>, <a href=\"https://profiles.wordpress.org/hilayt24/\">hilayt24</a>, <a href=\"https://profiles.wordpress.org/hirofumi2012/\">hirofumi2012</a>, <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a>, <a href=\"https://profiles.wordpress.org/h71/\">Hossein Farahani</a>, <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a>, <a href=\"https://profiles.wordpress.org/hudson-atwell/\">Hudson Atwell</a>, <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a>, <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianhayes94/\">ianhayes94</a>, <a href=\"https://profiles.wordpress.org/ianmjones/\">ianmjones</a>, <a href=\"https://profiles.wordpress.org/ignatggeorgiev/\">Ignat Georgiev</a>, <a href=\"https://profiles.wordpress.org/ibenic/\">Igor Benic</a>, <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a>, <a href=\"https://profiles.wordpress.org/infected/\">infected</a>, <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/iluy/\">Isaac</a>, <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a>, <a href=\"https://profiles.wordpress.org/ismaeld/\">ismaeld</a>, <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jackreichert/\">Jack Reichert</a>, <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jakubtyrcha/\">jakub.tyrcha</a>, <a href=\"https://profiles.wordpress.org/mcjambi/\">Jam Viet</a>, <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a>, <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a>, <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a>, <a href=\"https://profiles.wordpress.org/janwoostendorp/\">janw.oostendorp</a>, <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a>, <a href=\"https://profiles.wordpress.org/evermail/\">Jason R. Johnston</a>, <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a>, <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a>, <a href=\"https://profiles.wordpress.org/jayupadhyay01/\">Jay Upadhyay</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>, <a href=\"https://profiles.wordpress.org/teucrium/\">Jean-Philippe</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jeremyescott/\">Jeremy Scott</a>, <a href=\"https://profiles.wordpress.org/jeremyyip/\">Jeremy Yip</a>, <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a>, <a href=\"https://profiles.wordpress.org/engelen/\">Jesper van Engelen</a>, <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a>, <a href=\"https://profiles.wordpress.org/jigneshnakrani/\">Jignesh Nakrani</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joegasper/\">joegasper</a>, <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a>, <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/zenithcity/\">john zenith</a>, <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio (CLPTE)</a>, <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a>, <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a>, <a href=\"https://profiles.wordpress.org/josephdickson/\">Joseph Dickson</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha Haden</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jsnajdr/\">jsnajdr</a>, <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>, <a href=\"https://profiles.wordpress.org/juanruitina/\">juanruitina</a>, <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/junaidbhura/\">Junaid Bhura</a>, <a href=\"https://profiles.wordpress.org/nukaga/\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/justindocanto/\">Justin DoCanto</a>, <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a>, <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>, <a href=\"https://profiles.wordpress.org/kallookoo/\">kallookoo</a>, <a href=\"https://profiles.wordpress.org/akabarikalpesh/\">Kalpesh Akabari</a>, <a href=\"https://profiles.wordpress.org/kaneva/\">kaneva</a>, <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a>, <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a>, <a href=\"https://profiles.wordpress.org/sourav926/\">Keramot UL Islam</a>, <a href=\"https://profiles.wordpress.org/kingkero/\">kero</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a>, <a href=\"https://profiles.wordpress.org/kevinfodness/\">Kevin Fodness</a>, <a href=\"https://profiles.wordpress.org/keyur5/\">keyur5</a>, <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/vdwijngaert/\">Koen Van den Wijngaert</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/kurudrive/\">kurudrive</a>, <a href=\"https://profiles.wordpress.org/kwisatz/\">kwisatz</a>, <a href=\"https://profiles.wordpress.org/devnel/\">Kyle Nel</a>, <a href=\"https://profiles.wordpress.org/kzeni/\">KZeni</a>, <a href=\"https://profiles.wordpress.org/lalitjalandhar/\">lalitjalandhar</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/leogermani/\">leogermani</a>, <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a>, <a href=\"https://profiles.wordpress.org/liammitchell/\">liammitchell</a>, <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a>, <a href=\"https://profiles.wordpress.org/linux4me2/\">linux4me2</a>, <a href=\"https://profiles.wordpress.org/webaxones/\">Loïc Antignac</a>, <a href=\"https://profiles.wordpress.org/loranrendel/\">Loran A. Rendel</a>, <a href=\"https://profiles.wordpress.org/karpstrucking/\">Lucas Karpiuk</a>, <a href=\"https://profiles.wordpress.org/lucasw89/\">lucasw89</a>, <a href=\"https://profiles.wordpress.org/lucatume/\">lucatume</a>, <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a>, <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/luovalabs/\">luovalabs</a>, <a href=\"https://profiles.wordpress.org/lynk/\">lynk</a>, <a href=\"https://profiles.wordpress.org/asif2bd/\">M Asif Rahman</a>, <a href=\"https://profiles.wordpress.org/gorby31/\">Madalin Gorbanescu</a>, <a href=\"https://profiles.wordpress.org/aetherunbound/\">Madison</a>, <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a>, <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a>, <a href=\"https://profiles.wordpress.org/malae/\">Malae</a>, <a href=\"https://profiles.wordpress.org/malthert/\">malthert</a>, <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a>, <a href=\"https://profiles.wordpress.org/manishamakhija/\">Manisha Makhija</a>, <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a>, <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/marekhrabe/\">Marek Hrabe</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>, <a href=\"https://profiles.wordpress.org/wetah/\">Mateus Machado Luna</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/mhuntdesign/\">Matt</a>, <a href=\"https://profiles.wordpress.org/mattchowning/\">Matt Chowning</a>, <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>, <a href=\"https://profiles.wordpress.org/mattwiebe/\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattoakley/\">mattoakley</a>, <a href=\"https://profiles.wordpress.org/wppunk/\">Max</a>, <a href=\"https://profiles.wordpress.org/max-dayala/\">MaxD</a>, <a href=\"https://profiles.wordpress.org/maximeculea/\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mclaurent/\">mclaurent</a>, <a href=\"https://profiles.wordpress.org/medusor/\">MEDUSOR</a>, <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a>, <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/mgol/\">mgol</a>, <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a>, <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a>, <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/michelwppi/\">Michel &#8211; xiligroup dev</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mikaelmayer/\">mikaelmayer</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a>, <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">mirka</a>, <a href=\"https://profiles.wordpress.org/mjaschen/\">mjaschen</a>, <a href=\"https://profiles.wordpress.org/mjulian7/\">mjulian7</a>, <a href=\"https://profiles.wordpress.org/mmxxi/\">mmxxi</a>, <a href=\"https://profiles.wordpress.org/moch11/\">moch11</a>, <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a>, <a href=\"https://profiles.wordpress.org/mt8biz/\">moto hachi</a>, <a href=\"https://profiles.wordpress.org/computerguru/\">mqudsi</a>, <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a>, <a href=\"https://profiles.wordpress.org/mrjoeldean/\">mrjoeldean</a>, <a href=\"https://profiles.wordpress.org/mtoensing/\">mtoensing</a>, <a href=\"https://profiles.wordpress.org/wparslan/\">Muhammad Arslan</a>, <a href=\"https://profiles.wordpress.org/muhammadfaizanhaidar/\">Muhammad Faizan Haidar</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/musabshakeel/\">Musab Shakeel</a>, <a href=\"https://profiles.wordpress.org/amustaque97/\">Mustaque Ahmed</a>, <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a>, <a href=\"https://profiles.wordpress.org/nalininonstopnewsuk/\">Nalini Thakor</a>, <a href=\"https://profiles.wordpress.org/namithjawahar/\">Namith Jawahar</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/natewr/\">NateWr</a>, <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/nettsite/\">NettSite</a>, <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nickcernis/\">nickcernis</a>, <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a>, <a href=\"https://profiles.wordpress.org/jainnidhi/\">Nidhi Jain</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a>, <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nlpro/\">nlpro</a>, <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a>, <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a>, <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a>, <a href=\"https://profiles.wordpress.org/omarreiss/\">Omar Reiss</a>, <a href=\"https://profiles.wordpress.org/opr18/\">opr18</a>, <a href=\"https://profiles.wordpress.org/ellenbauer/\">Outzen Larkin</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/ovann86/\">ovann86</a>, <a href=\"https://profiles.wordpress.org/ovidiul/\">ovidiul</a>, <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a>, <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a>, <a href=\"https://profiles.wordpress.org/iaaxpage/\">page-carbajal</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pankajmohale/\">Pankaj Mohale</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patrick-b/\">Patrick B</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pabline/\">Paul Bunkham</a>, <a href=\"https://profiles.wordpress.org/rixeo/\">Paul Kevin</a>, <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a>, <a href=\"https://profiles.wordpress.org/pschrottky/\">Paul Von Schrottky</a>, <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a>, <a href=\"https://profiles.wordpress.org/pbking/\">pbking</a>, <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a>, <a href=\"https://profiles.wordpress.org/pputzer/\">pepe</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/walbo/\">Petter Walbø Johnsgård</a>, <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a>, <a href=\"https://profiles.wordpress.org/philipmjackson/\">Philip Jackson</a>, <a href=\"https://profiles.wordpress.org/pierlo/\">Pierre Gordon</a>, <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a>, <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a>, <a href=\"https://profiles.wordpress.org/powerbuoy/\">powerbuoy</a>, <a href=\"https://profiles.wordpress.org/praem90/\">praem90</a>, <a href=\"https://profiles.wordpress.org/promz/\">Pramod Jodhani</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a>, <a href=\"https://profiles.wordpress.org/procodewp/\">procodewp</a>, <a href=\"https://profiles.wordpress.org/psealock/\">psealock</a>, <a href=\"https://profiles.wordpress.org/psufan/\">psufan</a>, <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/radixweb/\">Radixweb</a>, <a href=\"https://profiles.wordpress.org/rtm909/\">Rahul Mehta</a>, <a href=\"https://profiles.wordpress.org/ralucastn/\">ralucastn</a>, <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/ravipatel/\">ravipatel</a>, <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a>, <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a>, <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld/\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a>, <a href=\"https://profiles.wordpress.org/richardfoley/\">Richard Foley</a>, <a href=\"https://profiles.wordpress.org/richards1052/\">richards1052</a>, <a href=\"https://profiles.wordpress.org/rickcurran/\">Rick Curran</a>, <a href=\"https://profiles.wordpress.org/rbrishabh/\">Rishabh Budhiraja</a>, <a href=\"https://profiles.wordpress.org/saju4wordpress/\">Riyadh Ahmed</a>, <a href=\"https://profiles.wordpress.org/rmartinezduque/\">rmartinezduque</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/robertghetau/\">robertght</a>, <a href=\"https://profiles.wordpress.org/robtarr/\">robtarr</a>, <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a>, <a href=\"https://profiles.wordpress.org/rohan013/\">Rohan Rawat</a>, <a href=\"https://profiles.wordpress.org/rhnsharma/\">Rohan Sharma</a>, <a href=\"https://profiles.wordpress.org/ronakganatra/\">Ronak Ganatra</a>, <a href=\"https://profiles.wordpress.org/rkohilakis/\">Roxy Kohilakis</a>, <a href=\"https://profiles.wordpress.org/russhylov/\">Ruslan</a>, <a href=\"https://profiles.wordpress.org/rviscomi/\">rviscomi</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/soean/\">Sören Wrede</a>, <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a>, <a href=\"https://profiles.wordpress.org/sabrib/\">Sabri Bouchaala</a>, <a href=\"https://profiles.wordpress.org/zeo/\">Safirul Alredha</a>, <a href=\"https://profiles.wordpress.org/solarissmoke/\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a>, <a href=\"https://profiles.wordpress.org/sandipmondal/\">Sandip Mondal &#8211; a11n</a>, <a href=\"https://profiles.wordpress.org/sanketchodavadiya/\">Sanket Chodavadiya</a>, <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a>, <a href=\"https://profiles.wordpress.org/sarayourfriend/\">sarayourfriend</a>, <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiyamoorthy V</a>, <a href=\"https://profiles.wordpress.org/savicmarko1985/\">savicmarko1985</a>, <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a>, <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a>, <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a>, <a href=\"https://profiles.wordpress.org/scruffian/\">scruffian</a>, <a href=\"https://profiles.wordpress.org/seanmcmillan/\">Sean McMillan</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/omaeyusuke/\">Segayuu</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sergiocinos/\">Sergio Cinos</a>, <a href=\"https://profiles.wordpress.org/sergioestevao/\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/shaharyar10/\">Shaharyar Afzal</a>, <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a>, <a href=\"https://profiles.wordpress.org/shohag121/\">Shazahanul Islam Shohag</a>, <a href=\"https://profiles.wordpress.org/shimon246/\">shimon246</a>, <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/shivapoudel/\">Shiva Poudel</a>, <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth</a>, <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a>, <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a>, <a href=\"https://profiles.wordpress.org/simonhammes/\">simonhammes</a>, <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/siobhan/\">Siobhan</a>, <a href=\"https://profiles.wordpress.org/sirreal/\">sirreal</a>, <a href=\"https://profiles.wordpress.org/sjlevy/\">sjlevy</a>, <a href=\"https://profiles.wordpress.org/skunkbad/\">skunkbad</a>, <a href=\"https://profiles.wordpress.org/smit08/\">Smit Rathod</a>, <a href=\"https://profiles.wordpress.org/snapfractalpop/\">snapfractalpop</a>, <a href=\"https://profiles.wordpress.org/sourovroy/\">Sourov Roy</a>, <a href=\"https://profiles.wordpress.org/spytzo/\">spytzo</a>, <a href=\"https://profiles.wordpress.org/ssergei/\">ssergei</a>, <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a>, <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a>, <a href=\"https://profiles.wordpress.org/hypest/\">Stefanos Togoulidis</a>, <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/strider72/\">Stephen Rider</a>, <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a>, <a href=\"https://profiles.wordpress.org/stevehenty/\">Steve Henty</a>, <a href=\"https://profiles.wordpress.org/stevegs/\">stevegs</a>, <a href=\"https://profiles.wordpress.org/stormrockwell/\">Storm Rockwell</a>, <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a>, <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a>, <a href=\"https://profiles.wordpress.org/tareiking/\">Tarei King</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a>, <a href=\"https://profiles.wordpress.org/terraling/\">terraling</a>, <a href=\"https://profiles.wordpress.org/terriann/\">Terri Ann</a>, <a href=\"https://profiles.wordpress.org/wildworks/\">Tetsuaki Hamano</a>, <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a>, <a href=\"https://profiles.wordpress.org/tweetythierry/\">Thierry Muller</a>, <a href=\"https://profiles.wordpress.org/thulshof/\">Thijs Hulshof</a>, <a href=\"https://profiles.wordpress.org/thimalw/\">Thimal Wickremage</a>, <a href=\"https://profiles.wordpress.org/thisiswilliam/\">thisiswilliam</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timlappe/\">timlappe</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/titsmaker/\">titsmaker</a>, <a href=\"https://profiles.wordpress.org/tjcafferkey/\">tjcafferkey</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/tomalec/\">Tomek</a>, <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a>, <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a>, <a href=\"https://profiles.wordpress.org/ttahmouch/\">Tony Tahmouch</a>, <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/sierratr/\">Tracy</a>, <a href=\"https://profiles.wordpress.org/travisnorthcutt/\">Travis Northcutt</a>, <a href=\"https://profiles.wordpress.org/tubys/\">tubys</a>, <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a>, <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a>, <a href=\"https://profiles.wordpress.org/desaiuditd/\">Udit Desai</a>, <a href=\"https://profiles.wordpress.org/umesh84/\">umesh84</a>, <a href=\"https://profiles.wordpress.org/devutpol/\">Utpol Deb Nath</a>, <a href=\"https://profiles.wordpress.org/webulous/\">Venkat Raj</a>, <a href=\"https://profiles.wordpress.org/versusbassz/\">versusbassz</a>, <a href=\"https://profiles.wordpress.org/bartoszgrzesik/\">verybg</a>, <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a>, <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a>, <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a>, <a href=\"https://profiles.wordpress.org/vladytimy/\">Vlad T</a>, <a href=\"https://profiles.wordpress.org/vondelphia/\">Vondelphia.com</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a>, <a href=\"https://profiles.wordpress.org/wb1234/\">wb1234</a>, <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wfmattr/\">WFMattR</a>, <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wojsmol/\">wojsmol</a>, <a href=\"https://profiles.wordpress.org/woodyhayday/\">woodyhayday</a>, <a href=\"https://profiles.wordpress.org/wp_kc/\">wp_kc</a>, <a href=\"https://profiles.wordpress.org/wpnomad/\">wpnomad a11n</a>, <a href=\"https://profiles.wordpress.org/wpweaver/\">wpweaver</a>, <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/yvettesonneveld/\">Yvette Sonneveld</a>, <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a>, and <a href=\"https://profiles.wordpress.org/zoiec/\">zoiec</a>.</p>\n\n\n\n<p>Lors de la publication de ce communiqué de presse officiel, WordPress 5.9 est déjà disponible dans 71 langues ayant traduit 90&nbsp;% ou plus de la version. Les traductrices et traducteurs de la communauté travaillent dur pour vous permettre d’utiliser WordPress dans votre langue natale.</p>\n\n\n\n<p>Merci en particulier à toutes les personnes qui ont aidé à traduire WordPress 5.9 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/arpe5\">Arpe5</a>,&nbsp;<a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/guerneves\">guerneves</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juliobox\">Julio Potier</a>,&nbsp;<a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>,&nbsp;<a href=\"https://profiles.wordpress.org/oellin\">Magali</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>,&nbsp;<a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nicolasricher\">Nicolas Richer</a>,&nbsp;<a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/valer1e\">valer1e</a>,&nbsp;<a href=\"https://profiles.wordpress.org/weartdevelopment\">WeArt Development</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wplmillet\">wplmillet</a>.</p>\n\n\n\n<p>Merci également aux personnes qui contribuent bénévolement aux <a href=\"https://wordpress.org/support/\">forums de support officiels</a>. Elles répondent aux questions que se posent les gens qui utilisent WordPress partout dans le monde. Cela entretien le succès de WordPress depuis la toute première version sortie en 2003.</p>\n\n\n\n<p><em>Si vous souhaitez contribuer à WordPress, nous vous invitons à découvrir le fonctionnement de ce CMS open source sur le site <a href=\"https://make.wordpress.org/\">Make WordPress</a> et à en savoir plus sur le fonctionnement de l’équipe cœur de WP sur son <a href=\"https://make.wordpress.org/core/\">blog de développement</a>.</em></p>\n\n\n\n<p>Bonne mise à jour&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://fr.wordpress.org/2022/01/25/wordpress-5-9/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"WordPress 5.9 : documentation en français des fonctionnalités de l’éditeur de site\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Jan 2022 15:40:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2304\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"À quelques jours de la sortie de WordPress 5.9 (prévue mardi 25 janvier 2022), l’équipe de documentation de WordPress en français vient de publier de nouveaux contenus afin de documenter les nouveautés de cette version. Ces pages de documentation sont enrichies de nombreuses captures d’écran et de quelques vidéos, et sont en particulier destinées aux [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3514:\"\n<p>À quelques jours de la sortie de WordPress 5.9 (prévue mardi 25 janvier 2022), l’équipe de documentation de WordPress en français vient de publier de nouveaux contenus afin de documenter les nouveautés de cette version.</p>\n\n\n\n<span id=\"more-2304\"></span>\n\n\n\n<p>Ces pages de documentation sont enrichies de nombreuses captures d’écran et de quelques vidéos, et sont en particulier destinées aux profils de webmasters.</p>\n\n\n\n<p>Si vous avez un profil plus technique nous vous conseillons également la lecture de <a href=\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/\" data-type=\"post\" data-id=\"2264\">cet article détaillant les changements techniques à venir sur WordPress 5.9</a>.</p>\n\n\n\n<h2 id=\"la-fonctionnalite-d-edition-complete-de-site-full-site-editing\">La fonctionnalité d’édition complète de site (<em>full site editing</em>)</h2>\n\n\n\n<p>Avec WordPress 5.9, de nouvelles fonctionnalités font leur apparition dans votre éditeur et vont vous permettre de modifier l’apparence et la mise en page de l’ensemble de votre site (vous retrouverez souvent ce concept sous son appellation anglophone <em>full site editing</em>), de l’en-tête au pied de page, en passant par la création de vos propres modèles de pages personnalisés.</p>\n\n\n\n<p>Avec ces nouvelles pages de documentation, vous pourrez avoir une connaissance plus précise de ce que propose l’<a href=\"https://fr.wordpress.org/support/article/site-editor/\">éditeur de site</a>, de ce que sont les <a href=\"https://fr.wordpress.org/support/article/theme-base-sur-des-blocs/\">thèmes basés sur des blocs</a>, mais aussi avoir une <a href=\"https://fr.wordpress.org/support/article/styles-overview/\">vue d’ensemble des styles globaux</a>, de comprendre comment utiliser <a href=\"https://fr.wordpress.org/support/article/template-editor/\">l’éditeur de modèles</a>, et de prendre en main les nouveaux blocs avancés&nbsp;: le <a href=\"https://fr.wordpress.org/support/article/navigation-block/\">bloc Navigation</a>, le <a href=\"https://fr.wordpress.org/support/article/template-part-block/\">bloc Élément de modèle</a>, ou encore le <a href=\"https://fr.wordpress.org/support/article/query-loop-block/\">bloc Boucle de requête</a>.</p>\n\n\n\n<p>Vous retrouverez toutes ces pages dans la nouvelle catégorie <a href=\"https://fr.wordpress.org/support/category/editeur-de-site/\">Éditeur de site</a> au sein de la documentation officielle de WordPress en français.</p>\n\n\n\n<p>Merci à toutes les personnes qui ont contribué à l’écriture ou à la relecture de ces nouvelles pages de documentation&nbsp;: <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/pasglop\">Patrick Olivaud</a>, <a href=\"https://profiles.wordpress.org/chaton666\">Marie Comet</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a> et <a href=\"https://profiles.wordpress.org/valer1e/\">Valérie Galassi</a>.</p>\n\n\n\n<p>Si vous avez des suggestions d’améliorations et de corrections, vous pouvez rejoindre l’équipe de documentation de WordPress en français sur le <a href=\"https://wpfr.net/slack\">Slack WordPress francophone</a>, canal <code>#documentation-fr</code>.</p>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">Communiqué co-rédigé par Jenny Dupuy et Jb Audras</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fr.wordpress.org/2022/01/17/wordpress-5-9-documentation-en-francais-des-fonctionnalites-de-lediteur-de-site/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Guide des changements techniques à venir sur WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Jan 2022 08:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2264\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:353:\"La sortie de WordPress 5.9 est prévue pour le 25 janvier 2022. WordPress 5.9 offrira la possibilité de construire l’ensemble de votre site en utilisant des blocs. Cette nouvelle version majeure apportera en effet des outils de conception avancés pour vous permettre de créer des mises en page personnalisées pour votre thème, et de les [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:32531:\"\n<figure class=\"wp-block-image size-full\"><a href=\"https://fr.wordpress.org/files/2022/01/wordpress-59.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1000\" height=\"600\" src=\"https://fr.wordpress.org/files/2022/01/wordpress-59.png\" alt=\"WordPress 5.9\" class=\"wp-image-2265\" srcset=\"https://fr.wordpress.org/files/2022/01/wordpress-59.png 1000w, https://fr.wordpress.org/files/2022/01/wordpress-59-300x180.png 300w, https://fr.wordpress.org/files/2022/01/wordpress-59-768x461.png 768w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></a></figure>\n\n\n\n<p class=\"has-text-align-center\" style=\"font-size:24px\">La sortie de WordPress 5.9 est prévue <br>pour le 25 janvier 2022.</p>\n\n\n\n<p>WordPress 5.9 offrira la possibilité de construire l’ensemble de votre site en utilisant des blocs. Cette nouvelle version majeure apportera en effet des outils de conception avancés pour vous permettre de créer des mises en page personnalisées pour votre thème, et de les mettre en forme selon vos préférences.</p>\n\n\n\n<p>Découvrez dans ce guide les nouveautés techniques majeures qui vous attendent pour cette nouvelle version de l’outil qui propulse plus de 43% du web !</p>\n\n\n\n<span id=\"more-2264\"></span>\n\n\n\n<p>Cette version majeure 5.9 corrige plus de <a href=\"https://core.trac.wordpress.org/query?milestone=5.9&amp;group=type&amp;page=4&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">100 bugs</a>, apporte <a href=\"https://core.trac.wordpress.org/query?milestone=5.9&amp;group=type&amp;page=4&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">99 améliorations</a>, répond à <a href=\"https://core.trac.wordpress.org/query?milestone=5.9&amp;group=type&amp;page=4&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">5 demandes de nouvelles fonctionnalités</a> et prend en charge <a href=\"https://core.trac.wordpress.org/query?milestone=5.9&amp;group=type&amp;page=4&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">51 tâches de maintenance</a>. Voici la <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=5.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\" data-type=\"URL\">liste complète des tickets fermés lors du développement de WordPress 5.9</a>.</p>\n\n\n\n<p>Vous pouvez d’ores et déjà tester cette nouvelle version en installant la <a href=\"https://wordpress.org/news/2022/01/wordpress-5-9-rc-2/\">version Release Candidate 2</a> sur un site de test. La version finale est prévue pour le 25 janvier 2022.</p>\n\n\n\n<p>Pour chaque composant de WordPress concerné par un changement majeur, vous trouverez un paragraphe introductif en français suivi des notes de développement et autres ressources publiées par l’équipe de développement de WordPress, en anglais.</p>\n\n\n\n<h2 id=\"editeur-de-blocs-arrivee-de-l-edition-complete-de-votre-site-a-l-aide-de-blocs-gutenberg\">Éditeur de blocs&nbsp;: arrivée de l’édition complète de votre site à l’aide de blocs Gutenberg</h2>\n\n\n\n<p>WordPress 5.9 est la version qui apporte le plus de changements à l’éditeur depuis le lancement de Gutenberg sur WP 5.0.</p>\n\n\n\n<p>Cette nouvelle version majeure apporte une suite complète d’outils permettant à l’éditeur de blocs de proposer bien plus que la seule écriture des pages et articles de votre site. Cela comprend une nouvelle façon de construire des thèmes, de créer des modèles et de mettre en forme votre site. En plus de cela, une dizaine de nouveaux blocs proposent le chargement de contenus dynamiques pour créer les modèles de pages de votre site.</p>\n\n\n\n<p>Le nouveau thème natif <strong>Twenty Twenty-Two</strong> est quant à lui chargé de faire la démonstration de toutes ces nouvelles fonctionnalités.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://make.wordpress.org/core/files/2021/10/Example-Pages-scaled.jpg\"><img decoding=\"async\" src=\"https://make.wordpress.org/core/files/2021/10/Example-Pages-1024x701.jpg\" alt=\"\" class=\"wp-image-91525\" /></a></figure>\n\n\n\n<p>Pour en savoir plus sur les thèmes basés sur des blocs et pour apprendre à construire le vôtre, consultez la note de développement dédiée&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"SWXSKzm4tM\"><a href=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/\">Block themes, a new way to build themes in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Block themes, a new way to build themes in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/04/block-themes-a-new-way-to-build-themes-in-wordpress-5-9/embed/#?secret=c4fiUtwbS1#?secret=SWXSKzm4tM\" data-secret=\"SWXSKzm4tM\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p><a href=\"https://developer.wordpress.org/block-editor/contributors/versions-in-wordpress/\">WordPress 5.9 comprend tous les changements ayant eu lieu sur l’extension Gutenberg</a> depuis la dernière version de WordPress, jusqu’au gel du développement de nouvelles fonctionnalités intervenu avec la version 11.9 de Gutenberg. Pour connaître le contenu de chaque version de l’extension Gutenberg, consultez leur article dédié&nbsp;: <a href=\"https://make.wordpress.org/core/2021/06/10/whats-new-in-gutenberg-10-8-9-june/\" data-type=\"post\" data-id=\"89357\">10.8</a>, <a href=\"https://make.wordpress.org/core/2021/06/24/whats-new-in-gutenberg-10-9-23-june/\" data-type=\"post\" data-id=\"89686\">10.9</a>, <a href=\"https://make.wordpress.org/core/2021/07/09/whats-new-in-gutenberg-11-0-0-9-july/\" data-type=\"post\" data-id=\"89923\">11.0</a>, <a href=\"https://make.wordpress.org/core/2021/07/21/whats-new-in-gutenberg-11-1-0-21-july/\" data-type=\"post\" data-id=\"90206\">11.1</a>, <a href=\"https://make.wordpress.org/core/2021/08/05/whats-new-in-gutenberg-11-2-0-4-august/\" data-type=\"post\" data-id=\"90397\">11.2</a>, <a href=\"https://make.wordpress.org/core/2021/08/18/whats-new-in-gutenberg-11-3-18-august/\" data-type=\"post\" data-id=\"90589\">11.3</a>, <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\" data-type=\"post\" data-id=\"90781\">11.4</a>, <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\" data-type=\"post\" data-id=\"91161\">11.5</a>, <a href=\"https://make.wordpress.org/core/2021/10/01/whats-new-in-gutenberg-11-6-29-september/\" data-type=\"post\" data-id=\"91369\">11.6</a>, <a href=\"https://make.wordpress.org/core/2021/10/14/whats-new-in-gutenberg-11-7-october-13th/\" data-type=\"post\" data-id=\"91649\">11.7</a>, <a href=\"https://make.wordpress.org/core/2021/10/28/whats-new-in-gutenberg-11-8-0-27-october/\" data-type=\"post\" data-id=\"91867\">11.8</a>, <a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\" data-type=\"post\" data-id=\"92148\">11.9</a>.</p>\n\n\n\n<p>Vous trouverez ci-après les principaux changements intervenus sur Gutenberg, avec des liens vers les notes de développement associées.</p>\n\n\n\n<h3 id=\"mise-a-jour-des-reglages-des-styles-et-du-fichier-theme-json\">Mise à jour des réglages, des styles et du fichier theme.json</h3>\n\n\n\n<p>La note de développement suivante décrit les changements notamment apportés au fichier theme.json.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"svOvwF6t4G\"><a href=\"https://make.wordpress.org/core/2022/01/08/updates-for-settings-styles-and-theme-json/\">Updates for Settings, Styles, and theme.json</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Updates for Settings, Styles, and theme.json&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/08/updates-for-settings-styles-and-theme-json/embed/#?secret=EZ9WXFA1VZ#?secret=svOvwF6t4G\" data-secret=\"svOvwF6t4G\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"refactorisation-du-bloc-galerie\">Refactorisation du bloc Galerie</h3>\n\n\n\n<p>Auparavant, le bloc galerie fonctionnait comme un bloc unique qui permettait de choisir des images à intégrer au bloc. À partir de WordPress 5.9, il devient un bloc «&nbsp;conteneur&nbsp;» et les images qu’il contient seront tout simplement des blocs intégrés au sein de celui-ci. Par ailleurs, il sera également possible d’y intégrer d’autres types de blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ODDpuDSnAc\"><a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\">Gallery Block Refactor Dev Note</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Gallery Block Refactor Dev Note&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/embed/#?secret=S0lJLeqvqn#?secret=ODDpuDSnAc\" data-secret=\"ODDpuDSnAc\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"le-nouveau-bloc-navigation\">Le nouveau bloc Navigation</h3>\n\n\n\n<p>Le nouveau bloc de navigation s’intègre pleinement dans l’objectif d’édition complète de votre site via l’éditeur de blocs. Celui-ci permet de créer et gérer vos menus de navigation au sein de l’éditeur.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZLBgTGrRWl\"><a href=\"https://make.wordpress.org/core/2022/01/07/the-new-navigation-block/\">The new Navigation block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;The new Navigation block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/07/the-new-navigation-block/embed/#?secret=7VIz3HSob6#?secret=ZLBgTGrRWl\" data-secret=\"ZLBgTGrRWl\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"encore-plus-de-controle-sur-les-blocs-pouvant-en-contenir-d-autres\">Encore plus de contrôle sur les blocs pouvant en contenir d’autres</h3>\n\n\n\n<p>La manière d’utiliser le composant <code>&lt;InnerBlocks /&gt;</code> a évolué. Cette note de développement vous permettra de mieux l’intégrer à vos projets de développements basés sur des blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQlv4ca8wR\"><a href=\"https://make.wordpress.org/core/2021/12/28/take-more-control-over-inner-block-areas-as-a-block-developer/\">Take more control over Inner Block Areas (as a block developer)</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Take more control over Inner Block Areas (as a block developer)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/12/28/take-more-control-over-inner-block-areas-as-a-block-developer/embed/#?secret=e3ut65A9Ce#?secret=hQlv4ca8wR\" data-secret=\"hQlv4ca8wR\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"possibilite-de-declarer-plusieurs-feuilles-de-styles-par-bloc\">Possibilité de déclarer plusieurs feuilles de styles par bloc</h3>\n\n\n\n<p>Le fichier <code>block.json</code> permet dorénavant de déclarer une ou plusieurs feuilles de styles pour un seul et même bloc, et de charger des styles provenant d’autres blocs si besoin. Les thèmes pourront donc ajouter des styles blocs par blocs au lieu d’utiliser des feuilles de styles très lourdes contenant des styles pour l’ensemble du site, et qui sont donc constamment chargées pour toutes les pages.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TWCV3clxxI\"><a href=\"https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/\">Using multiple stylesheets per block</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Using multiple stylesheets per block&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/12/15/using-multiple-stylesheets-per-block/embed/#?secret=SO4kaonk5W#?secret=TWCV3clxxI\" data-secret=\"TWCV3clxxI\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"une-nouvelle-api-permettant-d-acceder-aux-styles-et-reglages-globaux-du-site\">Une nouvelle API permettant d’accéder aux styles et réglages globaux du site</h3>\n\n\n\n<p>Un jeu de fonctions, de crochets d’action et de filtres permet d’accéder au fichier <code>theme.json</code> et d’en modifier les réglages.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"pImnyM4YOk\"><a href=\"https://make.wordpress.org/core/2022/01/04/new-api-to-access-global-settings-styles/\">New API to access global settings &amp; styles</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New API to access global settings &amp; styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/04/new-api-to-access-global-settings-styles/embed/#?secret=IeKJQ3tIxp#?secret=pImnyM4YOk\" data-secret=\"pImnyM4YOk\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"verrouillage-des-blocs\">Verrouillage des blocs</h3>\n\n\n\n<p>WordPress 5.9 apporte la possibilité de verrouiller certains blocs individuels au sein de compositions de blocs, afin d’empêcher leur modification dans l’éditeur. Ceci est particulièrement utile pour contraindre la mise en page et la mise en forme de certaines compositions par rapport à votre charte graphique.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"m9aKusEXIo\"><a href=\"https://make.wordpress.org/core/2022/01/08/locking-blocks-in-wordpress-5-9/\">Locking Blocks in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Locking Blocks in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/08/locking-blocks-in-wordpress-5-9/embed/#?secret=K3JEnG3aho#?secret=m9aKusEXIo\" data-secret=\"m9aKusEXIo\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"autres-modifications-concernant-l-editeur-de-blocs-sur-wp-5-9\">Autres modifications concernant l’éditeur de blocs sur WP 5.9</h3>\n\n\n\n<p>La note de développement suivante liste diverses autres améliorations et d’autres changements sur l’éditeur de blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zcz3Iu1aJ3\"><a href=\"https://make.wordpress.org/core/2022/01/04/miscellaneous-block-editor-changes-in-wordpress-5-9/\">Miscellaneous block editor changes in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous block editor changes in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/04/miscellaneous-block-editor-changes-in-wordpress-5-9/embed/#?secret=hwR7A5kJf5#?secret=zcz3Iu1aJ3\" data-secret=\"zcz3Iu1aJ3\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"performances\">Performances</h2>\n\n\n\n<h3 id=\"coup-d-oeil-sur-les-ameliorations-generales-des-performances-de-wordpress\">Coup d’œil sur les améliorations générales des performances de WordPress</h3>\n\n\n\n<p>La version 5.9 de WordPress apporte un grand nombre d’améliorations de performances. Cet article les détaille de façon précise.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5UGWFL9jjs\"><a href=\"https://make.wordpress.org/core/2022/01/05/wordpress-5-9-performance-improvements/\">WordPress 5.9 Performance Improvements</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 5.9 Performance Improvements&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/05/wordpress-5-9-performance-improvements/embed/#?secret=N0dmvbpkZN#?secret=5UGWFL9jjs\" data-secret=\"5UGWFL9jjs\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"ameliorations-du-chargement-differe-des-medias-sur-wordpress-5-9\">Améliorations du chargement différé des médias sur WordPress 5.9</h3>\n\n\n\n<p>Présent depuis WordPress 5.5 pour les images et 5.7 pour les iframes, le chargement différé (en anglais <em>lazy loading</em>) permet de ne charger un élément que lorsque l’on a besoin de l’afficher à la personne qui visite le site. Mais tous les médias ne doivent pas tout le temps être chargés en différé. WordPress 5.9 améliore cela en évitant le chargement différé des premiers éléments médias du site, ceux qui sont généralement situés au dessus de la ligne de flottaison de l’écran. Si vous développez des sites web avec WordPress, vous pouvez paramétrer ces réglages précisément pour vos projets.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"JgXt1vowJf\"><a href=\"https://make.wordpress.org/core/2021/12/29/enhanced-lazy-loading-performance-in-5-9/\">Enhanced lazy-loading performance in 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Enhanced lazy-loading performance in 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/12/29/enhanced-lazy-loading-performance-in-5-9/embed/#?secret=9dEgcoZp6L#?secret=JgXt1vowJf\" data-secret=\"JgXt1vowJf\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"api-du-coeur-wordpress\">API du cœur WordPress</h2>\n\n\n\n<h3 id=\"changements-concernant-les-publications-les-types-de-publications-ainsi-que-les-taxonomies\">Changements concernant les publications, les types de publications, ainsi que les taxonomies</h3>\n\n\n\n<p>De nouvelles fonctions, crochets d’action et filtres ont été ajoutés pour faciliter le travail des développeurs et des développeuses WordPress. Découvrez-les dans cette note de développement.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"w6AClHbkTk\"><a href=\"https://make.wordpress.org/core/2021/12/13/posts-post-types-and-taxonomy-changes-in-wordpress-5-9/\">Posts, Post types and Taxonomy changes in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Posts, Post types and Taxonomy changes in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/12/13/posts-post-types-and-taxonomy-changes-in-wordpress-5-9/embed/#?secret=Y8kbbhiT7Z#?secret=w6AClHbkTk\" data-secret=\"w6AClHbkTk\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"une-nouvelle-facon-de-faire-des-requetes-sur-les-permissions-des-comptes\">Une nouvelle façon de faire des requêtes sur les permissions des comptes</h3>\n\n\n\n<p>WordPress 5.9 apporte des améliorations à l’API permettant de récupérer des comptes en fonction de leurs permissions.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"YO1jgxzWku\"><a href=\"https://make.wordpress.org/core/2022/01/05/new-capability-queries-in-wordpress-5-9/\">New Capability Queries in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;New Capability Queries in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/05/new-capability-queries-in-wordpress-5-9/embed/#?secret=fFgZih7glT#?secret=YO1jgxzWku\" data-secret=\"YO1jgxzWku\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"internationalisation\">Internationalisation</h2>\n\n\n\n<p>Vous le verrez la prochaine fois que vous vous connecterez à votre site s’il dispose de plusieurs langues installées dans l’administration&nbsp;: un sélecteur de langue a été ajouté à la page de connexion de WordPress, ce qui permet aux utilisateurs et utilisatrices disposant d’un compte sur votre site d’afficher la page de connexion dans leur langue de préférence. Cela est particulièrement utile pour les sites multilingue, multisite ou comprenant un grand nombre de comptes.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cUWtWUTV8P\"><a href=\"https://make.wordpress.org/core/2021/12/20/introducing-new-language-switcher-on-the-login-screen-in-wp-5-9/\">Introducing new language switcher on the login screen in WP 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Introducing new language switcher on the login screen in WP 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/12/20/introducing-new-language-switcher-on-the-login-screen-in-wp-5-9/embed/#?secret=MICZjoa8az#?secret=cUWtWUTV8P\" data-secret=\"cUWtWUTV8P\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"themes-et-outil-de-personnalisation\">Thèmes et outil de personnalisation</h2>\n\n\n\n<h3 id=\"changement-concernant-le-developpement-de-themes\">Changement concernant le développement de thèmes</h3>\n\n\n\n<p>WordPress 5.9 introduit des changements concernant le développement de thèmes, mais aussi de nouveaux filtres pour aider les développeurs et développeuses.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ez8hcRzofd\"><a href=\"https://make.wordpress.org/core/2022/01/07/theme-focused-changes-and-filters-in-wordpress-5-9/\">Theme-focused changes and filters in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Theme-focused changes and filters in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/07/theme-focused-changes-and-filters-in-wordpress-5-9/embed/#?secret=9vlpnajCDf#?secret=ez8hcRzofd\" data-secret=\"ez8hcRzofd\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"mises-a-jour-sur-les-themes-natifs\">Mises à jour sur les thèmes natifs</h3>\n\n\n\n<p>WordPress 5.9 vient aussi avec un certain nombre de modifications concernant les thèmes natifs autres que Twenty Twenty-Two. Si vous utilisez ces thèmes natifs (ou un thème enfant basé sur ces thèmes), nous vous recommandons de prendre connaissance de cette note de développement.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"urRKh3rve8\"><a href=\"https://make.wordpress.org/core/2022/01/05/bundled-theme-updates-with-wordpress-5-9/\">Bundled theme updates with WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Bundled theme updates with WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/05/bundled-theme-updates-with-wordpress-5-9/embed/#?secret=zLDNcqhiAw#?secret=urRKh3rve8\" data-secret=\"urRKh3rve8\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 id=\"evolution-du-statut-de-l-outil-de-personnalisation\">Évolution du statut de l’outil de personnalisation</h3>\n\n\n\n<p>Avec les thèmes basés sur des blocs et l’édition complète de site (<em>full site editing</em> en anglais), l’outil de personnalisation perd un peu de son intérêt. Mais il reste utile pour les thèmes classiques&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"xCZdOct8zV\"><a href=\"https://make.wordpress.org/core/2022/01/07/state-of-the-customizer-with-block-themes-in-wordpress-5-9/\">State of the Customizer with block themes in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;State of the Customizer with block themes in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/07/state-of-the-customizer-with-block-themes-in-wordpress-5-9/embed/#?secret=CHW5jm647u#?secret=xCZdOct8zV\" data-secret=\"xCZdOct8zV\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"php-8-0-et-8-1\">PHP 8.0 et 8.1</h2>\n\n\n\n<p>Cette note de développement fait le point sur l’état de la compatibilité de WordPress avec les versions 8.0 et 8.1 de PHP.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8HBIk3Ijni\"><a href=\"https://make.wordpress.org/core/2022/01/10/wordpress-5-9-and-php-8-0-8-1/\">WordPress 5.9 and PHP 8.0-8.1</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;WordPress 5.9 and PHP 8.0-8.1&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/10/wordpress-5-9-and-php-8-0-8-1/embed/#?secret=PDGYoJaxp8#?secret=8HBIk3Ijni\" data-secret=\"8HBIk3Ijni\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"outils-de-tests-unitaires-du-coeur-wordpress\">Outils de tests unitaires du cœur WordPress</h2>\n\n\n\n<p>Cet article fait le point sur les changements ayant eu lieu sur les tests unitaires dont fait l’objet chaque ligne de code introduite dans le code source du CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6ihNzPxnfm\"><a href=\"https://make.wordpress.org/core/2021/09/27/changes-to-the-wordpress-core-php-test-suite/\">Changes to the WordPress Core PHP Test Suite</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Changes to the WordPress Core PHP Test Suite&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2021/09/27/changes-to-the-wordpress-core-php-test-suite/embed/#?secret=Rbh1GTGYFP#?secret=6ihNzPxnfm\" data-secret=\"6ihNzPxnfm\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 id=\"autres-changements-techniques\">Autres changements techniques</h2>\n\n\n\n<p>Mais ce n’est pas tout&nbsp;!</p>\n\n\n\n<p>Cette dernière note de développement rassemble divers autres changements ayant eu lieu sur WordPress 5.9&nbsp;:</p>\n\n\n\n<ul><li>Le champ de message des commentaires est maintenant mentionné comme étant obligatoire.</li><li>Deux nouveaux fournisseurs oEmbed font leur apparition&nbsp;: Pinterest ainsi que l’outil de représentation mathématique Wolfram Notebook.</li><li>Une nouvelle option pour restreindre les balises autorisées dans l’éditeur en fonction de leurs attributs.</li><li>Les PDF peuvent dorénavant être embarqués via la balise <code>object</code>.</li><li>Suppression de l’attribut redondant <code>role=\"navigation\"</code> des balises <code>nav</code> générées par WordPress.</li><li>Le nouveau filtre <code>wp_http_validate_url</code> permet de déclarer les ports utilisables pour des requêtes externes.</li><li>Le crochet d’action&nbsp;<code>wp_mail_succeeded</code>&nbsp;a été ajouté à la fonction&nbsp;<code>wp_mail()</code>.</li><li>La variable globale <code>post</code> est à présent utilisée par défaut sur la fonction&nbsp;<code>wp_get_post_parent_id()</code>.</li><li><code>wp_register_script()</code>&nbsp;peut dorénavant être appelé après&nbsp;<code>wp_enqueue_script()</code>.</li><li>Les fonctions&nbsp;<code>get_*_*_link()</code>&nbsp;et&nbsp;<code>edit_term_link()</code>&nbsp;acceptent désormais un «&nbsp;term ID&nbsp;» ou un objet&nbsp;<code>WP_Term</code>.</li></ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"boNv6pFAzh\"><a href=\"https://make.wordpress.org/core/2022/01/04/miscellaneous-core-changes-in-wordpress-5-9/\">Miscellaneous Core changes in WordPress 5.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" title=\"&#8220;Miscellaneous Core changes in WordPress 5.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2022/01/04/miscellaneous-core-changes-in-wordpress-5-9/embed/#?secret=Km2rn2BKZN#?secret=boNv6pFAzh\" data-secret=\"boNv6pFAzh\" width=\"600\" height=\"338\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-right has-small-font-size\">Rédigé par <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, relu et corrigé par <a href=\'https://profiles.wordpress.org/fxbenard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>fxbenard</a> et <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://fr.wordpress.org/2022/01/12/guide-des-changements-techniques-a-venir-sur-wordpress-5-9/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"« State of the Word 2021 », le bilan annuel du projet WordPress en vidéo sous-titrée en français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"https://fr.wordpress.org/2021/12/22/state-of-the-word-2021-le-bilan-annuel-du-projet-wordpress-en-video-sous-titree-en-francais/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:136:\"https://fr.wordpress.org/2021/12/22/state-of-the-word-2021-le-bilan-annuel-du-projet-wordpress-en-video-sous-titree-en-francais/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Dec 2021 20:23:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2239\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"Le « State of the Word » est la conférence annuelle du cofondateur de WordPress Matt Mullenweg. Cette année, elle s’est déroulée le 14 décembre 2021 à New York devant une petite audience de personnes. Une diffusion vidéo était également proposée pour que tout le monde puisse suivre cette conférence en direct. Il s’agit toujours d’un moment [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5944:\"\n<p>Le « State of the Word » est la conférence annuelle du cofondateur de WordPress Matt Mullenweg. Cette année, elle s’est déroulée le 14 décembre 2021 à New York devant une petite audience de personnes. Une diffusion vidéo était également proposée pour que tout le monde puisse suivre cette conférence en direct. Il s’agit toujours d’un moment important pour la communauté. Plus de 30 communautés locales ont même réuni en tout plus de 300 personnes lors de meetups locaux pour assister ensemble à la conférence, comme à Séville en Espagne.</p>\n\n\n\n<span id=\"more-2239\"></span>\n\n\n\n<p>Vous pouvez voir ou revoir cette conférence en utilisant le lecteur ci-dessous ou <a href=\"https://wordpress.tv/2021/12/15/matt-mullenweg-2021-state-of-the-word/\">en vous rendant sur WordPress.tv</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-videopress wp-block-embed-videopress wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe title=\"Matt Mullenweg: 2021 State of the Word\" width=\'612\' height=\'344\' src=\'https://video.wordpress.com/embed/Io14KzZ3?hd=1&amp;cover=1\' frameborder=\'0\' allowfullscreen ></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1633526814\'></script>\n</div></figure>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignright size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2021/12/video-subtitles-sotw-wordpress.png\"><img decoding=\"async\" loading=\"lazy\" src=\"https://fr.wordpress.org/files/2021/12/video-subtitles-sotw-wordpress.png\" alt=\"\" class=\"wp-image-2241\" width=\"108\" height=\"97\" srcset=\"https://fr.wordpress.org/files/2021/12/video-subtitles-sotw-wordpress.png 433w, https://fr.wordpress.org/files/2021/12/video-subtitles-sotw-wordpress-300x268.png 300w\" sizes=\"(max-width: 108px) 100vw, 108px\" /></a></figure></div>\n\n\n\n<p>Pour activer les sous-titres en français, lancez la vidéo puis sélectionnez sur le troisième bouton à droite, cliquez sur «&nbsp;Subtitles : On/Off&nbsp;» et sélectionnez «&nbsp;Français&nbsp;».</p>\n\n\n\n<p>Comme d’habitude, Matt a couvert un grand nombre de sujets. Le passé, le présent et le futur de WordPress ont été abordés, en soulignant notamment l’augmentation du nombre de contributeurs et contributrices, de traductions de WP dans d’autres langues que l’anglais, les différents jalons atteints par les dernières versions de WordPress, ou encore les initiatives en matière de contenus d’apprentissage et de documentation.</p>\n\n\n\n<p>Des démonstrations des nouvelles fonctionnalités qui arrivent avec la prochaine version majeure 5.9 ont été présentées&nbsp;: édition complète du site, compositions de blocs, options de styles globaux, contrôles d’images avancés…</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"575\" src=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-1024x575.png\" alt=\"\" class=\"wp-image-2246\" srcset=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-1024x575.png 1024w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-300x168.png 300w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-768x431.png 768w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-1536x862.png 1536w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-fonctionnalites-2048x1149.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Matt en a profité pour féliciter la communauté d&rsquo;avoir permis à WordPress de dépasser les 43&nbsp;% de parts de marché des CMS en décembre 2021, et pour remercier toutes les personnes qui ont déjà contribué à WordPress 5.9. Il a également rappelé que les entreprises qui bâtissent leur économie sur le CMS sont invitées à participer au programme «&nbsp;Five for the Future&nbsp;», c’est à dire à donner 5% de leur temps à la contribution à WordPress. Cela permet de garantir la pérennité du CMS sur le long terme, de continuer à évoluer et de maintenir ses parts de marché sur le web.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"590\" src=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs-1024x590.png\" alt=\"\" class=\"wp-image-2249\" srcset=\"https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs-1024x590.png 1024w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs-300x173.png 300w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs-768x442.png 768w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs-1536x884.png 1536w, https://fr.wordpress.org/files/2021/12/sotw-2021-WP59-contributeurs.png 1980w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption><small>Ci-dessus, la liste des personnes ayant contribué à WordPress 5.9 au 14 décembre 2021</small></figcaption></figure>\n\n\n\n<p>Matt a aussi rappelé la feuille de route du projet WordPress, qui comprend l’édition collaborative en temps réel pour 2023, puis la gestion multilingue native.</p>\n\n\n\n<p>Il a enfin évoqué des sujets plus généraux, comme le «&nbsp;web3&nbsp;», les différentes acquisitions et fusions au sein de l’écosystème, ainsi que la poursuite du développement de l’open-source dans le web.</p>\n\n\n\n<p>S’en est suivi une <a href=\"https://wordpress.tv/2021/12/15/matt-mullenweg-state-of-the-word-2021-qa/\">séance de questions-réponses</a> pendant laquelle il a pu répondre a plusieurs questions de l’assistance.</p>\n\n\n\n<p>N’hésitez pas à rejoindre la discussion sur Twitter, avec le mot-dièse <a href=\"https://twitter.com/hashtag/ILoveWP\">#ILoveWP</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"https://fr.wordpress.org/2021/12/22/state-of-the-word-2021-le-bilan-annuel-du-projet-wordpress-en-video-sous-titree-en-francais/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:79:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Déposer et gérer une extension sur WordPress.org : documentation en français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2021/10/24/deposer-et-gerer-une-extension-sur-wordpress-org-documentation-en-francais/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://fr.wordpress.org/2021/10/24/deposer-et-gerer-une-extension-sur-wordpress-org-documentation-en-francais/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 24 Oct 2021 16:32:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2208\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:368:\"Proposer une extension sur le répertoire WordPress.org, c&#8217;est une belle façon de faire profiter la communauté de ce que vous avez développé pour vos propres besoins, et de rendre la pareille à cette communauté tout en vous y faisant connaître. Ça tombe bien, l&#8217;équipe de documentation de WordPress en français vient de publier un guide [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3636:\"\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 40%\"><figure class=\"wp-block-media-text__media\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"701\" src=\"https://fr.wordpress.org/files/2021/10/wordpress-documentation-fr-1024x701.png\" alt=\"\" class=\"wp-image-2210 size-full\" srcset=\"https://fr.wordpress.org/files/2021/10/wordpress-documentation-fr-1024x701.png 1024w, https://fr.wordpress.org/files/2021/10/wordpress-documentation-fr-300x205.png 300w, https://fr.wordpress.org/files/2021/10/wordpress-documentation-fr-768x525.png 768w, https://fr.wordpress.org/files/2021/10/wordpress-documentation-fr.png 1450w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<p>Proposer une extension sur le répertoire WordPress.org, c&rsquo;est une belle façon de faire profiter la communauté de ce que vous avez développé pour vos propres besoins, et de rendre la pareille à cette communauté tout en vous y faisant connaître.</p>\n</div></div>\n\n\n\n<p>Ça tombe bien, l&rsquo;équipe de documentation de WordPress en français vient de publier un guide pour apprendre aux développeurs et développeuses d&rsquo;extensions comment déposer et gérer dans la durée leurs extensions WordPress sur le <a href=\"https://fr.wordpress.org/plugins\">répertoire officiel des extensions WordPress.org</a>.</p>\n\n\n\n<span id=\"more-2208\"></span>\n\n\n\n<p>Ce guide est accessible sur la <a href=\"https://fr.wordpress.org/support\">page d&rsquo;accueil de la documentation de WordPress en français</a>, rubrique «&nbsp;Développement&nbsp;». Vous pouvez également y accéder en suivant ce lien&nbsp;:</p>\n\n\n\n<div class=\"is-horizontal is-content-justification-center is-layout-flex wp-container-2 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-background\" href=\"https://fr.wordpress.org/support/article/deposer-et-gerer-son-extension-sur-le-repertoire-wordpress-org/\">Déposer et gérer mon extension sur le répertoire WP.org</a></div>\n</div>\n\n\n\n<p>Vous y retrouverez les pré-requis nécessaires avant de déposer votre extension, de l&rsquo;aide concernant les bonnes pratiques de développement, et les instructions concernant le versionnement de votre extension.</p>\n\n\n\n<p>En effet, si GIT est bien connu aujourd&rsquo;hui, SVN reste relativement obscur pour beaucoup de développeurs et de développeuses alors qu&rsquo;il ne s&rsquo;agit que de 4 ou 5 commandes à connaître.</p>\n\n\n\n<p>Ce point est d&rsquo;ailleurs celui qui a justifié la mise en œuvre de ce travail de documentation car l&rsquo;utilisation de SVN pose parfois des difficultés à la communauté.</p>\n\n\n\n<p>Bref, vous retrouverez tout ce qu&rsquo;il faut savoir concernant le dépôt et la gestion de votre extension sur le répertoire WordPress.org sur <a href=\"https://fr.wordpress.org/support/article/deposer-et-gerer-son-extension-sur-le-repertoire-wordpress-org/\">cette documentation dédiée</a>.</p>\n\n\n\n<p>Nous prévoyons prochainement de proposer plusieurs nouveaux guides liés à la contribution open source&nbsp;: dépôt d&rsquo;un thème sur le répertoire officiel, création d&rsquo;un meetup WordPress local officiel pris en charge par la communauté, etc. Si ce travail de documentation vous intéresse, n&rsquo;hésitez pas à <a href=\"https://fr.wordpress.org/team/handbook/traduire-la-documentation-de-wordpress-en-francais/rejoindre-lequipe-de-traduction-de-la-documentation/\">rejoindre l&rsquo;équipe de documentation de WordPress en français</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"https://fr.wordpress.org/2021/10/24/deposer-et-gerer-une-extension-sur-wordpress-org-documentation-en-francais/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:79:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Rendez-vous le 24 septembre 2021 pour le WordPress Translation Day !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://fr.wordpress.org/2021/09/06/rejoignez-nous-le-24-septembre-pour-le-wordpress-translation-day-2021/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"https://fr.wordpress.org/2021/09/06/rejoignez-nous-le-24-septembre-pour-le-wordpress-translation-day-2021/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Sep 2021 13:53:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2186\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:371:\"Cette année encore, c&#8217;est le retour du WordPress Translation Day, un évènement mondial dédié à la traduction de WordPress et de son écosystème. Cet évènement réunit toutes les communautés de traductrices et de traducteurs à travers le monde afin de contribuer ensemble à la traduction de notre CMS favori. Cette année, le WP Translation Day [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3556:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021.png\"><img decoding=\"async\" loading=\"lazy\" width=\"1024\" height=\"553\" src=\"https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-1024x553.png\" alt=\"\" class=\"wp-image-2187\" srcset=\"https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-1024x553.png 1024w, https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-300x162.png 300w, https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-768x415.png 768w, https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-1536x830.png 1536w, https://fr.wordpress.org/files/2021/09/wptranslationday-fr-2021-2048x1107.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Cette année encore, c&rsquo;est le retour du WordPress Translation Day, un évènement mondial dédié à la traduction de WordPress et de son écosystème.</p>\n\n\n\n<p>Cet évènement réunit toutes les communautés de traductrices et de traducteurs à travers le monde afin de contribuer ensemble à la traduction de notre CMS favori. Cette année, le WP Translation Day se déroulera durant tout le mois de septembre, pour permettre à chaque communauté locale de pouvoir organiser ses évènements locaux comme elle l&rsquo;entend.</p>\n\n\n\n<span id=\"more-2186\"></span>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignright size-large is-resized\"><img decoding=\"async\" loading=\"lazy\" src=\"https://fr.wordpress.org/files/2021/09/Polyglots-Wapuu-WPTD2021.png\" alt=\"\" class=\"wp-image-2190\" width=\"129\" height=\"121\" /></figure></div>\n\n\n\n<p class=\"has-text-color has-medium-font-size\" style=\"color:#c91e68\">L&rsquo;équipe de traduction de WordPress en français a le plaisir de vous convier à son évènement local en ligne, le vendredi 24 septembre 2021 de 14h à 19h&nbsp;!</p>\n\n\n\n<h2 id=\"comment-participer\">Comment participer&nbsp;?</h2>\n\n\n\n<p>C’est très simple&nbsp;: rendez-vous à partir de 14 heures sur le canal <code>#traductions</code> du <a href=\"https://wpfr.net/slack\">Slack WordPress FR (inscrivez-vous gratuitement ici)</a>. Si vous ne pouvez pas vous libérer dès 14 heures, n’hésitez pas à nous rejoindre en cours de route&nbsp;! Un lien de visioconférence sera alors partagé, mais vous pourrez aussi suivre l&rsquo;évènement depuis Slack.</p>\n\n\n\n<p>Durant cette après-midi les 4 GTE (<em>General Translation Editors</em>) seront présents pour vous aider (<a href=\"https://profile.wordpress.org/jdy68\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profile.wordpress.org/fxbenard\">FX Bénard</a>,&nbsp;<a href=\"https://profile.wordpress.org/wolforg\">Didier Demory</a>&nbsp;et&nbsp;<a href=\"https://profile.wordpress.org/audrasjb\">Jb Audras</a>) ainsi que les responsables de la documentation de WordPress en français (<a href=\"https://profile.wordpress.org/chaton666\">Marie Comet</a>&nbsp;et&nbsp;<a href=\"https://profile.wordpress.org/jdy68\">Jenny Dupuy</a>).</p>\n\n\n\n<p>L’objectif est d’accueillir, orienter et accompagner un maximum de nouvelles personnes pour les initier à la traduction du cœur de WordPress, mais aussi des thèmes, des extensions et de la documentation du CMS.</p>\n\n\n\n<p>On vous réservera aussi quelques petites surprises, avec notamment un petit jeu/quiz <img src=\"https://s.w.org/images/core/emoji/14.0.0/72x72/1f31f.png\" alt=\"🌟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p>N&rsquo;hésitez pas à partager cet article sur vos réseaux, on se retrouve vendredi 24 septembre&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2021/09/06/rejoignez-nous-le-24-septembre-pour-le-wordpress-translation-day-2021/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Thu, 27 Oct 2022 13:06:05 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 17 Oct 2022 18:12:46 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";s:14:\"20211220193300\";}', 'no');
INSERT INTO `hd_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(22081, '_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198', '1666919166', 'no'),
(22082, '_transient_feed_mod_0d2db5fea5a8633b56992c916819b198', '1666875966', 'no'),
(22083, '_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af', '1666919166', 'no'),
(22084, '_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af', '<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2022/10/12/guide-des-changements-techniques-de-wordpress-6-1/\'>Guide des changements techniques de WordPress 6.1</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2022/09/07/arret-definitif-des-mises-a-jour-de-securite-pour-les-versions-de-wordpress-3-7-a-4-0/\'>Arrêt définitif des mises à jour de sécurité pour les versions de WordPress 3.7 à 4.0</a></li></ul></div><div class=\"rss-widget\"><p><strong>Erreur RSS :</strong> WP HTTP Error: cURL error 60: SSL certificate problem: certificate has expired</p></div>', 'no'),
(22115, '_transient_timeout_rsssl_mixed_content_fixer_detected', '1666877149', 'no'),
(22116, '_transient_rsssl_mixed_content_fixer_detected', 'found', 'no'),
(22121, '_transient_timeout_daln_ticker_1', '1666876886', 'no'),
(22122, '_transient_daln_ticker_1', '<?xml version=\"1.0\" encoding=\"UTF-8\" ?><ticker><featurednews><news><newstitle>Etats-Unis: bonnes nouvelles sur le front de la croissance et de l&#039;emploi</newstitle><newsexcerpt>Le PIB a rebondi au troisième trimestre, à +2,6%, (en variation annuelle) après deux trimestres de contraction. &lt;br /&gt;&lt;br /&gt;&lt;img src=&quot;https://images.bfmtv.com/v6nQ24J7KtY2yYdx3PP7vzRBhss=/1x48:897x552/800x0/images/-298908.jpg&quot; /&gt;</newsexcerpt><url>https://www.bfmtv.com/economie/international/etats-unis-bonnes-nouvelles-sur-le-front-de-la-croissance-et-de-l-emploi_AD-202210270477.html</url></news></featurednews><slidingnews><news><newstitle>Etats-Unis: bonnes nouvelles sur le front de la croissance et de l&#039;emploi</newstitle><url>https://www.bfmtv.com/economie/international/etats-unis-bonnes-nouvelles-sur-le-front-de-la-croissance-et-de-l-emploi_AD-202210270477.html</url></news><news><newstitle>Hyères: 200 capsules de cocaïne et deux armes saisies au Val des Rougières</newstitle><url>https://www.bfmtv.com/var/hyeres-200-capsules-de-cocaine-et-deux-armes-saisies-au-val-des-rougieres_AN-202210270476.html</url></news><news><newstitle>Un trafic chargé sur les routes pour le pont de la Toussaint</newstitle><url>https://www.bfmtv.com/auto/un-trafic-charge-sur-les-routes-pour-le-pont-de-la-toussaint_AN-202210270474.html</url></news><news><newstitle>  Christine Lagarde: “l’inflation est passée à 9,9% en septembre&quot;</newstitle><url>https://www.bfmtv.com/economie/economie-social/christine-lagarde-l-inflation-est-passee-a-9-9-en-septembre_VN-202210270473.html</url></news><news><newstitle>Meurtre de Justine: que sait-on du principal suspect, Lucas L?</newstitle><url>https://www.bfmtv.com/police-justice/meurtre-de-justine-que-sait-on-du-principal-suspect-lucas-l_VN-202210270470.html</url></news><news><newstitle>Alpes-Maritimes: ils tentaient d’escroquer les commerçants avec de faux chèques-cadeaux</newstitle><url>https://www.bfmtv.com/cote-d-azur/alpes-maritimes-ils-tentaient-d-escroquer-les-commercants-avec-de-faux-cheques-cadeaux_AN-202210270468.html</url></news><news><newstitle>Vers un réchauffement de 2,6°C: l&#039;ONU déplore des engagements &quot;pitoyablement&quot; insuffisants</newstitle><url>https://www.bfmtv.com/environnement/climat/vers-un-rechauffement-de-2-6deg-c-l-onu-deplore-des-engagements-pitoyablement-insuffisants_AD-202210270467.html</url></news><news><newstitle>  C.Lagarde: “Les conditions difficiles concernant les prix de l’énergie devraient être limitées&quot;</newstitle><url>https://www.bfmtv.com/economie/economie-social/c-lagarde-les-conditions-difficiles-concernant-les-prix-de-l-energie-devraient-etre-limitees_VN-202210270466.html</url></news><news><newstitle>Christine Lagarde: &quot;il faudra encore relever les taux afin d’atteindre nos objectifs”</newstitle><url>https://www.bfmtv.com/economie/economie-social/christine-lagarde-il-faudra-encore-relever-les-taux-afin-d-atteindre-nos-objectifs_VN-202210270464.html</url></news><news><newstitle>Mort de Justine: le suspect passé aux aveux est connu de la justice</newstitle><url>https://www.bfmtv.com/police-justice/mort-de-justine-le-suspect-passe-aux-aveux-est-connu-de-la-justice_AN-202210270461.html</url></news></slidingnews><time>1666884026</time></ticker>', 'no'),
(22123, '_transient_timeout_global_styles_svg_filters_Divi-child', '1666876944', 'no'),
(22124, '_transient_global_styles_svg_filters_Divi-child', '<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>', 'no'),
(22125, '_transient_timeout_global_styles_Divi-child', '1666876944', 'no'),
(22126, '_transient_global_styles_Divi-child', 'body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 13px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;}body { margin: 0; }.wp-site-blocks > .alignleft { float: left; margin-right: 2em; }.wp-site-blocks > .alignright { float: right; margin-left: 2em; }.wp-site-blocks > .aligncenter { justify-content: center; margin-left: auto; margin-right: auto; }.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}', 'no');

-- --------------------------------------------------------

--
-- Structure de la table `hd_postmeta`
--

CREATE TABLE `hd_postmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL,
  `post_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_postmeta`
--

INSERT INTO `hd_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(33, 17, '_et_autogenerated_title', '0'),
(34, 17, '_et_default', '1'),
(35, 17, '_et_enabled', '1'),
(36, 17, '_et_header_layout_id', '0'),
(37, 17, '_et_header_layout_enabled', '0'),
(38, 17, '_et_body_layout_id', '0'),
(39, 17, '_et_body_layout_enabled', '1'),
(40, 17, '_et_footer_layout_id', '0'),
(41, 17, '_et_footer_layout_enabled', '0'),
(42, 16, '_et_template', '17'),
(236, 98, '_edit_last', '1'),
(237, 98, '_edit_lock', '1653386109:1'),
(240, 100, '_edit_last', '1'),
(241, 100, '_wp_page_template', 'default'),
(242, 100, '_et_pb_post_hide_nav', 'default'),
(243, 100, '_et_pb_page_layout', 'et_right_sidebar'),
(244, 100, '_et_pb_side_nav', 'off'),
(245, 100, '_et_pb_use_builder', 'on'),
(246, 100, '_et_pb_first_image', ''),
(247, 100, '_et_pb_truncate_post', ''),
(248, 100, '_et_pb_truncate_post_date', ''),
(249, 100, '_et_pb_old_content', ''),
(250, 100, '_edit_lock', '1666876228:1'),
(251, 100, '_et_pb_built_for_post_type', 'page'),
(252, 100, '_et_pb_ab_subjects', ''),
(253, 100, '_et_pb_enable_shortcode_tracking', ''),
(254, 100, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"100\" /]'),
(255, 100, '_et_pb_custom_css', ''),
(256, 100, '_et_pb_gutter_width', '3'),
(258, 100, '_global_colors_info', '{}'),
(259, 100, '_et_builder_version', 'VB|Divi|4.17.3'),
(377, 141, '_edit_lock', '1652869034:1'),
(378, 141, '_edit_last', '1'),
(379, 141, 'amm_options_submenu', 'a:16:{s:26:\"edit.php?post_type=project\";a:2:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:12:\"Publications\";i:1;s:10:\"edit_posts\";i:2;s:26:\"edit.php?post_type=project\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:10:\"edit_posts\";i:2;s:30:\"post-new.php?post_type=project\";}}s:10:\"upload.php\";a:2:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:13:\"Médiathèque\";i:1;s:12:\"upload_files\";i:2;s:10:\"upload.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:12:\"upload_files\";i:2;s:13:\"media-new.php\";}}s:9:\"mec-intro\";a:15:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:14:\"M.E Calendrier\";i:1;s:10:\"edit_posts\";i:2;s:9:\"mec-intro\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:21:\"Tous les évènements\";i:1;s:10:\"edit_posts\";i:2;s:29:\"edit.php?post_type=mec-events\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:22:\"Ajouter un événement\";i:1;s:10:\"edit_posts\";i:2;s:33:\"post-new.php?post_type=mec-events\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:11:\"Étiquettes\";i:1;s:17:\"edit_others_posts\";i:2;s:52:\"edit-tags.php?taxonomy=post_tag&post_type=mec-events\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:11:\"Catégories\";i:1;s:17:\"edit_others_posts\";i:2;s:56:\"edit-tags.php?taxonomy=mec_category&post_type=mec-events\";}i:5;a:4:{s:5:\"order\";s:1:\"5\";i:0;s:6:\"Labels\";i:1;s:17:\"edit_others_posts\";i:2;s:53:\"edit-tags.php?taxonomy=mec_label&post_type=mec-events\";}i:6;a:4:{s:5:\"order\";s:1:\"6\";i:0;s:5:\"Lieux\";i:1;s:17:\"edit_others_posts\";i:2;s:56:\"edit-tags.php?taxonomy=mec_location&post_type=mec-events\";}i:7;a:4:{s:5:\"order\";s:1:\"7\";i:0;s:13:\"Organisateurs\";i:1;s:17:\"edit_others_posts\";i:2;s:57:\"edit-tags.php?taxonomy=mec_organizer&post_type=mec-events\";}i:8;a:4:{s:5:\"order\";s:1:\"8\";i:0;s:10:\"Shortcodes\";i:1;s:14:\"manage_options\";i:2;s:32:\"edit.php?post_type=mec_calendars\";}i:9;a:4:{s:5:\"order\";s:1:\"9\";i:0;s:11:\"Paramètres\";i:1;s:14:\"manage_options\";i:2;s:12:\"MEC-settings\";}i:10;a:4:{s:5:\"order\";s:2:\"10\";i:0;s:6:\"Addons\";i:1;s:14:\"manage_options\";i:2;s:10:\"MEC-addons\";}i:11;a:4:{s:5:\"order\";s:2:\"11\";i:0;s:6:\"Wizard\";i:1;s:14:\"manage_options\";i:2;s:10:\"MEC-wizard\";}i:12;a:4:{s:5:\"order\";s:2:\"12\";i:0;s:6:\"Go Pro\";i:1;s:14:\"manage_options\";i:2;s:10:\"MEC-go-pro\";}i:13;a:4:{s:5:\"order\";s:2:\"13\";i:0;s:17:\"Importer/Exporter\";i:1;s:17:\"mec_import_export\";i:2;s:6:\"MEC-ix\";}i:14;a:4:{s:5:\"order\";s:2:\"14\";i:0;s:4:\"Aide\";i:1;s:14:\"manage_options\";i:2;s:11:\"MEC-support\";}}s:23:\"edit.php?post_type=page\";a:2:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:16:\"Toutes les pages\";i:1;s:10:\"edit_pages\";i:2;s:23:\"edit.php?post_type=page\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:10:\"edit_pages\";i:2;s:27:\"post-new.php?post_type=page\";}}s:9:\"index.php\";a:2:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:7:\"Accueil\";i:1;s:4:\"read\";i:2;s:9:\"index.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:26:\"Mises à jour <span class=\";i:1;s:11:\"update_core\";i:2;s:15:\"update-core.php\";}}s:10:\"themes.php\";a:7:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:20:\"Thèmes <span class=\";i:1;s:13:\"switch_themes\";i:2;s:10:\"themes.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:13:\"Personnaliser\";i:1;s:9:\"customize\";i:2;s:72:\"customize.php?return=%2Fwp-admin%2Fpost.php%3Fpost%3D141%26action%3Dedit\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:7:\"Widgets\";i:1;s:18:\"edit_theme_options\";i:2;s:11:\"widgets.php\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:5:\"Menus\";i:1;s:18:\"edit_theme_options\";i:2;s:13:\"nav-menus.php\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:13:\"Arrière-plan\";i:1;s:13:\"switch_themes\";i:2;s:112:\"customize.php?return=%2Fwp-admin%2Fpost.php%3Fpost%3D141%26action%3Dedit&autofocus%5Bcontrol%5D=background_image\";}i:5;a:4:{s:5:\"order\";s:1:\"5\";i:0;s:13:\"Arrière-plan\";i:1;s:18:\"edit_theme_options\";i:2;s:17:\"custom-background\";}i:6;a:4:{s:5:\"order\";s:1:\"6\";i:0;s:32:\"Éditeur de fichiers des thèmes\";i:1;s:11:\"edit_themes\";i:2;s:16:\"theme-editor.php\";}}s:11:\"plugins.php\";a:3:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:22:\"Extensions installées\";i:1;s:16:\"activate_plugins\";i:2;s:11:\"plugins.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:15:\"install_plugins\";i:2;s:18:\"plugin-install.php\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:35:\"Éditeur de fichiers des extensions\";i:1;s:12:\"edit_plugins\";i:2;s:17:\"plugin-editor.php\";}}s:9:\"users.php\";a:3:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:16:\"Tous les comptes\";i:1;s:10:\"list_users\";i:2;s:9:\"users.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:12:\"create_users\";i:2;s:12:\"user-new.php\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:6:\"Profil\";i:1;s:4:\"read\";i:2;s:11:\"profile.php\";}}s:9:\"tools.php\";a:6:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:18:\"Outils disponibles\";i:1;s:10:\"edit_posts\";i:2;s:9:\"tools.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:8:\"Importer\";i:1;s:6:\"import\";i:2;s:10:\"import.php\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:8:\"Exporter\";i:1;s:6:\"export\";i:2;s:10:\"export.php\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:14:\"Santé du site\";i:1;s:23:\"view_site_health_checks\";i:2;s:15:\"site-health.php\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:21:\"Exporter les données\";i:1;s:27:\"export_others_personal_data\";i:2;s:24:\"export-personal-data.php\";}i:5;a:4:{s:5:\"order\";s:1:\"5\";i:0;s:20:\"Effacer les données\";i:1;s:26:\"erase_others_personal_data\";i:2;s:23:\"erase-personal-data.php\";}}s:5:\"wpamm\";a:3:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:11:\"Menu Setups\";i:1;s:10:\"edit_posts\";i:2;s:22:\"edit.php?post_type=amm\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:8:\"Settings\";i:1;s:14:\"manage_options\";i:2;s:14:\"wpamm-settings\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:5:\"About\";i:1;s:14:\"manage_options\";i:2;s:11:\"wpamm-about\";}}s:19:\"options-general.php\";a:8:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:9:\"Général\";i:1;s:14:\"manage_options\";i:2;s:19:\"options-general.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:9:\"Écriture\";i:1;s:14:\"manage_options\";i:2;s:19:\"options-writing.php\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:7:\"Lecture\";i:1;s:14:\"manage_options\";i:2;s:19:\"options-reading.php\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:12:\"Commentaires\";i:1;s:14:\"manage_options\";i:2;s:22:\"options-discussion.php\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:7:\"Médias\";i:1;s:14:\"manage_options\";i:2;s:17:\"options-media.php\";}i:5;a:4:{s:5:\"order\";s:1:\"5\";i:0;s:10:\"Permaliens\";i:1;s:14:\"manage_options\";i:2;s:21:\"options-permalink.php\";}i:6;a:4:{s:5:\"order\";s:1:\"6\";i:0;s:16:\"Confidentialité\";i:1;s:22:\"manage_privacy_options\";i:2;s:19:\"options-privacy.php\";}i:7;a:4:{s:5:\"order\";s:1:\"7\";i:0;s:3:\"SSL\";i:1;s:16:\"activate_plugins\";i:2;s:25:\"rlrsssl_really_simple_ssl\";}}s:12:\"daln-tickers\";a:5:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:12:\"News Tickers\";i:1;s:14:\"manage_options\";i:2;s:12:\"daln-tickers\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:13:\"Featured News\";i:1;s:14:\"manage_options\";i:2;s:13:\"daln-featured\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:12:\"Sliding News\";i:1;s:14:\"manage_options\";i:2;s:12:\"daln-sliding\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:4:\"Help\";i:1;s:14:\"manage_options\";i:2;s:9:\"daln-help\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:7:\"Options\";i:1;s:14:\"manage_options\";i:2;s:12:\"daln-options\";}}s:15:\"et_divi_options\";a:6:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:17:\"Options du thème\";i:1;s:14:\"manage_options\";i:2;s:15:\"et_divi_options\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:14:\"Thème Builder\";i:1;s:17:\"edit_others_posts\";i:2;s:16:\"et_theme_builder\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:24:\"Personnaliseur de thème\";i:1;s:14:\"manage_options\";i:2;s:44:\"customize.php?et_customizer_option_set=theme\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:17:\"Éditeur de rôle\";i:1;s:14:\"manage_options\";i:2;s:19:\"et_divi_role_editor\";}i:4;a:4:{s:5:\"order\";s:1:\"4\";i:0;s:18:\"Bibliothèque Divi\";i:1;s:14:\"manage_options\";i:2;s:31:\"edit.php?post_type=et_pb_layout\";}i:5;a:4:{s:5:\"order\";s:1:\"5\";i:0;s:14:\"Support Center\";i:1;s:14:\"manage_options\";i:2;s:22:\"et_support_center_divi\";}}s:13:\"smart-slider3\";a:3:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:15:\"Tableau de bord\";i:1;s:11:\"smartslider\";i:2;s:13:\"smart-slider3\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:15:\"Centre d’aide\";i:1;s:11:\"smartslider\";i:2;s:18:\"smart-slider3-help\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:12:\"<span class=\";i:1;s:11:\"smartslider\";i:2;s:20:\"smart-slider3-go-pro\";}}s:34:\"edit.php?post_type=acf-field-group\";a:3:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:17:\"Groupes de champs\";i:1;s:14:\"manage_options\";i:2;s:34:\"edit.php?post_type=acf-field-group\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:14:\"manage_options\";i:2;s:38:\"post-new.php?post_type=acf-field-group\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:6:\"Outils\";i:1;s:14:\"manage_options\";i:2;s:9:\"acf-tools\";}}s:8:\"edit.php\";a:4:{i:0;a:4:{s:5:\"order\";s:1:\"0\";i:0;s:17:\"Tous les articles\";i:1;s:10:\"edit_posts\";i:2;s:8:\"edit.php\";}i:1;a:4:{s:5:\"order\";s:1:\"1\";i:0;s:7:\"Ajouter\";i:1;s:10:\"edit_posts\";i:2;s:12:\"post-new.php\";}i:2;a:4:{s:5:\"order\";s:1:\"2\";i:0;s:11:\"Catégories\";i:1;s:17:\"manage_categories\";i:2;s:31:\"edit-tags.php?taxonomy=category\";}i:3;a:4:{s:5:\"order\";s:1:\"3\";i:0;s:11:\"Étiquettes\";i:1;s:16:\"manage_post_tags\";i:2;s:31:\"edit-tags.php?taxonomy=post_tag\";}}}'),
(380, 141, 'amm_options_menu', 'a:19:{s:6:\"menu-0\";a:2:{s:5:\"order\";s:3:\"100\";s:2:\"id\";s:10:\"monitoring\";}s:6:\"menu-2\";a:2:{s:5:\"order\";s:2:\"26\";s:2:\"id\";s:26:\"edit.php?post_type=project\";}s:6:\"menu-3\";a:2:{s:5:\"order\";s:2:\"10\";s:2:\"id\";s:10:\"upload.php\";}s:6:\"menu-4\";a:2:{s:5:\"order\";s:8:\"26.46244\";s:2:\"id\";s:9:\"mec-intro\";}s:6:\"menu-5\";a:2:{s:5:\"order\";s:5:\"10091\";s:2:\"id\";s:71:\"https://happydisplay.opteam.net/wp-login.php?action=logout&_wpnonce=5519d450a7\";}s:6:\"menu-1\";a:2:{s:5:\"order\";s:2:\"20\";s:2:\"id\";s:23:\"edit.php?post_type=page\";}s:6:\"menu-6\";a:2:{s:5:\"order\";s:1:\"2\";s:2:\"id\";s:9:\"index.php\";}s:6:\"menu-7\";a:2:{s:5:\"order\";s:2:\"25\";s:2:\"id\";s:17:\"edit-comments.php\";}s:6:\"menu-8\";a:2:{s:5:\"order\";s:2:\"60\";s:2:\"id\";s:10:\"themes.php\";}s:6:\"menu-9\";a:2:{s:5:\"order\";s:2:\"65\";s:2:\"id\";s:11:\"plugins.php\";}s:7:\"menu-10\";a:2:{s:5:\"order\";s:2:\"70\";s:2:\"id\";s:9:\"users.php\";}s:7:\"menu-11\";a:2:{s:5:\"order\";s:2:\"75\";s:2:\"id\";s:9:\"tools.php\";}s:7:\"menu-12\";a:2:{s:5:\"order\";s:5:\"10090\";s:2:\"id\";s:5:\"wpamm\";}s:7:\"menu-13\";a:2:{s:5:\"order\";s:2:\"80\";s:2:\"id\";s:19:\"options-general.php\";}s:7:\"menu-14\";a:2:{s:5:\"order\";s:3:\"100\";s:2:\"id\";s:12:\"daln-tickers\";}s:7:\"menu-15\";a:2:{s:5:\"order\";s:3:\"101\";s:2:\"id\";s:15:\"et_divi_options\";}s:7:\"menu-16\";a:2:{s:5:\"order\";s:3:\"100\";s:2:\"id\";s:13:\"smart-slider3\";}s:7:\"menu-17\";a:2:{s:5:\"order\";s:8:\"80.06266\";s:2:\"id\";s:34:\"edit.php?post_type=acf-field-group\";}s:7:\"menu-18\";a:2:{s:5:\"order\";s:1:\"5\";s:2:\"id\";s:8:\"edit.php\";}}'),
(381, 141, 'amm_options_disabled', 'a:14:{s:6:\"menu-1\";a:2:{s:5:\"order\";s:2:\"20\";s:2:\"id\";s:23:\"edit.php?post_type=page\";}s:6:\"menu-6\";a:2:{s:5:\"order\";s:1:\"2\";s:2:\"id\";s:9:\"index.php\";}s:6:\"menu-7\";a:2:{s:5:\"order\";s:2:\"25\";s:2:\"id\";s:17:\"edit-comments.php\";}s:6:\"menu-8\";a:2:{s:5:\"order\";s:2:\"60\";s:2:\"id\";s:10:\"themes.php\";}s:6:\"menu-9\";a:2:{s:5:\"order\";s:2:\"65\";s:2:\"id\";s:11:\"plugins.php\";}s:7:\"menu-10\";a:2:{s:5:\"order\";s:2:\"70\";s:2:\"id\";s:9:\"users.php\";}s:7:\"menu-11\";a:2:{s:5:\"order\";s:2:\"75\";s:2:\"id\";s:9:\"tools.php\";}s:7:\"menu-12\";a:2:{s:5:\"order\";s:5:\"10090\";s:2:\"id\";s:5:\"wpamm\";}s:7:\"menu-13\";a:2:{s:5:\"order\";s:2:\"80\";s:2:\"id\";s:19:\"options-general.php\";}s:7:\"menu-14\";a:2:{s:5:\"order\";s:3:\"100\";s:2:\"id\";s:12:\"daln-tickers\";}s:7:\"menu-15\";a:2:{s:5:\"order\";s:3:\"101\";s:2:\"id\";s:15:\"et_divi_options\";}s:7:\"menu-16\";a:2:{s:5:\"order\";s:3:\"100\";s:2:\"id\";s:13:\"smart-slider3\";}s:7:\"menu-17\";a:2:{s:5:\"order\";s:8:\"80.06266\";s:2:\"id\";s:34:\"edit.php?post_type=acf-field-group\";}s:7:\"menu-18\";a:2:{s:5:\"order\";s:1:\"5\";s:2:\"id\";s:8:\"edit.php\";}}'),
(382, 141, 'roles', 'a:0:{}'),
(383, 141, 'apply_to', 'a:2:{i:0;s:1:\"3\";i:1;s:1:\"2\";}'),
(384, 141, 'activated', '1'),
(404, 145, '_edit_last', '1'),
(405, 145, '_wp_page_template', 'default'),
(406, 145, '_et_pb_post_hide_nav', 'default'),
(407, 145, '_et_pb_page_layout', 'et_right_sidebar'),
(408, 145, '_et_pb_side_nav', 'off'),
(409, 145, '_et_pb_use_builder', 'on'),
(410, 145, '_et_pb_first_image', ''),
(411, 145, '_et_pb_truncate_post', ''),
(412, 145, '_et_pb_truncate_post_date', ''),
(413, 145, '_et_pb_old_content', ''),
(414, 145, '_edit_lock', '1666876079:1'),
(415, 145, '_et_pb_built_for_post_type', 'page'),
(416, 145, '_et_pb_ab_subjects', ''),
(417, 145, '_et_pb_enable_shortcode_tracking', ''),
(418, 145, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"145\" /]'),
(419, 145, '_et_pb_custom_css', ''),
(420, 145, '_et_pb_gutter_width', '3'),
(422, 145, '_global_colors_info', '{}'),
(423, 145, '_et_builder_version', 'VB|Divi|4.15.1'),
(460, 161, '_edit_lock', '1651649933:1'),
(461, 161, '_edit_last', '1'),
(462, 100, 'code_ecran', 'Default'),
(463, 100, '_code_ecran', 'field_624eeb64f134b'),
(464, 165, 'code_ecran', 'maxTest'),
(465, 165, '_code_ecran', 'field_624eeb64f134b'),
(467, 145, 'code_ecran', 'DefaultFull'),
(468, 145, '_code_ecran', 'field_624eeb64f134b'),
(469, 167, 'code_ecran', 'maxtest2'),
(470, 167, '_code_ecran', 'field_624eeb64f134b'),
(479, 172, '_edit_lock', '1652793751:1'),
(480, 172, '_edit_last', '2'),
(481, 172, '_wp_page_template', 'default'),
(482, 172, '_et_pb_post_hide_nav', 'default'),
(483, 172, '_et_pb_page_layout', 'et_right_sidebar'),
(484, 172, '_et_pb_side_nav', 'off'),
(485, 172, '_et_pb_use_builder', 'on'),
(486, 172, '_et_pb_first_image', ''),
(487, 172, '_et_pb_truncate_post', ''),
(488, 172, '_et_pb_truncate_post_date', ''),
(489, 172, '_et_pb_old_content', ''),
(490, 172, 'code_ecran', 'cuisineTV'),
(491, 172, '_code_ecran', 'field_624eeb64f134b'),
(492, 173, 'code_ecran', ''),
(493, 173, '_code_ecran', 'field_624eeb64f134b'),
(494, 172, '_et_pb_built_for_post_type', 'page'),
(495, 172, '_et_pb_ab_subjects', ''),
(496, 172, '_et_pb_enable_shortcode_tracking', ''),
(497, 172, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"172\" /]'),
(498, 172, '_et_pb_custom_css', ''),
(499, 172, '_et_pb_gutter_width', '3'),
(501, 172, '_global_colors_info', '{}'),
(502, 172, '_et_builder_version', 'VB|Divi|4.17.0'),
(503, 177, 'code_ecran', 'cuisineTV'),
(504, 177, '_code_ecran', 'field_624eeb64f134b'),
(511, 183, '_edit_lock', '1666876752:1'),
(512, 183, '_edit_last', '1'),
(513, 183, '_et_pb_post_hide_nav', 'default'),
(514, 183, '_et_pb_project_nav', 'off'),
(515, 183, '_et_pb_page_layout', 'et_right_sidebar'),
(516, 183, '_et_pb_side_nav', 'off'),
(517, 183, '_et_pb_use_builder', 'on'),
(518, 183, '_et_pb_first_image', ''),
(519, 183, '_et_pb_truncate_post', ''),
(520, 183, '_et_pb_truncate_post_date', ''),
(521, 183, '_et_pb_old_content', ''),
(522, 183, 'page_associee', 'a:2:{i:0;s:3:\"100\";i:1;s:3:\"145\";}'),
(523, 183, '_page_associee', 'field_623dd2e555cf7'),
(524, 184, 'page_associee', '100'),
(525, 184, '_page_associee', 'field_623dd2e555cf7'),
(526, 183, '_et_pb_built_for_post_type', 'page'),
(527, 183, '_et_pb_ab_subjects', ''),
(528, 183, '_et_pb_enable_shortcode_tracking', ''),
(529, 183, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"183\" /]'),
(530, 183, '_et_pb_custom_css', ''),
(531, 183, '_et_pb_gutter_width', '3'),
(533, 183, '_global_colors_info', '{}'),
(534, 183, '_et_builder_version', 'VB|Divi|4.17.3'),
(535, 186, 'page_associee', '100'),
(536, 186, '_page_associee', 'field_623dd2e555cf7'),
(539, 190, 'code_ecran', 'maxTest'),
(540, 190, '_code_ecran', 'field_624eeb64f134b'),
(542, 192, 'code_ecran', 'maxTest'),
(543, 192, '_code_ecran', 'field_624eeb64f134b'),
(545, 100, '_et_pb_show_page_creation', 'off'),
(557, 196, 'page_associee', '100'),
(558, 196, '_page_associee', 'field_623dd2e555cf7'),
(561, 215, '_edit_lock', '1651054383:1'),
(562, 215, '_edit_last', '1'),
(563, 215, '_wptu_more_link', ''),
(564, 216, '_edit_last', '1'),
(565, 216, '_wptu_more_link', ''),
(566, 216, '_edit_lock', '1651054402:1'),
(571, 221, 'page_associee', '100'),
(572, 221, '_page_associee', 'field_623dd2e555cf7'),
(573, 222, '_wp_attached_file', '2022/04/pixel.jpg'),
(574, 222, '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:1;s:6:\"height\";i:1;s:4:\"file\";s:17:\"2022/04/pixel.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(617, 224, 'label', ''),
(618, 224, 'category', '3'),
(619, 224, 'location', ''),
(620, 224, 'organizer', ''),
(621, 224, 'tag', ''),
(622, 224, 'author', ''),
(623, 224, 'skin', 'list'),
(624, 224, 'sk-options', 'a:19:{s:4:\"list\";a:31:{s:5:\"style\";s:7:\"classic\";s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:13:\"end_date_type\";s:4:\"date\";s:18:\"maximum_date_range\";s:0:\"\";s:12:\"order_method\";s:3:\"ASC\";s:20:\"classic_date_format1\";s:5:\"d M Y\";s:20:\"minimal_date_format1\";s:1:\"d\";s:20:\"minimal_date_format2\";s:1:\"M\";s:20:\"minimal_date_format3\";s:1:\"l\";s:19:\"modern_date_format1\";s:1:\"d\";s:19:\"modern_date_format2\";s:1:\"F\";s:19:\"modern_date_format3\";s:1:\"l\";s:21:\"standard_date_format1\";s:3:\"d M\";s:22:\"accordion_date_format1\";s:1:\"d\";s:22:\"accordion_date_format2\";s:1:\"F\";s:5:\"limit\";s:1:\"4\";s:18:\"include_local_time\";s:1:\"1\";s:20:\"include_events_times\";s:1:\"0\";s:16:\"load_more_button\";s:1:\"0\";s:13:\"month_divider\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:15:\"set_geolocation\";s:1:\"0\";s:21:\"set_geolocation_focus\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:20:\"toggle_month_divider\";s:1:\"0\";s:10:\"sed_method\";s:2:\"no\";s:11:\"image_popup\";s:1:\"0\";}s:4:\"grid\";a:33:{s:5:\"style\";s:7:\"classic\";s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:13:\"end_date_type\";s:4:\"date\";s:18:\"maximum_date_range\";s:0:\"\";s:12:\"order_method\";s:3:\"ASC\";s:20:\"classic_date_format1\";s:5:\"d F Y\";s:18:\"clean_date_format1\";s:1:\"d\";s:18:\"clean_date_format2\";s:1:\"F\";s:20:\"minimal_date_format1\";s:1:\"d\";s:20:\"minimal_date_format2\";s:1:\"M\";s:19:\"modern_date_format1\";s:1:\"d\";s:19:\"modern_date_format2\";s:1:\"F\";s:19:\"modern_date_format3\";s:1:\"l\";s:19:\"simple_date_format1\";s:5:\"M d Y\";s:21:\"colorful_date_format1\";s:1:\"d\";s:21:\"colorful_date_format2\";s:1:\"F\";s:21:\"colorful_date_format3\";s:1:\"l\";s:18:\"novel_date_format1\";s:5:\"d F Y\";s:5:\"count\";s:1:\"1\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:20:\"include_events_times\";s:1:\"0\";s:16:\"load_more_button\";s:1:\"1\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:15:\"set_geolocation\";s:1:\"0\";s:21:\"set_geolocation_focus\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:6:\"agenda\";a:17:{s:5:\"style\";s:5:\"clean\";s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:13:\"end_date_type\";s:4:\"date\";s:18:\"maximum_date_range\";s:0:\"\";s:12:\"order_method\";s:3:\"ASC\";s:18:\"clean_date_format1\";s:1:\"l\";s:18:\"clean_date_format2\";s:3:\"F j\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:16:\"load_more_button\";s:1:\"1\";s:13:\"month_divider\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:13:\"full_calendar\";a:30:{s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:12:\"default_view\";s:4:\"list\";s:13:\"monthly_style\";s:5:\"clean\";s:5:\"limit\";s:0:\"\";s:4:\"list\";s:1:\"1\";s:16:\"date_format_list\";s:3:\"d M\";s:18:\"end_date_type_list\";s:4:\"date\";s:23:\"maximum_date_range_list\";s:0:\"\";s:17:\"order_method_list\";s:3:\"ASC\";s:4:\"grid\";s:1:\"0\";s:18:\"end_date_type_grid\";s:4:\"date\";s:23:\"maximum_date_range_grid\";s:0:\"\";s:17:\"order_method_grid\";s:3:\"ASC\";s:4:\"tile\";s:1:\"0\";s:6:\"yearly\";s:1:\"0\";s:20:\"date_format_yearly_1\";s:1:\"l\";s:20:\"date_format_yearly_2\";s:3:\"F j\";s:7:\"monthly\";s:1:\"1\";s:19:\"activate_first_date\";s:1:\"0\";s:20:\"activate_current_day\";s:1:\"1\";s:6:\"weekly\";s:1:\"1\";s:5:\"daily\";s:1:\"1\";s:13:\"display_price\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"include_local_time\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:11:\"yearly_view\";a:14:{s:5:\"style\";s:6:\"modern\";s:15:\"start_date_type\";s:18:\"start_current_year\";s:10:\"start_date\";s:0:\"\";s:19:\"modern_date_format1\";s:1:\"l\";s:19:\"modern_date_format2\";s:3:\"F j\";s:5:\"limit\";s:0:\"\";s:6:\"months\";a:12:{i:1;s:1:\"1\";i:2;s:1:\"1\";i:3;s:1:\"1\";i:4;s:1:\"1\";i:5;s:1:\"1\";i:6;s:1:\"1\";i:7;s:1:\"1\";i:8;s:1:\"1\";i:9;s:1:\"1\";i:10;s:1:\"1\";i:11;s:1:\"1\";i:12;s:1:\"1\";}s:18:\"include_local_time\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:12:\"monthly_view\";a:15:{s:5:\"style\";s:7:\"classic\";s:15:\"start_date_type\";s:19:\"start_current_month\";s:10:\"start_date\";s:0:\"\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:19:\"activate_first_date\";s:1:\"0\";s:20:\"activate_current_day\";s:1:\"1\";s:11:\"display_all\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:13:\"detailed_time\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:3:\"map\";a:5:{s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:5:\"limit\";s:3:\"200\";s:11:\"geolocation\";s:1:\"0\";s:17:\"geolocation_focus\";s:1:\"0\";}s:10:\"daily_view\";a:13:{s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:13:\"detailed_time\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:11:\"weekly_view\";a:13:{s:15:\"start_date_type\";s:18:\"start_current_week\";s:10:\"start_date\";s:0:\"\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:11:\"custom_data\";s:1:\"0\";s:13:\"detailed_time\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:9:\"timetable\";a:16:{s:5:\"style\";s:6:\"modern\";s:15:\"start_date_type\";s:18:\"start_current_week\";s:10:\"start_date\";s:0:\"\";s:5:\"limit\";s:0:\"\";s:21:\"number_of_days_modern\";s:1:\"7\";s:14:\"number_of_days\";s:1:\"5\";s:10:\"week_start\";s:2:\"-1\";s:10:\"start_time\";s:1:\"1\";s:8:\"end_time\";s:2:\"13\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:7:\"masonry\";a:20:{s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:13:\"end_date_type\";s:4:\"date\";s:18:\"maximum_date_range\";s:0:\"\";s:12:\"order_method\";s:3:\"ASC\";s:12:\"date_format1\";s:1:\"j\";s:12:\"date_format2\";s:1:\"F\";s:5:\"limit\";s:0:\"\";s:9:\"filter_by\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:10:\"fit_to_row\";s:1:\"0\";s:17:\"masonry_like_grid\";s:1:\"0\";s:16:\"load_more_button\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:5:\"cover\";a:11:{s:5:\"style\";s:7:\"classic\";s:18:\"date_format_clean1\";s:1:\"d\";s:18:\"date_format_clean2\";s:1:\"M\";s:18:\"date_format_clean3\";s:1:\"Y\";s:20:\"date_format_classic1\";s:3:\"F d\";s:20:\"date_format_classic2\";s:1:\"l\";s:19:\"date_format_modern1\";s:8:\"l, F d Y\";s:8:\"event_id\";s:3:\"231\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";}s:9:\"countdown\";a:11:{s:5:\"style\";s:6:\"style1\";s:19:\"date_format_style11\";s:5:\"j F Y\";s:19:\"date_format_style21\";s:5:\"j F Y\";s:19:\"date_format_style31\";s:1:\"j\";s:19:\"date_format_style32\";s:1:\"F\";s:19:\"date_format_style33\";s:1:\"Y\";s:8:\"event_id\";s:2:\"-1\";s:8:\"bg_color\";s:7:\"#437df9\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";}s:14:\"available_spot\";a:6:{s:12:\"date_format1\";s:1:\"j\";s:12:\"date_format2\";s:1:\"F\";s:8:\"event_id\";s:2:\"-1\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";}s:8:\"carousel\";a:24:{s:5:\"style\";s:5:\"type1\";s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:18:\"type1_date_format1\";s:1:\"d\";s:18:\"type1_date_format2\";s:1:\"F\";s:18:\"type1_date_format3\";s:1:\"Y\";s:18:\"type2_date_format1\";s:6:\"M d, Y\";s:18:\"type3_date_format1\";s:6:\"M d, Y\";s:5:\"count\";s:1:\"2\";s:12:\"count_tablet\";s:1:\"2\";s:12:\"count_mobile\";s:1:\"1\";s:5:\"limit\";s:0:\"\";s:15:\"autoplay_status\";s:1:\"1\";s:8:\"autoplay\";s:0:\"\";s:11:\"loop_status\";s:1:\"1\";s:11:\"custom_data\";s:1:\"0\";s:12:\"archive_link\";s:0:\"\";s:9:\"head_text\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:20:\"include_events_times\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:6:\"slider\";a:25:{s:5:\"style\";s:2:\"t1\";s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:18:\"type1_date_format1\";s:1:\"d\";s:18:\"type1_date_format2\";s:1:\"F\";s:18:\"type1_date_format3\";s:1:\"l\";s:18:\"type2_date_format1\";s:1:\"d\";s:18:\"type2_date_format2\";s:1:\"F\";s:18:\"type2_date_format3\";s:1:\"l\";s:18:\"type3_date_format1\";s:1:\"d\";s:18:\"type3_date_format2\";s:1:\"F\";s:18:\"type3_date_format3\";s:1:\"l\";s:18:\"type4_date_format1\";s:1:\"d\";s:18:\"type4_date_format2\";s:1:\"F\";s:18:\"type4_date_format3\";s:1:\"l\";s:18:\"type5_date_format1\";s:1:\"d\";s:18:\"type5_date_format2\";s:1:\"F\";s:18:\"type5_date_format3\";s:1:\"l\";s:5:\"limit\";s:0:\"\";s:8:\"autoplay\";s:0:\"\";s:15:\"transition_time\";s:3:\"250\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";}s:8:\"timeline\";a:17:{s:15:\"start_date_type\";s:5:\"today\";s:10:\"start_date\";s:0:\"\";s:13:\"end_date_type\";s:4:\"date\";s:18:\"maximum_date_range\";s:0:\"\";s:12:\"order_method\";s:3:\"ASC\";s:20:\"classic_date_format1\";s:5:\"d F Y\";s:5:\"limit\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:16:\"load_more_button\";s:1:\"1\";s:13:\"month_divider\";s:1:\"0\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:4:\"tile\";a:15:{s:15:\"start_date_type\";s:19:\"start_current_month\";s:10:\"start_date\";s:0:\"\";s:18:\"clean_date_format1\";s:1:\"j\";s:18:\"clean_date_format2\";s:1:\"M\";s:5:\"count\";s:1:\"4\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:18:\"display_categories\";s:1:\"0\";s:17:\"display_organizer\";s:1:\"0\";s:20:\"next_previous_button\";s:1:\"1\";s:5:\"limit\";s:0:\"\";s:16:\"load_more_button\";s:1:\"1\";s:11:\"custom_data\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}s:16:\"general_calendar\";a:8:{s:15:\"start_date_type\";s:19:\"start_current_month\";s:10:\"start_date\";s:0:\"\";s:10:\"more_event\";s:0:\"\";s:18:\"include_local_time\";s:1:\"0\";s:13:\"display_label\";s:1:\"0\";s:23:\"reason_for_cancellation\";s:1:\"0\";s:10:\"sed_method\";s:1:\"0\";s:11:\"image_popup\";s:1:\"0\";}}'),
(625, 224, 'sf-options', 'a:12:{s:4:\"list\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:4:\"grid\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:6:\"agenda\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:13:\"full_calendar\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:12:\"monthly_view\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:11:\"yearly_view\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:3:\"map\";a:10:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:10:\"daily_view\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:11:\"weekly_view\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:9:\"timetable\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:4:\"tile\";a:11:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"time_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}s:16:\"general_calendar\";a:10:{s:8:\"category\";a:1:{s:4:\"type\";s:1:\"0\";}s:8:\"location\";a:1:{s:4:\"type\";s:1:\"0\";}s:9:\"organizer\";a:1:{s:4:\"type\";s:1:\"0\";}s:7:\"speaker\";a:1:{s:4:\"type\";s:1:\"0\";}s:3:\"tag\";a:1:{s:4:\"type\";s:1:\"0\";}s:5:\"label\";a:1:{s:4:\"type\";s:1:\"0\";}s:14:\"address_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}s:10:\"event_cost\";a:1:{s:4:\"type\";s:1:\"0\";}s:12:\"month_filter\";a:1:{s:4:\"type\";s:1:\"0\";}s:11:\"text_search\";a:2:{s:4:\"type\";s:1:\"0\";s:11:\"placeholder\";s:0:\"\";}}}'),
(626, 224, 'sf_status', '0'),
(627, 224, 'sf_display_label', '0'),
(628, 224, 'show_past_events', '1'),
(629, 224, 'show_only_past_events', '0'),
(630, 224, 'show_only_ongoing_events', '0'),
(631, 224, '_edit_lock', '1651587077:1'),
(632, 224, '_edit_last', '1'),
(633, 224, 'sf_reset_button', '0'),
(634, 224, 'sf_refine', '0'),
(635, 224, 'show_only_one_occurrence', '0'),
(636, 224, 'show_ongoing_events', '0'),
(660, 226, 'code_ecran', 'maxTest'),
(661, 226, '_code_ecran', 'field_624eeb64f134b'),
(1298, 233, 'code_ecran', 'maxTest'),
(1299, 233, '_code_ecran', 'field_624eeb64f134b'),
(1306, 145, '_et_pb_show_page_creation', 'off'),
(1307, 240, 'code_ecran', 'maxtest2'),
(1308, 240, '_code_ecran', 'field_624eeb64f134b'),
(1315, 244, '_wp_attached_file', '2022/04/90.png'),
(1316, 244, '_wp_attachment_metadata', 'a:5:{s:5:\"width\";i:880;s:6:\"height\";i:687;s:4:\"file\";s:14:\"2022/04/90.png\";s:5:\"sizes\";a:13:{s:6:\"medium\";a:4:{s:4:\"file\";s:14:\"90-300x234.png\";s:5:\"width\";i:300;s:6:\"height\";i:234;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumbnail\";a:4:{s:4:\"file\";s:14:\"90-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:14:\"90-768x600.png\";s:5:\"width\";i:768;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"thumblist\";a:4:{s:4:\"file\";s:14:\"90-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"meccarouselthumb\";a:4:{s:4:\"file\";s:14:\"90-474x324.png\";s:5:\"width\";i:474;s:6:\"height\";i:324;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"gridsquare\";a:4:{s:4:\"file\";s:14:\"90-391x260.png\";s:5:\"width\";i:391;s:6:\"height\";i:260;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"tileview\";a:4:{s:4:\"file\";s:14:\"90-300x400.png\";s:5:\"width\";i:300;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-post-main-image\";a:4:{s:4:\"file\";s:14:\"90-400x250.png\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:31:\"et-pb-post-main-image-fullwidth\";a:4:{s:4:\"file\";s:14:\"90-880x675.png\";s:5:\"width\";i:880;s:6:\"height\";i:675;s:9:\"mime-type\";s:9:\"image/png\";}s:21:\"et-pb-portfolio-image\";a:4:{s:4:\"file\";s:14:\"90-400x284.png\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:9:\"image/png\";}s:28:\"et-pb-portfolio-module-image\";a:4:{s:4:\"file\";s:14:\"90-510x382.png\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:9:\"image/png\";}s:35:\"et-pb-gallery-module-image-portrait\";a:4:{s:4:\"file\";s:14:\"90-400x516.png\";s:5:\"width\";i:400;s:6:\"height\";i:516;s:9:\"mime-type\";s:9:\"image/png\";}s:30:\"et-pb-image--responsive--phone\";a:4:{s:4:\"file\";s:14:\"90-480x375.png\";s:5:\"width\";i:480;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(1321, 247, 'page_associee', '100'),
(1322, 247, '_page_associee', 'field_623dd2e555cf7'),
(1332, 256, 'page_associee', '100'),
(1333, 256, '_page_associee', 'field_623dd2e555cf7'),
(1337, 261, 'code_ecran', 'maxtest2'),
(1338, 261, '_code_ecran', 'field_624eeb64f134b'),
(1363, 284, 'page_associee', '100'),
(1364, 284, '_page_associee', 'field_623dd2e555cf7'),
(1366, 285, '_edit_lock', '1652793652:1'),
(1367, 285, '_edit_last', '2'),
(1368, 285, '_wp_page_template', 'default'),
(1369, 285, '_et_pb_post_hide_nav', 'default'),
(1370, 285, '_et_pb_page_layout', 'et_right_sidebar'),
(1371, 285, '_et_pb_side_nav', 'off'),
(1372, 285, '_et_pb_use_builder', 'on'),
(1373, 285, '_et_pb_first_image', ''),
(1374, 285, '_et_pb_truncate_post', ''),
(1375, 285, '_et_pb_truncate_post_date', ''),
(1376, 285, '_et_pb_old_content', ''),
(1377, 285, 'code_ecran', ''),
(1378, 285, '_code_ecran', 'field_624eeb64f134b'),
(1379, 286, 'code_ecran', ''),
(1380, 286, '_code_ecran', 'field_624eeb64f134b'),
(1381, 285, '_et_pb_built_for_post_type', 'page'),
(1382, 285, '_et_pb_ab_subjects', ''),
(1383, 285, '_et_pb_enable_shortcode_tracking', ''),
(1384, 285, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"285\" /]'),
(1385, 285, '_et_pb_custom_css', ''),
(1386, 285, '_et_pb_gutter_width', '3'),
(1388, 285, '_global_colors_info', '{}'),
(1389, 285, '_et_builder_version', 'VB|Divi|4.17.3'),
(1390, 285, '_et_pb_show_page_creation', 'off'),
(1391, 287, 'code_ecran', ''),
(1392, 287, '_code_ecran', 'field_624eeb64f134b'),
(1393, 288, '_edit_lock', '1651667096:2'),
(1394, 288, '_edit_last', '2'),
(1395, 288, '_wp_page_template', 'default'),
(1396, 288, '_et_pb_post_hide_nav', 'default'),
(1397, 288, '_et_pb_page_layout', 'et_right_sidebar'),
(1398, 288, '_et_pb_side_nav', 'off'),
(1399, 288, '_et_pb_use_builder', 'on'),
(1400, 288, '_et_pb_first_image', ''),
(1401, 288, '_et_pb_truncate_post', ''),
(1402, 288, '_et_pb_truncate_post_date', ''),
(1403, 288, '_et_pb_old_content', ''),
(1404, 288, 'code_ecran', ''),
(1405, 288, '_code_ecran', 'field_624eeb64f134b'),
(1406, 289, 'code_ecran', ''),
(1407, 289, '_code_ecran', 'field_624eeb64f134b'),
(1408, 288, '_et_pb_built_for_post_type', 'page'),
(1409, 288, '_et_pb_ab_subjects', ''),
(1410, 288, '_et_pb_enable_shortcode_tracking', ''),
(1411, 288, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"288\" /]'),
(1412, 288, '_et_pb_custom_css', ''),
(1413, 288, '_et_pb_gutter_width', '3'),
(1415, 288, '_global_colors_info', '{}'),
(1416, 288, '_et_builder_version', 'VB|Divi|4.17.3'),
(1417, 288, '_et_pb_show_page_creation', 'off'),
(1418, 290, 'code_ecran', ''),
(1419, 290, '_code_ecran', 'field_624eeb64f134b'),
(1420, 291, '_edit_lock', '1652793869:1'),
(1421, 291, '_edit_last', '2'),
(1422, 291, '_wp_page_template', 'default'),
(1423, 291, '_et_pb_post_hide_nav', 'default'),
(1424, 291, '_et_pb_page_layout', 'et_right_sidebar'),
(1425, 291, '_et_pb_side_nav', 'off'),
(1426, 291, '_et_pb_use_builder', 'on'),
(1427, 291, '_et_pb_first_image', ''),
(1428, 291, '_et_pb_truncate_post', ''),
(1429, 291, '_et_pb_truncate_post_date', ''),
(1430, 291, '_et_pb_old_content', ''),
(1431, 291, 'code_ecran', ''),
(1432, 291, '_code_ecran', 'field_624eeb64f134b'),
(1433, 292, 'code_ecran', ''),
(1434, 292, '_code_ecran', 'field_624eeb64f134b'),
(1435, 291, '_et_pb_built_for_post_type', 'page'),
(1436, 291, '_et_pb_ab_subjects', ''),
(1437, 291, '_et_pb_enable_shortcode_tracking', ''),
(1438, 291, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"291\" /]'),
(1439, 291, '_et_pb_custom_css', ''),
(1440, 291, '_et_pb_gutter_width', '3'),
(1442, 291, '_global_colors_info', '{}'),
(1443, 291, '_et_builder_version', 'VB|Divi|4.17.3'),
(1444, 291, '_et_pb_show_page_creation', 'off'),
(1445, 293, 'code_ecran', ''),
(1446, 293, '_code_ecran', 'field_624eeb64f134b'),
(1547, 313, '_edit_lock', '1652867854:3'),
(1548, 313, '_edit_last', '3'),
(1549, 313, '_wp_page_template', 'default'),
(1550, 313, '_et_pb_post_hide_nav', 'default'),
(1551, 313, '_et_pb_page_layout', 'et_right_sidebar'),
(1552, 313, '_et_pb_side_nav', 'off'),
(1553, 313, '_et_pb_use_builder', 'on'),
(1554, 313, '_et_pb_first_image', ''),
(1555, 313, '_et_pb_truncate_post', ''),
(1556, 313, '_et_pb_truncate_post_date', ''),
(1557, 313, '_et_pb_old_content', ''),
(1558, 313, 'code_ecran', ''),
(1559, 313, '_code_ecran', 'field_624eeb64f134b'),
(1560, 314, 'code_ecran', ''),
(1561, 314, '_code_ecran', 'field_624eeb64f134b'),
(1562, 313, '_et_pb_built_for_post_type', 'page'),
(1563, 313, '_et_pb_ab_subjects', ''),
(1564, 313, '_et_pb_enable_shortcode_tracking', ''),
(1565, 313, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"313\" /]'),
(1566, 313, '_et_pb_custom_css', ''),
(1567, 313, '_et_pb_gutter_width', '3'),
(1569, 313, '_global_colors_info', '{}'),
(1570, 313, '_et_builder_version', 'VB|Divi|4.17.3'),
(1571, 313, '_et_pb_show_page_creation', 'off'),
(1572, 320, 'code_ecran', ''),
(1573, 320, '_code_ecran', 'field_624eeb64f134b'),
(1647, 336, 'page_associee', '100'),
(1648, 336, '_page_associee', 'field_623dd2e555cf7'),
(1656, 344, '_edit_lock', '1652877290:1'),
(1657, 344, '_edit_last', '1'),
(1658, 344, '_wp_page_template', 'default'),
(1659, 344, '_et_pb_post_hide_nav', 'default'),
(1660, 344, '_et_pb_page_layout', 'et_right_sidebar'),
(1661, 344, '_et_pb_side_nav', 'off'),
(1662, 344, '_et_pb_use_builder', 'on'),
(1663, 344, '_et_pb_first_image', ''),
(1664, 344, '_et_pb_truncate_post', ''),
(1665, 344, '_et_pb_truncate_post_date', ''),
(1666, 344, '_et_pb_old_content', ''),
(1667, 344, 'code_ecran', ''),
(1668, 344, '_code_ecran', 'field_624eeb64f134b'),
(1669, 345, 'code_ecran', ''),
(1670, 345, '_code_ecran', 'field_624eeb64f134b'),
(1671, 344, '_et_pb_built_for_post_type', 'page'),
(1672, 344, '_et_pb_ab_subjects', ''),
(1673, 344, '_et_pb_enable_shortcode_tracking', ''),
(1674, 344, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"344\" /]'),
(1675, 344, '_et_pb_custom_css', ''),
(1676, 344, '_et_pb_gutter_width', '3'),
(1678, 344, '_global_colors_info', '{}'),
(1679, 344, '_et_builder_version', 'VB|Divi|4.17.3'),
(1680, 344, '_et_pb_show_page_creation', 'off'),
(1681, 347, 'code_ecran', ''),
(1682, 347, '_code_ecran', 'field_624eeb64f134b'),
(1727, 368, '_edit_lock', '1652877297:1'),
(1728, 368, '_edit_last', '1'),
(1729, 368, '_wp_page_template', 'default'),
(1730, 368, '_et_pb_post_hide_nav', 'default'),
(1731, 368, '_et_pb_page_layout', 'et_right_sidebar'),
(1732, 368, '_et_pb_side_nav', 'off'),
(1733, 368, '_et_pb_use_builder', 'on'),
(1734, 368, '_et_pb_first_image', ''),
(1735, 368, '_et_pb_truncate_post', ''),
(1736, 368, '_et_pb_truncate_post_date', ''),
(1737, 368, '_et_pb_old_content', ''),
(1738, 368, 'code_ecran', ''),
(1739, 368, '_code_ecran', 'field_624eeb64f134b'),
(1740, 369, 'code_ecran', ''),
(1741, 369, '_code_ecran', 'field_624eeb64f134b'),
(1742, 368, '_et_pb_built_for_post_type', 'page'),
(1743, 368, '_et_pb_ab_subjects', ''),
(1744, 368, '_et_pb_enable_shortcode_tracking', ''),
(1745, 368, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"368\" /]'),
(1746, 368, '_et_pb_custom_css', ''),
(1747, 368, '_et_pb_gutter_width', '3'),
(1749, 368, '_global_colors_info', '{}'),
(1750, 368, '_et_builder_version', 'VB|Divi|4.17.3'),
(1751, 368, '_et_pb_show_page_creation', 'off'),
(1752, 370, 'code_ecran', ''),
(1753, 370, '_code_ecran', 'field_624eeb64f134b'),
(1754, 100, 'mec_location_id', '0'),
(1755, 100, 'mec_additional_location_ids', 'a:0:{}'),
(1756, 100, 'mec_organizer_id', '0'),
(1757, 100, 'mec_additional_organizer_ids', 'a:0:{}'),
(1758, 145, 'mec_location_id', '0'),
(1759, 145, 'mec_additional_location_ids', 'a:0:{}'),
(1760, 145, 'mec_organizer_id', '0'),
(1761, 145, 'mec_additional_organizer_ids', 'a:0:{}'),
(1762, 344, 'mec_location_id', '0'),
(1763, 344, 'mec_additional_location_ids', 'a:0:{}'),
(1764, 344, 'mec_organizer_id', '0'),
(1765, 344, 'mec_additional_organizer_ids', 'a:0:{}'),
(1766, 368, 'mec_location_id', '0'),
(1767, 368, 'mec_additional_location_ids', 'a:0:{}'),
(1768, 368, 'mec_organizer_id', '0'),
(1769, 368, 'mec_additional_organizer_ids', 'a:0:{}'),
(2009, 468, '_et_pb_built_for_post_type', 'project'),
(2077, 468, '_et_pb_use_builder', 'on'),
(2078, 468, '_et_pb_ab_subjects', ''),
(2079, 468, '_et_pb_enable_shortcode_tracking', ''),
(2080, 468, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"468\" /]'),
(2081, 468, '_et_pb_custom_css', ''),
(2082, 468, '_et_pb_gutter_width', '3'),
(2084, 468, '_global_colors_info', '{}'),
(2085, 468, '_et_pb_first_image', ''),
(2086, 468, '_et_pb_truncate_post', ''),
(2087, 468, '_et_pb_truncate_post_date', ''),
(2088, 468, '_et_builder_version', 'VB|Divi|4.17.3'),
(2089, 468, '_edit_lock', '1653480388:1'),
(2198, 468, '_edit_last', '1'),
(2199, 468, '_et_pb_old_content', ''),
(2214, 516, '_et_pb_built_for_post_type', 'project'),
(2218, 516, '_edit_lock', '1655816205:3'),
(2219, 516, '_et_pb_use_builder', 'on'),
(2220, 516, '_et_pb_ab_subjects', ''),
(2221, 516, '_et_pb_enable_shortcode_tracking', ''),
(2222, 516, '_et_pb_ab_current_shortcode', '[et_pb_split_track id=\"516\" /]'),
(2223, 516, '_et_pb_custom_css', ''),
(2224, 516, '_et_pb_gutter_width', '3'),
(2226, 516, '_global_colors_info', '{}'),
(2227, 516, '_et_pb_first_image', '');
INSERT INTO `hd_postmeta` (`meta_id`, `post_id`, `meta_key`, `meta_value`) VALUES
(2228, 516, '_et_pb_truncate_post', ''),
(2229, 516, '_et_pb_truncate_post_date', ''),
(2230, 516, '_et_builder_version', 'VB|Divi|4.17.3'),
(2231, 516, '_edit_last', '3'),
(2232, 516, '_et_pb_old_content', ''),
(2308, 528, 'page_associee', 'a:1:{i:0;s:3:\"100\";}'),
(2309, 528, '_page_associee', 'field_623dd2e555cf7'),
(2361, 516, '_wp_old_slug', 'diapositive-exemple__trashed'),
(2364, 516, '_et_pb_show_page_creation', 'off'),
(2385, 554, 'page_associee', 'a:1:{i:0;s:3:\"100\";}'),
(2386, 554, '_page_associee', 'field_623dd2e555cf7'),
(2392, 557, '_wp_attached_file', '2022/10/cropped-logo_hppdspl-admin.jpg'),
(2393, 557, '_wp_attachment_context', 'site-icon'),
(2394, 557, '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:38:\"2022/10/cropped-logo_hppdspl-admin.jpg\";s:8:\"filesize\";i:32477;s:5:\"sizes\";a:15:{s:6:\"medium\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20051;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12710;}s:9:\"thumblist\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20051;}s:16:\"meccarouselthumb\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-474x324.jpg\";s:5:\"width\";i:474;s:6:\"height\";i:324;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24500;}s:10:\"gridsquare\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-391x260.jpg\";s:5:\"width\";i:391;s:6:\"height\";i:260;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20298;}s:8:\"tileview\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-300x400.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24259;}s:21:\"et-pb-post-main-image\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-400x250.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19896;}s:21:\"et-pb-portfolio-image\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-400x284.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:284;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21711;}s:28:\"et-pb-portfolio-module-image\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-510x382.jpg\";s:5:\"width\";i:510;s:6:\"height\";i:382;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:28321;}s:35:\"et-pb-gallery-module-image-portrait\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-400x512.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31227;}s:30:\"et-pb-image--responsive--phone\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-480x480.jpg\";s:5:\"width\";i:480;s:6:\"height\";i:480;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30707;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-270x270.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18427;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-192x192.jpg\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14668;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:38:\"cropped-logo_hppdspl-admin-180x180.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14228;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:36:\"cropped-logo_hppdspl-admin-32x32.jpg\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8130;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}'),
(2395, 558, '_wp_trash_meta_status', 'publish'),
(2396, 558, '_wp_trash_meta_time', '1666860962'),
(2397, 559, '_wp_trash_meta_status', 'publish'),
(2398, 559, '_wp_trash_meta_time', '1666860991'),
(2430, 561, 'page_associee', 'a:1:{i:0;s:3:\"100\";}'),
(2431, 561, '_page_associee', 'field_623dd2e555cf7'),
(2432, 183, 'mec_location_id', '0'),
(2433, 183, 'mec_additional_location_ids', 'a:0:{}'),
(2434, 183, 'mec_organizer_id', '0'),
(2435, 183, 'mec_additional_organizer_ids', 'a:0:{}'),
(2436, 172, '_wp_trash_meta_status', 'publish'),
(2437, 172, '_wp_trash_meta_time', '1666876128'),
(2438, 172, '_wp_desired_post_slug', 'ecran-3-tv-cuisine'),
(2439, 285, '_wp_trash_meta_status', 'publish'),
(2440, 285, '_wp_trash_meta_time', '1666876128'),
(2441, 285, '_wp_desired_post_slug', 'ecran-4-salle-visio'),
(2442, 288, '_wp_trash_meta_status', 'publish'),
(2443, 288, '_wp_trash_meta_time', '1666876128'),
(2444, 288, '_wp_desired_post_slug', 'ecran-5-salle-commune'),
(2445, 291, '_wp_trash_meta_status', 'publish'),
(2446, 291, '_wp_trash_meta_time', '1666876128'),
(2447, 291, '_wp_desired_post_slug', 'ecran-6-bde'),
(2448, 313, '_wp_trash_meta_status', 'publish'),
(2449, 313, '_wp_trash_meta_time', '1666876128'),
(2450, 313, '_wp_desired_post_slug', 'ecran-7-accueil'),
(2451, 344, '_wp_trash_meta_status', 'publish'),
(2452, 344, '_wp_trash_meta_time', '1666876128'),
(2453, 344, '_wp_desired_post_slug', 'ecran-8-couloir'),
(2454, 368, '_wp_trash_meta_status', 'publish'),
(2455, 368, '_wp_trash_meta_time', '1666876128'),
(2456, 368, '_wp_desired_post_slug', 'ecran-9-salle-des-profs'),
(2457, 563, 'code_ecran', 'maxTest'),
(2458, 563, '_code_ecran', 'field_624eeb64f134b'),
(2460, 564, 'code_ecran', 'Default'),
(2461, 564, '_code_ecran', 'field_624eeb64f134b'),
(2463, 565, 'code_ecran', 'DefaultFull'),
(2464, 565, '_code_ecran', 'field_624eeb64f134b'),
(2466, 566, 'page_associee', 'a:2:{i:0;s:3:\"100\";i:1;s:3:\"145\";}'),
(2467, 566, '_page_associee', 'field_623dd2e555cf7'),
(2486, 567, '_wp_attached_file', '2022/10/pixel_transparent.png'),
(2487, 567, '_wp_attachment_metadata', 'a:6:{s:5:\"width\";i:1;s:6:\"height\";i:1;s:4:\"file\";s:29:\"2022/10/pixel_transparent.png\";s:8:\"filesize\";i:928;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}'),
(2489, 568, 'page_associee', 'a:2:{i:0;s:3:\"100\";i:1;s:3:\"145\";}'),
(2490, 568, '_page_associee', 'field_623dd2e555cf7');

-- --------------------------------------------------------

--
-- Structure de la table `hd_posts`
--

CREATE TABLE `hd_posts` (
  `ID` bigint(20) UNSIGNED NOT NULL,
  `post_author` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

--
-- Déchargement des données de la table `hd_posts`
--

INSERT INTO `hd_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(5, 1, '2022-02-23 10:42:35', '2022-02-23 09:42:35', '', 'Divi-child', '', 'publish', 'closed', 'closed', '', 'divi-child', '', '', '2022-10-27 10:57:37', '2022-10-27 08:57:37', '', 0, 'http://happydisplay.opteam.net/2022/02/23/divi-child/', 0, 'custom_css', '', 0),
(6, 1, '2022-02-23 10:42:35', '2022-02-23 09:42:35', '', 'Divi-child', '', 'inherit', 'closed', 'closed', '', '5-revision-v1', '', '', '2022-02-23 10:42:35', '2022-02-23 09:42:35', '', 5, 'http://happydisplay.opteam.net/?p=6', 0, 'revision', '', 0),
(16, 1, '2022-02-23 11:35:20', '2022-02-23 10:35:20', '', 'Theme Builder', '', 'publish', 'closed', 'closed', '', 'theme-builder', '', '', '2022-02-23 11:35:20', '2022-02-23 10:35:20', '', 0, 'https://happydisplay.opteam.net/et_theme_builder/theme-builder/', 0, 'et_theme_builder', '', 0),
(17, 1, '2022-02-23 11:35:20', '2022-02-23 10:35:20', '', 'Modèle de site Web par défaut', '', 'publish', 'closed', 'closed', '', 'modele-de-site-web-par-defaut', '', '', '2022-02-23 11:35:20', '2022-02-23 10:35:20', '', 0, 'https://happydisplay.opteam.net/et_template/modele-de-site-web-par-defaut/', 0, 'et_template', '', 0),
(98, 1, '2022-03-25 15:45:37', '2022-03-25 14:45:37', 'a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"project\";}}}s:8:\"position\";s:15:\"acf_after_title\";s:5:\"style\";s:8:\"seamless\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:14:{i:0;s:9:\"permalink\";i:1;s:11:\"the_content\";i:2;s:7:\"excerpt\";i:3;s:10:\"discussion\";i:4;s:8:\"comments\";i:5;s:9:\"revisions\";i:6;s:4:\"slug\";i:7;s:6:\"author\";i:8;s:6:\"format\";i:9;s:15:\"page_attributes\";i:10;s:14:\"featured_image\";i:11;s:10:\"categories\";i:12;s:4:\"tags\";i:13;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";i:0;}', 'Ecrans', 'ecrans', 'publish', 'closed', 'closed', '', 'group_623dd263c37d2', '', '', '2022-05-24 11:48:24', '2022-05-24 09:48:24', '', 0, 'https://happydisplay.opteam.net/?post_type=acf-field-group&#038;p=98', 0, 'acf-field-group', '', 0),
(99, 1, '2022-03-25 15:45:37', '2022-03-25 14:45:37', 'a:11:{s:4:\"type\";s:11:\"post_object\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:1;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:9:\"post_type\";a:1:{i:0;s:4:\"page\";}s:8:\"taxonomy\";s:0:\"\";s:10:\"allow_null\";i:1;s:8:\"multiple\";i:1;s:13:\"return_format\";s:2:\"id\";s:2:\"ui\";i:1;}', 'Écran associé', 'page_associee', 'publish', 'closed', 'closed', '', 'field_623dd2e555cf7', '', '', '2022-05-24 10:55:22', '2022-05-24 08:55:22', '', 98, 'https://happydisplay.opteam.net/?post_type=acf-field&#038;p=99', 0, 'acf-field', '', 0),
(100, 1, '2022-03-25 15:48:32', '2022-03-25 14:48:32', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Agenda et News', '', 'publish', 'closed', 'closed', '', 'ecran-1', '', '', '2022-10-27 15:09:21', '2022-10-27 13:09:21', '', 0, 'https://happydisplay.opteam.net/?page_id=100', 0, 'page', '', 0),
(101, 1, '2022-03-25 15:46:00', '2022-03-25 14:46:00', '', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-03-25 15:46:00', '2022-03-25 14:46:00', '', 100, 'https://happydisplay.opteam.net/?p=101', 0, 'revision', '', 0),
(102, 1, '2022-03-25 15:48:32', '2022-03-25 14:48:32', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" theme_builder_area=\"post_content\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\" max_width=\"100%\" height=\"100%\"][myscreen id=\'100\'][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-03-25 15:48:32', '2022-03-25 14:48:32', '', 100, 'https://happydisplay.opteam.net/?p=102', 0, 'revision', '', 0),
(103, 1, '2022-03-25 15:49:07', '2022-03-25 14:49:07', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" hover_enabled=\"0\" global_colors_info=\"{}\" module_id=\"screen_color\" sticky_enabled=\"0\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen id=\'100\'][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-03-25 15:49:07', '2022-03-25 14:49:07', '', 100, 'https://happydisplay.opteam.net/?p=103', 0, 'revision', '', 0),
(104, 1, '2022-03-25 15:56:35', '2022-03-25 14:56:35', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-03-25 15:56:35', '2022-03-25 14:56:35', '', 100, 'https://happydisplay.opteam.net/?p=104', 0, 'revision', '', 0),
(141, 1, '2022-03-25 16:55:36', '2022-03-25 15:55:36', '', 'Epure', '', 'publish', 'closed', 'closed', '', 'epure', '', '', '2022-05-18 12:17:13', '2022-05-18 10:17:13', '', 0, 'https://happydisplay.opteam.net/?post_type=amm&#038;p=141', 0, 'amm', '', 0),
(145, 1, '2022-03-28 11:03:46', '2022-03-28 09:03:46', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 2 - Full écran', '', 'publish', 'closed', 'closed', '', 'ecran-2', '', '', '2022-10-27 15:10:11', '2022-10-27 13:10:11', '', 0, 'https://happydisplay.opteam.net/?page_id=145', 0, 'page', '', 0),
(146, 1, '2022-03-28 11:03:10', '2022-03-28 09:03:10', '', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-03-28 11:03:10', '2022-03-28 09:03:10', '', 145, 'https://happydisplay.opteam.net/?p=146', 0, 'revision', '', 0),
(148, 1, '2022-03-28 11:03:46', '2022-03-28 09:03:46', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-03-28 11:03:46', '2022-03-28 09:03:46', '', 145, 'https://happydisplay.opteam.net/?p=148', 0, 'revision', '', 0),
(160, 1, '2022-05-24 11:48:26', '2022-05-24 09:48:26', '', 'Ecrans', '', 'inherit', 'closed', 'closed', '', '98-autosave-v1', '', '', '2022-05-24 11:48:26', '2022-05-24 09:48:26', '', 98, 'https://happydisplay.opteam.net/?p=160', 0, 'revision', '', 0),
(161, 1, '2022-04-07 15:47:57', '2022-04-07 13:47:57', 'a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"page\";}}}s:8:\"position\";s:4:\"side\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";i:1;}', 'Syncro Ecran', 'syncro-ecran', 'publish', 'closed', 'closed', '', 'group_624eeb495c89f', '', '', '2022-04-07 15:49:29', '2022-04-07 13:49:29', '', 0, 'https://happydisplay.opteam.net/?post_type=acf-field-group&#038;p=161', 0, 'acf-field-group', '', 0),
(162, 1, '2022-04-07 15:47:57', '2022-04-07 13:47:57', 'a:10:{s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";}', 'Code ecran', 'code_ecran', 'publish', 'closed', 'closed', '', 'field_624eeb64f134b', '', '', '2022-04-07 15:47:57', '2022-04-07 13:47:57', '', 161, 'https://happydisplay.opteam.net/?post_type=acf-field&p=162', 0, 'acf-field', '', 0),
(163, 1, '2022-05-04 09:41:14', '2022-05-04 07:41:14', '', 'Syncro Ecran', '', 'inherit', 'closed', 'closed', '', '161-autosave-v1', '', '', '2022-05-04 09:41:14', '2022-05-04 07:41:14', '', 161, 'https://happydisplay.opteam.net/?p=163', 0, 'revision', '', 0),
(164, 1, '2022-04-07 15:49:44', '2022-04-07 13:49:44', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-07 15:49:44', '2022-04-07 13:49:44', '', 100, 'https://happydisplay.opteam.net/?p=164', 0, 'revision', '', 0),
(165, 1, '2022-04-07 15:49:47', '2022-04-07 13:49:47', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-07 15:49:47', '2022-04-07 13:49:47', '', 100, 'https://happydisplay.opteam.net/?p=165', 0, 'revision', '', 0),
(166, 1, '2022-04-07 16:32:35', '2022-04-07 14:32:35', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-04-07 16:32:35', '2022-04-07 14:32:35', '', 145, 'https://happydisplay.opteam.net/?p=166', 0, 'revision', '', 0),
(167, 1, '2022-04-07 16:32:38', '2022-04-07 14:32:38', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.15.1\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-04-07 16:32:38', '2022-04-07 14:32:38', '', 145, 'https://happydisplay.opteam.net/?p=167', 0, 'revision', '', 0),
(172, 1, '2022-04-11 14:24:07', '2022-04-11 12:24:07', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.16\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_fullwidth_code _builder_version=\"4.17.0\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Écran 3 - TV Cuisine', '', 'trash', 'closed', 'closed', '', 'ecran-3-tv-cuisine__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=172', 0, 'page', '', 0),
(173, 1, '2022-04-11 14:22:40', '2022-04-11 12:22:40', '', 'Écran 3 - TV Cuisine', '', 'inherit', 'closed', 'closed', '', '172-revision-v1', '', '', '2022-04-11 14:22:40', '2022-04-11 12:22:40', '', 172, 'https://happydisplay.opteam.net/?p=173', 0, 'revision', '', 0),
(175, 1, '2022-04-11 14:24:07', '2022-04-11 12:24:07', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.16\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_fullwidth_code _builder_version=\"4.17.0\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Écran 3 - TV Cuisine', '', 'inherit', 'closed', 'closed', '', '172-revision-v1', '', '', '2022-04-11 14:24:07', '2022-04-11 12:24:07', '', 172, 'https://happydisplay.opteam.net/?p=175', 0, 'revision', '', 0),
(177, 1, '2022-04-11 14:24:10', '2022-04-11 12:24:10', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.16\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_fullwidth_code _builder_version=\"4.17.0\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Écran 3 - TV Cuisine', '', 'inherit', 'closed', 'closed', '', '172-revision-v1', '', '', '2022-04-11 14:24:10', '2022-04-11 12:24:10', '', 172, 'https://happydisplay.opteam.net/?p=177', 0, 'revision', '', 0),
(183, 1, '2022-04-27 10:44:03', '2022-04-27 08:44:03', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.18.0\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.18.0\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" title_text=\"90\" sticky_enabled=\"0\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'publish', 'open', 'closed', '', 'publi-news', '', '', '2022-10-27 15:21:33', '2022-10-27 13:21:33', '', 0, 'https://happydisplay.opteam.net/?post_type=project&#038;p=183', 0, 'project', '', 0),
(184, 1, '2022-04-27 10:38:37', '2022-04-27 08:38:37', '', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 10:38:37', '2022-04-27 08:38:37', '', 183, 'https://happydisplay.opteam.net/?p=184', 0, 'revision', '', 0),
(186, 1, '2022-04-27 10:41:16', '2022-04-27 08:41:16', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100vw\" content_width=\"100%\" content_max_width=\"100vw\" height=\"100vh\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" title_text=\"20220322-webinar-icims-language-desktop\" hover_enabled=\"0\" sticky_enabled=\"0\"][/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 10:41:16', '2022-04-27 08:41:16', '', 183, 'https://happydisplay.opteam.net/?p=186', 0, 'revision', '', 0),
(188, 1, '2022-04-27 10:44:03', '2022-04-27 08:44:03', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100vw\" content_width=\"100%\" content_max_width=\"100vw\" height=\"100vh\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" title_text=\"Capture d’écran 2022-03-24 152537\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" sticky_enabled=\"0\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" _builder_version=\"4.17.3\" _module_preset=\"default\" title_text=\"Image20220223163417\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 10:44:03', '2022-04-27 08:44:03', '', 183, 'https://happydisplay.opteam.net/?p=188', 0, 'revision', '', 0),
(190, 1, '2022-04-27 10:46:34', '2022-04-27 08:46:34', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" module_id=\"screen_color\" _builder_version=\"4.16\" _module_preset=\"default\" max_width=\"100vw\" height=\"100vh\" overflow-x=\"hidden\" overflow-y=\"hidden\" global_colors_info=\"{}\"][et_pb_fullwidth_code _builder_version=\"4.16\" _module_preset=\"default\" max_width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_fullwidth_code][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 10:46:34', '2022-04-27 08:46:34', '', 100, 'https://happydisplay.opteam.net/?p=190', 0, 'revision', '', 0),
(192, 1, '2022-04-27 10:52:48', '2022-04-27 08:52:48', '[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" specialty=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\" width=\"100vw\" inner_max_width=\"100vw\" height=\"100vh\"][et_pb_column type=\"3_4\" specialty_columns=\"3\" theme_builder_area=\"post_content\"][et_pb_row_inner _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_column_inner saved_specialty_column_type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\" width=\"100%\" height=\"100%\"][myscreen][/et_pb_code][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 10:52:48', '2022-04-27 08:52:48', '', 100, 'https://happydisplay.opteam.net/?p=192', 0, 'revision', '', 0),
(194, 1, '2022-04-27 11:06:23', '2022-04-27 09:06:23', '[et_pb_section fb_built=\"1\" specialty=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" inner_max_width=\"100vw\" height=\"92vh\" hover_enabled=\"0\" global_colors_info=\"{}\" background_color_2=\"#f1f1f1\" sticky_enabled=\"0\" use_custom_gutter=\"on\" gutter_width=\"1\" background_color_1=\"#FFFFFF\" inner_width=\"100vw\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" custom_css_main_1=\"height:92vh;\" custom_css_main_2=\"height:92vh;\" make_equal=\"on\" padding_right_2=\"50px\" padding_left_2=\"50px\" padding_top_bottom_link_2=\"false\" padding_left_right_link_2=\"true\"][et_pb_column type=\"3_4\" specialty_columns=\"3\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_row_inner _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_column_inner saved_specialty_column_type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 11:06:23', '2022-04-27 09:06:23', '', 100, 'https://happydisplay.opteam.net/?p=194', 0, 'revision', '', 0),
(196, 1, '2022-04-27 11:07:20', '2022-04-27 09:07:20', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" global_colors_info=\"{}\" sticky_transition=\"on\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 11:07:20', '2022-04-27 09:07:20', '', 183, 'https://happydisplay.opteam.net/?p=196', 0, 'revision', '', 0),
(198, 1, '2022-04-27 11:12:56', '2022-04-27 09:12:56', '[et_pb_section fb_built=\"1\" specialty=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" inner_max_width=\"100vw\" height=\"92vh\" hover_enabled=\"0\" global_colors_info=\"{}\" background_color_2=\"#E09900\" sticky_enabled=\"0\" use_custom_gutter=\"on\" gutter_width=\"1\" background_color_1=\"#FFFFFF\" inner_width=\"100vw\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" custom_css_main_1=\"height:92vh;\" custom_css_main_2=\"height:92vh;\" make_equal=\"on\" padding_right_2=\"50px\" padding_left_2=\"50px\" padding_top_bottom_link_2=\"false\" padding_left_right_link_2=\"true\"][et_pb_column type=\"3_4\" specialty_columns=\"3\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_row_inner _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_column_inner saved_specialty_column_type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 11:12:56', '2022-04-27 09:12:56', '', 100, 'https://happydisplay.opteam.net/?p=198', 0, 'revision', '', 0),
(200, 1, '2022-04-27 11:24:10', '2022-04-27 09:24:10', '[et_pb_section fb_built=\"1\" specialty=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" inner_max_width=\"100vw\" height=\"92vh\" hover_enabled=\"0\" global_colors_info=\"{}\" background_color_2=\"#E09900\" sticky_enabled=\"0\" use_custom_gutter=\"on\" gutter_width=\"1\" background_color_1=\"#FFFFFF\" inner_width=\"100vw\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" custom_css_main_1=\"height:92vh;\" custom_css_main_2=\"height:92vh;\" make_equal=\"on\" padding_right_2=\"50px\" padding_left_2=\"50px\" padding_top_bottom_link_2=\"false\" padding_left_right_link_2=\"true\"][et_pb_column type=\"3_4\" specialty_columns=\"3\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_row_inner _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_column_inner saved_specialty_column_type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column_inner][/et_pb_row_inner][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.16\" custom_padding=\"|||\" global_colors_info=\"{}\" custom_padding__hover=\"|||\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" column_structure=\"3_4,1_4\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100%\" height=\"92vh\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"0px||0px|||\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"3_4\" theme_builder_area=\"post_content\"][/et_pb_column][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"1_4\" theme_builder_area=\"post_content\" background_color=\"#EDF000\" hover_enabled=\"0\" sticky_enabled=\"0\"][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 11:24:10', '2022-04-27 09:24:10', '', 100, 'https://happydisplay.opteam.net/?p=200', 0, 'revision', '', 0),
(201, 1, '2022-04-27 11:25:08', '2022-04-27 09:25:08', '[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" column_structure=\"3_4,1_4\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100%\" height=\"92vh\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"0px||0px|||\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"3_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"1_4\" theme_builder_area=\"post_content\" background_color=\"#EDF000\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\" theme_builder_area=\"post_content\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 11:25:08', '2022-04-27 09:25:08', '', 100, 'https://happydisplay.opteam.net/?p=201', 0, 'revision', '', 0),
(202, 1, '2022-04-27 11:28:10', '2022-04-27 09:28:10', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" show_arrows=\"off\" min_height=\"100vh\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" global_colors_info=\"{}\" sticky_transition=\"on\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 11:28:10', '2022-04-27 09:28:10', '', 183, 'https://happydisplay.opteam.net/?p=202', 0, 'revision', '', 0),
(204, 1, '2022-04-27 11:29:09', '2022-04-27 09:29:09', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" show_arrows=\"off\" min_height=\"92vh\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" global_colors_info=\"{}\" sticky_transition=\"on\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 11:29:09', '2022-04-27 09:29:09', '', 183, 'https://happydisplay.opteam.net/?p=204', 0, 'revision', '', 0),
(205, 1, '2022-04-27 11:30:09', '2022-04-27 09:30:09', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_fullwidth_slider _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" show_arrows=\"off\" min_height=\"92vh\" auto=\"on\" auto_ignore_hover=\"on\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" global_colors_info=\"{}\" sticky_transition=\"on\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 11:30:09', '2022-04-27 09:30:09', '', 183, 'https://happydisplay.opteam.net/?p=205', 0, 'revision', '', 0),
(206, 1, '2022-04-27 11:31:25', '2022-04-27 09:31:25', '[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" column_structure=\"3_4,1_4\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100%\" height=\"92vh\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"0px||0px|||\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"3_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"1_4\" theme_builder_area=\"post_content\" background_color=\"#f1f1f1\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"50px|50px|50px|50px|true|true\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\" theme_builder_area=\"post_content\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 11:31:25', '2022-04-27 09:31:25', '', 100, 'https://happydisplay.opteam.net/?p=206', 0, 'revision', '', 0),
(208, 1, '2022-04-27 12:08:13', '2022-04-27 10:08:13', '[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" column_structure=\"3_4,1_4\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100%\" height=\"92vh\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"0px||0px|||\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"3_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"1_4\" theme_builder_area=\"post_content\" background_color=\"#f1f1f1\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"50px|50px|50px|50px|true|true\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\" theme_builder_area=\"post_content\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\' category=\'country\' country=\'fr\'][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:08:13', '2022-04-27 10:08:13', '', 100, 'https://happydisplay.opteam.net/?p=208', 0, 'revision', '', 0),
(209, 1, '2022-04-27 12:09:10', '2022-04-27 10:09:10', '[et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" column_structure=\"3_4,1_4\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100%\" height=\"92vh\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"0px||0px|||\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"3_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"1_4\" theme_builder_area=\"post_content\" background_color=\"#f1f1f1\" hover_enabled=\"0\" sticky_enabled=\"0\" custom_padding=\"50px|50px|50px|50px|true|true\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" sticky_enabled=\"0\" theme_builder_area=\"post_content\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" theme_builder_area=\"post_content\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" width=\"100%\" max_width=\"100vw\" make_equal=\"on\" use_custom_gutter=\"on\" gutter_width=\"1\" hover_enabled=\"0\" sticky_enabled=\"0\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" background_color=\"#383838\"][et_pb_column _builder_version=\"4.17.3\" _module_preset=\"default\" type=\"4_4\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" theme_builder_area=\"post_content\" hover_enabled=\"0\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\' category=\'news\' source=\'cnn\'][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:09:10', '2022-04-27 10:09:10', '', 100, 'https://happydisplay.opteam.net/?p=209', 0, 'revision', '', 0);
INSERT INTO `hd_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(211, 1, '2022-04-27 12:12:08', '2022-04-27 10:12:08', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"92vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#383838\" width=\"100%\" max_width=\"100vw\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\'][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:12:08', '2022-04-27 10:12:08', '', 100, 'https://happydisplay.opteam.net/?p=211', 0, 'revision', '', 0),
(212, 1, '2022-04-27 12:12:29', '2022-04-27 10:12:29', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"92vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\'][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#383838\" width=\"100%\" max_width=\"100vw\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\'][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:12:29', '2022-04-27 10:12:29', '', 100, 'https://happydisplay.opteam.net/?p=212', 0, 'revision', '', 0),
(213, 1, '2022-04-27 12:13:01', '2022-04-27 10:13:01', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"92vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#383838\" width=\"100%\" max_width=\"100vw\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][wp_top_news layout=\'ticker\'][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:13:01', '2022-04-27 10:13:01', '', 100, 'https://happydisplay.opteam.net/?p=213', 0, 'revision', '', 0),
(214, 1, '2022-04-27 12:14:43', '2022-04-27 10:14:43', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"92vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#383838\" width=\"100%\" max_width=\"100vw\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"20px|||20px|false|false\" text_text_color=\"#FFFFFF\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p><span>[wp_ticker]</span></p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:14:43', '2022-04-27 10:14:43', '', 100, 'https://happydisplay.opteam.net/?p=214', 0, 'revision', '', 0),
(215, 1, '2022-04-27 12:15:10', '2022-04-27 10:15:10', '', 'Informations', '', 'publish', 'closed', 'closed', '', 'informations', '', '', '2022-04-27 12:15:10', '2022-04-27 10:15:10', '', 0, 'https://happydisplay.opteam.net/?post_type=wptu_ticker&#038;p=215', 0, 'wptu_ticker', '', 0),
(216, 1, '2022-04-27 12:15:32', '2022-04-27 10:15:32', '', 'jfboibfzizfgzer', '', 'publish', 'closed', 'closed', '', 'jfboibfzizfgzer', '', '', '2022-04-27 12:15:32', '2022-04-27 10:15:32', '', 0, 'https://happydisplay.opteam.net/?post_type=wptu_ticker&#038;p=216', 0, 'wptu_ticker', '', 0),
(217, 1, '2022-04-27 12:24:02', '2022-04-27 10:24:02', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"92vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section][et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_margin=\"||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#383838\" width=\"100%\" max_width=\"100vw\" height=\"8vh\" custom_margin=\"0px||0px||false|false\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"20px|||20px|false|false\" text_text_color=\"#FFFFFF\" hover_enabled=\"0\" sticky_enabled=\"0\"]<p><span>[wp_top_news layout=\'ticker\' category=\'country\' country=\'fr\']</span></p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:24:02', '2022-04-27 10:24:02', '', 100, 'https://happydisplay.opteam.net/?p=217', 0, 'revision', '', 0),
(220, 1, '2022-04-27 12:46:45', '2022-04-27 10:46:45', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 12:46:45', '2022-04-27 10:46:45', '', 100, 'https://happydisplay.opteam.net/?p=220', 0, 'revision', '', 0),
(221, 1, '2022-04-27 12:47:27', '2022-04-27 10:47:27', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/03/Capture-decran-2022-03-24-152537.jpg\" background_enable_image=\"on\" global_colors_info=\"{}\" sticky_transition=\"on\"][/et_pb_slide][et_pb_slide heading=\"Votre titre va ici\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/02/Image20220223163417.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Your content goes here. Edit or remove this text inline or in the module Content settings. You can also style every aspect of this content in the module Design settings and even apply custom CSS to this text in the module Advanced settings.</p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-04-27 12:47:27', '2022-04-27 10:47:27', '', 183, 'https://happydisplay.opteam.net/?p=221', 0, 'revision', '', 0),
(222, 1, '2022-04-27 15:21:10', '2022-04-27 13:21:10', '', 'pixel', '', 'inherit', 'open', 'closed', '', 'pixel', '', '', '2022-04-27 15:21:10', '2022-04-27 13:21:10', '', 0, 'https://happydisplay.opteam.net/wp-content/uploads/2022/04/pixel.jpg', 0, 'attachment', 'image/jpeg', 0),
(224, 1, '2022-04-27 15:38:03', '2022-04-27 13:38:03', '', 'Mes rdv de Rouen', '', 'publish', 'closed', 'closed', '', 'mes-rdv-de-rouen', '', '', '2022-05-03 16:13:36', '2022-05-03 14:13:36', '', 0, 'https://happydisplay.opteam.net/mec_calendars/mes-rdv-de-rouen/', 0, 'mec_calendars', '', 0),
(226, 1, '2022-04-27 16:29:20', '2022-04-27 14:29:20', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"]<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 16:29:20', '2022-04-27 14:29:20', '', 100, 'https://happydisplay.opteam.net/?p=226', 0, 'revision', '', 0),
(233, 1, '2022-04-27 16:47:00', '2022-04-27 14:47:00', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 16:47:00', '2022-04-27 14:47:00', '', 100, 'https://happydisplay.opteam.net/?p=233', 0, 'revision', '', 0),
(235, 1, '2022-04-27 16:49:16', '2022-04-27 14:49:16', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#f1f1f1\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" header_font=\"|800||on|||||\" header_text_color=\"#0f9191\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 16:49:16', '2022-04-27 14:49:16', '', 100, 'https://happydisplay.opteam.net/?p=235', 0, 'revision', '', 0),
(236, 1, '2022-04-27 17:10:14', '2022-04-27 15:10:14', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" text_text_color=\"#FFFFFF\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 17:10:14', '2022-04-27 15:10:14', '', 100, 'https://happydisplay.opteam.net/?p=236', 0, 'revision', '', 0),
(238, 1, '2022-04-27 17:29:00', '2022-04-27 15:29:00', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" text_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-04-27 17:29:00', '2022-04-27 15:29:00', '', 100, 'https://happydisplay.opteam.net/?p=238', 0, 'revision', '', 0),
(240, 1, '2022-05-03 14:15:27', '2022-05-03 12:15:27', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-05-03 14:15:27', '2022-05-03 12:15:27', '', 145, 'https://happydisplay.opteam.net/?p=240', 0, 'revision', '', 0),
(244, 1, '2022-05-03 14:21:41', '2022-05-03 12:21:41', '', '90', '', 'inherit', 'open', 'closed', '', '90', '', '', '2022-05-03 14:21:41', '2022-05-03 12:21:41', '', 183, 'https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png', 0, 'attachment', 'image/png', 0),
(245, 1, '2022-05-03 14:21:55', '2022-05-03 12:21:55', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" title_text=\"90\" sticky_enabled=\"0\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 14:21:55', '2022-05-03 12:21:55', '', 183, 'https://happydisplay.opteam.net/?p=245', 0, 'revision', '', 0),
(247, 1, '2022-05-03 14:22:21', '2022-05-03 12:22:21', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"66px\" body_font_size=\"24px\" body_line_height=\"1.8em\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 14:22:21', '2022-05-03 12:22:21', '', 183, 'https://happydisplay.opteam.net/?p=247', 0, 'revision', '', 0),
(249, 1, '2022-05-03 14:27:10', '2022-05-03 12:27:10', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"60px\" body_font_size=\"24px\" body_line_height=\"1.8em\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" header_level=\"h2\" header_line_height=\"1.3em\" header_font=\"|700|||||||\" sticky_enabled=\"0\" title_text=\"90\" background_enable_image=\"off\" background_color=\"#022a7f\" background_enable_color=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"60px\" body_font_size=\"24px\" body_line_height=\"1.8em\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" header_level=\"h2\" header_line_height=\"1.3em\" header_font=\"|700|||||||\" sticky_enabled=\"0\" title_text=\"brooke-cagle-LCcFI_26diA-unsplash-scaled\" background_enable_image=\"off\" background_color=\"#022a7f\" background_enable_color=\"on\"]<p><span>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</span></p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 14:27:10', '2022-05-03 12:27:10', '', 183, 'https://happydisplay.opteam.net/?p=249', 0, 'revision', '', 0),
(256, 1, '2022-05-03 14:56:47', '2022-05-03 12:56:47', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" header_font_size=\"60px\" header_line_height=\"1.3em\" body_font_size=\"24px\" body_line_height=\"1.8em\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" header_font_size=\"60px\" header_line_height=\"1.3em\" body_font_size=\"24px\" body_line_height=\"1.8em\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p><span>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</span></p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 14:56:47', '2022-05-03 12:56:47', '', 183, 'https://happydisplay.opteam.net/?p=256', 0, 'revision', '', 0),
(257, 1, '2022-05-03 14:57:40', '2022-05-03 12:57:40', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" auto=\"on\" auto_ignore_hover=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" custom_padding=\"0px||0px||false|false\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" header_font_size=\"60px\" header_line_height=\"1.3em\" body_font_size=\"24px\" body_line_height=\"1.8em\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" sticky_enabled=\"0\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" header_font_size=\"60px\" header_line_height=\"1.3em\" body_font_size=\"24px\" body_line_height=\"1.8em\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p><span>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</span></p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 14:57:40', '2022-05-03 12:57:40', '', 183, 'https://happydisplay.opteam.net/?p=257', 0, 'revision', '', 0),
(258, 1, '2022-05-03 15:04:27', '2022-05-03 13:04:27', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_ignore_hover=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" header_font_size=\"50px\" body_font_size=\"26px\" body_line_height=\"1.8em\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" header_line_height=\"1.4em\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" sticky_enabled=\"0\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p><span>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</span></p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 15:04:27', '2022-05-03 13:04:27', '', 183, 'https://happydisplay.opteam.net/?p=258', 0, 'revision', '', 0),
(259, 1, '2022-05-03 15:08:28', '2022-05-03 13:08:28', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" hover_enabled=\"0\" global_colors_info=\"{}\" header_font_size=\"50px\" body_font_size=\"26px\" body_line_height=\"1.8em\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" header_line_height=\"1.4em\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" sticky_enabled=\"0\" auto_speed=\"15000\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" sticky_enabled=\"0\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p><span>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</span></p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-03 15:08:28', '2022-05-03 13:08:28', '', 183, 'https://happydisplay.opteam.net/?p=259', 0, 'revision', '', 0),
(261, 1, '2022-05-03 15:11:41', '2022-05-03 13:11:41', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 2', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-05-03 15:11:41', '2022-05-03 13:11:41', '', 145, 'https://happydisplay.opteam.net/?p=261', 0, 'revision', '', 0),
(284, 1, '2022-05-04 09:28:41', '2022-05-04 07:28:41', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" hover_enabled=\"0\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" sticky_enabled=\"0\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" title_text=\"brooke-cagle-LCcFI_26diA-unsplash-scaled\" sticky_enabled=\"0\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-04 09:28:41', '2022-05-04 07:28:41', '', 183, 'https://happydisplay.opteam.net/?p=284', 0, 'revision', '', 0),
(285, 1, '2022-05-04 14:26:02', '2022-05-04 12:26:02', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 4 - Salle visio', '', 'trash', 'closed', 'closed', '', 'ecran-4-salle-visio__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=285', 0, 'page', '', 0),
(286, 1, '2022-05-04 14:25:33', '2022-05-04 12:25:33', '', 'Écran 4 - Salle visio', '', 'inherit', 'closed', 'closed', '', '285-revision-v1', '', '', '2022-05-04 14:25:33', '2022-05-04 12:25:33', '', 285, 'https://happydisplay.opteam.net/?p=286', 0, 'revision', '', 0),
(287, 1, '2022-05-04 14:26:02', '2022-05-04 12:26:02', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 4 - Salle visio', '', 'inherit', 'closed', 'closed', '', '285-revision-v1', '', '', '2022-05-04 14:26:02', '2022-05-04 12:26:02', '', 285, 'https://happydisplay.opteam.net/?p=287', 0, 'revision', '', 0),
(288, 1, '2022-05-04 14:27:08', '2022-05-04 12:27:08', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 5 - Salle commune', '', 'trash', 'closed', 'closed', '', 'ecran-5-salle-commune__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=288', 0, 'page', '', 0),
(289, 1, '2022-05-04 14:26:52', '2022-05-04 12:26:52', '', 'Écran 5 - Salle commune', '', 'inherit', 'closed', 'closed', '', '288-revision-v1', '', '', '2022-05-04 14:26:52', '2022-05-04 12:26:52', '', 288, 'https://happydisplay.opteam.net/?p=289', 0, 'revision', '', 0);
INSERT INTO `hd_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(290, 1, '2022-05-04 14:27:08', '2022-05-04 12:27:08', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 5 - Salle commune', '', 'inherit', 'closed', 'closed', '', '288-revision-v1', '', '', '2022-05-04 14:27:08', '2022-05-04 12:27:08', '', 288, 'https://happydisplay.opteam.net/?p=290', 0, 'revision', '', 0),
(291, 1, '2022-05-04 14:27:56', '2022-05-04 12:27:56', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 6 - BDE', '', 'trash', 'closed', 'closed', '', 'ecran-6-bde__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=291', 0, 'page', '', 0),
(292, 1, '2022-05-04 14:27:38', '2022-05-04 12:27:38', '', 'Écran 6 - BDE', '', 'inherit', 'closed', 'closed', '', '291-revision-v1', '', '', '2022-05-04 14:27:38', '2022-05-04 12:27:38', '', 291, 'https://happydisplay.opteam.net/?p=292', 0, 'revision', '', 0),
(293, 1, '2022-05-04 14:27:56', '2022-05-04 12:27:56', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 6 - BDE', '', 'inherit', 'closed', 'closed', '', '291-revision-v1', '', '', '2022-05-04 14:27:56', '2022-05-04 12:27:56', '', 291, 'https://happydisplay.opteam.net/?p=293', 0, 'revision', '', 0),
(313, 1, '2022-05-18 11:59:39', '2022-05-18 09:59:39', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 7 - Accueil', '', 'trash', 'closed', 'closed', '', 'ecran-7-accueil__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=313', 0, 'page', '', 0),
(314, 1, '2022-05-17 16:19:13', '2022-05-17 14:19:13', '', 'Écrant 7', '', 'inherit', 'closed', 'closed', '', '313-revision-v1', '', '', '2022-05-17 16:19:13', '2022-05-17 14:19:13', '', 313, 'https://happydisplay.opteam.net/?p=314', 0, 'revision', '', 0),
(318, 1, '2022-05-18 11:59:39', '2022-05-18 09:59:39', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 7 - Accueil', '', 'inherit', 'closed', 'closed', '', '313-revision-v1', '', '', '2022-05-18 11:59:39', '2022-05-18 09:59:39', '', 313, 'https://happydisplay.opteam.net/?p=318', 0, 'revision', '', 0),
(319, 1, '2022-05-18 11:59:39', '2022-05-18 09:59:39', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écrant 7', '', 'inherit', 'closed', 'closed', '', '313-revision-v1', '', '', '2022-05-18 11:59:39', '2022-05-18 09:59:39', '', 313, 'https://happydisplay.opteam.net/?p=319', 0, 'revision', '', 0),
(320, 1, '2022-05-18 11:59:42', '2022-05-18 09:59:42', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 7 - Accueil', '', 'inherit', 'closed', 'closed', '', '313-revision-v1', '', '', '2022-05-18 11:59:42', '2022-05-18 09:59:42', '', 313, 'https://happydisplay.opteam.net/?p=320', 0, 'revision', '', 0),
(333, 1, '2022-05-18 12:12:53', '2022-05-18 10:12:53', '', 'Coworkers carrying cardboard box in warehouse.', '', 'inherit', 'closed', 'closed', '', '332-autosave-v1', '', '', '2022-05-18 12:12:53', '2022-05-18 10:12:53', '', 332, 'https://happydisplay.opteam.net/?p=333', 0, 'revision', '', 0),
(336, 1, '2022-05-18 12:27:19', '2022-05-18 10:27:19', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" hover_enabled=\"0\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-05-18 12:27:19', '2022-05-18 10:27:19', '', 183, 'https://happydisplay.opteam.net/?p=336', 0, 'revision', '', 0),
(344, 1, '2022-05-18 14:19:05', '2022-05-18 12:19:05', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 8 - Couloir', '', 'trash', 'closed', 'closed', '', 'ecran-8-couloir__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=344', 0, 'page', '', 0),
(345, 1, '2022-05-18 14:18:01', '2022-05-18 12:18:01', '', 'Ecran 8 - couloir', '', 'inherit', 'closed', 'closed', '', '344-revision-v1', '', '', '2022-05-18 14:18:01', '2022-05-18 12:18:01', '', 344, 'https://happydisplay.opteam.net/?p=345', 0, 'revision', '', 0),
(346, 1, '2022-05-18 14:18:22', '2022-05-18 12:18:22', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 8 - couloir', '', 'inherit', 'closed', 'closed', '', '344-revision-v1', '', '', '2022-05-18 14:18:22', '2022-05-18 12:18:22', '', 344, 'https://happydisplay.opteam.net/?p=346', 0, 'revision', '', 0),
(347, 1, '2022-05-18 14:19:05', '2022-05-18 12:19:05', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 8 - couloir', '', 'inherit', 'closed', 'closed', '', '344-revision-v1', '', '', '2022-05-18 14:19:05', '2022-05-18 12:19:05', '', 344, 'https://happydisplay.opteam.net/?p=347', 0, 'revision', '', 0),
(368, 1, '2022-05-18 14:33:33', '2022-05-18 12:33:33', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 9 - Salle des profs', '', 'trash', 'closed', 'closed', '', 'ecran-9-salle-des-profs__trashed', '', '', '2022-10-27 15:08:48', '2022-10-27 13:08:48', '', 0, 'https://happydisplay.opteam.net/?page_id=368', 0, 'page', '', 0),
(369, 1, '2022-05-18 14:33:11', '2022-05-18 12:33:11', '', 'Écran 9 Salle des profs', '', 'inherit', 'closed', 'closed', '', '368-revision-v1', '', '', '2022-05-18 14:33:11', '2022-05-18 12:33:11', '', 368, 'https://happydisplay.opteam.net/?p=369', 0, 'revision', '', 0),
(370, 1, '2022-05-18 14:33:33', '2022-05-18 12:33:33', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 9 Salle des profs', '', 'inherit', 'closed', 'closed', '', '368-revision-v1', '', '', '2022-05-18 14:33:33', '2022-05-18 12:33:33', '', 368, 'https://happydisplay.opteam.net/?p=370', 0, 'revision', '', 0),
(371, 1, '2022-05-18 14:33:58', '2022-05-18 12:33:58', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" text_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Ecran 1 - Bibliothèque', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-05-18 14:33:58', '2022-05-18 12:33:58', '', 100, 'https://happydisplay.opteam.net/?p=371', 0, 'revision', '', 0),
(372, 1, '2022-05-18 14:34:07', '2022-05-18 12:34:07', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\" hover_enabled=\"0\" sticky_enabled=\"0\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" text_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Bibliothèque', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-05-18 14:34:07', '2022-05-18 12:34:07', '', 100, 'https://happydisplay.opteam.net/?p=372', 0, 'revision', '', 0),
(373, 1, '2022-05-18 14:34:37', '2022-05-18 12:34:37', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 2 - Parking', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-05-18 14:34:37', '2022-05-18 12:34:37', '', 145, 'https://happydisplay.opteam.net/?p=373', 0, 'revision', '', 0),
(374, 1, '2022-05-18 14:34:49', '2022-05-18 12:34:49', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 8 - Couloir', '', 'inherit', 'closed', 'closed', '', '344-revision-v1', '', '', '2022-05-18 14:34:49', '2022-05-18 12:34:49', '', 344, 'https://happydisplay.opteam.net/?p=374', 0, 'revision', '', 0),
(375, 1, '2022-05-18 14:34:57', '2022-05-18 12:34:57', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 9 - Salle des profs', '', 'inherit', 'closed', 'closed', '', '368-revision-v1', '', '', '2022-05-18 14:34:57', '2022-05-18 12:34:57', '', 368, 'https://happydisplay.opteam.net/?p=375', 0, 'revision', '', 0),
(465, 1, '2022-05-19 10:50:13', '2022-05-19 08:50:13', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\" custom_padding=\"0px||0px||false|false\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Bibliothèque', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-05-19 10:50:13', '2022-05-19 08:50:13', '', 100, 'https://happydisplay.opteam.net/?p=465', 0, 'revision', '', 0),
(468, 1, '2022-05-19 10:55:05', '2022-05-19 08:55:05', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" background_video_mp4=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/Em-Normandie-LIGHT.mp4\" height=\"100vh\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Vidéo Background', '', 'publish', 'closed', 'closed', '', 'video-background', '', '', '2022-05-25 14:08:44', '2022-05-25 12:08:44', '', 0, 'https://happydisplay.opteam.net/et_pb_layout/video-background/', 0, 'et_pb_layout', '', 0),
(480, 1, '2022-05-19 11:23:26', '2022-05-19 09:23:26', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" custom_padding=\"0px|0px|0px|0px|false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" background_video_mp4=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/Em-Normandie-LIGHT.mp4\" height=\"100vh\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Vidéo Background', '', 'inherit', 'closed', 'closed', '', '468-revision-v1', '', '', '2022-05-19 11:23:26', '2022-05-19 09:23:26', '', 468, 'https://happydisplay.opteam.net/?p=480', 0, 'revision', '', 0),
(489, 1, '2022-05-19 12:16:23', '2022-05-19 10:16:23', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px|0px|0px|0px|false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px|0px|0px|0px|false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Bibliothèque', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-05-19 12:16:23', '2022-05-19 10:16:23', '', 100, 'https://happydisplay.opteam.net/?p=489', 0, 'revision', '', 0),
(513, 1, '2022-05-25 14:08:42', '2022-05-25 12:08:42', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row _builder_version=\"4.17.3\" _module_preset=\"default\" background_video_mp4=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/Em-Normandie-LIGHT.mp4\" height=\"100vh\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][/et_pb_column][/et_pb_row][/et_pb_section]', 'Vidéo Background', '', 'inherit', 'closed', 'closed', '', '468-revision-v1', '', '', '2022-05-25 14:08:42', '2022-05-25 12:08:42', '', 468, 'https://happydisplay.opteam.net/?p=513', 0, 'revision', '', 0),
(516, 1, '2022-05-25 14:11:15', '2022-05-25 12:11:15', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" background_color=\"RGBA(255,255,255,0)\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Titre\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/EM-Logo-2018.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" body_text_color=\"#FFFFFF\" background_enable_color=\"off\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Hitium et quiasit harum laut fugit esequisque magnatis min poritis nulpa cum et occullicium as debit, inis ut aborporro dolorem rem vendis ilit, solumqu ibusant vollacc ulparum laboratis imusae non eum lacearum seque non rae eos dolores qui ipsanda alis quo il minvelis et moluptas eium quos as as ius es ipient, sum restis porro que consequi ut iur?</p>\n<p><strong>Retrouvez l\'article sur le blog EM Normandie.</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Diapositive Exemple', '', 'publish', 'closed', 'closed', '', 'diapositive-exemple', '', '', '2022-06-21 14:58:35', '2022-06-21 12:58:35', '', 0, 'https://happydisplay.opteam.net/et_pb_layout/diapositive-exemple/', 0, 'et_pb_layout', '', 0),
(517, 1, '2022-05-25 14:11:40', '2022-05-25 12:11:40', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" background_color=\"RGBA(255,255,255,0)\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Titre\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/EM-Logo-2018.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" body_text_color=\"#FFFFFF\" background_enable_color=\"off\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Hitium et quiasit harum laut fugit esequisque magnatis min poritis nulpa cum et occullicium as debit, inis ut aborporro dolorem rem vendis ilit, solumqu ibusant vollacc ulparum laboratis imusae non eum lacearum seque non rae eos dolores qui ipsanda alis quo il minvelis et moluptas eium quos as as ius es ipient, sum restis porro que consequi ut iur?</p>\n<p><strong>Retrouvez l\'article sur le blog EM Normandie.</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Diapositive Exemple', '', 'inherit', 'closed', 'closed', '', '516-revision-v1', '', '', '2022-05-25 14:11:40', '2022-05-25 12:11:40', '', 516, 'https://happydisplay.opteam.net/?p=517', 0, 'revision', '', 0),
(528, 1, '2022-06-14 10:00:06', '2022-06-14 08:00:06', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-06-14 10:00:06', '2022-06-14 08:00:06', '', 183, 'https://happydisplay.opteam.net/?p=528', 0, 'revision', '', 0),
(539, 1, '2022-06-21 14:55:45', '2022-06-21 12:55:45', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_enabled=\"0\"][/et_pb_section]', 'Diapositive Exemple', '', 'inherit', 'closed', 'closed', '', '516-revision-v1', '', '', '2022-06-21 14:55:45', '2022-06-21 12:55:45', '', 516, 'https://happydisplay.opteam.net/?p=539', 0, 'revision', '', 0),
(543, 1, '2022-06-21 14:57:22', '2022-06-21 12:57:22', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_row _builder_version=\"4.17.4\" _module_preset=\"default\" height=\"100vh\" custom_padding=\"0px||0px||false|false\" hover_enabled=\"0\" global_colors_info=\"{}\" theme_builder_area=\"post_content\" title_text=\"OpteamIntranet\" sticky_enabled=\"0\" background_enable_video_mp4=\"off\" background_color=\"#322d49\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\" theme_builder_area=\"post_content\"][et_pb_image _builder_version=\"4.17.4\" _module_preset=\"default\" theme_builder_area=\"post_content\" title_text=\"OpteamIntranet\" background_video_mp4=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/OpteamIntranet.mp4\" hover_enabled=\"0\" sticky_enabled=\"0\"][/et_pb_image][/et_pb_column][/et_pb_row][/et_pb_section]', 'Diapositive Exemple', '', 'inherit', 'closed', 'closed', '', '516-revision-v1', '', '', '2022-06-21 14:57:22', '2022-06-21 12:57:22', '', 516, 'https://happydisplay.opteam.net/?p=543', 0, 'revision', '', 0),
(544, 1, '2022-06-21 14:58:35', '2022-06-21 12:58:35', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" background_color=\"RGBA(255,255,255,0)\" background_image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/header-admission-2022.jpg\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Titre\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/EM-Logo-2018.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" body_text_color=\"#FFFFFF\" background_enable_color=\"off\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Hitium et quiasit harum laut fugit esequisque magnatis min poritis nulpa cum et occullicium as debit, inis ut aborporro dolorem rem vendis ilit, solumqu ibusant vollacc ulparum laboratis imusae non eum lacearum seque non rae eos dolores qui ipsanda alis quo il minvelis et moluptas eium quos as as ius es ipient, sum restis porro que consequi ut iur?</p>\n<p><strong>Retrouvez l\'article sur le blog EM Normandie.</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Diapositive Exemple', '', 'inherit', 'closed', 'closed', '', '516-revision-v1', '', '', '2022-06-21 14:58:35', '2022-06-21 12:58:35', '', 516, 'https://happydisplay.opteam.net/?p=544', 0, 'revision', '', 0),
(554, 1, '2022-07-22 11:03:19', '2022-07-22 09:03:19', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" hover_enabled=\"0\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\" sticky_enabled=\"0\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-07-22 11:03:19', '2022-07-22 09:03:19', '', 183, 'https://happydisplay.opteam.net/?p=554', 0, 'revision', '', 0),
(557, 1, '2022-10-27 10:55:52', '2022-10-27 08:55:52', 'https://happydisplay.opteam.net/wp-content/uploads/2022/10/cropped-logo_hppdspl-admin.jpg', 'cropped-logo_hppdspl-admin.jpg', '', 'inherit', 'open', 'closed', '', 'cropped-logo_hppdspl-admin-jpg', '', '', '2022-10-27 10:55:52', '2022-10-27 08:55:52', '', 0, 'https://happydisplay.opteam.net/wp-content/uploads/2022/10/cropped-logo_hppdspl-admin.jpg', 0, 'attachment', 'image/jpeg', 0),
(558, 1, '2022-10-27 10:56:01', '2022-10-27 08:56:01', '{\n    \"site_icon\": {\n        \"value\": 557,\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2022-10-27 08:56:01\"\n    }\n}', '', '', 'trash', 'closed', 'closed', '', '3bfeb0d3-5bf5-451c-9f83-cb65089e3464', '', '', '2022-10-27 10:56:01', '2022-10-27 08:56:01', '', 0, 'https://happydisplay.opteam.net/3bfeb0d3-5bf5-451c-9f83-cb65089e3464/', 0, 'customize_changeset', '', 0),
(559, 1, '2022-10-27 10:56:31', '2022-10-27 08:56:31', '[]', '', '', 'trash', 'closed', 'closed', '', 'f576ee1b-b67c-481c-aceb-6816d6fe6ad7', '', '', '2022-10-27 10:56:31', '2022-10-27 08:56:31', '', 0, 'https://happydisplay.opteam.net/f576ee1b-b67c-481c-aceb-6816d6fe6ad7/', 0, 'customize_changeset', '', 0),
(560, 1, '2022-10-27 15:06:00', '0000-00-00 00:00:00', '', 'Brouillon auto', '', 'auto-draft', 'open', 'open', '', '', '', '', '2022-10-27 15:06:00', '0000-00-00 00:00:00', '', 0, 'https://happydisplay.opteam.net/?p=560', 0, 'post', '', 0),
(561, 1, '2022-10-27 15:07:56', '2022-10-27 13:07:56', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-10-27 15:07:56', '2022-10-27 13:07:56', '', 183, 'https://happydisplay.opteam.net/?p=561', 0, 'revision', '', 0);
INSERT INTO `hd_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES
(562, 1, '2022-10-27 15:09:07', '2022-10-27 13:09:07', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Bibliothèque', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-10-27 15:09:07', '2022-10-27 13:09:07', '', 100, 'https://happydisplay.opteam.net/?p=562', 0, 'revision', '', 0),
(563, 1, '2022-10-27 15:09:10', '2022-10-27 13:09:10', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Agenda et News', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-10-27 15:09:10', '2022-10-27 13:09:10', '', 100, 'https://happydisplay.opteam.net/?p=563', 0, 'revision', '', 0),
(564, 1, '2022-10-27 15:09:21', '2022-10-27 13:09:21', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_row column_structure=\"3_4,1_4\" use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px|0px|0px|0px|false|false\" global_colors_info=\"{}\"][et_pb_column type=\"3_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" custom_padding=\"0px||0px||false|false\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][et_pb_column type=\"1_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" background_color=\"#1695a0\" custom_padding=\"50px|50px|50px|50px|true|true\" global_colors_info=\"{}\"][et_pb_text _builder_version=\"4.17.3\" _module_preset=\"default\" text_text_color=\"#FFFFFF\" header_font=\"|800||on|||||\" header_text_color=\"#FFFFFF\" header_4_text_color=\"#FFFFFF\" global_colors_info=\"{}\"]<h1>Agenda</h1>\n<p>[MEC id=\"224\"]</p>[/et_pb_text][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 1 - Agenda et News', '', 'inherit', 'closed', 'closed', '', '100-revision-v1', '', '', '2022-10-27 15:09:21', '2022-10-27 13:09:21', '', 100, 'https://happydisplay.opteam.net/?p=564', 0, 'revision', '', 0),
(565, 1, '2022-10-27 15:10:11', '2022-10-27 13:10:11', '[et_pb_section fb_built=\"1\" _builder_version=\"4.17.3\" _module_preset=\"default\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_row use_custom_gutter=\"on\" gutter_width=\"1\" make_equal=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" max_width=\"100%\" height=\"100vh\" custom_padding=\"0px||0px|||\" global_colors_info=\"{}\"][et_pb_column type=\"4_4\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_code _builder_version=\"4.17.3\" _module_preset=\"default\" width=\"100%\" height=\"100%\" global_colors_info=\"{}\"][myscreen][/et_pb_code][/et_pb_column][/et_pb_row][/et_pb_section]', 'Écran 2 - Full écran', '', 'inherit', 'closed', 'closed', '', '145-revision-v1', '', '', '2022-10-27 15:10:11', '2022-10-27 13:10:11', '', 145, 'https://happydisplay.opteam.net/?p=565', 0, 'revision', '', 0),
(566, 1, '2022-10-27 15:10:42', '2022-10-27 13:10:42', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/05/brooke-cagle-LCcFI_26diA-unsplash-scaled-1.jpg\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-10-27 15:10:42', '2022-10-27 13:10:42', '', 183, 'https://happydisplay.opteam.net/?p=566', 0, 'revision', '', 0),
(567, 1, '2022-10-27 15:19:51', '2022-10-27 13:19:51', '', 'pixel_transparent', '', 'inherit', 'open', 'closed', '', 'pixel_transparent', '', '', '2022-10-27 15:19:51', '2022-10-27 13:19:51', '', 0, 'https://happydisplay.opteam.net/wp-content/uploads/2022/10/pixel_transparent.png', 0, 'attachment', 'image/png', 0),
(568, 1, '2022-10-27 15:21:30', '2022-10-27 13:21:30', '[et_pb_section fb_built=\"1\" fullwidth=\"on\" _builder_version=\"4.17.3\" _module_preset=\"default\" global_colors_info=\"{}\"][et_pb_fullwidth_slider show_arrows=\"off\" _builder_version=\"4.18.0\" _module_preset=\"default\" header_font_size=\"50px\" header_line_height=\"1.4em\" body_font_size=\"26px\" body_line_height=\"1.8em\" width=\"100%\" content_width=\"100%\" content_max_width=\"100%\" min_height=\"100vh\" height=\"100%\" custom_padding=\"0px||0px||false|false\" auto=\"on\" auto_speed=\"15000\" header_text_shadow_style=\"preset1\" header_text_shadow_color=\"RGBA(255,255,255,0)\" body_text_shadow_style=\"preset1\" body_text_shadow_color=\"RGBA(255,255,255,0)\" global_colors_info=\"{}\"][et_pb_slide heading=\"Les planètes du monde virtuel semblent alignées pour le metaverse\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.17.3\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" global_colors_info=\"{}\" sticky_transition=\"on\"]<p>Imaginez un monde numérique virtuel, le metaverse, rassemblant les personnes à travers leur avatar, comme jamais auparavant, effaçant toujours plus les frontières entre le monde réel et virtuel, tout en permettant la téléportation entre les différentes applications. Qu’en est-il précisément ?</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][et_pb_slide heading=\"Dirigeants, comment mettre en place la semaine de quatre jours ?\" image=\"https://happydisplay.opteam.net/wp-content/uploads/2022/04/90.png\" _builder_version=\"4.18.0\" _module_preset=\"default\" header_level=\"h2\" header_font=\"|700|||||||\" background_color=\"#022a7f\" background_enable_color=\"on\" background_enable_image=\"off\" hover_enabled=\"0\" global_colors_info=\"{}\" sticky_transition=\"on\" title_text=\"90\" sticky_enabled=\"0\"]<p>La semaine de quatre jours suscite un certain engouement, de la Belgique à l’Espagne. Les entreprises qui sautent le pas restent toutefois minoritaires. Comment procéder ? Mode d’emploi.</p>\n<p><strong>Venez lire l\'article sur le blog EM Normandie !</strong></p>[/et_pb_slide][/et_pb_fullwidth_slider][/et_pb_section]', 'Publi news', '', 'inherit', 'closed', 'closed', '', '183-revision-v1', '', '', '2022-10-27 15:21:30', '2022-10-27 13:21:30', '', 183, 'https://happydisplay.opteam.net/?p=568', 0, 'revision', '', 0);

-- --------------------------------------------------------

--
-- Structure de la table `hd_revslider_css`
--

CREATE TABLE `hd_revslider_css` (
  `id` int(9) NOT NULL,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Déchargement des données de la table `hd_revslider_css`
--

INSERT INTO `hd_revslider_css` (`id`, `handle`, `settings`, `hover`, `advanced`, `params`) VALUES
(1, '.tp-caption.medium_grey', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"padding\":\"2px 4px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#888\"}'),
(2, '.tp-caption.small_text', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"700\",\"font-size\":\"14px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(3, '.tp-caption.medium_text', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"700\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(4, '.tp-caption.large_text', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"700\",\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(5, '.tp-caption.very_large_text', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"0px 2px 5px rgba(0, 0, 0, 0.5)\",\"white-space\":\"nowrap\",\"letter-spacing\":\"-2px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(6, '.tp-caption.very_big_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\",\"padding-top\":\"1px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"800\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"padding\":\"0px 4px\",\"background-color\":\"#000\"}'),
(7, '.tp-caption.very_big_black', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\",\"padding-top\":\"1px\"},\"hover\":\"\"}', '{\"color\":\"#000\",\"font-weight\":\"700\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"padding\":\"0px 4px\",\"background-color\":\"#fff\"}'),
(8, '.tp-caption.modern_medium_fat', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#000\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(9, '.tp-caption.modern_medium_fat_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"800\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(10, '.tp-caption.modern_medium_light', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#000\",\"font-weight\":\"300\",\"font-size\":\"24px\",\"line-height\":\"20px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(11, '.tp-caption.modern_big_bluebg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"letter-spacing\":\"0\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"800\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#4e5b6c\"}'),
(12, '.tp-caption.modern_big_redbg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"padding-top\":\"1px\",\"letter-spacing\":\"0\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-family\":\"\\\"Open Sans\\\", sans-serif\",\"padding\":\"3px 10px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\",\"background-color\":\"#de543e\"}'),
(13, '.tp-caption.modern_small_text_dark', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"white-space\":\"nowrap\"},\"hover\":\"\"}', '{\"color\":\"#555\",\"font-size\":\"14px\",\"line-height\":\"22px\",\"font-family\":\"Arial\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-style\":\"none\"}'),
(14, '.tp-caption.boxshadow', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"-moz-box-shadow\":\"0px 0px 20px rgba(0, 0, 0, 0.5)\",\"-webkit-box-shadow\":\"0px 0px 20px rgba(0, 0, 0, 0.5)\",\"box-shadow\":\"0px 0px 20px rgba(0, 0, 0, 0.5)\"},\"hover\":\"\"}', '[]'),
(15, '.tp-caption.black', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"#000\"}'),
(16, '.tp-caption.noshadow', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '[]'),
(17, '.tp-caption.thinheadline_dark', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"rgba(0,0,0,0.85)\",\"font-weight\":\"300\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(18, '.tp-caption.thintext_dark', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"rgba(0,0,0,0.85)\",\"font-weight\":\"300\",\"font-size\":\"16px\",\"line-height\":\"26px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"transparent\"}'),
(19, '.tp-caption.largeblackbg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#000\",\"padding\":\"0px 20px\",\"border-radius\":\"0px\"}'),
(20, '.tp-caption.largepinkbg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#db4360\",\"padding\":\"0px 20px\",\"border-radius\":\"0px\"}'),
(21, '.tp-caption.largewhitebg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\"},\"hover\":\"\"}', '{\"color\":\"#000\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#fff\",\"padding\":\"0px 20px\",\"border-radius\":\"0px\"}'),
(22, '.tp-caption.largegreenbg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"position\":\"absolute\",\"text-shadow\":\"none\",\"-webkit-border-radius\":\"0px\",\"-moz-border-radius\":\"0px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"font-weight\":\"300\",\"font-size\":\"50px\",\"line-height\":\"70px\",\"font-family\":\"\\\"Open Sans\\\"\",\"background-color\":\"#67ae73\",\"padding\":\"0px 20px\",\"border-radius\":\"0px\"}'),
(23, '.tp-caption.excerpt', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\",\"letter-spacing\":\"-1.5px\",\"width\":\"150px\",\"white-space\":\"normal !important\",\"height\":\"auto\"},\"hover\":\"\"}', '{\"font-size\":\"36px\",\"line-height\":\"36px\",\"font-weight\":\"700\",\"font-family\":\"Arial\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"rgba(0, 0, 0, 1)\",\"margin\":\"0px\",\"padding\":\"1px 4px 0px 4px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 255, 255)\",\"border-style\":\"none\"}'),
(24, '.tp-caption.large_bold_grey', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"margin\":\"0px\",\"padding\":\"1px 4px 0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(25, '.tp-caption.medium_thin_grey', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"font-size\":\"34px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(102, 102, 102)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(26, '.tp-caption.small_thin_grey', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"font-size\":\"18px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(117, 117, 117)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"1px 4px 0px\",\"margin\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(27, '.tp-caption.lightgrey_divider', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"width\":\"370px\",\"height\":\"3px\",\"background-position\":\"initial initial\",\"background-repeat\":\"initial initial\"},\"hover\":\"\"}', '{\"text-decoration\":\"none\",\"background-color\":\"rgba(235, 235, 235, 1)\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(28, '.tp-caption.large_bold_darkblue', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(29, '.tp-caption.medium_bg_darkblue', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(52, 73, 94)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(30, '.tp-caption.medium_bold_red', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(31, '.tp-caption.medium_light_red', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"21px\",\"line-height\":\"26px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(227, 58, 12)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(32, '.tp-caption.medium_bg_red', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(227, 58, 12)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(33, '.tp-caption.medium_bold_orange', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"24px\",\"line-height\":\"30px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(243, 156, 18)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(34, '.tp-caption.medium_bg_orange', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(243, 156, 18)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(35, '.tp-caption.grassfloor', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"width\":\"4000px\",\"height\":\"150px\"},\"hover\":\"\"}', '{\"text-decoration\":\"none\",\"background-color\":\"rgba(160, 179, 151, 1)\",\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(36, '.tp-caption.large_bold_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(37, '.tp-caption.medium_light_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(38, '.tp-caption.mediumlarge_light_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(39, '.tp-caption.mediumlarge_light_white_center', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px 0px 0px 0px\",\"text-align\":\"center\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(40, '.tp-caption.medium_bg_asbestos', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(127, 140, 141)\",\"padding\":\"10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(41, '.tp-caption.medium_light_black', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"30px\",\"line-height\":\"36px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(42, '.tp-caption.large_bold_black', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"58px\",\"line-height\":\"60px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(43, '.tp-caption.mediumlarge_light_darkblue', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"34px\",\"line-height\":\"40px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(52, 73, 94)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(44, '.tp-caption.small_light_white', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"17px\",\"line-height\":\"28px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"padding\":\"0px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(45, '.tp-caption.roundedimage', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"border-width\":\"0px\",\"border-color\":\"rgb(34, 34, 34)\",\"border-style\":\"none\"}'),
(46, '.tp-caption.large_bg_black', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":[],\"hover\":\"\"}', '{\"font-size\":\"40px\",\"line-height\":\"40px\",\"font-weight\":\"800\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(255, 255, 255)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(0, 0, 0)\",\"padding\":\"10px 20px 15px\",\"border-width\":\"0px\",\"border-color\":\"rgb(255, 214, 88)\",\"border-style\":\"none\"}'),
(47, '.tp-caption.mediumwhitebg', '{\"translated\":5,\"type\":\"text\",\"version\":\"4\"}', 'null', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-family\":\"\\\"Open Sans\\\"\",\"color\":\"rgb(0, 0, 0)\",\"text-decoration\":\"none\",\"background-color\":\"rgb(255, 255, 255)\",\"padding\":\"5px 15px 10px\",\"border-width\":\"0px\",\"border-color\":\"rgb(0, 0, 0)\",\"border-style\":\"none\"}'),
(48, '.tp-caption.MarkerDisplay', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ff0000\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0px\",\"0px\",\"0px\",\"0px\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"font-style\":\"normal\",\"font-family\":\"Permanent Marker\",\"padding\":\"0px 0px 0px 0px\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"#000000\",\"border-style\":\"none\",\"border-width\":\"0px\",\"border-radius\":\"0px 0px 0px 0px\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(49, '.tp-caption.Restaurant-Display', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"font-size\":\"120px\",\"line-height\":\"120px\",\"font-weight\":\"700\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(50, '.tp-caption.Restaurant-Cursive', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Nothing you could do\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(51, '.tp-caption.Restaurant-ScrollDownText', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"font-size\":\"17px\",\"line-height\":\"17px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(52, '.tp-caption.Restaurant-Description', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":{\"letter-spacing\":\"3px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"font-size\":\"20px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(53, '.tp-caption.Restaurant-Price', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\"}', '{\"idle\":{\"letter-spacing\":\"3px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(54, '.tp-caption.Restaurant-Menuitem', '{\"hover\":\"false\",\"type\":\"text\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#ffffff\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"500\",\"easing\":\"power2.inOut\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"17px\",\"line-height\":\"17px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"10px\",\"30px\",\"10px\",\"30px\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"#000000\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(55, '.tp-caption.Furniture-LogoText', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"#e6cfa3\",\"color-transparency\":\"1\",\"font-size\":\"160px\",\"line-height\":\"150px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(56, '.tp-caption.Furniture-Plus', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"30px\",\"30px\",\"30px\",\"30px\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0.5\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\",\"box-shadow\":\"rgba(0,0,0,0.1) 0 1px 3px\"},\"hover\":\"\"}', '{\"color\":\"#e6cfa3\",\"color-transparency\":\"1\",\"font-size\":\"20\",\"line-height\":\"20px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":[\"6px\",\"7px\",\"4px\",\"7px\"],\"text-decoration\":\"none\",\"background-color\":\"#ffffff\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"30px\",\"30px\",\"30px\",\"30px\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(57, '.tp-caption.Furniture-Title', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\",\"letter-spacing\":\"3px\"},\"hover\":\"\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"700\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(58, '.tp-caption.Furniture-Subtitle', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"font-size\":\"17px\",\"line-height\":\"20px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(59, '.tp-caption.Gym-Display', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"80px\",\"line-height\":\"70px\",\"font-weight\":\"900\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(60, '.tp-caption.Gym-Subline', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"5px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"100\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(61, '.tp-caption.Gym-SmallText', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"17px\",\"line-height\":\"22\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(62, '.tp-caption.Fashion-SmallText', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"12px\",\"line-height\":\"20px\",\"font-weight\":\"600\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(63, '.tp-caption.Fashion-BigDisplay', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"font-size\":\"60px\",\"line-height\":\"60px\",\"font-weight\":\"900\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(64, '.tp-caption.Fashion-TextBlock', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"font-size\":\"20px\",\"line-height\":\"40px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(65, '.tp-caption.Sports-Display', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"13px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"130px\",\"line-height\":\"130px\",\"font-weight\":\"100\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":\"0 0 0 0\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":\"0 0 0 0\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(66, '.tp-caption.Sports-DisplayFat', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":[\"\"],\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"130px\",\"line-height\":\"130px\",\"font-weight\":\"900\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":\"0 0 0 0\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":\"0 0 0 0\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(67, '.tp-caption.Sports-Subline', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"4px\"},\"hover\":\"\"}', '{\"color\":\"#000000\",\"color-transparency\":\"1\",\"font-size\":\"32px\",\"line-height\":\"32px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"\\\"Raleway\\\"\",\"padding\":\"0 0 0 0\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":\"0 0 0 0\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(68, '.tp-caption.Instagram-Caption', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"900\",\"font-style\":\"normal\",\"font-family\":\"Roboto\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(69, '.tp-caption.News-Title', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"70px\",\"line-height\":\"60px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Roboto Slab\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}');
INSERT INTO `hd_revslider_css` (`id`, `handle`, `settings`, `hover`, `advanced`, `params`) VALUES
(70, '.tp-caption.News-Subtitle', '{\"hover\":\"true\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"0.65\",\"text-decoration\":\"none\",\"background-color\":\"#ffffff\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"solid\",\"border-width\":\"0px\",\"border-radius\":[\"0\",\"0\",\"0px\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"300\",\"easing\":\"power3.inOut\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"15px\",\"line-height\":\"24px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Roboto Slab\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"#ffffff\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(71, '.tp-caption.Photography-Display', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"5px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"80px\",\"line-height\":\"70px\",\"font-weight\":\"100\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(72, '.tp-caption.Photography-Subline', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"3px\"},\"hover\":\"\"}', '{\"color\":\"#777777\",\"color-transparency\":\"1\",\"font-size\":\"20px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(73, '.tp-caption.Photography-ImageHover', '{\"hover\":\"true\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"0.5\",\"scalex\":\"0.8\",\"scaley\":\"0.8\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"1000\",\"easing\":\"power3.inOut\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"20\",\"line-height\":\"22\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"#ffffff\",\"border-transparency\":\"0\",\"border-style\":\"none\",\"border-width\":\"0px\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(74, '.tp-caption.Photography-Menuitem', '{\"hover\":\"true\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#00ffde\",\"background-transparency\":\"0.65\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"200\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"20px\",\"line-height\":\"20px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"3px\",\"5px\",\"3px\",\"8px\"],\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"0.65\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(75, '.tp-caption.Photography-Textblock', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"color-transparency\":\"1\",\"font-size\":\"17px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(76, '.tp-caption.Photography-Subline-2', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"3px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"0.35\",\"font-size\":\"20px\",\"line-height\":\"30px\",\"font-weight\":\"300\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(77, '.tp-caption.Photography-ImageHover2', '{\"hover\":\"true\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"0.5\",\"scalex\":\"0.8\",\"scaley\":\"0.8\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"500\",\"easing\":\"back.out\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"20\",\"line-height\":\"22\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Arial\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"#ffffff\",\"border-transparency\":\"0\",\"border-style\":\"none\",\"border-width\":\"0px\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(78, '.tp-caption.WebProduct-Title', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#333333\",\"color-transparency\":\"1\",\"font-size\":\"90px\",\"line-height\":\"90px\",\"font-weight\":\"100\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(79, '.tp-caption.WebProduct-SubTitle', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#999999\",\"color-transparency\":\"1\",\"font-size\":\"15px\",\"line-height\":\"20px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(80, '.tp-caption.WebProduct-Content', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#999999\",\"color-transparency\":\"1\",\"font-size\":\"16px\",\"line-height\":\"24px\",\"font-weight\":\"600\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\"}'),
(81, '.tp-caption.WebProduct-Menuitem', '{\"hover\":\"true\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#999999\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#ffffff\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"200\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"2px\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"15px\",\"line-height\":\"20px\",\"font-weight\":\"500\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"3px\",\"5px\",\"3px\",\"8px\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"#333333\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(82, '.tp-caption.WebProduct-Title-Light', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#fff\",\"color-transparency\":\"1\",\"font-size\":\"90px\",\"line-height\":\"90px\",\"font-weight\":\"100\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(83, '.tp-caption.WebProduct-SubTitle-Light', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"0.35\",\"font-size\":\"15px\",\"line-height\":\"20px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"parallax\":\"-\"}'),
(84, '.tp-caption.WebProduct-Content-Light', '{\"hover\":\"false\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"0.65\",\"font-size\":\"16px\",\"line-height\":\"24px\",\"font-weight\":\"600\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"parallax\":\"-\"}'),
(85, '.tp-caption.FatRounded', '{\"hover\":\"true\",\"type\":\"text\",\"version\":\"5.0\",\"translated\":\"5\"}', '{\"color\":\"#fff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"1\",\"border-color\":\"#d3d3d3\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0px\",\"border-radius\":[\"50px\",\"50px\",\"50px\",\"50px\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"300\",\"easing\":\"none\"}', '{\"idle\":{\"text-shadow\":\"none\"},\"hover\":\"\"}', '{\"color\":\"#fff\",\"color-transparency\":\"1\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"900\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":[\"20px\",\"22px\",\"20px\",\"25px\"],\"text-decoration\":\"none\",\"text-align\":\"left\",\"background-color\":\"#000000\",\"background-transparency\":\"0.5\",\"border-color\":\"#d3d3d3\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0px\",\"border-radius\":[\"50px\",\"50px\",\"50px\",\"50px\"],\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(86, '.tp-caption.NotGeneric-Title', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":\"[object Object]\",\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"70px\",\"line-height\":\"70px\",\"font-weight\":\"800\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":\"10px 0px 10px 0\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":\"0 0 0 0\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(87, '.tp-caption.NotGeneric-SubTitle', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"auto\",\"speed\":\"0\",\"easing\":\"none\"}', '{\"idle\":{\"letter-spacing\":\"4px\",\"text-align\":\"left\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"13px\",\"line-height\":\"20px\",\"font-weight\":\"500\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":\"0 0 0 0\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"1\",\"border-color\":\"transparent\",\"border-transparency\":\"1\",\"border-style\":\"none\",\"border-width\":\"0\",\"border-radius\":\"0 0 0 0\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(88, '.tp-caption.NotGeneric-CallToAction', '{\"hover\":\"true\",\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"1\",\"border-style\":\"solid\",\"border-width\":\"1\",\"border-radius\":\"0px 0px 0px 0px\",\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"300\",\"easing\":\"power3.out\"}', '{\"idle\":{\"letter-spacing\":\"3px\",\"text-align\":\"left\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"14px\",\"line-height\":\"14px\",\"font-weight\":\"500\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":\"10px 30px 10px 30px\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"0.5\",\"border-style\":\"solid\",\"border-width\":\"1\",\"border-radius\":\"0px 0px 0px 0px\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(89, '.tp-caption.NotGeneric-Icon', '{\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"transparent\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"1\",\"border-style\":\"solid\",\"border-width\":\"1\",\"border-radius\":[\"0px\",\"0px\",\"0px\",\"0px\"],\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"default\",\"speed\":\"300\",\"easing\":\"power3.out\"}', '{\"idle\":{\"letter-spacing\":\"3px\",\"text-align\":\"left\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"30px\",\"line-height\":\"30px\",\"font-weight\":\"400\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":\"0px 0px 0px 0px\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"0\",\"border-style\":\"solid\",\"border-width\":\"0px\",\"border-radius\":\"0px 0px 0px 0px\",\"z\":\"0\",\"skewx\":\"0\",\"skewy\":\"0\",\"scalex\":\"1\",\"scaley\":\"1\",\"opacity\":\"1\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"2d_origin_x\":\"50\",\"2d_origin_y\":\"50\",\"pers\":\"600\",\"corner_left\":\"nothing\",\"corner_right\":\"nothing\",\"parallax\":\"-\"}'),
(90, '.tp-caption.NotGeneric-Menuitem', '{\"hover\":\"true\",\"translated\":5,\"type\":\"text\",\"version\":\"5.0\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"1\",\"border-style\":\"solid\",\"border-width\":\"1px\",\"border-radius\":\"0px 0px 0px 0px\",\"opacity\":\"1\",\"scalex\":\"1\",\"scaley\":\"1\",\"skewx\":\"0\",\"skewy\":\"0\",\"xrotate\":\"0\",\"yrotate\":\"0\",\"2d_rotation\":\"0\",\"pointer_events\":\"auto\",\"css_cursor\":\"pointer\",\"speed\":\"300\",\"easing\":\"power1.inOut\"}', '{\"idle\":{\"letter-spacing\":\"3px\",\"text-align\":\"left\"},\"hover\":\"\"}', '{\"color\":\"#ffffff\",\"color-transparency\":\"1\",\"font-size\":\"14px\",\"line-height\":\"14px\",\"font-weight\":\"500\",\"font-style\":\"normal\",\"font-family\":\"Raleway\",\"padding\":\"27px 30px 27px 30px\",\"text-decoration\":\"none\",\"background-color\":\"#000000\",\"background-transparency\":\"0\",\"border-color\":\"#ffffff\",\"border-transparency\":\"0.15\",\"border-style\":\"solid\",\"border-width\":\"1px\",\"border-radius\":\"