<?php

// ACTIVTATION DU THEME ENFANT

function theme_enqueue_styles() {
 wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );


// AJOUT DES ICONES FONT AWESOME

function dc_load_fontawesome() {
  wp_enqueue_style( 'font-awesome', '//maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css', null, '4.7.0' );
}
add_action('wp_enqueue_scripts', 'dc_load_fontawesome');


// MASQUER LES ERREURS DE CONNEXION A L'ADMINISTRATION

function wpm_hide_errors() {
	return "L'identifiant ou le mot de passe est incorrect";
}
add_filter('login_errors', 'wpm_hide_errors');

// Supprime les notifications de mise à jour
/*
function remove_core_updates(){
    global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
add_filter('pre_site_transient_update_core','remove_core_updates');
add_filter('pre_site_transient_update_plugins','remove_core_updates');
add_filter('pre_site_transient_update_themes','remove_core_updates');
*/

// Removes et_add_viewport_meta from the wp_head phase
function remove_divi_actions() {
	remove_action( 'wp_head', 'et_add_viewport_meta' );
}
add_action('init','remove_divi_actions');
	
function et_add_viewport_meta_2(){
	echo '<meta name="viewport" content="width=device-width, initial-scale=0.5, maximum-scale=1.0, user-scalable=no" />';
}
add_action( 'wp_head', 'et_add_viewport_meta_2' );

/*********************************** 
Personnalisation de la page de login
***********************************/

//Nouveau css
function custom_login_css() {
echo '<link rel="stylesheet" type="text/css" href="' . get_stylesheet_directory_uri() . '/css/login-opteam.css" />';
}
add_action('login_head', 'custom_login_css');

//URL du logo
function custom_url_login() {
return 'http://www.opteam-interactive.com';
}
add_filter('login_headerurl', 'custom_url_login');

//Attribut title du logo
function custom_title_login($message) {
return 'Opteam Interactive Agence de communication Le Havre';
}
add_filter('login_headertitle', 'custom_title_login');

/*
 * JS Opteam
 */
function theme_enqueue_scripts() {
	wp_enqueue_script( 'opteam-script', get_stylesheet_directory_uri() . '/js/scripts.js', array( 'jquery' ));
	wp_enqueue_script( 'fancybox-script', '//cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.js', array( 'jquery' ));

}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_scripts' );

function remove_toolbar_items($wp_adminbar) {
    $wp_adminbar->remove_node('wpseo-menu');
    $wp_adminbar->remove_node('edit');
    $wp_adminbar->remove_node('new-content');
    $wp_adminbar->remove_node('site-name');
    $wp_adminbar->remove_node('wp-logo');
    $wp_adminbar->remove_node('smart_slider_3');
    $wp_adminbar->remove_node('comments');

} 
add_action('admin_bar_menu', 'remove_toolbar_items', 999);

function custom_login_redirect( $redirect_to, $request, $user ) {
	if ( isset( $user->roles ) && is_array( $user->roles ) ) {
	if ( in_array( 'administrator', $user->roles )) {
	$redirect_to = admin_url('/admin.php?page=monitoring');
	} else {
	$redirect_to = home_url();
	}
	}
	return $redirect_to;
}
add_filter( 'login_redirect', 'custom_login_redirect', 10, 3 );

function Renommer_projets_divi() {

	/* Renommer le custom post type */
		

		register_post_type( 'project',
			array(
				'labels' => array(
				  'name' => __( 'Publications', 'divi' ),
				  'singular_name' => __( 'Publication', 'divi' ),
	
			),
			'has_archive' => true,
			'hierarchical' => true,
			'public' => true,
			'rewrite' => array( 'slug' => 'publications', 'with_front' => true ),
			'supports' => array(),
			'menu_icon' => 'dashicons-paperclip',
		));
	
	/* Renommer la catégorie
		register_taxonomy( 'project_category', array( 'project' ),
		  array(
			'labels' => array(
			  'name' => _x( 'Catégories de publications', 'Catégories de publications', 'Divi' ),
		  ),
			'hierarchical' => true,
			'show_ui' => true,
			'rewrite' => array( 'slug' => 'publications'),
			'show_admin_column' => true,
			'query_var' => true,
		) ); */
		unregister_taxonomy( 'project_category' );
	
	/* Renommer les étiquettes 
		register_taxonomy( 'project_tag', array( 'project' ),
		  array(
			'labels' => array(
			  'name' => _x( 'Étiquettes des publications', 'Étiquettes des publications', 'Divi' ),
		  ),
			'hierarchical' => true,
			'show_ui' => true,
			'show_admin_column' => true,
			'query_var' => true,
		) );*/
		unregister_taxonomy( 'project_tag' );
	
	}
	add_action( 'init', 'Renommer_projets_divi' );

	function wpd_change_page_labels( $labels ) {
		$labels->menu_name  = 'Écrans';
		$labels->name  = 'Écrans';
		$labels->singular_name  = 'Écran';
		return $labels;
	}
	add_filter( 'post_type_labels_page', 'wpd_change_page_labels' );

	add_filter( 'manage_project_posts_columns', function ($columns) {
		$coll = [];
		$i = 0;
		foreach($columns as $columni=>$value):
			$coll = array_merge($coll, array(
				$columni => $value
			));
			$i++;
			if($i == 2):
				$coll = array_merge($coll, array(
					'ecran' => __( 'Écran' )
				));
			endif;
		endforeach;
		return $coll;
	} );
	
	add_action( 'manage_project_posts_custom_column', function ($column, $post_id) {
		$array = [];
		switch ($column) {
			case 'ecran':
				$ecran = get_field("page_associee",$post_id);
				if(is_array($ecran)):
					foreach($ecran as $screen):
						$array[] = get_the_title($screen);
					endforeach;
					asort($array);
					echo implode(", ", $array);
				elseif(!empty($ecran)):
					echo get_the_title($ecran);
				else:
					echo '<span aria-hidden="true">Aucun écran</span>';
				endif;
				break;
		}
	}, 10, 2 );
	
	add_filter( 'manage_edit-project_sortable_columns', function ($cols) {
		$cols['ecran'] = 'ecran';
		return $cols;
	});
	
	function ecran_column_orderby( $vars ) {
		if ( isset( $vars['orderby'] ) && 'ecran' == $vars['orderby'] ) {
			$vars = array_merge( $vars, array(
				'meta_key' => 'page_associee',
				'orderby' => 'meta_value_num'
			) );
		}	 
		return $vars;
	}
	add_filter( 'request', 'ecran_column_orderby' );
	
	add_filter( 'parse_query', 'ecran_admin_posts_filter' );
	add_action( 'restrict_manage_posts', 'ecran_admin_posts_filter_restrict_manage_posts' );
	 
	function ecran_admin_posts_filter( $query ){
		global $pagenow;
		if ( is_admin() && $pagenow=='edit.php' && $query->is_main_query() && isset($_GET['ADMIN_FILTER_ECRAN']) && $_GET['ADMIN_FILTER_ECRAN'] != '') {
			$query->query_vars['meta_key'] = "page_associee";
			$query->query_vars['meta_value'] = $_GET['ADMIN_FILTER_ECRAN'];
			$query->query_vars['meta_compare'] = "LIKE";
		}
	}
	 
	function ecran_admin_posts_filter_restrict_manage_posts($post_type){
		if ( $post_type == 'project'):
			global $wpdb;
			$select = '<select name="ADMIN_FILTER_ECRAN" id="ADMIN_FILTER_ECRAN" class="postform">';
			if(isset($_GET['ADMIN_FILTER_ECRAN']) && $_GET['ADMIN_FILTER_ECRAN'] == ''):
				$select .= '<option value="" selected="selected">Tous les écrans</option>';
			else:
				$select .= '<option value="">Tous les écrans</option>';
			endif;
			$screens = get_posts(array(
				'posts_per_page'  => -1,
				'post_type'       => 'page',
				'post_status'     => 'publish',
				'orderby'         => 'title',
				'order'           => 'ASC',
			));
			foreach($screens as $screen):
				$id_ecran = $screen->ID;
				if(isset($_GET['ADMIN_FILTER_ECRAN']) && $_GET['ADMIN_FILTER_ECRAN'] == $id_ecran):
					$select .= '<option value="'.$id_ecran.'" selected="selected">'.get_the_title($id_ecran).'</option>';
				else:
					$select .= '<option value="'.$id_ecran.'">'.get_the_title($id_ecran).'</option>';
				endif;
			endforeach;

			$select .= '</select>';
			echo $select;
		endif;
	}

// Mes fonctions

function shortcode_myscreen(){
	if ( is_page() ):
        global $post;
		$html = "";
		$id = $post->ID;

		$projects = new WP_Query(array(
			'posts_per_page'  => 1,
			'post_type'       => 'project',
			'post_status'     => 'publish',
			'orderby'         => 'date',
			'order'           => 'DESC',
            'suppress_filters' => true,
			'meta_query'	=> array(
				'relation'		=> 'AND',
				array(
					'key'	 	=> 'page_associee',
					'value'	  	=> $id,
					'compare' 	=> 'LIKE',
				),
			),
		));

		if(isset($projects) && $projects->have_posts()):
			while($projects->have_posts() ) : $projects->the_post();
				$id_projects = $projects->post->ID;
				$screen = get_post($id_projects);
				$the_content = apply_filters('the_content', $screen->post_content);
				$html .= $the_content;
			endwhile;
		else:
			$html .= 'Aucune publication';
		endif;

        return $html;
	endif;
}
add_shortcode('myscreen', 'shortcode_myscreen');