<?php
class OPTEAM_IMPORT{
    public function __construct(){
		add_action('admin_menu', array($this, 'optimport_add_admin_menu'), 2);
		add_action('admin_menu', array($this, 'optimport_add_logout'), 99);
		add_action('admin_enqueue_scripts', array($this, 'optimport_init'));
    }
	
	// CETTE FONCTION AJOUTE UNE PAGE D'ADMINISTRATION
	public function optimport_add_admin_menu(){
		add_menu_page(
		  "Monitoring", // PAGE TITLE
		  "Monitoring", // MENU TITLE
		  'manage_options', // CAPABILITY
		  'monitoring', // MENU SLUG
		  array($this, 'optimport_index'), // FUNCTION
		  OPTIMPORT_PLUGIN_DIR_URL.'admin/img/small.png'
		);
	}

	public function optimport_add_logout(){
		add_menu_page(
		  "Se déconnecter", // PAGE TITLE
		  "Se déconnecter", // MENU TITLE
		  'manage_options', // CAPABILITY
		  wp_logout_url(),
		  '',
		  'dashicons-migrate'
		);
	}

	// CETTE FONCTION CHARGE LES CSS ET JS DU PLUGIN
	public function optimport_init() {
		wp_register_script('optjs', OPTIMPORT_PLUGIN_DIR_URL.'assets/js/admin.js', false, '1.0');
		wp_enqueue_script('optjs');

		wp_register_style( 'optcss',  OPTIMPORT_PLUGIN_DIR_URL.'assets/css/main.css', false, '1.0' );
		wp_enqueue_style( 'optcss' );
	}

/* #################################################################################################################################################################################################### */
/* #### PAGES ######################################################################################################################################################################################### */
/* #################################################################################################################################################################################################### */

	// CETTE FONCTION AFFICHE LE CONTENU DE LA PAGE ADMIN
	public function optimport_index(){
		include OPTIMPORT_PLUGIN_DIR."index.php";
	}
}

  // CETTE FONCTION INITIALISE ET REND GLOBAL LES OBJETS
  function init_objects(){
    $OPTEAM_IMPORT = new OPTEAM_IMPORT();
    $GLOBALS["OPTEAM_IMPORT"] = $OPTEAM_IMPORT;
  }
  add_action('init', 'init_objects');
?>
