<?php

/*
 * this class should be used to work with the public side of wordpress
 */
class Daln_Public{
    
    //general class properties
    protected static $instance = null;
    private $shared = null;
    private $apply_ticker = true;

    /*
     * create an instance of this class
     */
    public static function get_instance() {

        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    private function __construct() {
        
        //assign an instance of the shared class
        $this->shared = Daln_Shared::get_instance();

        //Write in the front-end head
        add_action('wp_head', array( $this, 'generate_ticker'));

        //Load public css and js
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

        /*
         * This hook is triggered right after a category is deleted with the Posts -> Category menu. It's placed here
         * because doesn't work if used in the Daln_Admin class.
         */
        add_action( 'delete_category', array( $this, 'ticker_delete_category' ) );
        
    }

    public function enqueue_styles() {
        wp_enqueue_style( $this->shared->get('slug') .'-general', $this->shared->get('url') . 'public/assets/css/general.css', array(), $this->shared->get('ver') );
    }

    public function enqueue_scripts() {

        wp_enqueue_script( $this->shared->get('slug') . 'general', $this->shared->get('url') . 'public/assets/js/general.js', array( 'jquery' ), $this->shared->get('ver') );

        if(intval(get_option("daln_load_momentjs"), 10) === 1){
            wp_enqueue_script( $this->shared->get('slug') . '-momentjs', $this->shared->get('url') . 'public/assets/js/momentjs/momentjs.js', array( 'jquery' ), $this->shared->get('ver') );
        }

    }

	/*
	 * This method generates in the <head> section of the page:
	 *
	 * - All the javascript variables used by general.js to generate the news ticker
	 * - The CSS of the ticker
	 */
    function generate_ticker(){

        $current_url = $this->shared->get_current_url();
        $ticker_obj = $this->shared->get_ticker_with_target_url($current_url);

        /*
         * If there isn't a ticker associated with this url use the ticker associated with the website if exists.
         */
        if($ticker_obj === false){

            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
            $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE target = %d", 1);
            $ticker_obj = $wpdb->get_row($safe_sql);

            //if there is no ticker set the class property $apply_ticker to true and return
            if($ticker_obj === NULL){
                $this->apply_ticker = false;
            }

        }

        /*
         * Do not display the ticker if the "Enable Ticker" flag is set to no
         */
        if( $ticker_obj === NULL or intval($ticker_obj->enable_ticker, 10) == 0){
            $this->apply_ticker = false;
        }

        /*
         * Do not display the ticker if the "Mobile Detect" class detects that the current devices is a mobile device
         * and at the same time the "Enable with Mobile Devices" option is set to "No" (0). Do not even load the
         * Mobile Detect class and perform this check if the ticker should not be applied.
         */
        if($this->apply_ticker) {
            require_once( $this->shared->get( 'dir' ) . 'public/inc/mobile-detect/Mobile_Detect.php' );
            $detect = new Daln_Mobile_Detect();
            if ( $detect->isMobile() and intval( $ticker_obj->enable_with_mobile_devices, 10 ) == 0 ) {
                $this->apply_ticker = false;
            }
        }

        if($this->apply_ticker) {

	        //apply the ticker
            echo '<script type="text/javascript">';

                /*
                 * Flag used to verify if the ticker should be appended by javascript (in general.js) before the ending
                 * body tag
                 */
                echo 'var daln_apply_ticker = true;';

                //nonce used for the ajax requests
                echo 'var daln_nonce = "' . wp_create_nonce( "live-news" ) . '";';

                //set the ajax url variable in javascript
                echo 'var daln_ajax_url = "' . admin_url( 'admin-ajax.php' ) . '";';

                //set the plugin url variable in javascript
                echo 'var daln_plugin_url = "' . WP_PLUGIN_URL . '/live-news/";';

                //set the target attribute of the links
                if(intval($ticker_obj->open_links_new_tab, 10) == 1){
                    echo "var daln_target_attribute = '_blank';";
                }else{
                    echo "var daln_target_attribute = '_self';";
                }

                //set the sliding speed in a javascript variable
                $sliding_speed = intval( ( 50 / intval( $ticker_obj->sliding_speed, 10 ) ), 10 );
                echo 'var daln_sliding_speed = ' . $sliding_speed . ';';

                //set the sliding delay
                echo 'var daln_sliding_delay = ' . intval($ticker_obj->sliding_delay, 10) . ';';

                //set the rtl layout option in a javscript variable
                echo 'var daln_rtl_layout = ' . intval( $ticker_obj->enable_rtl_layout, 10 ) . ';';

                //set the number of cached cycles
                echo 'var daln_cached_cycles = ' . abs(intval($ticker_obj->cached_cycles, 10)) . ';';

                //set the ticker_id
                echo 'var daln_ticker_id = ' . intval($ticker_obj->id, 10) . ';';

		        //enable_links
	            if(intval($ticker_obj->enable_links, 10) == 1){
		            $enable_links_javascript_value = 'true';
	            }else{
		            $enable_links_javascript_value = 'false';
	            }
		        echo 'var daln_enable_links = ' . $enable_links_javascript_value . ';';

		        //clock offset
		        echo 'var daln_clock_offset = ' . intval($ticker_obj->clock_offset, 10) . ';';

                //clock format
                echo 'var daln_clock_format = ' . json_encode(stripslashes($ticker_obj->clock_format)) . ';';

                //clock source
	            echo 'var daln_clock_source = ' . intval($ticker_obj->clock_source, 10) . ';';

		        //clock autoupdate
		        echo 'var daln_clock_autoupdate = ' . intval($ticker_obj->clock_autoupdate, 10) . ';';

		        //clock autoupdate time
		        echo 'var daln_clock_autoupdate_time = ' . intval($ticker_obj->clock_autoupdate_time, 10) . ';';

	            /*
	             * If the transient exists generate the daln_ticker_transient JavaScript variable. Which is a string
	             * that includes the ticker XML.
	             */
                $ticker_transient = get_transient('daln_ticker_' . $ticker_obj->id);
                if($ticker_transient !== false){

                    /*
                     * Save the XML string in a JavaScript variable.
                     *
                     * Note that json_encode() is only used to avoid errors and escape the JavaScript variable, not
                     * to perform a conversion to json. The resulting daln_ticker_transient JavaScript variable is
                     * an XML string. (that will be converted to an actual XML Document by jQuery.parseXML() in
                     * general.js)
                     */
                    echo 'var daln_ticker_transient = ' . json_encode($ticker_transient) . ';';

                }

            echo '</script>' . "\n";

            echo '<style type="text/css">';

                if ( $ticker_obj->hide_featured_news == 2 or ( $ticker_obj->hide_featured_news == 3 and $detect->isMobile() ) ){

	                /*
	                 * If in "Hide the featured news" is selected "Yes" or if is selected "Only with Mobile Devices" and
	                 * the current device is a mobile device hide the featured news area remove the button used to open
	                 * and close the featured news area.
	                 */
                    echo "#daln-container{ min-height: 40px; }";
                    echo "#daln-featured-container{ display: none; }";
                    echo "#daln-open{ display: none; }";

                }

                /*
                * If in "Hide the featured news" is selected "No" or if is selected "Only with Mobile Devices" and
                * the current device is not a mobile device use the "live_news_status" cookie to determine the
                * status of the news ticker (open or closed).
                */
                if ( isset( $_COOKIE['live_news_status'] ) ) {

                    //If the live_news_status cookie exists set the gallery status based on this cookie
                    if ( $_COOKIE['live_news_status'] == "open" ) {
                        $current_status = "open";
                    } else {
                        $current_status = "closed";
                    }

                } else {

                    /*
                     * If the "live_news_status" cookie doesn't exist set the gallery status based on the
                     * "Open news as default" option.
                     */
                    if ( intval($ticker_obj->open_news_as_default, 10) == 1 ) {
                        $current_status = "open";
                    } else {
                        $current_status = "closed";
                    }

                }

                /*
                 * Use the status to set the proper CSS
                 */
                if ( $current_status == "open" ) {

                    echo "#daln-container{ display: block; }";
                    echo "#daln-open{ display: none; }";

                } else {

                    echo "#daln-container{ display: none; }";
                    echo "#daln-open{ display: block; }";

                }

		        //set the font family based on the plugin option
		        echo '#daln-featured-title, #daln-featured-title a,#daln-featured-excerpt, #daln-featured-excerpt a, #daln-clock, #daln-close, .daln-slider-single-news, .daln-slider-single-news a{ font-family: ' . htmlentities( stripslashes( $ticker_obj->font_family ), ENT_COMPAT ) . ' !important; }';

		        //set the sliding news background color
		        $color_a = $this->shared->rgb_hex_to_dec(str_replace('#', '', $ticker_obj->featured_news_background_color ));
		        echo "#daln-featured-container{ background: " . "rgba(" . $color_a['r'] . "," . $color_a['g'] . "," . $color_a['b'] . ", " . floatval($ticker_obj->featured_news_background_color_opacity) . ")" . "; }";

		        //set the sliding news background color
		        $color_a = $this->shared->rgb_hex_to_dec(str_replace('#', '', $ticker_obj->sliding_news_background_color ));
		        echo "#daln-slider{ background: " . "rgba(" . $color_a['r'] . "," . $color_a['g'] . "," . $color_a['b'] . ", " . floatval($ticker_obj->sliding_news_background_color_opacity) . ")" . "; }";

		        //set the font size of the textual elements
		        echo "#daln-featured-title{ font-size: " . intval( $ticker_obj->featured_title_font_size, 10 ) . "px; }";
		        echo "#daln-featured-excerpt{ font-size: " . intval( $ticker_obj->featured_excerpt_font_size, 10 ) . "px; }";
		        echo "#daln-slider-floating-content .daln-slider-single-news{ font-size: " . intval( $ticker_obj->sliding_news_font_size, 10 ) . "px; }";
		        echo "#daln-clock{ font-size: " . intval( $ticker_obj->clock_font_size, 10 ) . "px; }";

		        //hide the clock if this options is set in the plugin option
		        if ( $ticker_obj->hide_clock == "1" ) {
			        echo "#daln-clock{ display: none; }";
		        }

		        //set news css for the rtl layout
		        if ( intval($ticker_obj->enable_rtl_layout, 10) == 1 ) {
			        echo "#daln-featured-title-container, #daln-featured-title, #daln-featured-title a{ text-align: right !important; direction: rtl !important; unicode-bidi: embed !important; }";
			        echo "#daln-featured-excerpt-container, #daln-featured-excerpt a{ text-align: right !important; direction: rtl !important; unicode-bidi: embed !important; }";
			        echo "#daln-slider, #daln-slider-floating-content, .daln-slider-single-news{ text-align: right !important; direction: rtl !important; unicode-bidi: embed !important; }";
		        }

		        //set the open button image url
		        echo "#daln-open{background: url( '" . esc_attr(stripslashes($ticker_obj->open_button_image)) . "');}";

		        //set the close button image url
		        echo "#daln-close{background: url( '" . esc_attr(stripslashes($ticker_obj->close_button_image)) . "');}";

		        //set the clock background image url
		        echo "#daln-clock{background: url( '" . esc_attr(stripslashes($ticker_obj->clock_background_image)) . "');}";

		        //set the featured news title color
		        echo "#daln-featured-title a{color: " . esc_attr(stripslashes($ticker_obj->featured_news_title_color)) . ";}";

		        //set the featured news title color hover
		        echo "#daln-featured-title a:hover{color: " . esc_attr(stripslashes($ticker_obj->featured_news_title_color_hover)) . ";}";

		        //set the featured news excerpt color
		        echo "#daln-featured-excerpt{color: " . esc_attr(stripslashes($ticker_obj->featured_news_excerpt_color)) . ";}";

		        //set the sliding news color
		        echo ".daln-slider-single-news, .daln-slider-single-news a{color: " . esc_attr(stripslashes($ticker_obj->sliding_news_color)) . ";}";

		        //set the sliding news color hover
		        echo ".daln-slider-single-news a:hover{color: " . esc_attr(stripslashes($ticker_obj->sliding_news_color_hover)) . ";}";

		        //set the clock text color
		        echo "#daln-clock{color: " . esc_attr(stripslashes($ticker_obj->clock_text_color)) . ";}";

	            //set the sliding news margin
	            echo "#daln-slider-floating-content .daln-slider-single-news{margin-right: "  . intval( $ticker_obj->sliding_news_margin, 10 ) . "px !important; }";

	            //set the sliding news padding
	            echo "#daln-slider-floating-content .daln-slider-single-news{padding: 0 "  . intval( $ticker_obj->sliding_news_padding, 10 ) . "px !important; }";
	            echo "#daln-container .daln-image-before{margin: 0 "  . intval( $ticker_obj->sliding_news_padding, 10 ) . "px 0 0 !important; }";
		        echo "#daln-container .daln-image-after{margin: 0 0 0 "  . intval( $ticker_obj->sliding_news_padding, 10 ) . "px !important; }";

            echo '</style>';

	        //embed google fonts if selected
	        if ( mb_strlen(trim($ticker_obj->google_font)) > 0 ) {
		        echo "<link href='" . esc_url(stripslashes($ticker_obj->google_font)) . "' rel='stylesheet' type='text/css'>";
	        }

        }

    }

    /*
     * The purpose of this method is to prevent to have tickers associated with categories that no longer exist.
     * This method is called by the 'delete_category' action hook, which is triggered when a category is deleted from
     * the Posts -> Category menu. If the deleted category is included in a ticker the 'category' value of the ticker
     * will be set to 0, which is the 'All' value used to show all the categories of a ticker.
     */
    public function ticker_delete_category($term_id) {

        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
        $safe_sql = $wpdb->prepare("UPDATE $table_name SET category = 0 WHERE category = %d", $term_id);
        $wpdb->query($safe_sql);

    }
    
}