<?php
/*
Plugin Name: Live News
Description: Real Time News Ticker.
Version: 2.14
Author: DAEXT
Author URI: https://daext.com
*/

//Prevent direct access to this file
if ( ! defined( 'WPINC' ) ) { die(); }

//Class shared across public and admin
require_once( plugin_dir_path( __FILE__ ) . 'shared/class-daln-shared.php' );

//Public
require_once( plugin_dir_path( __FILE__ ) . 'public/class-daln-public.php' );
add_action( 'plugins_loaded', array( 'Daln_Public', 'get_instance' ) );

//Admin
if ( is_admin() && ( ! defined( 'DOING_AJAX' ) || ! DOING_AJAX ) ) {
    
    //Admin
    require_once( plugin_dir_path( __FILE__ ) . 'admin/class-daln-admin.php' );
    add_action( 'plugins_loaded', array( 'Daln_Admin', 'get_instance' ) );
    
    //Activate
    register_activation_hook( __FILE__, array( Daln_Admin::get_instance(), 'ac_activate' ) );
    
}

//Ajax
if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
    
    //Admin
    require_once( plugin_dir_path( __FILE__ ) . 'class-daln-ajax.php' );
    add_action( 'plugins_loaded', array( 'Daln_Ajax', 'get_instance' ) );
    
}