<?php

        if ( !current_user_can(get_option( $this->shared->get('slug') . "_sliding_menu_capability")) )  {
            wp_die( __( 'You do not have sufficient permissions to access this page.', 'daln' ) );
        }

        ?>

        <!-- process data -->

        <?php

         if( isset( $_POST['update_id'] ) or isset($_POST['form_submitted']) ){

             //Sanitization -----------------------------------------------------------------------------------------------------
             $update_id = isset($_POST['update_id']) ? intval($_POST['update_id']) : '';
             $news_title = sanitize_text_field($_POST['news_title']);
             $url = esc_url_raw($_POST['url']);
             $ticker_id = intval($_POST['ticker_id'], 10);
             $text_color = sanitize_text_field($_POST['text_color']);
             $text_color_hover = sanitize_text_field($_POST['text_color_hover']);
             $background_color = sanitize_text_field($_POST['background_color']);
             $background_color_opacity = floatval($_POST['background_color_opacity']);
             $image_before = esc_url_raw($_POST['image_before']);
             $image_after = esc_url_raw($_POST['image_after']);

             //Validation -------------------------------------------------------------------------------------------------------
            $invalid_data_message = '';

            //validation on "Title"
            if( mb_strlen( trim($news_title) ) == 0 or mb_strlen($news_title) > 1000 ){
                $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Title" field.', 'daln') . '</p></div>';
                $invalid_data = true;
            }

            //validation on "URL"
             if( mb_strlen($url) > 2083 ){
                $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid URL in the "URL" field.', 'daln') . '</p></div>';
                $invalid_data = true;
            }

            //validation on "Text Color"
            if(!preg_match($this->shared->hex_rgb_regex, $text_color)){
                $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid color in the "Text Color" field.', 'daln') . '</p></div>';
                $invalid_data = true;
            }

			//validation on "Text Color Hover"
			if(!preg_match($this->shared->hex_rgb_regex, $text_color_hover)){
				$invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid color in the "Text Color Hover" field.', 'daln') . '</p></div>';
				$invalid_data = true;
			}

            //validation on "Background Color"
            if(!preg_match($this->shared->hex_rgb_regex, $background_color)){
                $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid color in the "Background Color" field.', 'daln') . '</p></div>';
                $invalid_data = true;
            }

	         //validation on "Background Color Opacity"
	         if($background_color_opacity < 0 or $background_color_opacity > 1){
		         $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a value included between 0 and 1 in the "Background Color Opacity" field.', 'daln') . '</p></div>';
		         $invalid_data = true;
	         }

             //validation on "Image Before"
             if( mb_strlen($image_before) > 2083 ){
                 $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid URL in the "Image Left" field.', 'daln') . '</p></div>';
                 $invalid_data = true;
             }

             //validation on "Image After"
             if( mb_strlen($image_after) > 2083 ){
                 $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid URL in the "Image Right" field.', 'daln') . '</p></div>';
                 $invalid_data = true;
             }

        }

        //update ---------------------------------------------------------------
        if( isset( $_POST['update_id'] ) and !isset($invalid_data) ){

            //update the database
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
            $safe_sql = $wpdb->prepare("UPDATE $table_name SET
                news_title = %s,
                url = %s,
                ticker_id = %d,
                text_color = %s,
                text_color_hover = %s,
                background_color = %s,
                background_color_opacity = %f,
                image_before = %s,
                image_after = %s
                WHERE id = %d",
                $news_title,
                $url,
                $ticker_id,
                $text_color,
                $text_color_hover,
                $background_color,
                $background_color_opacity,
                $image_before,
                $image_after,
                $update_id);

            $query_result = $wpdb->query( $safe_sql );

            if($query_result !== false){
                $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The sliding news has been successfully updated.', 'daln') . '</p></div>';
            }

        }else{

            //add ------------------------------------------------------------------
            if( isset($_POST['form_submitted']) and !isset($invalid_data) ){

                //insert into the database
                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
                $safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                    news_title = %s,
                    url = %s,
                    ticker_id = %d,
                    text_color = %s,
                    text_color_hover = %s,
                    background_color = %s,
                    background_color_opacity = %f,
                    image_before = %s,
                    image_after = %s",
                    $news_title,
                    $url,
                    $ticker_id,
                    $text_color,
                    $text_color_hover,
                    $background_color,
                    $background_color_opacity,
                    $image_before,
                    $image_after
                    );

                $query_result = $wpdb->query( $safe_sql );

                if($query_result !== false){
                    $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The sliding news has been successfully added.', 'daln') . '</p></div>';
                }

            }

        }

        //delete a sliding news
        if( isset( $_POST['delete_id']) ){

            global $wpdb;
            $delete_id = intval($_POST['delete_id'], 10);

            //delete this game
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
            $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE id = %d ", $delete_id);

            $query_result = $wpdb->query( $safe_sql );

            if($query_result !== false){
                $process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The sliding news has been successfully deleted.', 'daln') . '</p></div>';
            }

        }

        //get the sliding news data
        $display_form = true;
        if(isset($_GET['edit_id'])){
            $edit_id = intval($_GET['edit_id'], 10);
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
            $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d ", $edit_id);
            $sliding_news_obj = $wpdb->get_row($safe_sql);
	        if($sliding_news_obj === null){
		        $display_form = false;
	        }
        }

        //Get the value of the custom filter
        if( isset($_GET['cf']) and $_GET['cf'] != 'all' ){
            $ticker_id_in_cf = intval($_GET['cf'], 10);
        }else{
            $ticker_id_in_cf = false;
        }

        ?>
        
        <!-- output -->

        <div class="wrap">

            <?php if ($this->shared->get_number_of_sliding_news() > 0) : ?>

                <div id="daext-header-wrapper" class="daext-clearfix">

                    <h2><?php esc_attr_e('Live News - Sliding News', 'daln'); ?></h2>

                    <!-- Search Form -->

                    <form action="admin.php" method="get" id="daext-search-form">

                        <input type="hidden" name="page" value="daln-sliding">

                        <p><?php esc_attr_e('Perform your Search', 'daln'); ?></p>

                        <?php
                        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                            $search_string = $_GET['s'];
                        } else {
                            $search_string = '';
                        }

                        //Custom Filter
                        if($ticker_id_in_cf !== false){
                            echo '<input type="hidden" name="cf" value="' . $ticker_id_in_cf . '">';
                        }

                        ?>

                        <input type="text" name="s" name="s"
                               value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
                        <input type="submit" value="">

                    </form>

                    <!-- Filter Form -->

                    <form method="GET" action="admin.php" id="daext-filter-form">

                        <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-sliding">

                        <p><?php esc_attr_e('Filter by News Ticker', 'daln'); ?></p>

                        <select id="cf" name="cf" class="daext-display-none">

                            <option value="all" <?php if(isset($_GET['cf'])){selected( $_GET['cf'], 'all' );} ?>><?php esc_attr_e('All', 'daln'); ?></option>

                            <?php

                            global $wpdb;
                            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
                            $safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
                            $tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

                            foreach ($tickers_a as $key => $ticker) {

                                if(isset($_GET['cf'])){
                                    echo '<option value="' . $ticker['id'] . '" ' .  selected( $_GET['cf'], $ticker['id'], false ) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                                }else{
                                    echo '<option value="' . $ticker['id'] . '">' . esc_attr(stripslashes($ticker['name'])) . '</option>';

                                }

                            }

                            ?>

                        </select>

                    </form>

                </div>

            <?php else: ?>

                <div id="daext-header-wrapper" class="daext-clearfix">

                    <h2><?php esc_attr_e('Live News - Sliding News', 'daln'); ?></h2>

                </div>

            <?php endif; ?>

            <?php

        //do not display the menu if in the 'cf' url parameter is applied a filter based on a ticker that doesn't exist
        if( isset($_GET['cf']) and $_GET['cf'] != 'all' and !$this->shared->ticker_exists($_GET['cf']) ){
            echo '<p>' . esc_attr__("The filter can't be applied because this news ticker doesn't exist.", 'daln') . '</p>';
            return;
        }

        //retrieve the url parameter that should be used in the linked URLs
        if(isset($_GET['cf']) and $this->shared->ticker_exists($_GET['cf'])){
            $ticker_url_parameter = '&cf=' . intval($_GET['cf'], 10);
        }else{
            $ticker_url_parameter = '';
        }

        //display a message and not the menu if there are no tickers
        if($this->shared->get_number_of_tickers() == 0){
            echo '<p>' . esc_attr__("There are no news tickers at the moment, please create at least one news ticker with the", 'daln') . ' ' . '<a href="admin.php?page=daln-tickers">' . esc_attr__('News Tickers', 'daln') . '</a> menu.' . '</p>';
            return;
        }

        ?>

        <div id="daext-menu-wrapper">

            <?php if(isset($invalid_data_message)){echo $invalid_data_message;} ?>
            <?php if(isset($process_data_message)){echo $process_data_message;} ?>
            
            <!-- table -->

            <?php

            //custom filter
            if($ticker_id_in_cf === false){
                $filter = '';
            }else{
                global $wpdb;
                $filter = $wpdb->prepare("WHERE ticker_id = %d", $ticker_id_in_cf);
            }

            //create the query part used to filter the results when a search is performed
            if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

                $search_string = $_GET['s'];
                global $wpdb;

                if(strlen(trim($filter)) > 0){
                    $filter .= $wpdb->prepare(' AND (news_title LIKE %s OR url LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%');
                }else{
                    $filter = $wpdb->prepare('WHERE (news_title LIKE %s OR url LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%');
                }

            }

            //retrieve the total number of sliding news
            global $wpdb;
            $table_name=$wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
            $total_items = $wpdb->get_var( "SELECT COUNT(*) FROM $table_name $filter");

            //Initialize the pagination class
            require_once( $this->shared->get('dir') . '/admin/inc/class-daln-pagination.php' );
            $pag = new daln_pagination();
            $pag->set_total_items( $total_items );//Set the total number of items
            $pag->set_record_per_page( 10 ); //Set records per page
            $pag->set_target_page( "admin.php?page=" . $this->shared->get('slug') . "-sliding" );//Set target page
            $pag->set_current_page();//set the current page number from $_GET

            ?>

            <!-- Query the database -->
            <?php
            $query_limit = $pag->query_limit();
            $results = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY id DESC $query_limit ", ARRAY_A); ?>

            <?php if( count($results) > 0 ) : ?>

            <div class="daext-items-container">

                <!-- list of tables -->
                <table class="daext-items">
                    <thead>
                        <tr>
                            <th>
                                <div><?php esc_attr_e('Title', 'daln'); ?></div>
                                <div class="help-icon" title="<?php esc_attr_e('The title of the sliding news.', 'daln'); ?>"></div>
                            </th>
                            <th>
                                <div><?php esc_attr_e('Ticker', 'daln'); ?></div>
                                <div class="help-icon" title="<?php esc_attr_e('The news ticker associated with the sliding news.', 'daln'); ?>"></div>
                            </th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>

                    <?php foreach($results as $result) : ?>
                        <tr>
                            <td><?php echo esc_attr(stripslashes($result['news_title'])); ?></td>
                            <td><?php echo esc_attr(stripslashes($this->shared->get_textual_ticker($result['ticker_id']))); ?></td>
                            <td class="icons-container">

                                <a class="menu-icon edit" href="admin.php?page=<?php echo $this->shared->get('slug'); ?>-sliding&edit_id=<?php echo $result['id']; ?><?php echo $ticker_url_parameter; ?>"></a>
                                <form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-sliding">
                                    <input type="hidden" value="<?php echo $result['id']; ?>" name="delete_id" >
                                    <input class="menu-icon delete" type="submit" value="">
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>

                    </tbody>

                </table>

            </div>

                <!-- Display the pagination -->
                <?php if($pag->total_items > 0) : ?>
                    <div class="daext-tablenav daext-clearfix">
                        <div class="daext-tablenav-pages">
                            <span class="daext-displaying-num"><?php echo $pag->total_items; ?> <?php esc_attr_e('items', 'daln'); ?></span>
                            <?php $pag->show(); ?>
                        </div>
                    </div>
                <?php endif; ?>

            <?php else : ?>

                <?php

                if(strlen(trim($filter)) > 0){
                    echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.', 'daln') . '</p></div>';
                }

                ?>

            <?php endif; ?>

            <div id="sliding-news-form-container">

	            <?php if( $display_form ) : ?>

	                 <form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-sliding<?php echo $ticker_url_parameter; ?>" autocomplete="off">

	                    <input type="hidden" value="1" name="form_submitted">

	                    <?php if(isset($_GET['edit_id'])) : ?>

	                        <!-- Edit a sliding news -->

	                        <div class="daext-form-container">

	                            <h3 class="daext-form-title"><?php esc_attr_e('Edit Sliding News', 'daln'); ?> <?php echo $sliding_news_obj->id; ?></h3>

	                            <table class="daext-form">

	                                <input type="hidden" name="update_id" id="update-id" value="<?php echo $sliding_news_obj->id; ?>" />

	                                 <!-- title -->
	                                 <tr valign="top">
	                                     <th scope="row"><label for="news-title"><?php esc_attr_e('Title', 'daln'); ?></label></th>
	                                     <td>
	                                         <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->news_title)); ?>" type="text" id="news-title" maxlength="1000" size="30" name="news_title" />
	                                         <div class="help-icon" title="<?php esc_attr_e('Enter the title of the sliding news.', 'daln'); ?>"></div>
	                                     </td>
	                                 </tr>

	                                 <!-- URL -->
	                                 <tr valign="top">
	                                     <th scope="row"><label for="url"><?php esc_attr_e('URL', 'daln'); ?></label></th>
	                                     <td>
	                                         <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->url)); ?>" type="text" id="url" maxlength="2083" size="30" name="url" />
	                                         <div class="help-icon" title="<?php esc_attr_e('Enter the URL of the sliding news.', 'daln'); ?>"></div>
	                                     </td>
	                                 </tr>

	                                <!-- Ticker -->
	                                <tr>
	                                    <th scope="row"><?php esc_attr_e('Ticker', 'daln'); ?></th>
	                                    <td>
	                                        <select id="ticker-id" name="ticker_id" class="daext-display-none">

	                                            <?php

	                                            global $wpdb;
	                                            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
	                                            $safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
	                                            $tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

	                                            foreach ($tickers_a as $key => $ticker) {

	                                                echo '<option value="' . $ticker['id'] . '" ' .  selected($sliding_news_obj->ticker_id, $ticker['id']) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';

	                                            }

	                                            ?>

	                                        </select>
	                                        <div class="help-icon" title='<?php esc_attr_e('Select the news ticker associated with this sliding news.', 'daln'); ?>'></div>
	                                    </td>
	                                </tr>

	                                <!-- Text Color -->
	                                <tr valign="top">
	                                    <th scope="row"><label for="text-color"><?php esc_attr_e('Text Color', 'daln'); ?></label></th>
	                                    <td>
	                                        <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->text_color)); ?>" class="wp-color-picker" type="text" id="text-color" maxlength="7" size="30" name="text_color"/>
	                                        <div class="help-icon" title="<?php esc_attr_e('Select the color used to display the text of this sliding news.', 'daln'); ?>"></div>
	                                    </td>
	                                </tr>

	                                <!-- Text Color Hover -->
	                                <tr valign="top">
	                                    <th scope="row"><label for="text-color-hover"><?php esc_attr_e('Text Color Hover', 'daln'); ?></label></th>
	                                    <td>
	                                        <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->text_color_hover)); ?>" class="wp-color-picker" type="text" id="text-color-hover" maxlength="7" size="30" name="text_color_hover"/>
	                                        <div class="help-icon" title="<?php esc_attr_e('Select the color used to display the text of this sliding news in hover state.', 'daln'); ?>"></div>
	                                    </td>
	                                </tr>

	                                <!-- Background Color -->
	                                <tr valign="top">
	                                    <th scope="row"><label for="background-color"><?php esc_attr_e('Background Color', 'daln'); ?></label></th>
	                                    <td>
	                                        <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->background_color)); ?>" class="wp-color-picker" type="text" id="background-color" maxlength="7" size="30" name="background_color"/>
	                                        <div class="help-icon" title="<?php esc_attr_e('Select the background color of this sliding news.', 'daln'); ?>"></div>
	                                    </td>
	                                </tr>

	                                <!-- Background Color Opacity -->
	                                <tr>
	                                    <th scope="row"><label for="background-color-opacity"><?php esc_attr_e('Background Color Opacity', 'daln'); ?></label></th>
	                                    <td>
	                                        <input value="<?php echo floatval($sliding_news_obj->background_color_opacity); ?>" type="text" id="background-color-opacity" maxlength="3" size="30" name="background_color_opacity" />
	                                        <div class="help-icon" title="<?php esc_attr_e('The background color opacity of this sliding news.', 'daln'); ?>"></div>
	                                    </td>
	                                </tr>

		                            <!-- Image Before -->
		                            <tr>
			                            <th scope="row"><label for="image-before"><?php esc_attr_e('Image Left', 'daln'); ?></label></th>
			                            <td>

				                            <div class="image-uploader">
					                            <img class="selected-image" src="<?php echo esc_attr(stripslashes($sliding_news_obj->image_before)); ?>" <?php echo mb_strlen(trim($sliding_news_obj->image_before)) == 0 ? 'style="display: none;"' : ''; ?>>
					                            <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->image_before)); ?>" type="hidden" id="image-before" maxlength="2083" name="image_before">
					                            <a class="button_add_media" data-set-remove="<?php echo mb_strlen(trim($sliding_news_obj->image_before)) == 0 ? 'set' : 'remove'; ?>" data-set="<?php esc_attr_e('Set image', 'daln'); ?>" data-remove="<?php esc_attr_e('Remove Image', 'daln'); ?>"><?php echo mb_strlen(trim($sliding_news_obj->image_before)) == 0 ? esc_attr__('Set image', 'daln') : esc_attr__('Remove Image', 'daln'); ?></a>
					                            <p class="description"><?php esc_attr_e("Select the image displayed on the left of the sliding news. It's recommended to use an image with an height of 40 pixels.", 'daln'); ?></p>
				                            </div>

			                            </td>
		                            </tr>

		                            <!-- Image After -->
		                            <tr>
			                            <th scope="row"><label for="image-after"><?php esc_attr_e('Image Right', 'daln'); ?></label></th>
			                            <td>

				                            <div class="image-uploader">
					                            <img class="selected-image" src="<?php echo esc_attr(stripslashes($sliding_news_obj->image_after)); ?>" <?php echo mb_strlen(trim($sliding_news_obj->image_after)) == 0 ? 'style="display: none;"' : ''; ?>>
					                            <input value="<?php echo esc_attr(stripslashes($sliding_news_obj->image_after)); ?>" type="hidden" id="image-after" maxlength="2083" name="image_after">
					                            <a class="button_add_media" data-set-remove="<?php echo mb_strlen(trim($sliding_news_obj->image_after)) == 0 ? 'set' : 'remove'; ?>" data-set="<?php esc_attr_e('Set image', 'daln'); ?>" data-remove="<?php esc_attr_e('Remove Image', 'daln'); ?>"><?php echo mb_strlen(trim($sliding_news_obj->image_after)) == 0 ? esc_attr__('Set image', 'daln') : esc_attr__('Remove Image', 'daln'); ?></a>
					                            <p class="description"><?php esc_attr_e("Select the image displayed on the right of the sliding news. It's recommended to use an image with an height of 40 pixels.", 'daln'); ?></p>
				                            </div>

			                            </td>
		                            </tr>

	                            </table>

	                            <!-- submit button -->
	                            <div class="daext-form-action">
	                                <input class="button" type="submit" value="<?php esc_attr_e('Update Sliding News', 'daln'); ?>" >
	                            </div>

	                    <?php else : ?>

	                        <!-- Create New Sliding News -->

	                        <div class="daext-form-container">

	                            <div class="daext-form-title"><?php esc_attr_e('Create a Sliding News', 'daln'); ?></div>

	                                 <table class="daext-form">

	                                     <!-- Title -->
	                                     <tr valign="top">
	                                         <th scope="row"><label for="news-title"><?php esc_attr_e('Title', 'daln'); ?></label></th>
	                                         <td>
	                                             <input type="text" id="news-title" maxlength="1000" size="30" name="news_title" />
	                                             <div class="help-icon" title="<?php esc_attr_e('Enter the title of the sliding news.', 'daln'); ?>"></div>
	                                         </td>
	                                     </tr>

	                                     <!-- URL -->
	                                     <tr valign="top">
	                                         <th scope="row"><label for="url"><?php esc_attr_e('URL', 'daln'); ?></label></th>
	                                         <td>
	                                             <input type="text" id="url" maxlength="2083" size="30" name="url" />
	                                             <div class="help-icon" title="<?php esc_attr_e('Enter the URL of the sliding news.', 'daln'); ?>"></div>
	                                         </td>
	                                     </tr>

	                                    <!-- Ticker -->
	                                    <tr>
	                                        <th scope="row"><?php esc_attr_e('Ticker', 'daln'); ?></th>
	                                        <td>
	                                            <select id="ticker-id" name="ticker_id" class="daext-display-none">

	                                                <?php

	                                                global $wpdb;
	                                                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
	                                                $safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
	                                                $tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

                                                    if($ticker_id_in_cf === false){

                                                        foreach ($tickers_a as $key => $ticker) {
                                                            echo '<option value="' . $ticker['id'] . '">' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                                                        }

                                                    }else{

                                                        foreach ($tickers_a as $key => $ticker) {
                                                            echo '<option value="' . $ticker['id'] . '" ' . selected($ticker_id_in_cf, $ticker['id'], false) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                                                        }

                                                    }

	                                                ?>

	                                            </select>
	                                            <div class="help-icon" title='<?php esc_attr_e('Select the news ticker associated with this sliding news.', 'daln'); ?>'></div>
	                                        </td>
	                                    </tr>

	                                     <!-- Text Color -->
		                                 <tr valign="top">
			                                 <th scope="row"><label for="text-color"><?php esc_attr_e('Text Color', 'daln'); ?></label></th>
			                                 <td>
				                                 <input class="wp-color-picker" type="text" id="text-color" maxlength="7" size="30" name="text_color"/>
				                                 <div class="help-icon" title="<?php esc_attr_e('Select the color used to display the text of this sliding news.', 'daln'); ?>"></div>
			                                 </td>
		                                 </tr>

		                                 <!-- Text Color Hover -->
		                                 <tr valign="top">
			                                 <th scope="row"><label for="text-color-hover"><?php esc_attr_e('Text Color Hover', 'daln'); ?></label></th>
			                                 <td>
				                                 <input class="wp-color-picker" type="text" id="text-color-hover" maxlength="7" size="30" name="text_color_hover"/>
				                                 <div class="help-icon" title="<?php esc_attr_e('Select the color used to display the text of this sliding news in hover state.', 'daln'); ?>"></div>
			                                 </td>
		                                 </tr>

	                                     <!-- Background Color -->
	                                     <tr valign="top">
	                                         <th scope="row"><label for="background-color"><?php esc_attr_e('Background Color', 'daln'); ?></label></th>
	                                         <td>
	                                             <input class="wp-color-picker" type="text" id="background-color" maxlength="7" size="30" name="background_color"/>
	                                             <div class="help-icon" title="<?php esc_attr_e('Select the background color of this sliding news.', 'daln'); ?>"></div>
	                                         </td>
	                                     </tr>

		                                 <!-- Background Color Opacity -->
		                                 <tr>
			                                 <th scope="row"><label for="background-color-opacity"><?php esc_attr_e('Background Color Opacity', 'daln'); ?></label></th>
			                                 <td>
				                                 <input value="1" type="text" id="background-color-opacity" maxlength="3" size="30" name="background_color_opacity" />
				                                 <div class="help-icon" title="<?php esc_attr_e('The background color opacity of this sliding news.', 'daln'); ?>"></div>
			                                 </td>
		                                 </tr>

		                                 <!-- Image Before -->
	                                     <tr>
	                                         <th scope="row"><label for="image-before"><?php esc_attr_e('Image Left', 'daln'); ?></label></th>
	                                         <td>

	                                             <div class="image-uploader">
	                                                 <img class="selected-image" src="" style="display: none">
	                                                 <input type="hidden" id="image-before" maxlength="2083" name="image_before">
	                                                 <a class="button_add_media" data-set-remove="set" data-set="<?php esc_attr_e('Set image', 'daln'); ?>" data-remove="<?php esc_attr_e('Remove Image', 'daln'); ?>"><?php esc_attr_e('Set image', 'daln'); ?></a>
	                                                 <p class="description"><?php esc_attr_e("Select the image displayed on the left of the sliding news. It's recommended to use an image with an height of 40 pixels.", 'daln'); ?></p>
	                                             </div>

	                                         </td>
	                                     </tr>

	                                     <!-- Image After -->
		                                 <tr>
			                                 <th scope="row"><label for="image-after"><?php esc_attr_e('Image Right', 'daln'); ?></label></th>
			                                 <td>

				                                 <div class="image-uploader">
					                                 <img class="selected-image" src="" style="display: none">
					                                 <input type="hidden" id="image-after" maxlength="2083" name="image_after">
					                                 <a class="button_add_media" data-set-remove="set" data-set="<?php esc_attr_e('Set image', 'daln'); ?>" data-remove="<?php esc_attr_e('Remove Image', 'daln'); ?>"><?php esc_attr_e('Set image', 'daln'); ?></a>
					                                 <p class="description"><?php esc_attr_e("Select the image displayed on the right of the sliding news. It's recommended to use an image with an height of 40 pixels.", 'daln'); ?></p>
				                                 </div>

			                                 </td>
		                                 </tr>

	                                </table>

	                                <!-- submit button -->
	                                <div class="daext-form-action">
	                                    <input class="button" type="submit" value="<?php esc_attr_e('Add Sliding News', 'daln'); ?>" >
	                                </div>

	                            <?php endif; ?>

	                        </div>

	                </form>

	            <?php endif; ?>

            </div>

        </div>

    </div>