<?php

if ( !current_user_can(get_option( $this->shared->get('slug') . "_featured_menu_capability")) )  {
	wp_die( esc_attr__( 'You do not have sufficient permissions to access this page.', 'daln' ) );
}

?>

<!-- process data -->

<?php

if( isset( $_POST['update_id'] ) or isset($_POST['form_submitted']) ){

    //Sanitization -----------------------------------------------------------------------------------------------------
    $update_id = isset($_POST['update_id']) ? intval($_POST['update_id']) : '';
    $news_title        = sanitize_text_field( $_POST['news_title'] );
    $news_excerpt          = sanitize_text_field( $_POST['news_excerpt'] );
    $url    = esc_url_raw( $_POST['url'] );
    $ticker_id   = intval( $_POST['ticker_id'], 10 );

    //Validation -------------------------------------------------------------------------------------------------------
	$invalid_data_message = '';

	//validation on "Title"
	if( mb_strlen( trim($news_title) ) == 0 or mb_strlen($news_title) > 1000 ){
		$invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Title" field.', 'daln') . '</p></div>';
		$invalid_data = true;
	}

	//validation on "Excerpt"
	if( mb_strlen( trim($news_excerpt) ) == 0 or mb_strlen($news_excerpt) > 1000 ){
		$invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid value in the "Excerpt" field.', 'daln') . '</p></div>';
		$invalid_data = true;
	}

    //validation on "URL"
    if( mb_strlen($url) > 2083 ){
        $invalid_data_message .= '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('Please enter a valid URL in the "URL" field.', 'daln') . '</p></div>';
        $invalid_data = true;
    }

}

//update ---------------------------------------------------------------
if( isset( $_POST['update_id'] ) and !isset($invalid_data) ){

	//update the database
	global $wpdb;
	$table_name = $wpdb->prefix . $this->shared->get('slug') . "_featured_news";
	$safe_sql = $wpdb->prepare("UPDATE $table_name SET
                news_title = %s,
                news_excerpt = %s,
                url = %s,
                ticker_id = %d
                WHERE id = %d",
		$news_title,
		$news_excerpt,
		$url,
		$ticker_id,
		$update_id);

	$query_result = $wpdb->query( $safe_sql );

	if($query_result !== false){
		$process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The featured news has been successfully updated.', 'daln') . '</p></div>';
	}

}else{

	//add ------------------------------------------------------------------
	if( isset($_POST['form_submitted']) and !isset($invalid_data) ){

		//insert into the database
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_featured_news";
		$safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                    news_title = %s,
                    news_excerpt = %s,
                    url = %s,
                    ticker_id = %d",
			$news_title,
			$news_excerpt,
			$url,
			$ticker_id
		);

		$query_result = $wpdb->query( $safe_sql );

		if($query_result !== false){
			$process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The featured news has been successfully added.', 'daln') . '</p></div>';
		}

	}

}

//delete a featured news
if( isset( $_POST['delete_id']) ){

	global $wpdb;
	$delete_id = intval($_POST['delete_id'], 10);

	//delete this featured news
	$table_name = $wpdb->prefix . $this->shared->get('slug') . "_featured_news";
	$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE id = %d ", $delete_id);

	$query_result = $wpdb->query( $safe_sql );

	if($query_result !== false){
		$process_data_message = '<div class="updated settings-error notice is-dismissible below-h2"><p>' . esc_attr__('The featured news has been successfully deleted.', 'daln') . '</p></div>';
	}

}

//get the featured news data
$display_form = true;
if(isset($_GET['edit_id'])){
	$edit_id = intval($_GET['edit_id'], 10);
	global $wpdb;
	$table_name = $wpdb->prefix . $this->shared->get('slug') . "_featured_news";
	$safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d ", $edit_id);
	$featured_news_obj = $wpdb->get_row($safe_sql);
	if($featured_news_obj === null){
		$display_form = false;
	}
}

//Get the value of the custom filter
if( isset($_GET['cf']) and $_GET['cf'] != 'all' ){
    $ticker_id_in_cf = intval($_GET['cf'], 10);
}else{
    $ticker_id_in_cf = false;
}

?>

<!-- output -->

<div class="wrap">

    <?php if ($this->shared->get_number_of_featured_news() > 0) : ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_attr_e('Live News - Featured News', 'daln'); ?></h2>

            <!-- Search Form -->

            <form action="admin.php" method="get" id="daext-search-form">

                <input type="hidden" name="page" value="daln-featured">

                <p><?php esc_attr_e('Perform your Search', 'daln'); ?></p>

                <?php
                if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {
                    $search_string = $_GET['s'];
                } else {
                    $search_string = '';
                }

                //Custom Filter
                if($ticker_id_in_cf !== false){
                    echo '<input type="hidden" name="cf" value="' . $ticker_id_in_cf . '">';
                }

                ?>

                <input type="text" name="s" name="s"
                       value="<?php echo esc_attr(stripslashes($search_string)); ?>" autocomplete="off" maxlength="255">
                <input type="submit" value="">

            </form>

            <!-- Filter Form -->

            <form method="GET" action="admin.php" id="daext-filter-form">

                <input type="hidden" name="page" value="<?php echo $this->shared->get('slug'); ?>-featured">

                <p><?php esc_attr_e('Filter by News Ticker', 'daln'); ?></p>

                <select id="cf" name="cf" class="daext-display-none">

                    <option value="all" <?php if(isset($_GET['cf'])){selected( $_GET['cf'], 'all' );} ?>><?php esc_attr_e('All', 'daln'); ?></option>

                    <?php

                    global $wpdb;
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
                    $safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
                    $tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

                    foreach ($tickers_a as $key => $ticker) {

                        if(isset($_GET['cf'])){
                            echo '<option value="' . $ticker['id'] . '" ' .  selected( $_GET['cf'], $ticker['id'], false ) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                        }else{
                            echo '<option value="' . $ticker['id'] . '">' . esc_attr(stripslashes($ticker['name'])) . '</option>';

                        }

                    }

                    ?>

                </select>

            </form>

        </div>

    <?php else: ?>

        <div id="daext-header-wrapper" class="daext-clearfix">

            <h2><?php esc_attr_e('Live News - Featured News', 'daln'); ?></h2>

        </div>

    <?php endif; ?>

	<?php

	//do not display the menu if in the 'cf' url parameter is applied a filter based on a ticker that doesn't exist
	if( isset($_GET['cf']) and $_GET['cf'] != 'all' and !$this->shared->ticker_exists($_GET['cf']) ){
		echo '<p>' . esc_attr__("The filter can't be applied because this news ticker doesn't exist.", 'daln') . '</p>';
		return;
	}

	//retrieve the url parameter that should be used in the linked URLs
	if(isset($_GET['cf']) and $this->shared->ticker_exists($_GET['cf'])){
		$ticker_url_parameter = '&cf=' . intval($_GET['cf'], 10);
	}else{
		$ticker_url_parameter = '';
	}

	//display a message and not the menu if there are no tickers
	if($this->shared->get_number_of_tickers() == 0){
		echo '<p>' . esc_attr__("There are no news tickers at the moment, please create at least one news ticker with the", 'daln') . ' ' . '<a href="admin.php?page=daln-tickers">' . esc_attr__('News Tickers', 'daln') . '</a> menu.' . '</p>';
		return;
	}

	?>

	<div id="daext-menu-wrapper">

		<?php if(isset($invalid_data_message)){echo $invalid_data_message;} ?>
		<?php if(isset($process_data_message)){echo $process_data_message;} ?>

		<!-- table -->

		<?php

        //custom filter
        if($ticker_id_in_cf === false){
            $filter = '';
        }else{
            global $wpdb;
            $filter = $wpdb->prepare("WHERE ticker_id = %d", $ticker_id_in_cf);
        }

        //create the query part used to filter the results when a search is performed
        if (isset($_GET['s']) and strlen(trim($_GET['s'])) > 0) {

            $search_string = $_GET['s'];
            global $wpdb;

            if(strlen(trim($filter)) > 0){
                $filter .= $wpdb->prepare(' AND (news_title LIKE %s OR news_excerpt LIKE %s OR url LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%', '%' . $search_string . '%');
            }else{
                $filter = $wpdb->prepare('WHERE (news_title LIKE %s OR news_excerpt LIKE %s OR url LIKE %s)', '%' . $search_string . '%', '%' . $search_string . '%', '%' . $search_string . '%');
            }

        }

		//retrieve the total number of featured news
		global $wpdb;
		$table_name=$wpdb->prefix . $this->shared->get('slug') . "_featured_news";
		$total_items = $wpdb->get_var( "SELECT COUNT(*) FROM $table_name $filter");

		//Initialize the pagination class
		require_once( $this->shared->get('dir') . '/admin/inc/class-daln-pagination.php' );
		$pag = new daln_pagination();
		$pag->set_total_items( $total_items );//Set the total number of items
		$pag->set_record_per_page( 10 ); //Set records per page
		$pag->set_target_page( "admin.php?page=" . $this->shared->get('slug') . "-featured" );//Set target page
		$pag->set_current_page();//set the current page number from $_GET

		?>

		<!-- Query the database -->
		<?php
		$query_limit = $pag->query_limit();
		$results = $wpdb->get_results("SELECT * FROM $table_name $filter ORDER BY id DESC $query_limit ", ARRAY_A); ?>

		<?php if( count($results) > 0 ) : ?>

			<div class="daext-items-container">

				<!-- list of tables -->
				<table class="daext-items">
					<thead>
					<tr>
						<th>
							<div><?php esc_attr_e('Title', 'daln'); ?></div>
							<div class="help-icon" title="<?php esc_attr_e('The title of the featured news.', 'daln'); ?>"></div>
						</th>
						<th>
							<div><?php esc_attr_e('Ticker', 'daln'); ?></div>
							<div class="help-icon" title="<?php esc_attr_e('The news ticker associated with the featured news.', 'daln'); ?>"></div>
						</th>
						<th></th>
					</tr>
					</thead>
					<tbody>

					<?php foreach($results as $result) : ?>
						<tr>
							<td><?php echo esc_attr(stripslashes($result['news_title'])); ?></td>
							<td><?php echo '<a href="admin.php?page=daln-tickers&edit_id=' . $result['ticker_id'] . '">' . esc_attr(stripslashes($this->shared->get_textual_ticker($result['ticker_id']))) . '</a>'; ?></td>
							<td class="icons-container">
								<a class="menu-icon edit" href="admin.php?page=<?php echo $this->shared->get('slug'); ?>-featured&edit_id=<?php echo $result['id']; ?><?php echo $ticker_url_parameter; ?>"></a>
								<form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-featured">
									<input type="hidden" value="<?php echo $result['id']; ?>" name="delete_id" >
									<input class="menu-icon delete" type="submit" value="">
								</form>
							</td>
						</tr>
					<?php endforeach; ?>

					</tbody>

				</table>

			</div>

			<!-- Display the pagination -->
			<?php if($pag->total_items > 0) : ?>
				<div class="daext-tablenav daext-clearfix">
					<div class="daext-tablenav-pages">
						<span class="daext-displaying-num"><?php echo $pag->total_items; ?> <?php esc_attr_e('items', 'daln'); ?></span>
						<?php $pag->show(); ?>
					</div>
				</div>
			<?php endif; ?>

        <?php else : ?>

		    <?php

        if(strlen(trim($filter)) > 0){
            echo '<div class="error settings-error notice is-dismissible below-h2"><p>' . esc_attr__('There are no results that match your filter.', 'daln') . '</p></div>';
        }

        ?>

	    <?php endif; ?>

		<div id="featured-news-form-container">

			<?php if( $display_form ) : ?>

				<form method="POST" action="admin.php?page=<?php echo $this->shared->get('slug'); ?>-featured<?php echo $ticker_url_parameter; ?>" autocomplete="off">

					<input type="hidden" value="1" name="form_submitted">

					<?php if(isset($_GET['edit_id'])) : ?>

					<!-- Edit a featured news -->

					<div class="daext-form-container">

						<h3 class="daext-form-title"><?php esc_attr_e('Edit Featured News', 'daln'); ?> <?php echo $featured_news_obj->id; ?></h3>

						<table class="daext-form">

							<input type="hidden" name="update_id" value="<?php echo $featured_news_obj->id; ?>" />

							<!-- title -->
							<tr valign="top">
								<th scope="row"><label for="news-title"><?php esc_attr_e('Title', 'daln'); ?></label></th>
								<td>
									<input value="<?php echo esc_attr(stripslashes($featured_news_obj->news_title)); ?>" type="text" id="news-title" maxlength="1000" size="30" name="news_title" />
									<div class="help-icon" title="<?php esc_attr_e('Enter the title of the featured news.', 'daln'); ?>"></div>
								</td>
							</tr>

							<!-- excerpt -->
							<tr valign="top">
								<th scope="row"><label for="news-excerpt"><?php esc_attr_e('Excerpt', 'daln'); ?></label></th>
								<td>
									<input value="<?php echo esc_attr(stripslashes($featured_news_obj->news_excerpt)); ?>" type="text" id="news-excerpt" maxlength="1000" size="30" name="news_excerpt" />
									<div class="help-icon" title="<?php esc_attr_e('Enter the excerpt of the featured news.', 'daln'); ?>"></div>
								</td>
							</tr>

							<!-- URL -->
							<tr valign="top">
								<th scope="row"><label for="url"><?php esc_attr_e('URL', 'daln'); ?></label></th>
								<td>
									<input value="<?php echo esc_attr(stripslashes($featured_news_obj->url)); ?>" type="text" id="url" maxlength="2083" size="30" name="url" />
									<div class="help-icon" title="<?php esc_attr_e('Enter the URL of the featured news.', 'daln'); ?>"></div>
								</td>
							</tr>

							<!-- Ticker -->
							<tr>
                                <th scope="row"><label for="ticker-id"><?php esc_attr_e('Ticker', 'daln'); ?></label></th>
								<td>
									<select id="ticker-id" name="ticker_id" class="daext-display-none">

										<?php

										global $wpdb;
										$table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
										$safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
										$tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

										foreach ($tickers_a as $key => $ticker) {
											echo '<option value="' . $ticker['id'] . '" ' .  selected($featured_news_obj->ticker_id, $ticker['id']) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';
										}

										?>

									</select>
									<div class="help-icon" title='<?php esc_attr_e('The news ticker associated with this featured news.', 'daln'); ?>'></div>
								</td>
							</tr>

						</table>

						<!-- submit button -->
						<div class="daext-form-action">
							<input class="button" type="submit" value="<?php esc_attr_e('Update Featured News', 'daln'); ?>" >
						</div>

						<?php else : ?>

						<!-- Create New featured News -->

						<div class="daext-form-container">

							<div class="daext-form-title"><?php esc_attr_e('Create a Featured News', 'daln'); ?></div>

							<table class="daext-form">

								<!-- Title -->
								<tr valign="top">
									<th scope="row"><label for="news-title"><?php esc_attr_e('Title', 'daln'); ?></label></th>
									<td>
										<input type="text" id="news-title" maxlength="1000" size="30" name="news_title" />
										<div class="help-icon" title="<?php esc_attr_e('Enter the title of the featured news.', 'daln'); ?>"></div>
									</td>
								</tr>

								<!-- Excerpt -->
								<tr valign="top">
									<th scope="row"><label for="news-excerpt"><?php esc_attr_e('Excerpt', 'daln'); ?></label></th>
									<td>
										<input type="text" id="news-excerpt" maxlength="1000" size="30" name="news_excerpt" />
										<div class="help-icon" title="<?php esc_attr_e('Enter the excerpt of the featured news.', 'daln'); ?>"></div>
									</td>
								</tr>

								<!-- URL -->
								<tr valign="top">
									<th scope="row"><label for="url"><?php esc_attr_e('URL', 'daln'); ?></label></th>
									<td>
										<input type="text" id="url" maxlength="2083" size="30" name="url" />
										<div class="help-icon" title="<?php esc_attr_e('Enter the URL of the featured news.', 'daln'); ?>"></div>
									</td>
								</tr>

								<!-- Ticker -->
								<tr>
                                    <th scope="row"><label for="ticker-id"><?php esc_attr_e('Ticker', 'daln'); ?></label></th>
									<td>
										<select id="ticker-id" name="ticker_id" class="daext-display-none">

											<?php

											global $wpdb;
											$table_name = $wpdb->prefix . $this->shared->get('slug') . "_tickers";
											$safe_sql = "SELECT id, name FROM $table_name ORDER BY id DESC";
											$tickers_a = $wpdb->get_results($safe_sql, ARRAY_A);

                                            if($ticker_id_in_cf === false){

                                                foreach ($tickers_a as $key => $ticker) {
                                                    echo '<option value="' . $ticker['id'] . '">' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                                                }

                                            }else{

                                                foreach ($tickers_a as $key => $ticker) {
                                                    echo '<option value="' . $ticker['id'] . '" ' . selected($ticker_id_in_cf, $ticker['id'], false) . '>' . esc_attr(stripslashes($ticker['name'])) . '</option>';
                                                }

                                            }

											?>

										</select>
										<div class="help-icon" title='<?php esc_attr_e('The news ticker associated with this featured news', 'daln'); ?>'></div>
									</td>
								</tr>

							</table>

							<!-- submit button -->
							<div class="daext-form-action">
								<input class="button" type="submit" value="<?php esc_attr_e('Add Featured News', 'daln'); ?>" >
							</div>

							<?php endif; ?>

						</div>

				</form>

			<?php endif; ?>

		</div>

	</div>

</div>