<?php

/*
 * this class should be used to work with the administrative side of wordpress
 */
class Daln_Admin{

    protected static $instance = null;
    private $shared = null;

	private $screen_id_tickers = null;
	private $screen_id_featured = null;
	private $screen_id_sliding = null;
	private $screen_id_options = null;
    
    private function __construct() {

        //assign an instance of the shared class
        $this->shared = Daln_Shared::get_instance();

        //Load admin stylesheets and JavaScript
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_styles' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_scripts' ) );

	    //Write in back-end head
	    add_action('admin_head', array( $this, 'wr_admin_head' ));

        //Add the admin menu
        add_action( 'admin_menu', array( $this, 'me_add_admin_menu' ) );

	    //Load the options API registrations and callbacks
	    add_action('admin_init', array( $this, 'op_register_options' ) );

        //this hook is triggered during the creation of a new blog
        add_action('wpmu_new_blog', array($this, 'new_blog_create_options_and_tables'), 10, 6);

        //this hook is triggered during the deletion of a blog
        add_action( 'delete_blog', array($this, 'delete_blog_delete_options_and_tables'), 10, 1 );

    }

    /*
     * return an instance of this class
     */
    public static function get_instance() {

        if ( null == self::$instance ) {
            self::$instance = new self;
        }

        return self::$instance;

    }

	/*
	 * write in the admin head
	 */
	public function wr_admin_head(){

		echo '<script type="text/javascript">';
		echo 'var daln_ajax_url = "' . admin_url('admin-ajax.php') . '";';
		echo 'var daln_nonce = "' . wp_create_nonce( "live-news" ) . '";';
		echo 'var daln_admin_url ="' . get_admin_url() . '";';
		echo '</script>';

	}

    public function enqueue_admin_styles() {

        $screen = get_current_screen();

        //menu tickers
        if ( $screen->id == $this->screen_id_tickers ) {
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_style( $this->shared->get('slug') .'-menu-sliding', $this->shared->get('url') . 'admin/assets/css/menu-tickers.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-framework-menu', $this->shared->get('url') . 'admin/assets/css/framework/menu.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver') );
        }

        //menu featured
        if ( $screen->id == $this->screen_id_featured ) {
            wp_enqueue_style( $this->shared->get('slug') .'-menu-featured', $this->shared->get('url') . 'admin/assets/css/menu-featured.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-framework-menu', $this->shared->get('url') . 'admin/assets/css/framework/menu.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver') );
        }

        //menu sliding
        if ( $screen->id == $this->screen_id_sliding ) {
	        wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_style( $this->shared->get('slug') .'-menu-sliding', $this->shared->get('url') . 'admin/assets/css/menu-sliding.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-framework-menu', $this->shared->get('url') . 'admin/assets/css/framework/menu.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver') );
        }

	    //menu options
	    if ( $screen->id == $this->screen_id_options ) {
		    wp_enqueue_style( $this->shared->get('slug') .'-framework-options', $this->shared->get('url') . 'admin/assets/css/framework/options.css', array(), $this->shared->get('ver') );
		    wp_enqueue_style( $this->shared->get('slug') .'-jquery-ui-tooltip', $this->shared->get('url') . 'admin/assets/css/jquery-ui-tooltip.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.css', array(), $this->shared->get('ver') );
            wp_enqueue_style( $this->shared->get('slug') .'-chosen-custom', $this->shared->get('url') . 'admin/assets/css/chosen-custom.css', array(), $this->shared->get('ver') );
	    }

    }

    /*
     * enqueue admin-specific javascript
     */
    public function enqueue_admin_scripts() {

        $screen = get_current_screen();

        //menu tickers
        if( $screen->id == $this->screen_id_tickers ){
            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script( $this->shared->get('slug') . '-menu-tickers', $this->shared->get('url') . 'admin/assets/js/menu-tickers.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get('slug') . '-jquery-ui-tooltip-init', $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get('slug') . '-wp-color-picker-init', $this->shared->get('url') . 'admin/assets/js/wp-color-picker-init.js', array( 'wp-color-picker' ), false, true );
            wp_enqueue_script( $this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get( 'slug' ) . '-jquery-ui-chosen-init-tickers', $this->shared->get( 'url' ) . 'admin/assets/js/chosen-init-tickers.js', 'jquery', $this->shared->get( 'ver' ) );
	        wp_enqueue_media();
	        wp_enqueue_script( $this->shared->get('slug') . '-media-uploader', $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver') );
        }

        //menu featured
        if( $screen->id == $this->screen_id_featured ){
            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script( $this->shared->get('slug') . '-jquery-ui-tooltip-init', $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get( 'slug' ) . '-jquery-ui-chosen-init-featured', $this->shared->get( 'url' ) . 'admin/assets/js/chosen-init-featured.js', 'jquery', $this->shared->get( 'ver' ) );
            wp_enqueue_script( $this->shared->get('slug') . '-menu-featured', $this->shared->get('url') . 'admin/assets/js/menu-featured.js', 'jquery', $this->shared->get('ver') );
        }

        //menu sliding
        if( $screen->id == $this->screen_id_sliding ){
            wp_enqueue_script('jquery-ui-tooltip');
            wp_enqueue_script( $this->shared->get('slug') . '-jquery-ui-tooltip-init', $this->shared->get('url') . 'admin/assets/js/jquery-ui-tooltip-init.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get( 'slug' ) . '-jquery-ui-chosen-init-sliding', $this->shared->get( 'url' ) . 'admin/assets/js/chosen-init-sliding.js', 'jquery', $this->shared->get( 'ver' ) );
	        wp_enqueue_script( $this->shared->get('slug') . '-wp-color-picker-init', $this->shared->get('url') . 'admin/assets/js/wp-color-picker-init.js', array( 'wp-color-picker' ), false, true );
	        wp_enqueue_script( $this->shared->get('slug') . '-menu-sliding', $this->shared->get('url') . 'admin/assets/js/menu-sliding.js', 'jquery', $this->shared->get('ver') );
	        wp_enqueue_media();
	        wp_enqueue_script( $this->shared->get('slug') . '-media-uploader', $this->shared->get('url') . 'admin/assets/js/media-uploader.js', 'jquery', $this->shared->get('ver') );
        }

	    //menu options
	    if ( $screen->id == $this->screen_id_options ) {
		    wp_enqueue_script( 'jquery-ui-tooltip' );
		    wp_enqueue_script( $this->shared->get( 'slug' ) . '-jquery-ui-tooltip-init', $this->shared->get( 'url' ) . 'admin/assets/js/jquery-ui-tooltip-init.js', 'jquery', $this->shared->get( 'ver' ) );
            wp_enqueue_script( $this->shared->get('slug') . '-chosen', $this->shared->get('url') . 'admin/assets/inc/chosen/chosen-min.js', 'jquery', $this->shared->get('ver') );
            wp_enqueue_script( $this->shared->get( 'slug' ) . '-chosen-init-options', $this->shared->get( 'url' ) . 'admin/assets/js/chosen-init-options.js', 'jquery', $this->shared->get( 'ver' ) );
	    }

    }

    /*
     * plugin activation
     */
    public function ac_activate( $networkwide ) {

        /*
		 * create options and tables for all the sites in the network
		 */
        if ( function_exists( 'is_multisite' ) and is_multisite() ) {

            /*
			 * if this is a "Network Activation" create the options and tables
			 * for each blog
			 */
            if ( $networkwide ) {

                //get the current blog id
                global $wpdb;
                $current_blog = $wpdb->blogid;

                //create an array with all the blog ids
                $blogids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );

                //iterate through all the blogs
                foreach ( $blogids as $blog_id ) {

                    //switch to the iterated blog
                    switch_to_blog( $blog_id );

                    //create options and tables for the iterated blog
                    $this->ac_initialize_options();
                    $this->ac_create_database_tables();

                }

                //switch to the current blog
                switch_to_blog( $current_blog );

            } else {

                /*
				 * if this is not a "Network Activation" create options and
				 * tables only for the current blog
				 */
                $this->ac_initialize_options();
                $this->ac_create_database_tables();

            }

        } else {

            /*
			 * if this is not a multisite installation create options and
			 * tables only for the current blog
			 */
            $this->ac_initialize_options();
            $this->ac_create_database_tables();

        }

    }

    //create the options and tables for the newly created blog
    public function new_blog_create_options_and_tables( $blog_id, $user_id, $domain, $path, $site_id, $meta ) {

        global $wpdb;

        /*
		 * if the plugin is "Network Active" create the options and tables for
		 * this new blog
		 */
        if ( is_plugin_active_for_network( 'uberchart/init.php' ) ) {

            //get the id of the current blog
            $current_blog = $wpdb->blogid;

            //switch to the blog that is being activated
            switch_to_blog( $blog_id );

            //create options and database tables for the new blog
            $this->ac_initialize_options();
            $this->ac_create_database_tables();

            //switch to the current blog
            switch_to_blog( $current_blog );

        }

    }

    //delete options and tables for the deleted blog
    public function delete_blog_delete_options_and_tables( $blog_id ) {

        global $wpdb;

        //get the id of the current blog
        $current_blog = $wpdb->blogid;

        //switch to the blog that is being activated
        switch_to_blog( $blog_id );

        //create options and database tables for the new blog
        $this->un_delete_options();
        $this->un_delete_database_tables();

        //switch to the current blog
        switch_to_blog( $current_blog );

    }

    /*
	 * initialize plugin options
	 */
    private function ac_initialize_options() {

        //database version -----------------------------------------------------
        add_option( $this->shared->get( 'slug' ) . "_database_version", "0" );

	    //general --------------------------------------------------------------
        add_option( $this->shared->get('slug') . '_detect_url_mode', "server_variable");
        add_option( $this->shared->get('slug') . '_load_momentjs', "1");
	    add_option( $this->shared->get( 'slug' ) . "_tickers_menu_capability", "manage_options" );
	    add_option( $this->shared->get( 'slug' ) . "_featured_menu_capability", "manage_options" );
	    add_option( $this->shared->get( 'slug' ) . "_sliding_menu_capability", "manage_options" );

    }

    /*
	 * create the plugin database tables
	 */
    private function ac_create_database_tables() {

        global $wpdb;

        //Get the database character collate that will be appended at the end of each query
        $charset_collate = $wpdb->get_charset_collate();

        //check database version and create the database
        if ( intval( get_option( $this->shared->get( 'slug' ) . '_database_version' ), 10 ) < 3 ) {

            require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

            //create *prefix*_daln_tickers
            global $wpdb;
            $table_name=$wpdb->prefix . $this->shared->get('slug') . "_tickers";
            $sql = "CREATE TABLE $table_name (
                  `name` varchar(100) NOT NULL DEFAULT '',
                  `id` bigint(20) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `target` int(11) NOT NULL DEFAULT '1',
                  `url` TEXT NOT NULL DEFAULT '',
                  `source` int(11) NOT NULL DEFAULT '1',
                  `url_rss` varchar(2083) NOT NULL DEFAULT '',
                  `category` bigint(20) NOT NULL DEFAULT '0',
                  `twitter_username` varchar(255) NOT NULL DEFAULT '',
                  `twitter_oauth_access_token` varchar(255) NOT NULL DEFAULT '',
                  `twitter_oauth_access_token_secret` varchar(255) NOT NULL DEFAULT '',
                  `twitter_consumer_key` varchar(255) NOT NULL DEFAULT '',
                  `twitter_consumer_secret` varchar(255) NOT NULL DEFAULT '',
                  `twitter_strip_links` tinyint(1) DEFAULT '0',
                  `twitter_strip_hashtags` tinyint(1) DEFAULT '0',
                  `twitter_strip_usernames` tinyint(1) DEFAULT '0',
                  `open_links_new_tab` tinyint(1) DEFAULT '0',
                  `clock_offset` int(11) NOT NULL DEFAULT '0',
                  `clock_format` varchar(40) NOT NULL DEFAULT 'HH:mm',
                  `clock_source` int(11) NOT NULL DEFAULT '2',
                  `clock_autoupdate` tinyint(1) DEFAULT '1',
                  `clock_autoupdate_time` int(11) NOT NULL DEFAULT '10',
                  `sliding_speed` int(11) NOT NULL DEFAULT '5',
                  `sliding_delay` int(11) NOT NULL DEFAULT '0',
                  `number_of_sliding_news` int(11) NOT NULL DEFAULT '10',
                  `featured_title_maximum_length` int(11) NOT NULL DEFAULT '255',
                  `featured_excerpt_maximum_length` int(11) NOT NULL DEFAULT '255',
                  `sliding_news_maximum_length` int(11) NOT NULL DEFAULT '255',
                  `open_news_as_default` tinyint(1) DEFAULT '1',
                  `hide_featured_news` int(11) NOT NULL DEFAULT '1',
                  `hide_clock` tinyint(1) DEFAULT '0',
                  `enable_rtl_layout` tinyint(1) DEFAULT '0',
                  `cached_cycles` int(11) NOT NULL DEFAULT '0',
                  `featured_news_background_color` varchar(7) DEFAULT NULL,
                  `sliding_news_background_color` varchar(7) DEFAULT NULL,
                  `sliding_news_background_color_opacity` float DEFAULT NULL,
                  `font_family` varchar(255) DEFAULT NULL,
                  `google_font` varchar(255) DEFAULT NULL,
                  `featured_title_font_size` int(11) NOT NULL DEFAULT '38',
                  `featured_excerpt_font_size` int(11) NOT NULL DEFAULT '28',
                  `sliding_news_font_size` int(11) NOT NULL DEFAULT '28',
                  `clock_font_size` int(11) NOT NULL DEFAULT '28',
                  `enable_with_mobile_devices` tinyint(1) DEFAULT '0',
                  `open_button_image` varchar(2083) NOT NULL DEFAULT '',
                  `close_button_image` varchar(2083) NOT NULL DEFAULT '',
                  `clock_background_image` varchar(2083) NOT NULL DEFAULT '',
                  `featured_news_title_color` varchar(7) DEFAULT NULL,
                  `featured_news_title_color_hover` varchar(7) DEFAULT NULL,
                  `featured_news_excerpt_color` varchar(7) DEFAULT NULL,
                  `sliding_news_color` varchar(7) DEFAULT NULL,
                  `sliding_news_color_hover` varchar(7) DEFAULT NULL,
                  `clock_text_color` varchar(7) DEFAULT NULL,
                  `featured_news_background_color_opacity` float DEFAULT NULL,
                  `enable_ticker` tinyint(1) DEFAULT '1',
                  `enable_links` tinyint(1) DEFAULT '1',
                  `transient_expiration` int(11) NOT NULL DEFAULT '0',
                  `sliding_news_margin` int(11) NOT NULL DEFAULT '84',
                  `sliding_news_padding` int(11) NOT NULL DEFAULT '28',
                  `url_mode` tinyint(1) DEFAULT '0'
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_daln_featured_news
            global $wpdb;
            $table_name=$wpdb->prefix . $this->shared->get('slug') . "_featured_news";
            $sql = "CREATE TABLE $table_name (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `news_title` varchar(1000) NOT NULL DEFAULT '',
                  `news_excerpt` varchar(1000) NOT NULL DEFAULT '',
                  `url` varchar(2083) NOT NULL DEFAULT '',
                  `ticker_id` bigint(20) NOT NULL
            ) $charset_collate";

            dbDelta($sql);

            //create *prefix*_daln_sliding_news
            global $wpdb;
            $table_name=$wpdb->prefix . $this->shared->get('slug') . "_sliding_news";
            $sql = "CREATE TABLE $table_name (
                  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
                  `news_title` varchar(1000) NOT NULL DEFAULT '',
                  `url` varchar(2083) NOT NULL DEFAULT '',
                  `ticker_id` bigint(20) NOT NULL,
                  `text_color` varchar(7) DEFAULT NULL,
                  `text_color_hover` varchar(7) DEFAULT NULL,
                  `background_color` varchar(7) DEFAULT NULL,
                  `background_color_opacity` float DEFAULT NULL,
                  `image_before` varchar(2083) NOT NULL DEFAULT '',
                  `image_after` varchar(2083) NOT NULL DEFAULT ''
            ) $charset_collate";

            dbDelta($sql);

            //Update database version
            update_option( $this->shared->get( 'slug' ) . '_database_version', "2" );

        }

    }

    /*
	 * plugin delete
	 */
    static public function un_delete() {

        /*
		 * delete options and tables for all the sites in the network
		 */
        if ( function_exists( 'is_multisite' ) and is_multisite() ) {

            //get the current blog id
            global $wpdb;
            $current_blog = $wpdb->blogid;

            //create an array with all the blog ids
            $blogids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );

            //iterate through all the blogs
            foreach ( $blogids as $blog_id ) {

                //switch to the iterated blog
                switch_to_blog( $blog_id );

                //create options and tables for the iterated blog
                Daln_Admin::un_delete_options();
                Daln_Admin::un_delete_database_tables();

            }

            //switch to the current blog
            switch_to_blog( $current_blog );

        } else {

            /*
			 * if this is not a multisite installation delete options and
			 * tables only for the current blog
			 */
            Daln_Admin::un_delete_options();
            Daln_Admin::un_delete_database_tables();

        }

    }

    /*
	 * delete plugin options
	 */
    static public function un_delete_options() {

        //assign an instance of Daln_Shared
        $shared = Daln_Shared::get_instance();

        //database version -----------------------------------------------------
        delete_option( $shared->get( 'slug' ) . "_database_version" );

	    //general --------------------------------------------------------------
        delete_option( $shared->get('slug') . '_detect_url_mode');
        delete_option( $shared->get('slug') . '_load_momentjs');
	    delete_option( $shared->get( 'slug' ) . "_tickers_menu_capability" );
	    delete_option( $shared->get( 'slug' ) . "_featured_menu_capability" );
	    delete_option( $shared->get( 'slug' ) . "_sliding_menu_capability" );

    }

    /*
	 * delete plugin database tables
	 */
    static public function un_delete_database_tables() {

        //assign an instance of Daln_Shared
        $shared = Daln_Shared::get_instance();

        global $wpdb;

        //delete transients associated with the table prefix '_tickers'
        $table_name = $wpdb->prefix . $shared->get( 'slug' ) . "_tickers";
        $results    = $wpdb->get_results( "SELECT id FROM $table_name", ARRAY_A );
        foreach ( $results as $result ) {
            delete_transient('daln_ticker_' . $result['id']);
        }

        //delete table prefix + '_tickers'
        $table_name = $wpdb->prefix . $shared->get( 'slug' ) . "_tickers";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query( $sql );

        //delete table prefix + '_featured_news'
        $table_name = $wpdb->prefix . $shared->get( 'slug' ) . "_featured_news";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query( $sql );

        //delete table prefix + '_sliding_news'
        $table_name = $wpdb->prefix . $shared->get( 'slug' ) . "_sliding_news";
        $sql        = "DROP TABLE $table_name";
        $wpdb->query( $sql );

    }

    /*
	 * register the admin menu
	 */
    public function me_add_admin_menu() {

        add_menu_page(
            'LN',
            esc_attr__('Live News', 'daln'),
	        get_option($this->shared->get('slug') . "_tickers_menu_capability"),
            $this->shared->get('slug') . '-tickers',
            array( $this, 'me_display_menu_tickers'),
            'dashicons-admin-site'
        );

        $this->screen_id_tickers = add_submenu_page(
            $this->shared->get('slug') . '-tickers',
            esc_attr__('News Tickers', 'daln'),
            esc_attr__('News Tickers', 'daln'),
	        get_option($this->shared->get('slug') . "_tickers_menu_capability"),
            $this->shared->get('slug') . '-tickers',
            array( $this, 'me_display_menu_tickers')
        );

        $this->screen_id_featured = add_submenu_page(
            $this->shared->get('slug') . '-tickers',
            esc_attr__('Featured News', 'daln'),
            esc_attr__('Featured News', 'daln'),
	        get_option($this->shared->get('slug') . "_featured_menu_capability"),
            $this->shared->get('slug') . '-featured',
            array( $this, 'me_display_menu_featured')
        );

        $this->screen_id_sliding = add_submenu_page(
            $this->shared->get('slug') . '-tickers',
            esc_attr__('Sliding News', 'daln'),
            esc_attr__('Sliding News', 'daln'),
	        get_option($this->shared->get('slug') . "_sliding_menu_capability"),
            $this->shared->get('slug') . '-sliding',
            array( $this, 'me_display_menu_sliding')
        );

        $this->screen_id_help = add_submenu_page(
            $this->shared->get('slug') . '-tickers',
            esc_attr__('Help', 'daln'),
            esc_attr__('Help', 'daln'),
            'manage_options',
            $this->shared->get('slug') . '-help',
            array( $this, 'me_display_menu_help')
        );

	    $this->screen_id_options = add_submenu_page(
		    $this->shared->get('slug') . '-tickers',
		    esc_attr__('Options', 'daln'),
		    esc_attr__('Options', 'daln'),
		    'manage_options',
		    $this->shared->get('slug') . '-options',
		    array( $this, 'me_display_menu_options')
	    );

    }

    /*
     * includes the tickers view
     */
    public function me_display_menu_tickers() {
        include_once( 'view/tickers.php' );
    }

    /*
     * includes the featured view
     */
    public function me_display_menu_featured() {
        include_once( 'view/featured.php' );
    }

    /*
     * includes the sliding view
     */
    public function me_display_menu_sliding() {
        include_once( 'view/sliding.php' );
    }

    /*
     * includes the help view
     */
    public function me_display_menu_help() {
        include_once( 'view/help.php' );
    }

	/*
	 * includes the options view
	 */
	public function me_display_menu_options() {
		include_once( 'view/options.php' );
	}

	/*
	 * register options
	 */
	public function op_register_options() {

		//section general ----------------------------------------------------------
		add_settings_section(
			'daln_general_settings_section',
			null,
			null,
			'daln_general_options'
		);

        add_settings_field(
            'detect_url_mode',
            esc_attr__( 'Detect URL Mode', 'daln' ),
            array( $this, 'detect_url_mode_callback' ),
            'daln_general_options',
            'daln_general_settings_section'
        );

        register_setting(
            'daln_general_options',
            'daln_detect_url_mode',
            array( $this, 'detect_url_mode_validation' )
        );

        add_settings_field(
            'load_momentjs',
            esc_attr__( 'Load Moment.js', 'daln' ),
            array( $this, 'load_momentjs_callback' ),
            'daln_general_options',
            'daln_general_settings_section'
        );

        register_setting(
            'daln_general_options',
            'daln_load_momentjs',
            array( $this, 'load_momentjs_validation' )
        );

		add_settings_field(
			'tickers_menu_capability',
			esc_attr__( 'Tickers Menu Capability', 'daln' ),
			array( $this, 'tickers_menu_capability_callback' ),
			'daln_general_options',
			'daln_general_settings_section'
		);

		register_setting(
			'daln_general_options',
			'daln_tickers_menu_capability',
			array( $this, 'tickers_menu_capability_validation' )
		);

		add_settings_field(
			'featured_menu_capability',
			esc_attr__( 'Featured News Menu Capability', 'daln' ),
			array( $this, 'featured_menu_capability_callback' ),
			'daln_general_options',
			'daln_general_settings_section'
		);

		register_setting(
			'daln_general_options',
			'daln_featured_menu_capability',
			array( $this, 'featured_menu_capability_validation' )
		);

		add_settings_field(
			'sliding_menu_capability',
			esc_attr__( 'Sliding News Menu Capability', 'daln' ),
			array( $this, 'sliding_menu_capability_callback' ),
			'daln_general_options',
			'daln_general_settings_section'
		);

		register_setting(
			'daln_general_options',
			'daln_sliding_menu_capability',
			array( $this, 'sliding_menu_capability_validation' )
		);

	}


    public function detect_url_mode_callback($args){

        $html = '<select id="daln-detect-url-mode" name="daln_detect_url_mode" class="daext-display-none">';
        $html .= '<option ' . selected(get_option("daln_detect_url_mode"), 'server_variable', false) . ' value="server_variable">' . esc_attr__('Server Variable', 'dahm') . '</option>';
        $html .= '<option ' . selected(get_option("daln_detect_url_mode"), 'wp_request', false) . ' value="wp_request">' . esc_attr__('WP Request', 'dahm') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('Select the method used to detect the URL of the page.', 'dahm') . '"></div>';

        echo $html;

    }

    public function detect_url_mode_validation($input){

        if($input === 'server_variable' or $input === 'wp_request'){
            $output = $input;
        }else{
            $output = 'server_variable';
        }

        return $output;

    }

    public function load_momentjs_callback($args)
    {

        $html = '<select id="daln-load-momentjs" name="daln_load_momentjs" class="daext-display-none">';
        $html .= '<option ' . selected(intval(get_option("daln_load_momentjs")), 0, false) . ' value="0">' . esc_attr__('No', 'daln') . '</option>';
        $html .= '<option ' . selected(intval(get_option("daln_load_momentjs")), 1, false) . ' value="1">' . esc_attr__('Yes', 'daln') . '</option>';
        $html .= '</select>';
        $html .= '<div class="help-icon" title="' . esc_attr__('Please select "No" only if other components of your website are already loading the Moment.js library.', 'daln') . '"></div>';

        echo $html;

    }

    public function load_momentjs_validation($input)
    {

        return intval($input, 10) == 1 ? '1' : '0';

    }

	public function tickers_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="daln-tickers-menu-capability" name="daln_tickers_menu_capability" class="regular-text" value="' . esc_attr(get_option("daln_tickers_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "News Tickers" menu.', 'daln') . '"></div>';

		echo $html;

	}

	public function tickers_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'daln_tickers_menu_capability', 'daln_tickers_menu_capability', esc_attr__('Please enter a valid capability in the "Tickers Menu Capability" option.', 'daln') );
			$output = get_option('daln_tickers_menu_capability');
		}else{
			$output = $input;
		}

		return trim($output);

	}

	public function featured_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="daln-featured-menu-capability" name="daln_featured_menu_capability" class="regular-text" value="' . esc_attr(get_option("daln_featured_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Featured News" menu.', 'daln') . '"></div>';

		echo $html;

	}

	public function featured_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'daln_featured_menu_capability', 'daln_featured_menu_capability', esc_attr__('Please enter a valid capability in the "Featured News Menu Capability" option.', 'daln') );
			$output = get_option('daln_featured_menu_capability');
		}else{
			$output = $input;
		}

		return trim($output);

	}

	public function sliding_menu_capability_callback($args){

		$html = '<input autocomplete="off" type="text" id="daln-sliding-menu-capability" name="daln_sliding_menu_capability" class="regular-text" value="' . esc_attr(get_option("daln_sliding_menu_capability")) . '" />';
		$html .= '<div class="help-icon" title="' . esc_attr__('The capability required to get access on the "Sliding News" menu.', 'daln') . '"></div>';

		echo $html;

	}

	public function sliding_menu_capability_validation($input){

		if(!preg_match($this->shared->regex_capability, $input)){
			add_settings_error( 'daln_sliding_menu_capability', 'daln_sliding_menu_capability', esc_attr__('Please enter a valid capability in the "Sliding News Menu Capability" option.', 'daln') );
			$output = get_option('daln_sliding_menu_capability');
		}else{
			$output = $input;
		}

		return trim($output);

	}
    
}